<?php
/**
 * @package SP Page Builder
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2019 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
//no direct accees
defined ('_JEXEC') or die ('Restricted access');

class SppagebuilderAddonYogacalendar extends SppagebuilderAddons {

	public function render() {
		// Variables
		$settings = $this->addon->settings;
		$class 	= (isset($settings->class) && $settings->class) ? ' ' . $settings->class : '';
		$column = (isset($settings->column) && $settings->column) ? ' ' . $settings->column : 3;
		
		$output  = '<div id="sppb-yogacalendar-'. $this->addon->id .'" class="sppb-yogacalendar ' . $class . '">';
			$output .= '<div class="sppb-addon-content sppb-tab tabs-tab">';
				$output .='<ul class="sppb-nav sppb-nav-tabs" role="tablist">';
					foreach ($settings->sp_yogacalendar_item as $key => $tab) {
						$output .='<li class="'. ( ($key==0) ? "active" : "").'">';
							$output .= '<a data-toggle="sppb-tab" id="sppb-content-'. ($this->addon->id + $key) .'" class="" href="#sppb-tab-'. ($this->addon->id + $key) .'" role="tab" aria-controls="sppb-tab-'. ($this->addon->id + $key) .'" aria-selected="'. ( ($key==0) ? "true" : "false").'">'. $tab->day . '</a>';
						$output .='</li>';
					}
				$output .='</ul>';

				//Tab Contnet
				$output .='<div class="sppb-tab-content sppb-tab-tabs-content">';
					foreach ($settings->sp_yogacalendar_item as $key => $item) {

						$output .='<div id="sppb-tab-'. ($this->addon->id + $key) .'" class="sppb-tab-pane sppb-fade'. ( ($key==0) ? " active in" : "").'" role="tabpanel" aria-labelledby="sppb-content-'. ($this->addon->id + $key) .'">';

							$output .='<div class="sppb-row">';
								foreach ($item->yogacalendar_inner_items as $key => $inner_item) {
									$time 			= (isset($inner_item->time) && $inner_item->time) ? $inner_item->time : '';
									$title 			= (isset($inner_item->title) && $inner_item->title) ? $inner_item->title : '';
									$content 		= (isset($inner_item->content) && $inner_item->content) ? $inner_item->content : '';
									$button_text 	= (isset($inner_item->button_text) && $inner_item->button_text) ? $inner_item->button_text : '';
									$button_url 	= (isset($inner_item->button_url) && $inner_item->button_url) ? $inner_item->button_url : '';
									$button_target 	= (isset($inner_item->button_target) && $inner_item->button_target) ? 'target="'. $inner_item->button_target .'"' : '';

									$output .='<div class="sppb-col-md-'. round(12/$column) .'">';
										$output .= '<div class="sppb-yogacalendar-item-wrap">';
										$output .= ($inner_item->time) ? '<h3 class="sppb-yogacalendar-time">' . $inner_item->time . '</h3>' : '';
										$output .= ($inner_item->title) ? '<h4 class="sppb-yogacalendar-title">' . $inner_item->title . '</h4>' : '';
										$output .= ($inner_item->content) ? '<div class="sppb-yogacalendar-content">'. $inner_item->content .'</div>' : '';//.sppb-yogacalendar-content
										$output .= ($inner_item->button_text) ? '<a href="'. $button_url .'" ' . $button_target . ' class="sppb-btn sppb-btn-default sppb-btn-rounded ">'. $inner_item->button_text .'</a>' : '';//button
									$output .='</div>';

									$output .='</div>'; //.sppb-col-md-3
								}
							$output .='</div>'; //.sppb-row
						$output .='</div>'; //Tab item
					}
				$output .='</div>';//.sppb-tab-content

			$output .= '</div>'; //.sppb-tab
		$output .= '</div>'; //.sppb-yogacalendar

		return $output;
	}

	public static function getTemplate(){
		$output = '
			<div id="sppb-yogacalendar-{{data.id}}" class="sppb-yogacalendar {{data.class}}">
			<div class="sppb-addon-content sppb-tab tabs-tab">
				<ul class="sppb-nav sppb-nav-tabs" role="tablist">
					<# _.each (data.sp_yogacalendar_item, function( tab, key) {
						let activeValue = (key == 0) ? "active" : "";
						let activeIn 		= (key == 0) ? " active in" : "";
						let keyValue 		= (key == 0) ? "true" : "false";
						#>
						<li class="{{activeValue}}">
							<a data-toggle="sppb-tab" id="sppb-content-{{data.id + key}}" class="" href="#sppb-tab-{{data.id + key}}" role="tab" aria-controls="sppb-tab-{{data.id + key}} aria-selected="{{keyValue}}">{{tab.day}}</a>
						</li>
					<# }) #>
				</ul>

				<div class="sppb-tab-content sppb-tab-tabs-content">
					<# _.each (data.sp_yogacalendar_item, function(item, key) {
						let activeIn 		= (key == 0) ? " active in" : "";
					#>

						<div id="sppb-tab-{{data.id + key}}" class="sppb-tab-pane sppb-fade {{activeIn}}" role="tabpanel" aria-labelledby="sppb-content-{{data.id + key}}">

							<div class="sppb-row">
								<# _.each (item.yogacalendar_inner_items, function(inner_item, key) {
									let timeData 					= (!_.isEmpty(inner_item.time) && !_.isEmpty(inner_item.time)) ? \'<h3 class="sppb-yogacalendar-time">\' + inner_item.time + \'</h3>\' : "";
									let title 				= (!_.isEmpty(inner_item.title) && !_.isEmpty(inner_item.title)) ? \'<h4 class="sppb-yogacalendar-title">\' + inner_item.title + \'</h4>\' : "";
									let content 			= (!_.isEmpty(inner_item.content) && !_.isEmpty(inner_item.content)) ? \'<div class="sppb-yogacalendar-content">\' + inner_item.content + \'</div>\' : "";
									let button_text 	= (!_.isEmpty(inner_item.button_text) && !_.isEmpty(inner_item.button_text)) ? inner_item.button_text : "";
									let button_url 		= (!_.isEmpty(inner_item.button_url) && !_.isEmpty(inner_item.button_url)) ? inner_item.button_url : "";
									let button_target = (!_.isEmpty(inner_item.button_target) && !_.isEmpty(inner_item.button_target)) ? \'target="\' + inner_item.button_target + \'"\' : "";
									let full_btn = (!_.isEmpty(button_text)) ? \'<a href="\' + button_url + \'"\' + button_target + \'class="sppb-btn sppb-btn-default sppb-btn-rounded ">\' + button_text + \'</a>\' : "";
									let columnSize = _.round(12/data.column);
									console.log(button_text);
								#>
									<div class="sppb-col-md-{{columnSize}}">
										<div class="sppb-yogacalendar-item-wrap">
											{{{timeData + title + content + full_btn}}}
										</div>
									</div>
								<# }) #>
							</div>
						</div>
					<# }) #>
				</div>

			</div>
		</div>
		';

		return $output;
	}
}