<?php
/**
* @package SP Page Builder
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2019 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
//no direct accees
defined ('_JEXEC') or die ('Restricted access');

SpAddonsConfig::addonConfig(
	array(
		'type'=>'repeatable',
		'addon_name'=>'sp_yogacalendar',
		'category'=>'yoga',
		'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_YOGACALENDAR'),
		'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_YOGACALENDAR_DESC'),
		'attr'=>array(
			'general' => array(

				'admin_label'=>array(
					'type'=>'text',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_ADMIN_LABEL'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_ADMIN_LABEL_DESC'),
					'std'=> ''
				),

				'column'=>array(
					'type'=>'select',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_YOGACALENDAR_COLUMN'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_YOGACALENDAR_COLUMN_DESC'),
					'values'=>array(
						'2'=>JText::_('COM_SPPAGEBUILDER_ADDON_YOGACALENDAR_COLUMN_2'),
						'3'=>JText::_('COM_SPPAGEBUILDER_ADDON_YOGACALENDAR_COLUMN_3'),
						'4'=>JText::_('COM_SPPAGEBUILDER_ADDON_YOGACALENDAR_COLUMN_4'),
						'6'=>JText::_('COM_SPPAGEBUILDER_ADDON_YOGACALENDAR_COLUMN_6'),
					),
					'std'=>'3',
				),

				'class'=>array(
					'type'=>'text',
					'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_CLASS'),
					'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_CLASS_DESC'),
					'std'=>''
				),

				//repeatable
				'sp_yogacalendar_item'=>array(
					'title'=> JText::_('COM_SPPAGEBUILDER_ADDON_YOGACALENDAR_ITEMS'),
					'type'=>'repeatable',
					// 'std'=> array(	

					// ),
					'attr'=>  array(

						'day'=>array(
							'type'=>'text',
							'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_YOGACALENDAR_ITEM_DAY'),
							'std'=>'Sun',
						),

						//inner items
						'yogacalendar_inner_items'=>array(
							'title'=> JText::_('COM_SPPAGEBUILDER_ADDON_YOGACALENDAR_DAY_ITEM'),
                            'type'=>'repeatable',
							'attr'=>  array(
								'time'=>array(
									'type'=>'text',
									'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_YOGACALENDAR_ITEM_TIME'),
									'std'=>'8:30 AM - 9:30 AM',
								),

								'title'=>array(
									'type'=>'text',
									'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_YOGACALENDAR_ITEM_TITLE'),
									'std'=>'Where Art and Technology Collide',
								),

								'content'=>array(
									'type'=>'editor',
									'title'=>JText::_('COM_SPPAGEBUILDER_ADDON_YOGACALENDAR_ITEM_CONTENT'),
									'desc'=>JText::_('COM_SPPAGEBUILDER_ADDON_YOGACALENDAR_ITEM_CONTENT_DESC'),
									'std'=> ''
								),

								//Button
								'button_text'=>array(
									'type'=>'text',
									'title'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_TEXT'),
									'desc'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_TEXT_DESC'),
									'std'=>'',
								),

								'button_url'=>array(
									'type'=>'media',
									'format'=>'attachment',
									'title'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_URL'),
									'desc'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_BUTTON_URL_DESC'),
									'placeholder'=>'http://',
									'hide_preview'=>true,
									'depends'=> array(
										array('button_text', '!=', ''),
									)
								),

								'button_target'=>array(
									'type'=>'select',
									'title'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_LINK_NEWTAB'),
									'desc'=>JText::_('COM_SPPAGEBUILDER_GLOBAL_LINK_NEWTAB_DESC'),
									'values'=>array(
										''=>JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_TARGET_SAME_WINDOW'),
										'_blank'=>JText::_('COM_SPPAGEBUILDER_ADDON_GLOBAL_TARGET_NEW_WINDOW'),
									),
									'depends'=> array(
										array('button_text', '!=', ''),
									)
								),
							),
						),	
					),
				),
			),
		),
	)
);
