<?php
/**
 * @package     Sp Page Builder Translate for Joomla!
 * @author      Stéphane Bouey <stephane.bouey@faboba.com> - http://www.faboba.com
 * @license     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @copyright   Copyright (C) 2012-2013 Faboba. All rights reserved.
 */


defined('_JEXEC') or die;

/**
 * To work need 3 files to be overrdien
 * components/com_sppagebuilder/parser/addon-parser.php
 * administrator/components/com_sppagebuilder/views/page/tmpl/edit.php
 * plugins/system/sppagebuilder/sppagebuilder.php
 */

/**
 * Joomla! System Logging Plugin.
 *
 * @since  1.5
 */
class PlgSystemSppagebuildertranslate extends JPlugin
{
	var $sppbVersion = 3;

	public function __construct(&$subject, $config)
	{
		parent::__construct($subject, $config);
	}


	public function getSppbVersion(){
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('manifest_cache');
		$query->from($db->quoteName('#__extensions'));
		$query->where('element = "com_sppagebuilder"');
		$db->setQuery($query);

		$manifest = json_decode($db->loadResult(), true);
		$version = $manifest['version'];

		if (version_compare($version,'3','<'))
		{
			$this->sppbVersion = 2;
		}
	}

	//render is for front-end
	public function onBeforeAddonRender(&$addon)
	{
		if ($this->sppbVersion == 3) {
			$this->onBeforeAddonRenderv3($addon);
		} else {
			$this->onBeforeAddonRenderv2($addon);
		}
	}

	public function onBeforeAddonRenderv3(&$addon)
	{

		require_once JPATH_PLUGINS .'/system/sppagebuildertranslate/config.php';

		if ( file_exists(JPATH_PLUGINS . '/system/sppagebuildertranslate/addons/'.$addon->name.'.php') ) {
			require_once JPATH_PLUGINS . '/system/sppagebuildertranslate/addons/'.$addon->name.'.php';
		}

		$lang = JFactory::getLanguage()->getTag();

		$translated_fields = SpAddonsConfigTranslation::$addons;

		//manage addon's filter by language
		if (isset(SpAddonsConfigTranslation::$addons[$addon->name]['language']) &&  SpAddonsConfigTranslation::$addons[ $addon->name ]['language'] == true) {
			if (isset($translated_fields[$addon->name]['language']) && $translated_fields[$addon->name]['language']) {
				if ($addon->settings->language != '*' && $addon->settings->language != $lang) {
					$addon = null;
					return;
				}
			}
		}


		if (empty($translated_fields)){return;}
		//is no transalted addon is make make for this addon return
		//todo find a nicer way
		if (empty($translated_fields[$addon->name])){return;}


		if (isset($translated_fields[$addon->name]['repeatable_item_name'])){
			$repeatable_item_name = $translated_fields[$addon->name]['repeatable_item_name'];
			$repeatable_items = $addon->settings->$repeatable_item_name;
		}

		$fields = $translated_fields[$addon->name]['attr'];


		if (empty($fields)){return;}

		//replace this with an recursive process

		foreach ($fields as $field){
			if (!is_array($field)) {
				$translatedFieldName =  $this->getTranslatedFieldName($field,$lang);
				if (!empty($addon->settings->{$translatedFieldName}))
				{
					$addon->settings->{$field} = $addon->settings->{$translatedFieldName};
				}
			} else {
				$addon_repeatable_items =$addon->settings->{$repeatable_item_name};
				$addon_repeatable_items_count = count($addon_repeatable_items);

				//loop on each repeatable item
				for ($idx = 0 ;$idx < $addon_repeatable_items_count; $idx++)
				{
					//loop on each repeatable translated item
					//check if a translation exist and replace it in the original value
					foreach ($field['attr'] as $translatedItem)
					{
						//normally all $afield are array
						$fieldLangValue     = null;
						$translatedKey = 'translate_' . $translatedItem . '_' . $lang;
						if (isset($addon->settings->{$repeatable_item_name}[$idx]->{$translatedKey}))
						{
							$fieldLangValue = $addon->settings->{$repeatable_item_name}[$idx]->{$translatedKey};
						}
						if (!empty($fieldLangValue))
						{
							$addon->settings->{$repeatable_item_name}[$idx]->{$translatedItem} = $fieldLangValue;
						}
					}
				}
			}
		}
	}

	public function onBeforeAddonRenderv2(&$addon)
	{

		require_once JPATH_PLUGINS .'/system/sppagebuildertranslate/config.php';

		$lang = JFactory::getLanguage()->getTag();

		if ( file_exists(JPATH_PLUGINS . '/system/sppagebuildertranslate/addons/'.$addon->name.'.php') ) {
			require_once JPATH_PLUGINS . '/system/sppagebuildertranslate/addons/'.$addon->name.'.php';
		}

		$translated_fields = SpAddonsConfigTranslation::$addons;

		//manage addon's filter by language
		if (isset(SpAddonsConfigTranslation::$addons[$addon->name]['language']) &&  SpAddonsConfigTranslation::$addons[ $addon->name ]['language'] == true) {
			if (isset($translated_fields[$addon->name]['language']) && $translated_fields[$addon->name]['language']) {
				if ($addon->settings->language != '*' && $addon->settings->language != $lang) {
					$addon = null;
					return;
				}
			}
		}

		if (empty($translated_fields)){return;}
		//is no transalted addon is make make for this addon return
		//todo find a nicer way
		if (empty($translated_fields[$addon->name])){return;}


		if (isset($translated_fields[$addon->name]['repeatable_item_name'])){
			$repeatable_item_name = $translated_fields[$addon->name]['repeatable_item_name'];
			$repeatable_items = $addon->settings->$repeatable_item_name;
		}

		$fields = $translated_fields[$addon->name]['attr'];

		if (empty($fields)){return;}

		//replace this with an recursive process

		foreach ($fields as $field){
			if (!is_array($field)) {
				$field_lang = 'translate_' . $field . '_' . $lang;
				if (!empty($addon->settings->{$field_lang}))
				{
					$addon->settings->{$field} = $addon->settings->{$field_lang};
				}
			} else {
				foreach ($field as $afield){
					//normally all $afield are array
					if (is_array($afield))
					{
						foreach ($afield as $i => $aafield)
						{
							//on multiple $repeatable_items is set / give the number of item
							foreach ($repeatable_items as $key => $repeatable_item)
							{
								$field_lang = 'translate_' . $repeatable_item_name . '_' . $aafield . '_' . $key . '_' . $lang;
								if (!empty($addon->settings->{$field_lang}))
								{
									$addon->settings->{$repeatable_item_name}[$key]->{$aafield} = $addon->settings->{$field_lang};
								}
							}
						}
					}

				}
			}
		}
	}

	/*
	 * SP Page Builder 3.0 event use to add translate option
	 * backend
	 */
	public function onBeforeAddonConfigure($addon_name, &$addon)
	{
		require_once JPATH_PLUGINS .'/system/sppagebuildertranslate/config.php';

		if ( file_exists(JPATH_PLUGINS . '/system/sppagebuildertranslate/addons/'.$addon_name.'.php') ) {
			require_once JPATH_PLUGINS . '/system/sppagebuildertranslate/addons/'.$addon_name.'.php';
		}

		if (isset(SpAddonsConfigTranslation::$addons[$addon_name])){
			$translated_fields = SpAddonsConfigTranslation::$addons[$addon_name];
		}

		//manage addon's filter by language
		if (isset(SpAddonsConfigTranslation::$addons[$addon_name]['language']) &&  SpAddonsConfigTranslation::$addons[ $addon_name ]['language'] == true) {
			$languages_list = $this->getSelectLanguagesArray();

			$language_array = array(
				'language' => array(
					'type'   => 'select',
					'title'  => JText::_( 'Language' ),
					'desc'   => JText::_( 'Select the language to display' ),
					'std'    => '*',
					'values' => $languages_list,
				)
			);

			//set default to all language (don't work with the std parameter above
			$addon['default']['language'] = '*';

			$addon['attr']['languages'] = $language_array;
			return;
		}


		//if no translation need for this addons stop here.
		if (empty($translated_fields)){return;}

		$output = array();

		$languages = $this->getLanguages();

		foreach ($languages as $language )
		{
			$this->visit($addon['attr'], $translated_fields['attr'],$language, $output);
		}



		$addon['attr']['languages'] = $output;



/*
		foreach ($translated_fields['attr'] as $field )
		{//sbou
			if (is_array($field)){
				return;
			} else	{
				$field_name_translated      = $this->getTranslatedFieldName($field, 'fr_FR');
				$addon['attr']['languages'] = array(
					$field_name_translated => $addon['attr']['general'][$field]

				);
			}
		}
*/
	}


//	//new test version for Row transalion
//	public function onBeforeRowConfigure(&$rowSettings){
//
//		//if no translation need for this builder settings stop here.
//		if (empty($translated_fields)){return;}
//
//		$output = array();
//
//		$languages = $this->getLanguages();
//
//		foreach ($languages as $language )
//		{
//			$this->visit($rowSettings['attr'], $translated_fields['attr'],$language, $output);
//		}
//
//		$addon['attr']['languages'] = $output;
//
//	}

	private function getLanguages(){
		$languages = JLanguageHelper::getLanguages();
		$default_lang = JComponentHelper::getParams('com_languages')->get('site', 'en-GB');
		//remove default language from $languages
		foreach ($languages as $i => $language) {
			if ($language->lang_code == $default_lang) {
				unset($languages[$i]);
				break;
			}
		}
		return $languages;
	}

	//format the language list for the language select

	private function getSelectLanguagesArray(){
		$languages = \JHtml::_('contentlanguage.existing',true);
		$result = array();

		foreach ($languages as $language){
			$result[$language->value]= JText::_($language->text);
		}

		return $result;

	}

	/**
	 * get the internal name to store translation
	 * @param $name
	 * @param $language
	 *
	 * @return string
	 * 	 */
	private function getTranslatedFieldName($name, $language_code)
	{
		return 'translate_' . $name . '_' . $language_code;
	}

	/*
	 * use to format the Title of field for a translated item
	 */
	private function getTranslatedFieldTitle($name, $language)
	{
		return $name .' '.$language->lang_code;
	}


	/**
	 * Use for SP Pagebuilder 2.5
	 * @param $addon_name
	 * @param $form_fields
	 * @param $options
	 */
    public function onBeforeAddonOptionsRender($addon_name,&$form_fields, &$options)
    {

        require_once JPATH_PLUGINS .'/system/sppagebuildertranslate/config.php';

        if ( file_exists(JPATH_PLUGINS . '/system/sppagebuildertranslate/addons/'.$addon_name.'.php') ) {
           require_once JPATH_PLUGINS . '/system/sppagebuildertranslate/addons/'.$addon_name.'.php';
        }

        $translated_fields = SpAddonsConfigTranslation::$addons;


        //if no translation need for this addons stop here.
        if (empty($translated_fields)){return;}

        //todo is it necessary to have the field or the cound is enought
	    $grouped_fields = $this->get_grouped_input_fields($addon_name,$options,$translated_fields);

        //load addon translated field
        $fields = $translated_fields[$addon_name]['attr'];
        if (isset($translated_fields[$addon_name]['repeatable_item_name']))
        {
	        $repeatable_item_name = $translated_fields[$addon_name]['repeatable_item_name'];
        }

        if (empty($fields)){return;}

	    $languages = $this->getLanguages();

        $translate_language = array();
        foreach ($languages as $language) {
        	//loop on field

		        foreach ($fields as $field)
		        {
		        	//$field is an array for repeatable item
		        	if (!is_array($field))
			        {
				        $hint = '';
				        //get the type from the default addon
				        if (!empty($form_fields[$addon_name]['attr']['general']))
				        {
					        $type = $form_fields[$addon_name]['attr']['general'][$field]['type'];
					        $hint  = $form_fields[$addon_name]['attr']['general'][$field]['title'];
				        }
				        else
				        {
					        //progress_bar don't have general
					        $type = $form_fields[$addon_name]['attr'][$field]['type'];
					        $hint  = $form_fields[$addon_name]['attr'][$field]['title'];
				        }

				        //don't display hint all all type field
				        if ($type == 'textarea')
				        {
				        	$hint = '';
				        }
				        else{
				        	$hint = '<span class="small"> ('.$hint.')</span>';
				        }

				        $format = empty($form_fields[$addon_name]['attr']['general'][$field]['format']) ? '' : $form_fields[$addon_name]['attr']['general'][$field]['format'];
				        $placeholder = empty($form_fields[$addon_name]['attr']['general'][$field]['placeholder']) ? '' : $form_fields[$addon_name]['attr']['general'][$field]['placeholder'];
				        $translate_language['translate_' . $field . '_' . $language->lang_code] = array(
					        'type'  => $type,
					        'title' => JText::_($field . ' ' . $language->lang_code).$hint,
					        'std'   => '',
					        'format' => $format,
					        'placeholder' => $placeholder
				        );
			        } else
			        {
				        foreach ($grouped_fields as $key => $grouped_field )
				        {
					        foreach ($fields[$repeatable_item_name]['attr'] as $field)
					        {
						        $attr_field  = $form_fields[$addon_name]['attr']['general'][$repeatable_item_name]['attr'][$field];
						        $type        = $attr_field['type'];
						        $format      = empty($attr_field['format']) ? '' : $attr_field['format'];
						        $placeholder = empty($attr_field['placeholder']) ? '' : $attr_field['placeholder'];
						        $hint = '<span class="small"> ('.$grouped_field[$field].')</span>';;
						        $translate_language['translate_' . $repeatable_item_name . '_' . $field . '_'.$key.'_' . $language->lang_code] = array(
							        'type'        => $type,
							        'title'       => JText::_($field . ' ' . $language->lang_code) . $hint,
							        'std'         => '',
							        'format'      => $format,
							        'placeholder' => $placeholder
						        );
					        }
				        }
			        }
		        }
        }

        $options['languages'] = $translate_language;
    }

	/**
	 * Grouped input filed generator
	 * use for v2
	 * @since 1.0
	 * @access private
	 * @return fields
	 */
	private function get_grouped_input_fields( $addon_name, $options,$translated_fields ) {
		//get grouped fields (see get_grouped_input_fields administrator/components/com_sppagebuilder/builder/classes/ajax.php
		$input = JFactory::getApplication()->input;
		$post = $input->post;
		$grouped = array();

        //TODO FIND A BETTER WAY BY POST
		$settings = null;
	      if (isset($_POST['settings'])) {
		      $settings = $_POST['settings'];
	      }

		if (isset($translated_fields[$addon_name]['repeatable_item_name'])){
			$repeatable_item_name = $translated_fields[$addon_name]['repeatable_item_name'];
			if (isset($settings[$repeatable_item_name]))
			{
				$grouped = $settings[$repeatable_item_name];

			}

			$count = count($grouped);
			if ($count <= 0) {$count = 1;}

		}

		return $grouped;
	}

	/**
	 * @param $addon
	 * @param $translated_fields
	 *
	 * @return mixed
	 */
	private function visit(&$addon, $translated_fields,$language,&$output)
	{
		foreach ($translated_fields as $name => $field)
		{
			if (is_array($field))
			{
					foreach ($field['attr'] as $key)
					{
						$field_name_translated          = $this->getTranslatedFieldName($name . '_' . $key . '_' , $language->lang_code);//translate_sp_accordion_item_content_1_fr-FR
						$translatedField                = $addon['general'][$name]['attr'][$key];
						$translatedField['title']       = $this->getTranslatedFieldTitle($translatedField['title'], $language);
						//$output[$field_name_translated] = $translatedField;
						$addon['general'][$name]['attr']['translate_'.$key.'_'.$language->lang_code] =  $translatedField ;

					}
			}
			else
			{
				$field_name_translated      = $this->getTranslatedFieldName($field, $language->lang_code);
				if (!isset($addon['general'])){continue;}
				$translatedField = $addon['general'][$field];
				$translatedField['title'] = $this->getTranslatedFieldTitle($translatedField['title'],$language);
				$output[$field_name_translated] =$translatedField;
			}

		}

		return $addon;
	}
}
