/**
 * @package     FILEman
 * @copyright   Copyright (C) 2011 Timble CVBA. (http://www.timble.net)
 * @license     GNU GPLv3 <http://www.gnu.org/licenses/gpl.html>
 * @link        http://www.joomlatools.com
 */

"use strict";
console.log();

(function($) {

    if (typeof window.Fileman === 'undefined') window.Fileman = {};

    Fileman.Folder = function(config) {

        var my = {
            init: function(config) {
                this.folder_input = config.folder_input ? config.folder_input : '#files-new-folder-input';
                this.create_button = config.create_button ? config.create_button : '#files-new-folder-create';
                this.post_url = config.post_url;
                this.token = config.token;
                this.container = config.container ? config.container : '.koowa_table--files tbody';
                this.template = config.template ? config.template : '#fileman-folder-template';

                $(this.folder_input).on('change paste keyup', function() {
                    var input = $(this);
                    var button = $(my.create_button);
                    if (input.val().length > 0) {
                        button.prop('disabled', false);
                    } else {
                        button.attr('disabled', true);
                    }
                });

                $(this.create_button).click(function(e) {
                    e.preventDefault();
                    var input = $(my.folder_input);
                    my.add(input.val());
                });

                if (this.template) {
                    var template = $(this.template);
                    template.html(this.templateCleanup(template.html()));
                }
            },
            templateCleanup: function(content)
            {
                return content.replace(/(href|src)=".+?\[%=/g, "$1=\"[%=");
            },
            add: function(name)
            {
                $.ajax({
                    url: this.post_url,
                    method: 'post',
                    data: {
                        name: name,
                        csrf_token: my.token
                    },
                    success: function(data) {
                        my.render(data.entities.pop(), 500);
                        $(my.folder_input).val('');
                        $(my.container).trigger('after.add');
                        $.magnificPopup.close();
                    }
                });
            },
            bind: function(event, handler) {
              $(this.container).on(event, handler);
            },
            render: function(folder, fadein, append)
            {
                var url = folder.links.self.href;

                url = url.replace(/[\?&]format=json/, '');

                var context = {
                    data: {
                        display_name: folder.display_name,
                        url: url
                    },
                    folder: folder
                };

                $(this.container).trigger('before.render',context);

                var output = new EJS({element: $(this.template).get(0)}).render(context.data);

                output = $(output);

                if (fadein) {
                    output.hide();
                }

                if (append) {
                    $(this.container).append(output);
                } else {
                    $(this.container).prepend(output);
                }

                if (fadein) {
                    output.fadeIn(fadein);
                }
            }
        };

        my.init(config);

        return my;
    };
})(kQuery);


