/**ABDB**/CREATE TABLE `#__wf_profiles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `users` text NOT NULL,
  `types` text NOT NULL,
  `components` text NOT NULL,
  `area` tinyint(3) NOT NULL,
  `device` varchar(255) NOT NULL,
  `rows` text NOT NULL,
  `plugins` text NOT NULL,
  `published` tinyint(3) NOT NULL,
  `ordering` int(11) NOT NULL,
  `checked_out` int(11) NOT NULL,
  `checked_out_time` datetime NOT NULL,
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__wf_profiles`  VALUES 
('1', 'Default', 'Default Profile for all users', '', '3,4,5,6,8,7', '', '0', 'desktop,tablet,phone', 'help,newdocument,undo,redo,spacer,bold,italic,underline,strikethrough,justifyfull,justifycenter,justifyleft,justifyright,spacer,blockquote,formatselect,styleselect,removeformat,cleanup;fontselect,fontsizeselect,fontcolor,spacer,clipboard,indent,outdent,lists,sub,sup,textcase,charmap,hr;directionality,fullscreen,print,searchreplace,spacer,table,style,xhtmlxtras;visualaid,visualchars,visualblocks,nonbreaking,anchor,unlink,link,imgmanager,spellchecker,article', 'formatselect,styleselect,cleanup,fontselect,fontsizeselect,fontcolor,clipboard,lists,textcase,charmap,hr,directionality,fullscreen,print,searchreplace,table,style,xhtmlxtras,visualchars,visualblocks,nonbreaking,anchor,link,imgmanager,spellchecker,article,spellchecker,article,browser,contextmenu,inlinepopups,media,preview,source', '1', '1', '0', '0000-00-00 00:00:00', '{}'),
('2', 'Front End', 'Sample Front-end Profile', '', '3,4,5', '', '1', 'desktop,tablet,phone', 'help,newdocument,undo,redo,spacer,bold,italic,underline,strikethrough,justifyfull,justifycenter,justifyleft,justifyright,spacer,formatselect,styleselect;clipboard,searchreplace,indent,outdent,lists,cleanup,charmap,removeformat,hr,sub,sup,textcase,nonbreaking,visualchars,visualblocks;fullscreen,print,visualaid,style,xhtmlxtras,anchor,unlink,link,imgmanager,spellchecker,article', 'charmap,contextmenu,inlinepopups,help,clipboard,searchreplace,fullscreen,preview,print,style,textcase,nonbreaking,visualchars,visualblocks,xhtmlxtras,imgmanager,anchor,link,spellchecker,article,lists,formatselect,styleselect,hr', '0', '2', '0', '0000-00-00 00:00:00', '{}'),
('3', 'Blogger', 'Simple Blogging Profile', '', '3,4,5,6,8,7', '', '0', 'desktop,tablet,phone', 'bold,italic,strikethrough,lists,blockquote,spacer,justifyleft,justifycenter,justifyright,spacer,link,unlink,imgmanager,article,spellchecker,fullscreen,kitchensink;formatselect,styleselect,underline,justifyfull,clipboard,removeformat,charmap,indent,outdent,undo,redo,help', 'link,imgmanager,article,spellchecker,fullscreen,kitchensink,clipboard,contextmenu,inlinepopups,lists,formatselect,styleselect,textpattern', '0', '3', '0', '0000-00-00 00:00:00', 'null'),
('4', 'Mobile', 'Sample Mobile Profile', '', '3,4,5,6,8,7', '', '0', 'tablet,phone', 'undo,redo,spacer,bold,italic,underline,formatselect,spacer,justifyleft,justifycenter,justifyfull,justifyright,spacer,fullscreen,kitchensink;styleselect,lists,spellchecker,article,link,unlink', 'fullscreen,kitchensink,spellchecker,article,link,inlinepopups,lists,formatselect,styleselect,textpattern', '0', '4', '0', '0000-00-00 00:00:00', 'null'),
('5', 'Markdown', 'Sample Markdown Profile', '', '6,7,3,4,5,8', '', '0', 'desktop,tablet,phone', 'fullscreen,justifyleft,justifycenter,justifyfull,justifyright,link,unlink,imgmanager,styleselect', 'fullscreen,link,imgmanager,styleselect,inlinepopups,media,textpattern', '0', '5', '0', '0000-00-00 00:00:00', 'null');
/**ABDB**/CREATE TABLE `#__viewlevels` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `rules` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_assetgroup_title_lookup` (`title`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__viewlevels`  VALUES 
('1', 'Public', '0', '[1]'),
('2', 'Registered', '2', '[6,2,8]'),
('3', 'Special', '3', '[6,3,8]'),
('5', 'Guest', '1', '[9]'),
('6', 'Super Users', '4', '[8]');
/**ABDB**/CREATE TABLE `#__utf8_conversion` (
  `converted` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__utf8_conversion`  VALUES 
('2');
/**ABDB**/CREATE TABLE `#__users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `username` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `password` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `block` tinyint(4) NOT NULL DEFAULT '0',
  `sendEmail` tinyint(4) DEFAULT '0',
  `registerDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lastvisitDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `activation` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `lastResetTime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'Date of last password reset',
  `resetCount` int(11) NOT NULL DEFAULT '0' COMMENT 'Count of password resets since lastResetTime',
  `otpKey` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Two factor authentication encrypted keys',
  `otep` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'One time emergency passwords',
  `requireReset` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Require user to reset password on next login',
  PRIMARY KEY (`id`),
  KEY `idx_name` (`name`(100)),
  KEY `idx_block` (`block`),
  KEY `username` (`username`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=808 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__users`  VALUES 
('803', 'Super User', 'adminump', 'faizul@ump.edu.my', '$2y$10$/3wQQ/T7wTFlKDvqQfAx6.wkJAdY15A.uf6/TE4S88znobJ0aKXUO', '0', '1', '2019-08-28 03:04:45', '2020-02-26 01:49:09', '0', '', '0000-00-00 00:00:00', '0', '', '', '0'),
('804', 'Faizul Azley', 'faizul', 'faizul@ump.edu.my', '$2y$10$viNI0XOhVvBNOkiLdnMyYeMP7OvZ/8j9AMvKG.QH/n9HdH8kpISQi', '0', '0', '2019-12-20 02:31:46', '2019-12-20 02:44:45', '', '{\"admin_style\":\"\",\"admin_language\":\"\",\"language\":\"\",\"editor\":\"\",\"helpsite\":\"\",\"timezone\":\"\"}', '0000-00-00 00:00:00', '0', '', '', '0'),
('805', 'Azlina Ali', 'alin', 'azlinaali@ump.edu.my', '$2y$10$mDSJlBK2.SF83C/Mibit1eRsuHp8cvUr9LIZqpKhNbyShvelpuqO.', '0', '0', '2020-01-10 02:17:33', '0000-00-00 00:00:00', '', '{\"admin_style\":\"\",\"admin_language\":\"\",\"language\":\"\",\"editor\":\"\",\"helpsite\":\"\",\"timezone\":\"\"}', '0000-00-00 00:00:00', '0', '', '', '0'),
('806', 'Aman Shah', 'aman', 'amanshah@ump.edu.my', '$2y$10$xZLYOiNQRjInAWoFlppncOencWZm77rSnxu/TAOr9O0Z/PbpNFtdO', '0', '0', '2020-01-10 02:18:59', '0000-00-00 00:00:00', '', '{\"admin_style\":\"\",\"admin_language\":\"\",\"language\":\"\",\"editor\":\"\",\"helpsite\":\"\",\"timezone\":\"\"}', '0000-00-00 00:00:00', '0', '', '', '0'),
('807', 'Mohd Halimi b. Abdul Aziz', 'halimi', 'halimi@ump.edu.my', '$2y$10$d3so37XwqTvBdkIXP9/zBuJSZ906wBqMzFQl6bFLlZh920xgPdH7e', '0', '0', '2020-01-28 02:46:00', '2020-02-19 08:28:49', '', '{\"admin_style\":\"\",\"admin_language\":\"\",\"language\":\"\",\"editor\":\"\",\"timezone\":\"\"}', '0000-00-00 00:00:00', '0', '', '', '0');
/**ABDB**/CREATE TABLE `#__usergroups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Adjacency List Reference Id',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_usergroup_parent_title_lookup` (`parent_id`,`title`),
  KEY `idx_usergroup_title_lookup` (`title`),
  KEY `idx_usergroup_adjacency_lookup` (`parent_id`),
  KEY `idx_usergroup_nested_set_lookup` (`lft`,`rgt`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__usergroups`  VALUES 
('1', '0', '1', '18', 'Public'),
('2', '1', '8', '15', 'Registered'),
('3', '2', '9', '14', 'Author'),
('4', '3', '10', '13', 'Editor'),
('5', '4', '11', '12', 'Publisher'),
('6', '1', '4', '7', 'Manager'),
('7', '6', '5', '6', 'Administrator'),
('8', '1', '16', '17', 'Super Users'),
('9', '1', '2', '3', 'Guest');
/**ABDB**/CREATE TABLE `#__user_usergroup_map` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Foreign Key to #__users.id',
  `group_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Foreign Key to #__usergroups.id',
  PRIMARY KEY (`user_id`,`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__user_usergroup_map`  VALUES 
('803', '8'),
('804', '8'),
('805', '8'),
('806', '8'),
('807', '7');
/**ABDB**/CREATE TABLE `#__user_profiles` (
  `user_id` int(11) NOT NULL,
  `profile_key` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `profile_value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `idx_user_id_profile_key` (`user_id`,`profile_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Simple user profile storage table';
/**ABDB**/CREATE TABLE `#__user_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `catid` int(10) unsigned NOT NULL DEFAULT '0',
  `subject` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `body` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_user_id` int(10) unsigned NOT NULL,
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `review_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_category_id` (`catid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__user_keys` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `series` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `invalid` tinyint(4) NOT NULL,
  `time` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `uastring` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `series` (`series`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__updates` (
  `update_id` int(11) NOT NULL AUTO_INCREMENT,
  `update_site_id` int(11) DEFAULT '0',
  `extension_id` int(11) DEFAULT '0',
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `element` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `folder` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `client_id` tinyint(3) DEFAULT '0',
  `version` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `detailsurl` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `infourl` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `extra_query` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`update_id`)
) ENGINE=InnoDB AUTO_INCREMENT=340 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Available Updates';
/**ABDB**/INSERT INTO `#__updates`  VALUES 
('256', '2', '0', 'Armenian', '', 'pkg_hy-AM', 'package', '', '0', '3.4.4.1', '', 'https://update.joomla.org/language/details3/hy-AM_details.xml', '', ''),
('257', '2', '0', 'Romanian', '', 'pkg_ro-RO', 'package', '', '0', '3.9.13.1', '', 'https://update.joomla.org/language/details3/ro-RO_details.xml', '', ''),
('258', '2', '0', 'Flemish', '', 'pkg_nl-BE', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/nl-BE_details.xml', '', ''),
('259', '2', '0', 'Chinese Traditional', '', 'pkg_zh-TW', 'package', '', '0', '3.8.0.1', '', 'https://update.joomla.org/language/details3/zh-TW_details.xml', '', ''),
('260', '2', '0', 'French', '', 'pkg_fr-FR', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/fr-FR_details.xml', '', ''),
('261', '2', '0', 'Galician', '', 'pkg_gl-ES', 'package', '', '0', '3.3.1.2', '', 'https://update.joomla.org/language/details3/gl-ES_details.xml', '', ''),
('262', '2', '0', 'Georgian', '', 'pkg_ka-GE', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/ka-GE_details.xml', '', ''),
('263', '2', '0', 'Greek', '', 'pkg_el-GR', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/el-GR_details.xml', '', ''),
('264', '2', '0', 'Japanese', '', 'pkg_ja-JP', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/ja-JP_details.xml', '', ''),
('265', '2', '0', 'Hebrew', '', 'pkg_he-IL', 'package', '', '0', '3.1.1.2', '', 'https://update.joomla.org/language/details3/he-IL_details.xml', '', ''),
('266', '2', '0', 'Bengali', '', 'pkg_bn-BD', 'package', '', '0', '3.8.10.1', '', 'https://update.joomla.org/language/details3/bn-BD_details.xml', '', ''),
('267', '2', '0', 'Hungarian', '', 'pkg_hu-HU', 'package', '', '0', '3.9.12.1', '', 'https://update.joomla.org/language/details3/hu-HU_details.xml', '', ''),
('268', '2', '0', 'Afrikaans', '', 'pkg_af-ZA', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/af-ZA_details.xml', '', ''),
('269', '2', '0', 'Arabic Unitag', '', 'pkg_ar-AA', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/ar-AA_details.xml', '', ''),
('270', '2', '0', 'Belarusian', '', 'pkg_be-BY', 'package', '', '0', '3.2.1.2', '', 'https://update.joomla.org/language/details3/be-BY_details.xml', '', ''),
('271', '2', '0', 'Bulgarian', '', 'pkg_bg-BG', 'package', '', '0', '3.6.5.2', '', 'https://update.joomla.org/language/details3/bg-BG_details.xml', '', ''),
('272', '2', '0', 'Catalan', '', 'pkg_ca-ES', 'package', '', '0', '3.9.11.2', '', 'https://update.joomla.org/language/details3/ca-ES_details.xml', '', ''),
('273', '2', '0', 'Chinese Simplified', '', 'pkg_zh-CN', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/zh-CN_details.xml', '', ''),
('274', '2', '0', 'Croatian', '', 'pkg_hr-HR', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/hr-HR_details.xml', '', ''),
('275', '2', '0', 'Czech', '', 'pkg_cs-CZ', 'package', '', '0', '3.9.13.1', '', 'https://update.joomla.org/language/details3/cs-CZ_details.xml', '', ''),
('276', '2', '0', 'Danish', '', 'pkg_da-DK', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/da-DK_details.xml', '', ''),
('277', '2', '0', 'Dutch', '', 'pkg_nl-NL', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/nl-NL_details.xml', '', ''),
('278', '2', '0', 'Esperanto', '', 'pkg_eo-XX', 'package', '', '0', '3.8.11.1', '', 'https://update.joomla.org/language/details3/eo-XX_details.xml', '', ''),
('279', '2', '0', 'Estonian', '', 'pkg_et-EE', 'package', '', '0', '3.9.14.2', '', 'https://update.joomla.org/language/details3/et-EE_details.xml', '', ''),
('280', '2', '0', 'Italian', '', 'pkg_it-IT', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/it-IT_details.xml', '', ''),
('281', '2', '0', 'Khmer', '', 'pkg_km-KH', 'package', '', '0', '3.4.5.1', '', 'https://update.joomla.org/language/details3/km-KH_details.xml', '', ''),
('282', '2', '0', 'Korean', '', 'pkg_ko-KR', 'package', '', '0', '3.8.9.1', '', 'https://update.joomla.org/language/details3/ko-KR_details.xml', '', ''),
('283', '2', '0', 'Latvian', '', 'pkg_lv-LV', 'package', '', '0', '3.7.3.1', '', 'https://update.joomla.org/language/details3/lv-LV_details.xml', '', ''),
('284', '2', '0', 'Lithuanian', '', 'pkg_lt-LT', 'package', '', '0', '3.9.6.1', '', 'https://update.joomla.org/language/details3/lt-LT_details.xml', '', ''),
('285', '2', '0', 'Macedonian', '', 'pkg_mk-MK', 'package', '', '0', '3.6.5.1', '', 'https://update.joomla.org/language/details3/mk-MK_details.xml', '', ''),
('286', '2', '0', 'Norwegian Bokmal', '', 'pkg_nb-NO', 'package', '', '0', '3.8.11.1', '', 'https://update.joomla.org/language/details3/nb-NO_details.xml', '', ''),
('287', '2', '0', 'Norwegian Nynorsk', '', 'pkg_nn-NO', 'package', '', '0', '3.4.2.1', '', 'https://update.joomla.org/language/details3/nn-NO_details.xml', '', ''),
('288', '2', '0', 'Persian', '', 'pkg_fa-IR', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/fa-IR_details.xml', '', ''),
('289', '2', '0', 'Polish', '', 'pkg_pl-PL', 'package', '', '0', '3.9.13.1', '', 'https://update.joomla.org/language/details3/pl-PL_details.xml', '', ''),
('290', '2', '0', 'Portuguese', '', 'pkg_pt-PT', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/pt-PT_details.xml', '', ''),
('291', '2', '0', 'Russian', '', 'pkg_ru-RU', 'package', '', '0', '3.9.12.1', '', 'https://update.joomla.org/language/details3/ru-RU_details.xml', '', ''),
('292', '2', '0', 'English AU', '', 'pkg_en-AU', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/en-AU_details.xml', '', ''),
('293', '2', '0', 'Slovak', '', 'pkg_sk-SK', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/sk-SK_details.xml', '', ''),
('294', '2', '0', 'English US', '', 'pkg_en-US', 'package', '', '0', '3.9.15.2', '', 'https://update.joomla.org/language/details3/en-US_details.xml', '', ''),
('295', '2', '0', 'Swedish', '', 'pkg_sv-SE', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/sv-SE_details.xml', '', ''),
('296', '2', '0', 'Syriac', '', 'pkg_sy-IQ', 'package', '', '0', '3.4.5.1', '', 'https://update.joomla.org/language/details3/sy-IQ_details.xml', '', ''),
('297', '2', '0', 'Tamil', '', 'pkg_ta-IN', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/ta-IN_details.xml', '', ''),
('298', '2', '0', 'Thai', '', 'pkg_th-TH', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/th-TH_details.xml', '', ''),
('299', '2', '0', 'Turkish', '', 'pkg_tr-TR', 'package', '', '0', '3.9.4.1', '', 'https://update.joomla.org/language/details3/tr-TR_details.xml', '', ''),
('300', '2', '0', 'Ukrainian', '', 'pkg_uk-UA', 'package', '', '0', '3.7.1.1', '', 'https://update.joomla.org/language/details3/uk-UA_details.xml', '', ''),
('301', '2', '0', 'Uyghur', '', 'pkg_ug-CN', 'package', '', '0', '3.7.5.2', '', 'https://update.joomla.org/language/details3/ug-CN_details.xml', '', ''),
('302', '2', '0', 'Albanian', '', 'pkg_sq-AL', 'package', '', '0', '3.1.1.2', '', 'https://update.joomla.org/language/details3/sq-AL_details.xml', '', ''),
('303', '2', '0', 'Basque', '', 'pkg_eu-ES', 'package', '', '0', '3.7.5.1', '', 'https://update.joomla.org/language/details3/eu-ES_details.xml', '', ''),
('304', '2', '0', 'Hindi', '', 'pkg_hi-IN', 'package', '', '0', '3.3.6.2', '', 'https://update.joomla.org/language/details3/hi-IN_details.xml', '', ''),
('305', '2', '0', 'German DE', '', 'pkg_de-DE', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/de-DE_details.xml', '', ''),
('306', '2', '0', 'Portuguese Brazil', '', 'pkg_pt-BR', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/pt-BR_details.xml', '', ''),
('307', '2', '0', 'Serbian Latin', '', 'pkg_sr-YU', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/sr-YU_details.xml', '', ''),
('308', '2', '0', 'Spanish', '', 'pkg_es-ES', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/es-ES_details.xml', '', ''),
('309', '2', '0', 'Bosnian', '', 'pkg_bs-BA', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/bs-BA_details.xml', '', ''),
('310', '2', '0', 'Serbian Cyrillic', '', 'pkg_sr-RS', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/sr-RS_details.xml', '', ''),
('311', '2', '0', 'Vietnamese', '', 'pkg_vi-VN', 'package', '', '0', '3.2.1.2', '', 'https://update.joomla.org/language/details3/vi-VN_details.xml', '', ''),
('312', '2', '0', 'Bahasa Indonesia', '', 'pkg_id-ID', 'package', '', '0', '3.6.2.1', '', 'https://update.joomla.org/language/details3/id-ID_details.xml', '', ''),
('313', '2', '0', 'Finnish', '', 'pkg_fi-FI', 'package', '', '0', '3.9.14.1', '', 'https://update.joomla.org/language/details3/fi-FI_details.xml', '', ''),
('314', '2', '0', 'Swahili', '', 'pkg_sw-KE', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/sw-KE_details.xml', '', ''),
('315', '2', '0', 'Montenegrin', '', 'pkg_srp-ME', 'package', '', '0', '3.3.1.2', '', 'https://update.joomla.org/language/details3/srp-ME_details.xml', '', ''),
('316', '2', '0', 'English CA', '', 'pkg_en-CA', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/en-CA_details.xml', '', ''),
('317', '2', '0', 'French CA', '', 'pkg_fr-CA', 'package', '', '0', '3.6.5.1', '', 'https://update.joomla.org/language/details3/fr-CA_details.xml', '', ''),
('318', '2', '0', 'Welsh', '', 'pkg_cy-GB', 'package', '', '0', '3.9.14.1', '', 'https://update.joomla.org/language/details3/cy-GB_details.xml', '', ''),
('319', '2', '0', 'Sinhala', '', 'pkg_si-LK', 'package', '', '0', '3.3.1.2', '', 'https://update.joomla.org/language/details3/si-LK_details.xml', '', ''),
('320', '2', '0', 'Dari Persian', '', 'pkg_prs-AF', 'package', '', '0', '3.4.4.3', '', 'https://update.joomla.org/language/details3/prs-AF_details.xml', '', ''),
('321', '2', '0', 'Turkmen', '', 'pkg_tk-TM', 'package', '', '0', '3.5.0.2', '', 'https://update.joomla.org/language/details3/tk-TM_details.xml', '', ''),
('322', '2', '0', 'Irish', '', 'pkg_ga-IE', 'package', '', '0', '3.8.13.1', '', 'https://update.joomla.org/language/details3/ga-IE_details.xml', '', ''),
('323', '2', '0', 'Dzongkha', '', 'pkg_dz-BT', 'package', '', '0', '3.6.2.1', '', 'https://update.joomla.org/language/details3/dz-BT_details.xml', '', ''),
('324', '2', '0', 'Slovenian', '', 'pkg_sl-SI', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/sl-SI_details.xml', '', ''),
('325', '2', '0', 'Spanish CO', '', 'pkg_es-CO', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/es-CO_details.xml', '', ''),
('326', '2', '0', 'German CH', '', 'pkg_de-CH', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/de-CH_details.xml', '', ''),
('327', '2', '0', 'German AT', '', 'pkg_de-AT', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/de-AT_details.xml', '', ''),
('328', '2', '0', 'German LI', '', 'pkg_de-LI', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/de-LI_details.xml', '', ''),
('329', '2', '0', 'German LU', '', 'pkg_de-LU', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/de-LU_details.xml', '', ''),
('330', '2', '0', 'English NZ', '', 'pkg_en-NZ', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/en-NZ_details.xml', '', ''),
('331', '2', '0', 'Kazakh', '', 'pkg_kk-KZ', 'package', '', '0', '3.9.15.1', '', 'https://update.joomla.org/language/details3/kk-KZ_details.xml', '', ''),
('334', '15', '0', 'shaper_yamas', 'Shaper Yamas', 'shaper_yamas', 'template', '', '0', '1.1', '', 'https://www.joomshaper.com/updates/shaper-yamas.xml', '', ''),
('335', '16', '0', 'FOF 3.x Stable', 'FOF 3.x Stable', 'lib_fof30', 'library', '', '1', '3.5.1', '', 'http://cdn.akeebabackup.com/updates/fof3_file.xml', '\n					https://www.akeebabackup.com/download/fof3/3-5-1.html\n				', ''),
('338', '24', '0', 'SP Page Builder Translate', 'SP Page Builder Translate', 'plg_sppagebuildertranslate', 'plugin', 'system', '1', '2.7', '', 'https://www.faboba.com/update/sppagebuidertranslate/plg_sppbuildertranslate.xml', 'https://www.faboba.com/component/ars/?view=release&id=236', '');
/**ABDB**/CREATE TABLE `#__update_sites_extensions` (
  `update_site_id` int(11) NOT NULL DEFAULT '0',
  `extension_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`update_site_id`,`extension_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Links extensions to update sites';
/**ABDB**/INSERT INTO `#__update_sites_extensions`  VALUES 
('1', '700'),
('2', '802'),
('3', '28'),
('4', '10004'),
('11', '10011'),
('13', '10000'),
('15', '10025'),
('16', '10026'),
('17', '10033'),
('18', '10032'),
('22', '10057'),
('24', '10060'),
('25', '10065'),
('26', '10068'),
('27', '10078'),
('28', '10086'),
('32', '10125');
/**ABDB**/CREATE TABLE `#__update_sites` (
  `update_site_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `location` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `enabled` int(11) DEFAULT '0',
  `last_check_timestamp` bigint(20) DEFAULT '0',
  `extra_query` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`update_site_id`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Update Sites';
/**ABDB**/INSERT INTO `#__update_sites`  VALUES 
('1', 'Joomla! Core', 'collection', 'https://update.joomla.org/core/list.xml', '1', '1582683843', ''),
('2', 'Accredited Joomla! Translations', 'collection', 'https://update.joomla.org/language/translationlist_3.xml', '1', '1582680267', ''),
('3', 'Joomla! Update Component Update Site', 'extension', 'https://update.joomla.org/core/extensions/com_joomlaupdate.xml', '1', '1582680289', ''),
('4', 'System - Helix Ultimate Framework', 'extension', 'http://www.joomshaper.com/updates/plg-system-helixultimate.xml', '1', '1582680269', ''),
('11', 'WebInstaller Update Site', 'extension', 'https://appscdn.joomla.org/webapps/jedapps/webinstaller.xml', '1', '1582680269', ''),
('13', 'SP Page Builder', 'extension', 'https://www.joomshaper.com/updates/com-sp-page-builder-pro.xml', '1', '1582680270', 'joomshaper_email=2017.ump.ptmk%40gmail.com&amp;joomshaper_license_key=0b76699ec85b69cf4995cd7b1db01f49'),
('15', 'yamas', 'extension', 'https://www.joomshaper.com/updates/shaper-yamas.xml', '1', '1582680270', ''),
('16', 'FOF 3.x', 'extension', 'http://cdn.akeebabackup.com/updates/fof3_file.xml', '1', '1582680271', ''),
('17', 'Akeeba FEF', 'extension', 'http://cdn.akeebabackup.com/updates/fef.xml', '1', '1582680271', ''),
('18', 'Akeeba Backup Core', 'extension', 'https://cdn.akeebabackup.com/updates/pkgakeebacore.xml', '1', '1582683918', ''),
('22', 'Accredited Joomla! Translations', 'collection', 'http://update.joomla.org/language/translationlist_3.xml', '1', '1582680272', ''),
('24', 'SP Page Builder Translate', 'extension', 'https://www.faboba.com/update/sppagebuidertranslate/plg_sppbuildertranslate.xml', '1', '1582680275', ''),
('25', 'Falang Pro', 'extension', 'https://www.faboba.com/update/falang/pkgfalangpro.xml', '1', '1582680277', ''),
('26', 'DOCman', 'extension', 'https://api.joomlatools.com/extension/docman.xml', '1', '1582680278', ''),
('27', 'FILEman', 'extension', 'https://api.joomlatools.com/extension/fileman.xml', '1', '1582680279', ''),
('28', 'LOGman', 'extension', 'https://api.joomlatools.com/extension/logman.xml', '1', '1582680280', ''),
('32', 'JCE Editor Package', 'extension', 'https://cdn.joomlacontenteditor.net/updates/xml/editor/pkg_jce.xml', '1', '1582683842', '');
/**ABDB**/CREATE TABLE `#__ucm_history` (
  `version_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ucm_item_id` int(10) unsigned NOT NULL,
  `ucm_type_id` int(10) unsigned NOT NULL,
  `version_note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Optional version name',
  `save_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `editor_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `character_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Number of characters in this version.',
  `sha1_hash` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'SHA1 hash of the version_data column.',
  `version_data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'json-encoded string of version data',
  `keep_forever` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0=auto delete; 1=keep',
  PRIMARY KEY (`version_id`),
  KEY `idx_ucm_item_id` (`ucm_type_id`,`ucm_item_id`),
  KEY `idx_save_date` (`save_date`)
) ENGINE=InnoDB AUTO_INCREMENT=344 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__ucm_history`  VALUES 
('1', '1', '2', '', '2019-08-28 03:04:45', '803', '1688', 'a28eb900b520a7030741fc7fc174a65c7aad0cb5', '{\"id\":1,\"name\":\"Contact\",\"alias\":\"contact\",\"con_position\":\"\",\"address\":\"\",\"suburb\":\"\",\"state\":\"\",\"country\":\"\",\"postcode\":\"\",\"telephone\":\"\",\"fax\":\"\",\"misc\":\"\",\"image\":\"\",\"email_to\":\"\",\"default_con\":0,\"published\":\"1\",\"checked_out\":null,\"checked_out_time\":null,\"ordering\":1,\"params\":\"{\\\"show_contact_category\\\":\\\"\\\",\\\"show_contact_list\\\":\\\"\\\",\\\"presentation_style\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_info\\\":\\\"\\\",\\\"show_name\\\":\\\"\\\",\\\"show_position\\\":\\\"\\\",\\\"show_email\\\":\\\"\\\",\\\"add_mailto_link\\\":\\\"\\\",\\\"show_street_address\\\":\\\"\\\",\\\"show_suburb\\\":\\\"\\\",\\\"show_state\\\":\\\"\\\",\\\"show_postcode\\\":\\\"\\\",\\\"show_country\\\":\\\"\\\",\\\"show_telephone\\\":\\\"\\\",\\\"show_mobile\\\":\\\"\\\",\\\"show_fax\\\":\\\"\\\",\\\"show_webpage\\\":\\\"\\\",\\\"show_image\\\":\\\"\\\",\\\"show_misc\\\":\\\"\\\",\\\"allow_vcard\\\":\\\"\\\",\\\"show_articles\\\":\\\"\\\",\\\"articles_display_num\\\":\\\"\\\",\\\"show_profile\\\":\\\"\\\",\\\"show_links\\\":\\\"\\\",\\\"linka_name\\\":\\\"\\\",\\\"linka\\\":false,\\\"linkb_name\\\":\\\"\\\",\\\"linkb\\\":false,\\\"linkc_name\\\":\\\"\\\",\\\"linkc\\\":false,\\\"linkd_name\\\":\\\"\\\",\\\"linkd\\\":false,\\\"linke_name\\\":\\\"\\\",\\\"linke\\\":false,\\\"contact_layout\\\":\\\"\\\",\\\"show_email_form\\\":\\\"\\\",\\\"show_email_copy\\\":\\\"\\\",\\\"banned_email\\\":\\\"\\\",\\\"banned_subject\\\":\\\"\\\",\\\"banned_text\\\":\\\"\\\",\\\"validate_session\\\":\\\"\\\",\\\"custom_reply\\\":\\\"\\\",\\\"redirect\\\":\\\"\\\"}\",\"user_id\":0,\"catid\":\"4\",\"access\":\"1\",\"mobile\":\"\",\"webpage\":false,\"sortname1\":\"\",\"sortname2\":\"\",\"sortname3\":\"\",\"language\":\"*\",\"created\":\"2018-02-22 18:30:43\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-22 18:30:43\",\"modified_by\":null,\"metakey\":\"\",\"metadesc\":\"\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"rights\\\":\\\"\\\"}\",\"featured\":\"0\",\"xreference\":\"\",\"publish_up\":\"0000-00-00 00:00:00\",\"publish_down\":\"0000-00-00 00:00:00\",\"version\":1,\"hits\":null}', '0'),
('2', '1', '2', '', '2019-08-28 03:04:45', '803', '1712', 'f0c36e09d47e25ad97c973c5e8c3c10ea556f83d', '{\"id\":1,\"name\":\"Contact\",\"alias\":\"contact\",\"con_position\":\"\",\"address\":\"\",\"suburb\":\"\",\"state\":\"\",\"country\":\"\",\"postcode\":\"\",\"telephone\":\"\",\"fax\":\"\",\"misc\":\"\",\"image\":\"\",\"email_to\":\"\",\"default_con\":0,\"published\":\"1\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-22 18:31:13\",\"ordering\":\"1\",\"params\":\"{\\\"show_contact_category\\\":\\\"\\\",\\\"show_contact_list\\\":\\\"\\\",\\\"presentation_style\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_info\\\":\\\"\\\",\\\"show_name\\\":\\\"\\\",\\\"show_position\\\":\\\"\\\",\\\"show_email\\\":\\\"\\\",\\\"add_mailto_link\\\":\\\"\\\",\\\"show_street_address\\\":\\\"\\\",\\\"show_suburb\\\":\\\"\\\",\\\"show_state\\\":\\\"\\\",\\\"show_postcode\\\":\\\"\\\",\\\"show_country\\\":\\\"\\\",\\\"show_telephone\\\":\\\"\\\",\\\"show_mobile\\\":\\\"\\\",\\\"show_fax\\\":\\\"\\\",\\\"show_webpage\\\":\\\"\\\",\\\"show_image\\\":\\\"\\\",\\\"show_misc\\\":\\\"\\\",\\\"allow_vcard\\\":\\\"\\\",\\\"show_articles\\\":\\\"\\\",\\\"articles_display_num\\\":\\\"\\\",\\\"show_profile\\\":\\\"\\\",\\\"show_links\\\":\\\"\\\",\\\"linka_name\\\":\\\"\\\",\\\"linka\\\":false,\\\"linkb_name\\\":\\\"\\\",\\\"linkb\\\":false,\\\"linkc_name\\\":\\\"\\\",\\\"linkc\\\":false,\\\"linkd_name\\\":\\\"\\\",\\\"linkd\\\":false,\\\"linke_name\\\":\\\"\\\",\\\"linke\\\":false,\\\"contact_layout\\\":\\\"\\\",\\\"show_email_form\\\":\\\"\\\",\\\"show_email_copy\\\":\\\"\\\",\\\"banned_email\\\":\\\"\\\",\\\"banned_subject\\\":\\\"\\\",\\\"banned_text\\\":\\\"\\\",\\\"validate_session\\\":\\\"\\\",\\\"custom_reply\\\":\\\"\\\",\\\"redirect\\\":\\\"\\\"}\",\"user_id\":\"871\",\"catid\":\"4\",\"access\":\"1\",\"mobile\":\"\",\"webpage\":false,\"sortname1\":\"\",\"sortname2\":\"\",\"sortname3\":\"\",\"language\":\"*\",\"created\":\"2018-02-22 18:30:43\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-22 18:31:44\",\"modified_by\":\"871\",\"metakey\":\"\",\"metadesc\":\"\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"rights\\\":\\\"\\\"}\",\"featured\":\"0\",\"xreference\":\"\",\"publish_up\":\"0000-00-00 00:00:00\",\"publish_down\":\"0000-00-00 00:00:00\",\"version\":2,\"hits\":\"1\"}', '0'),
('3', '1', '2', '', '2019-08-28 03:04:45', '803', '1805', '73cb062813e3aa45647d92fb2e13638720efe036', '{\"id\":1,\"name\":\"Contact\",\"alias\":\"contact\",\"con_position\":\"Founder & CEO\",\"address\":\"2261 Byers Lane\",\"suburb\":\"Paradise\",\"state\":\"California\",\"country\":\"USA\",\"postcode\":\"95969\",\"telephone\":\"530-873-7429\",\"fax\":\"\",\"misc\":\"\",\"image\":\"\",\"email_to\":\"email@email.com\",\"default_con\":0,\"published\":\"1\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-22 18:32:56\",\"ordering\":\"1\",\"params\":\"{\\\"show_contact_category\\\":\\\"\\\",\\\"show_contact_list\\\":\\\"\\\",\\\"presentation_style\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_info\\\":\\\"\\\",\\\"show_name\\\":\\\"\\\",\\\"show_position\\\":\\\"\\\",\\\"show_email\\\":\\\"\\\",\\\"add_mailto_link\\\":\\\"\\\",\\\"show_street_address\\\":\\\"\\\",\\\"show_suburb\\\":\\\"\\\",\\\"show_state\\\":\\\"\\\",\\\"show_postcode\\\":\\\"\\\",\\\"show_country\\\":\\\"\\\",\\\"show_telephone\\\":\\\"\\\",\\\"show_mobile\\\":\\\"\\\",\\\"show_fax\\\":\\\"\\\",\\\"show_webpage\\\":\\\"\\\",\\\"show_image\\\":\\\"\\\",\\\"show_misc\\\":\\\"\\\",\\\"allow_vcard\\\":\\\"\\\",\\\"show_articles\\\":\\\"\\\",\\\"articles_display_num\\\":\\\"\\\",\\\"show_profile\\\":\\\"\\\",\\\"show_links\\\":\\\"\\\",\\\"linka_name\\\":\\\"\\\",\\\"linka\\\":false,\\\"linkb_name\\\":\\\"\\\",\\\"linkb\\\":false,\\\"linkc_name\\\":\\\"\\\",\\\"linkc\\\":false,\\\"linkd_name\\\":\\\"\\\",\\\"linkd\\\":false,\\\"linke_name\\\":\\\"\\\",\\\"linke\\\":false,\\\"contact_layout\\\":\\\"\\\",\\\"show_email_form\\\":\\\"\\\",\\\"show_email_copy\\\":\\\"\\\",\\\"banned_email\\\":\\\"\\\",\\\"banned_subject\\\":\\\"\\\",\\\"banned_text\\\":\\\"\\\",\\\"validate_session\\\":\\\"\\\",\\\"custom_reply\\\":\\\"\\\",\\\"redirect\\\":\\\"\\\"}\",\"user_id\":\"871\",\"catid\":\"4\",\"access\":\"1\",\"mobile\":\"858-774-4605\",\"webpage\":false,\"sortname1\":\"\",\"sortname2\":\"\",\"sortname3\":\"\",\"language\":\"*\",\"created\":\"2018-02-22 18:30:43\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-22 18:34:50\",\"modified_by\":\"871\",\"metakey\":\"\",\"metadesc\":\"\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"rights\\\":\\\"\\\"}\",\"featured\":\"0\",\"xreference\":\"\",\"publish_up\":\"0000-00-00 00:00:00\",\"publish_down\":\"0000-00-00 00:00:00\",\"version\":3,\"hits\":\"3\"}', '0'),
('4', '1', '2', '', '2019-08-28 03:04:45', '803', '1806', '015836154c4087cd75381bcf24c32a74856fce67', '{\"id\":1,\"name\":\"Contact\",\"alias\":\"contact\",\"con_position\":\"Founder & CEO\",\"address\":\"2261 Byers Lane\",\"suburb\":\"Paradise\",\"state\":\"California\",\"country\":\"USA\",\"postcode\":\"95969\",\"telephone\":\"530-873-7429\",\"fax\":\"\",\"misc\":\"\",\"image\":\"\",\"email_to\":\"email@email.com\",\"default_con\":0,\"published\":\"1\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-22 18:34:50\",\"ordering\":\"1\",\"params\":\"{\\\"show_contact_category\\\":\\\"\\\",\\\"show_contact_list\\\":\\\"\\\",\\\"presentation_style\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_info\\\":\\\"0\\\",\\\"show_name\\\":\\\"\\\",\\\"show_position\\\":\\\"\\\",\\\"show_email\\\":\\\"\\\",\\\"add_mailto_link\\\":\\\"\\\",\\\"show_street_address\\\":\\\"\\\",\\\"show_suburb\\\":\\\"\\\",\\\"show_state\\\":\\\"\\\",\\\"show_postcode\\\":\\\"\\\",\\\"show_country\\\":\\\"\\\",\\\"show_telephone\\\":\\\"\\\",\\\"show_mobile\\\":\\\"\\\",\\\"show_fax\\\":\\\"\\\",\\\"show_webpage\\\":\\\"\\\",\\\"show_image\\\":\\\"\\\",\\\"show_misc\\\":\\\"\\\",\\\"allow_vcard\\\":\\\"\\\",\\\"show_articles\\\":\\\"\\\",\\\"articles_display_num\\\":\\\"\\\",\\\"show_profile\\\":\\\"\\\",\\\"show_links\\\":\\\"\\\",\\\"linka_name\\\":\\\"\\\",\\\"linka\\\":false,\\\"linkb_name\\\":\\\"\\\",\\\"linkb\\\":false,\\\"linkc_name\\\":\\\"\\\",\\\"linkc\\\":false,\\\"linkd_name\\\":\\\"\\\",\\\"linkd\\\":false,\\\"linke_name\\\":\\\"\\\",\\\"linke\\\":false,\\\"contact_layout\\\":\\\"\\\",\\\"show_email_form\\\":\\\"\\\",\\\"show_email_copy\\\":\\\"\\\",\\\"banned_email\\\":\\\"\\\",\\\"banned_subject\\\":\\\"\\\",\\\"banned_text\\\":\\\"\\\",\\\"validate_session\\\":\\\"\\\",\\\"custom_reply\\\":\\\"\\\",\\\"redirect\\\":\\\"\\\"}\",\"user_id\":\"871\",\"catid\":\"4\",\"access\":\"1\",\"mobile\":\"858-774-4605\",\"webpage\":false,\"sortname1\":\"\",\"sortname2\":\"\",\"sortname3\":\"\",\"language\":\"*\",\"created\":\"2018-02-22 18:30:43\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-22 18:35:27\",\"modified_by\":\"871\",\"metakey\":\"\",\"metadesc\":\"\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"rights\\\":\\\"\\\"}\",\"featured\":\"0\",\"xreference\":\"\",\"publish_up\":\"0000-00-00 00:00:00\",\"publish_down\":\"0000-00-00 00:00:00\",\"version\":4,\"hits\":\"4\"}', '0'),
('5', '1', '2', '', '2019-08-28 03:04:45', '803', '1807', 'd92c4b80f57b46eb128d3c052ce72b365a445593', '{\"id\":1,\"name\":\"Contact\",\"alias\":\"contact\",\"con_position\":\"Founder & CEO\",\"address\":\"2261 Byers Lane\",\"suburb\":\"Paradise\",\"state\":\"California\",\"country\":\"USA\",\"postcode\":\"95969\",\"telephone\":\"530-873-7429\",\"fax\":\"\",\"misc\":\"\",\"image\":\"\",\"email_to\":\"email@email.com\",\"default_con\":0,\"published\":\"1\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-22 18:35:27\",\"ordering\":\"1\",\"params\":\"{\\\"show_contact_category\\\":\\\"\\\",\\\"show_contact_list\\\":\\\"\\\",\\\"presentation_style\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_info\\\":\\\"0\\\",\\\"show_name\\\":\\\"\\\",\\\"show_position\\\":\\\"\\\",\\\"show_email\\\":\\\"\\\",\\\"add_mailto_link\\\":\\\"\\\",\\\"show_street_address\\\":\\\"\\\",\\\"show_suburb\\\":\\\"\\\",\\\"show_state\\\":\\\"\\\",\\\"show_postcode\\\":\\\"\\\",\\\"show_country\\\":\\\"\\\",\\\"show_telephone\\\":\\\"\\\",\\\"show_mobile\\\":\\\"\\\",\\\"show_fax\\\":\\\"\\\",\\\"show_webpage\\\":\\\"\\\",\\\"show_image\\\":\\\"\\\",\\\"show_misc\\\":\\\"0\\\",\\\"allow_vcard\\\":\\\"\\\",\\\"show_articles\\\":\\\"\\\",\\\"articles_display_num\\\":\\\"\\\",\\\"show_profile\\\":\\\"\\\",\\\"show_links\\\":\\\"\\\",\\\"linka_name\\\":\\\"\\\",\\\"linka\\\":false,\\\"linkb_name\\\":\\\"\\\",\\\"linkb\\\":false,\\\"linkc_name\\\":\\\"\\\",\\\"linkc\\\":false,\\\"linkd_name\\\":\\\"\\\",\\\"linkd\\\":false,\\\"linke_name\\\":\\\"\\\",\\\"linke\\\":false,\\\"contact_layout\\\":\\\"\\\",\\\"show_email_form\\\":\\\"\\\",\\\"show_email_copy\\\":\\\"\\\",\\\"banned_email\\\":\\\"\\\",\\\"banned_subject\\\":\\\"\\\",\\\"banned_text\\\":\\\"\\\",\\\"validate_session\\\":\\\"\\\",\\\"custom_reply\\\":\\\"\\\",\\\"redirect\\\":\\\"\\\"}\",\"user_id\":\"871\",\"catid\":\"4\",\"access\":\"1\",\"mobile\":\"858-774-4605\",\"webpage\":false,\"sortname1\":\"\",\"sortname2\":\"\",\"sortname3\":\"\",\"language\":\"*\",\"created\":\"2018-02-22 18:30:43\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-22 18:35:40\",\"modified_by\":\"871\",\"metakey\":\"\",\"metadesc\":\"\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"rights\\\":\\\"\\\"}\",\"featured\":\"0\",\"xreference\":\"\",\"publish_up\":\"0000-00-00 00:00:00\",\"publish_down\":\"0000-00-00 00:00:00\",\"version\":5,\"hits\":\"5\"}', '0'),
('6', '1', '2', '', '2019-08-28 03:04:45', '803', '1813', 'aed2056cf88e90092020aa9771335945de73c590', '{\"id\":1,\"name\":\"Contact\",\"alias\":\"contact\",\"con_position\":\"Founder & CEO\",\"address\":\"2261 Byers Lane\",\"suburb\":\"Paradise\",\"state\":\"California\",\"country\":\"USA\",\"postcode\":\"95969\",\"telephone\":\"530-873-7429\",\"fax\":\"\",\"misc\":\"\",\"image\":\"\",\"email_to\":\"email@email.com\",\"default_con\":0,\"published\":\"1\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-22 18:35:40\",\"ordering\":\"1\",\"params\":\"{\\\"show_contact_category\\\":\\\"\\\",\\\"show_contact_list\\\":\\\"\\\",\\\"presentation_style\\\":\\\"plain\\\",\\\"show_tags\\\":\\\"0\\\",\\\"show_info\\\":\\\"0\\\",\\\"show_name\\\":\\\"\\\",\\\"show_position\\\":\\\"\\\",\\\"show_email\\\":\\\"\\\",\\\"add_mailto_link\\\":\\\"\\\",\\\"show_street_address\\\":\\\"\\\",\\\"show_suburb\\\":\\\"\\\",\\\"show_state\\\":\\\"\\\",\\\"show_postcode\\\":\\\"\\\",\\\"show_country\\\":\\\"\\\",\\\"show_telephone\\\":\\\"\\\",\\\"show_mobile\\\":\\\"\\\",\\\"show_fax\\\":\\\"\\\",\\\"show_webpage\\\":\\\"\\\",\\\"show_image\\\":\\\"\\\",\\\"show_misc\\\":\\\"0\\\",\\\"allow_vcard\\\":\\\"\\\",\\\"show_articles\\\":\\\"\\\",\\\"articles_display_num\\\":\\\"\\\",\\\"show_profile\\\":\\\"\\\",\\\"show_links\\\":\\\"\\\",\\\"linka_name\\\":\\\"\\\",\\\"linka\\\":false,\\\"linkb_name\\\":\\\"\\\",\\\"linkb\\\":false,\\\"linkc_name\\\":\\\"\\\",\\\"linkc\\\":false,\\\"linkd_name\\\":\\\"\\\",\\\"linkd\\\":false,\\\"linke_name\\\":\\\"\\\",\\\"linke\\\":false,\\\"contact_layout\\\":\\\"\\\",\\\"show_email_form\\\":\\\"\\\",\\\"show_email_copy\\\":\\\"\\\",\\\"banned_email\\\":\\\"\\\",\\\"banned_subject\\\":\\\"\\\",\\\"banned_text\\\":\\\"\\\",\\\"validate_session\\\":\\\"\\\",\\\"custom_reply\\\":\\\"\\\",\\\"redirect\\\":\\\"\\\"}\",\"user_id\":\"871\",\"catid\":\"4\",\"access\":\"1\",\"mobile\":\"858-774-4605\",\"webpage\":false,\"sortname1\":\"\",\"sortname2\":\"\",\"sortname3\":\"\",\"language\":\"*\",\"created\":\"2018-02-22 18:30:43\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-22 18:36:08\",\"modified_by\":\"871\",\"metakey\":\"\",\"metadesc\":\"\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"rights\\\":\\\"\\\"}\",\"featured\":\"0\",\"xreference\":\"\",\"publish_up\":\"0000-00-00 00:00:00\",\"publish_down\":\"0000-00-00 00:00:00\",\"version\":6,\"hits\":\"6\"}', '0'),
('67', '1', '2', '', '2019-08-28 03:04:45', '803', '1845', 'f066feeb859e8a11fd93ba7f825f1346fe672460', '{\"id\":1,\"name\":\"Contact\",\"alias\":\"contact\",\"con_position\":\"Founder & CEO\",\"address\":\"6\\/14, Block - A, Lalmatia\",\"suburb\":\"Dhaka\",\"state\":\"Dhaka\",\"country\":\"USA\",\"postcode\":\"1207\",\"telephone\":\"530-873-7429\",\"fax\":\"858-774-4605\",\"misc\":\"\",\"image\":\"\",\"email_to\":\"email@email.com\",\"default_con\":0,\"published\":\"1\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-23 14:36:51\",\"ordering\":\"1\",\"params\":\"{\\\"show_contact_category\\\":\\\"\\\",\\\"show_contact_list\\\":\\\"\\\",\\\"presentation_style\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_info\\\":\\\"\\\",\\\"show_name\\\":\\\"\\\",\\\"show_position\\\":\\\"\\\",\\\"show_email\\\":\\\"\\\",\\\"add_mailto_link\\\":\\\"\\\",\\\"show_street_address\\\":\\\"\\\",\\\"show_suburb\\\":\\\"\\\",\\\"show_state\\\":\\\"\\\",\\\"show_postcode\\\":\\\"\\\",\\\"show_country\\\":\\\"\\\",\\\"show_telephone\\\":\\\"\\\",\\\"show_mobile\\\":\\\"\\\",\\\"show_fax\\\":\\\"\\\",\\\"show_webpage\\\":\\\"\\\",\\\"show_image\\\":\\\"\\\",\\\"show_misc\\\":\\\"\\\",\\\"allow_vcard\\\":\\\"\\\",\\\"show_articles\\\":\\\"\\\",\\\"articles_display_num\\\":\\\"\\\",\\\"show_profile\\\":\\\"\\\",\\\"show_links\\\":\\\"\\\",\\\"linka_name\\\":\\\"\\\",\\\"linka\\\":false,\\\"linkb_name\\\":\\\"\\\",\\\"linkb\\\":false,\\\"linkc_name\\\":\\\"\\\",\\\"linkc\\\":false,\\\"linkd_name\\\":\\\"\\\",\\\"linkd\\\":false,\\\"linke_name\\\":\\\"\\\",\\\"linke\\\":false,\\\"contact_layout\\\":\\\"\\\",\\\"show_email_form\\\":\\\"\\\",\\\"show_email_copy\\\":\\\"\\\",\\\"banned_email\\\":\\\"\\\",\\\"banned_subject\\\":\\\"\\\",\\\"banned_text\\\":\\\"\\\",\\\"validate_session\\\":\\\"\\\",\\\"custom_reply\\\":\\\"\\\",\\\"redirect\\\":\\\"\\\"}\",\"user_id\":\"871\",\"catid\":\"4\",\"access\":\"1\",\"mobile\":\"858-774-4605\",\"webpage\":\"https:\\/\\/www.joomshaper.com\",\"sortname1\":\"\",\"sortname2\":\"\",\"sortname3\":\"\",\"language\":\"*\",\"created\":\"2018-02-22 18:30:43\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 14:37:19\",\"modified_by\":\"871\",\"metakey\":\"\",\"metadesc\":\"\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"rights\\\":\\\"\\\"}\",\"featured\":\"0\",\"xreference\":\"\",\"publish_up\":\"0000-00-00 00:00:00\",\"publish_down\":\"0000-00-00 00:00:00\",\"version\":9,\"hits\":\"51\"}', '0'),
('69', '2', '8', '', '2019-08-28 03:04:45', '803', '566', '616ddb7dc48fc6f8b6aa2e90ed3ce7a453fa7683', '{\"id\":2,\"parent_id\":\"1\",\"lft\":\"1\",\"rgt\":2,\"level\":1,\"path\":\"animations\",\"title\":\"Animations\",\"alias\":\"animations\",\"note\":\"\",\"description\":null,\"published\":1,\"checked_out\":\"0\",\"checked_out_time\":\"2018-02-26 06:42:28\",\"access\":1,\"params\":\"{}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{}\",\"created_user_id\":\"871\",\"created_time\":\"2018-02-26 06:42:28\",\"created_by_alias\":\"\",\"modified_user_id\":\"0\",\"modified_time\":\"2018-02-26 06:42:28\",\"images\":\"{}\",\"urls\":\"{}\",\"hits\":\"0\",\"language\":\"*\",\"version\":\"1\",\"publish_up\":\"2018-02-26 06:42:28\",\"publish_down\":\"2018-02-26 06:42:28\"}', '0'),
('72', '3', '8', '', '2019-08-28 03:04:45', '803', '557', 'c0edb34678c58ff31cdc044bee28948585deed14', '{\"id\":3,\"parent_id\":\"1\",\"lft\":\"3\",\"rgt\":4,\"level\":1,\"path\":\"builder\",\"title\":\"Builder\",\"alias\":\"builder\",\"note\":\"\",\"description\":null,\"published\":1,\"checked_out\":\"0\",\"checked_out_time\":\"2018-02-26 06:51:56\",\"access\":1,\"params\":\"{}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{}\",\"created_user_id\":\"871\",\"created_time\":\"2018-02-26 06:51:56\",\"created_by_alias\":\"\",\"modified_user_id\":\"0\",\"modified_time\":\"2018-02-26 06:51:56\",\"images\":\"{}\",\"urls\":\"{}\",\"hits\":\"0\",\"language\":\"*\",\"version\":\"1\",\"publish_up\":\"2018-02-26 06:51:56\",\"publish_down\":\"2018-02-26 06:51:56\"}', '0'),
('73', '4', '8', '', '2019-08-28 03:04:45', '803', '560', 'bdbac141cab03c1486f4010ded1bba033bd93755', '{\"id\":4,\"parent_id\":\"1\",\"lft\":\"5\",\"rgt\":6,\"level\":1,\"path\":\"dropdown\",\"title\":\"Dropdown\",\"alias\":\"dropdown\",\"note\":\"\",\"description\":null,\"published\":1,\"checked_out\":\"0\",\"checked_out_time\":\"2018-02-26 06:51:56\",\"access\":1,\"params\":\"{}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{}\",\"created_user_id\":\"871\",\"created_time\":\"2018-02-26 06:51:56\",\"created_by_alias\":\"\",\"modified_user_id\":\"0\",\"modified_time\":\"2018-02-26 06:51:56\",\"images\":\"{}\",\"urls\":\"{}\",\"hits\":\"0\",\"language\":\"*\",\"version\":\"1\",\"publish_up\":\"2018-02-26 06:51:56\",\"publish_down\":\"2018-02-26 06:51:56\"}', '0'),
('74', '5', '8', '', '2019-08-28 03:04:45', '803', '548', '6f8b4de9ad01f97b562f1697b821a5f06ceb1825', '{\"id\":5,\"parent_id\":\"1\",\"lft\":\"7\",\"rgt\":8,\"level\":1,\"path\":\"drag\",\"title\":\"Drag\",\"alias\":\"drag\",\"note\":\"\",\"description\":null,\"published\":1,\"checked_out\":\"0\",\"checked_out_time\":\"2018-02-26 06:51:56\",\"access\":1,\"params\":\"{}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{}\",\"created_user_id\":\"871\",\"created_time\":\"2018-02-26 06:51:56\",\"created_by_alias\":\"\",\"modified_user_id\":\"0\",\"modified_time\":\"2018-02-26 06:51:56\",\"images\":\"{}\",\"urls\":\"{}\",\"hits\":\"0\",\"language\":\"*\",\"version\":\"1\",\"publish_up\":\"2018-02-26 06:51:56\",\"publish_down\":\"2018-02-26 06:51:56\"}', '0'),
('75', '6', '8', '', '2019-08-28 03:04:45', '803', '549', 'd4530eda7a9326d3acd0bc35e5b21c4b739fca26', '{\"id\":6,\"parent_id\":\"1\",\"lft\":\"9\",\"rgt\":10,\"level\":1,\"path\":\"drop\",\"title\":\"Drop\",\"alias\":\"drop\",\"note\":\"\",\"description\":null,\"published\":1,\"checked_out\":\"0\",\"checked_out_time\":\"2018-02-26 06:51:56\",\"access\":1,\"params\":\"{}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{}\",\"created_user_id\":\"871\",\"created_time\":\"2018-02-26 06:51:56\",\"created_by_alias\":\"\",\"modified_user_id\":\"0\",\"modified_time\":\"2018-02-26 06:51:56\",\"images\":\"{}\",\"urls\":\"{}\",\"hits\":\"0\",\"language\":\"*\",\"version\":\"1\",\"publish_up\":\"2018-02-26 06:51:56\",\"publish_down\":\"2018-02-26 06:51:56\"}', '0'),
('76', '7', '8', '', '2019-08-28 03:04:45', '803', '565', '1f97921c5724fa6e309d9c3287b754a1d726c2a6', '{\"id\":7,\"parent_id\":\"1\",\"lft\":\"11\",\"rgt\":12,\"level\":1,\"path\":\"mega-menu\",\"title\":\"Mega Menu\",\"alias\":\"mega-menu\",\"note\":\"\",\"description\":null,\"published\":1,\"checked_out\":\"0\",\"checked_out_time\":\"2018-02-26 06:51:56\",\"access\":1,\"params\":\"{}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{}\",\"created_user_id\":\"871\",\"created_time\":\"2018-02-26 06:51:56\",\"created_by_alias\":\"\",\"modified_user_id\":\"0\",\"modified_time\":\"2018-02-26 06:51:56\",\"images\":\"{}\",\"urls\":\"{}\",\"hits\":\"0\",\"language\":\"*\",\"version\":\"1\",\"publish_up\":\"2018-02-26 06:51:56\",\"publish_down\":\"2018-02-26 06:51:56\"}', '0'),
('77', '8', '8', '', '2019-08-28 03:04:45', '803', '562', '5228699d9d4dd34664e7a338b6cde8fb04e21434', '{\"id\":8,\"parent_id\":\"1\",\"lft\":\"13\",\"rgt\":14,\"level\":1,\"path\":\"features\",\"title\":\"Features\",\"alias\":\"features\",\"note\":\"\",\"description\":null,\"published\":1,\"checked_out\":\"0\",\"checked_out_time\":\"2018-02-26 06:51:56\",\"access\":1,\"params\":\"{}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{}\",\"created_user_id\":\"871\",\"created_time\":\"2018-02-26 06:51:56\",\"created_by_alias\":\"\",\"modified_user_id\":\"0\",\"modified_time\":\"2018-02-26 06:51:56\",\"images\":\"{}\",\"urls\":\"{}\",\"hits\":\"0\",\"language\":\"*\",\"version\":\"1\",\"publish_up\":\"2018-02-26 06:51:56\",\"publish_down\":\"2018-02-26 06:51:56\"}', '0'),
('310', '13', '5', '', '2019-12-20 02:13:11', '803', '547', '5eaf7d1baa4e4f0659299f24fe4223382fd933ac', '{\"id\":13,\"asset_id\":207,\"parent_id\":\"1\",\"lft\":\"19\",\"rgt\":20,\"level\":1,\"path\":null,\"extension\":\"com_content\",\"title\":\"News\",\"alias\":\"news\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":null,\"checked_out_time\":null,\"access\":\"1\",\"params\":\"{\\\"category_layout\\\":\\\"\\\",\\\"image\\\":\\\"\\\",\\\"image_alt\\\":\\\"\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"803\",\"created_time\":\"2019-12-20 02:13:11\",\"modified_user_id\":null,\"modified_time\":\"2019-12-20 02:13:11\",\"hits\":\"0\",\"language\":\"*\",\"version\":null}', '0'),
('311', '34', '1', '', '2019-12-20 02:37:37', '804', '5582', 'e76b9a8347e31236dcd74eeabf67a6176c6ee79f', '{\"id\":34,\"asset_id\":208,\"title\":\"UMP proudly produces 2,773 graduates in its 13th Convocation\",\"alias\":\"ump-proudly-produces-2-773-graduates-in-its-13th-convocation\",\"introtext\":\"<p class=\\\"text-align-justify\\\">Universiti Malaysia Pahang (UMP) will celebrate the graduation of 2,773 of its students in its 13th convocation ceremony to be held over two days on November 10 and 11 at UMP Gambang Campus Sports Complex.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p class=\\\"text-align-justify\\\">His Royal Highness the Regent of Pahang and UMP Chancellor Tengku Abdullah Al-Haj Ibni Sultan Haji Ahmad Shah Al-Musta\\u2019in Billah will grace the ceremony and present the scrolls and excellent achievement awards in the first session.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">There are 63 Doctor of Philosophy (PhD) graduates, 172 Masters\\u2019 degree graduates, 1,713 Bachelor\\u2019s degree graduates, 40 dual degree graduates, 270 Diploma graduates, 221 Executive Masters\\u2019 degree graduates, 52 Executive Bachelor degree graduates and 242 Executive Diploma graduates from nine faculties and two education centres.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">The graduates are from Faculty of Civil &amp; Natural Resources Engineering (264), Faculty of Electrical &amp; Electronics Engineering (203), Faculty of Chemical &amp; Natural Resources Engineering (299), Faculty of Mechanical Engineering (307), Faculty of Computer Systems &amp; Software Engineering (296), Faculty of Manufacturing Engineering (136), Faculty of Industrial Sciences &amp; Technology (144), Faculty of Industrial Management (183), Faculty of Engineering Technology (191), UMP Advanced Education (515) and Institute of Postgraduate Studies (235).<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">The 40 dual degree graduates are those to be presented with Bachelor\\u2019s (Honours) in Mechatronic Engineering and Bachelor\\u2019s (Honours) in Automotive Engineering. It is a joint programme between UMP and Karlsruhe University of Applied Sciences (HsKA), Germany.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">UMP will also see the first batch of Bachelor\\u2019s Degree in Business Engineering graduates who completed their course which is a joint programme between UMP and Reutlingen University.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">A total of 28 graduates will receive the university\\u2019s excellence awards and industry\\u2019s prizes. There will be three new awards \\u2013 BASF Petronas Excellence Award, Soho Niaga Excellence Award and Setegap Ventures Excellence Award.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">According to UMP Vice-Chancellor, Professor Dato\\u2019 Sri Dr. Daing Nasir Ibrahim, the university would confer Honorary Doctorate in Engineering (Electronic) to former General Manager of Motorola Solutions Sdn. Bhd, Dr. Hari Narayanan P Ondiveeran as a mark of appreciation and recognition to his character, credibility and leadership.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">\\u201cThe university deeply appreciates the many inputs and ideas contributed during his tenure as the Adjunct Professor at Faculty of Electrical Engineering and Electronic (FKEE) and his substantial role in the <a href=\\\"mailto:CEO@Faculty\\\">CEO@Faculty<\\/a> programme implemented by Ministry of Higher Education (KPM).<br \\/> \\u00a0<br \\/> Dr. Hari Narayanan has also made considerable contribution in the wakaf and educational endowment initiatives in UMP through the MyGift platform and showed great commitment in the teaching of Science, Technology, Engineering and Mathematics (STEM) for school students.<br \\/> \\u00a0<br \\/> Dr. Hari has also received numerous awards such as The Best CEO Award, The Most Outstanding CEO Award and The Most Active CEO Award.<\\/p>\",\"state\":1,\"catid\":\"13\",\"created\":\"2019-12-20 02:37:37\",\"created_by\":\"804\",\"created_by_alias\":\"\",\"modified\":\"2019-12-20 02:37:37\",\"modified_by\":null,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2019-12-20 02:37:37\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2019\\\\\\/12\\\\\\/20\\\\\\/ump_konvo_13.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":1,\"ordering\":null,\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":null,\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0'),
('312', '14', '5', '', '2019-12-23 15:39:04', '803', '555', '5cbeacc86452e39edf17026a1651beda73e05a34', '{\"id\":14,\"asset_id\":214,\"parent_id\":\"1\",\"lft\":\"21\",\"rgt\":22,\"level\":1,\"path\":null,\"extension\":\"com_content\",\"title\":\"Research\",\"alias\":\"research\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":null,\"checked_out_time\":null,\"access\":\"1\",\"params\":\"{\\\"category_layout\\\":\\\"\\\",\\\"image\\\":\\\"\\\",\\\"image_alt\\\":\\\"\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"803\",\"created_time\":\"2019-12-23 15:39:04\",\"modified_user_id\":null,\"modified_time\":\"2019-12-23 15:39:04\",\"hits\":\"0\",\"language\":\"*\",\"version\":null}', '0'),
('313', '35', '1', '', '2019-12-23 15:42:17', '803', '4854', '3495b4886b192a2a0bf672bf57bbc4579a2dd63e', '{\"id\":35,\"asset_id\":215,\"title\":\"UMP researchers invented stingless bee honey suction pump for more quality produce\",\"alias\":\"ump-researchers-invented-stingless-bee-honey-suction-pump-for-more-quality-produce\",\"introtext\":\"<p>A group of researchers from Universiti Malaysia Pahang (UMP) has developed a product called \\u2018Sleek Pump\\u2019 to make it easier for stingless bee farmers to extract honey without compromising the quality.<\\/p>\\r\\n<p>The group was led by Dr. Mohamad Firdaus Basrawi, 34, who is also a lecturer at Faculty of Mechanical Engineering &amp; Manufacturing (FKMP) while the rest of the members were Dr. Daing Mohamad Nafiz Daing Idris, Dr. Mohd Hazwan Yusof, Dr. Mohd Yusof Taib, Abdullah Inrahim Mahmoud Al Anati, Luqman Abdul Halim and Siti Sarah Shaikh Mohd Raziff.<\\/p>\\r\\n<p>Dr. Mohamad Firdaus said the project began in 2016 and was fully completed in 2018, following a request from the Pahang Stingless Bee Honey Entrepreneurs Association (PUKP).<\\/p>\\r\\n<p>He said Malaysia had more than 4,000 stingless bee honey farmers and in Pahang alone, there were 110 farmers who were registered with PUKP.<\\/p>\\r\\n<p>Their monthly production was estimated at 1,400kg, he added.<\\/p>\\r\\n<p>\\u201cThe association had sought help for an easy and cheap method to extract the honey which gave us the idea for this suction pump.<\\/p>\\r\\n<p>\\u201cPrior to this, various methods had been used which included using of the straw, syringe and even a pump. However, these methods resulted in honey produced of less quality, bubbling while the suction flow was slow,\\u201d he added.<\\/p>\\r\\n<p>He said the \\u2018Sleek Pump\\u2019 created was a battery-powered tool and easy to carry.<\\/p>\\r\\n<p>He also said if a rubber tapper would require a good knife to get quality latex, a stingless bee honey farmer would need a good suction tool to extract quality honey.<\\/p>\\r\\n<p>At the initial stage, the tool was used and tested by 30 farmers who were members of PUKP and feedback from them were collected to gauge the effectiveness of the suction pump, he added.<\\/p>\\r\\n<p>\\u201cBased on their response, they said it was much faster to use the suction pump as compared to other devices and that the battery lasted longer.\\u00a0<\\/p>\\r\\n<p>\\u201cThere was less bubbling. Most of the consumers did not like honey with too much bubbling, and at times, it could cause the bottles to crack.<\\/p>\\r\\n<p>\\u201cWith the \\u2018Sleek Pump\\u2019, suction can be made straight from the bee nests into bottles and it does not need between one week and a month for the bubbling to set in. The system is powered by batteries that can last up to four hours,\\u201d he said.<\\/p>\\r\\n<p>He added that the compact-designed pumps would be in the market soon and the price was set between RM500 and RM600.<\\/p>\\r\\n<p>\\u201cThe suction pump works faster and the honey produced in bubbling-free,\\u201d said Dr. Mohamad Firdaus.<\\/p>\",\"fulltext\":\"\",\"state\":1,\"catid\":\"14\",\"created\":\"2019-12-23 15:42:17\",\"created_by\":\"803\",\"created_by_alias\":\"\",\"modified\":\"2019-12-23 15:42:17\",\"modified_by\":null,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2019-12-23 15:42:17\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2019\\\\\\/12\\\\\\/23\\\\\\/UMP researchers invented stingless bee honey suction pump.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":1,\"ordering\":null,\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":null,\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0'),
('314', '35', '1', '', '2019-12-23 15:57:34', '803', '4874', 'f3182c1ae86e42985d2bac2b8958a62e4650dbc6', '{\"id\":35,\"asset_id\":\"215\",\"title\":\"UMP researchers invented stingless bee honey suction pump for more quality produce\",\"alias\":\"ump-researchers-invented-stingless-bee-honey-suction-pump-for-more-quality-produce\",\"introtext\":\"<p>A group of researchers from Universiti Malaysia Pahang (UMP) has developed a product called \\u2018Sleek Pump\\u2019 to make it easier for stingless bee farmers to extract honey without compromising the quality.<\\/p>\\r\\n<p>The group was led by Dr. Mohamad Firdaus Basrawi, 34, who is also a lecturer at Faculty of Mechanical Engineering &amp; Manufacturing (FKMP) while the rest of the members were Dr. Daing Mohamad Nafiz Daing Idris, Dr. Mohd Hazwan Yusof, Dr. Mohd Yusof Taib, Abdullah Inrahim Mahmoud Al Anati, Luqman Abdul Halim and Siti Sarah Shaikh Mohd Raziff.<\\/p>\\r\\n<p>Dr. Mohamad Firdaus said the project began in 2016 and was fully completed in 2018, following a request from the Pahang Stingless Bee Honey Entrepreneurs Association (PUKP).<\\/p>\\r\\n<p>He said Malaysia had more than 4,000 stingless bee honey farmers and in Pahang alone, there were 110 farmers who were registered with PUKP.<\\/p>\\r\\n<p>Their monthly production was estimated at 1,400kg, he added.<\\/p>\\r\\n<p>\\u201cThe association had sought help for an easy and cheap method to extract the honey which gave us the idea for this suction pump.<\\/p>\\r\\n<p>\\u201cPrior to this, various methods had been used which included using of the straw, syringe and even a pump. However, these methods resulted in honey produced of less quality, bubbling while the suction flow was slow,\\u201d he added.<\\/p>\\r\\n<p>He said the \\u2018Sleek Pump\\u2019 created was a battery-powered tool and easy to carry.<\\/p>\\r\\n<p>He also said if a rubber tapper would require a good knife to get quality latex, a stingless bee honey farmer would need a good suction tool to extract quality honey.<\\/p>\\r\\n<p>At the initial stage, the tool was used and tested by 30 farmers who were members of PUKP and feedback from them were collected to gauge the effectiveness of the suction pump, he added.<\\/p>\\r\\n<p>\\u201cBased on their response, they said it was much faster to use the suction pump as compared to other devices and that the battery lasted longer.\\u00a0<\\/p>\\r\\n<p>\\u201cThere was less bubbling. Most of the consumers did not like honey with too much bubbling, and at times, it could cause the bottles to crack.<\\/p>\\r\\n<p>\\u201cWith the \\u2018Sleek Pump\\u2019, suction can be made straight from the bee nests into bottles and it does not need between one week and a month for the bubbling to set in. The system is powered by batteries that can last up to four hours,\\u201d he said.<\\/p>\\r\\n<p>He added that the compact-designed pumps would be in the market soon and the price was set between RM500 and RM600.<\\/p>\\r\\n<p>\\u201cThe suction pump works faster and the honey produced in bubbling-free,\\u201d said Dr. Mohamad Firdaus.<\\/p>\",\"fulltext\":\"\",\"state\":1,\"catid\":\"13\",\"created\":\"2019-12-23 15:42:17\",\"created_by\":\"803\",\"created_by_alias\":\"\",\"modified\":\"2019-12-23 15:57:34\",\"modified_by\":\"803\",\"checked_out\":\"803\",\"checked_out_time\":\"2019-12-23 15:57:25\",\"publish_up\":\"2019-12-23 15:42:17\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2019\\\\\\/12\\\\\\/23\\\\\\/UMP researchers invented stingless bee honey suction pump.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":3,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"11\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0'),
('315', '35', '1', '', '2019-12-23 15:59:49', '803', '4878', '9be67c88bbaa4c87b308b3b093229a26333bf829', '{\"id\":35,\"asset_id\":\"215\",\"title\":\"UMP researchers invented stingless bee honey suction pump for more quality produce\",\"alias\":\"ump-researchers-invented-stingless-bee-honey-suction-pump-for-more-quality-produce\",\"introtext\":\"<p>A group of researchers from Universiti Malaysia Pahang (UMP) has developed a product called \\u2018Sleek Pump\\u2019 to make it easier for stingless bee farmers to extract honey without compromising the quality.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>The group was led by Dr. Mohamad Firdaus Basrawi, 34, who is also a lecturer at Faculty of Mechanical Engineering &amp; Manufacturing (FKMP) while the rest of the members were Dr. Daing Mohamad Nafiz Daing Idris, Dr. Mohd Hazwan Yusof, Dr. Mohd Yusof Taib, Abdullah Inrahim Mahmoud Al Anati, Luqman Abdul Halim and Siti Sarah Shaikh Mohd Raziff.<\\/p>\\r\\n<p>Dr. Mohamad Firdaus said the project began in 2016 and was fully completed in 2018, following a request from the Pahang Stingless Bee Honey Entrepreneurs Association (PUKP).<\\/p>\\r\\n<p>He said Malaysia had more than 4,000 stingless bee honey farmers and in Pahang alone, there were 110 farmers who were registered with PUKP.<\\/p>\\r\\n<p>Their monthly production was estimated at 1,400kg, he added.<\\/p>\\r\\n<p>\\u201cThe association had sought help for an easy and cheap method to extract the honey which gave us the idea for this suction pump.<\\/p>\\r\\n<p>\\u201cPrior to this, various methods had been used which included using of the straw, syringe and even a pump. However, these methods resulted in honey produced of less quality, bubbling while the suction flow was slow,\\u201d he added.<\\/p>\\r\\n<p>He said the \\u2018Sleek Pump\\u2019 created was a battery-powered tool and easy to carry.<\\/p>\\r\\n<p>He also said if a rubber tapper would require a good knife to get quality latex, a stingless bee honey farmer would need a good suction tool to extract quality honey.<\\/p>\\r\\n<p>At the initial stage, the tool was used and tested by 30 farmers who were members of PUKP and feedback from them were collected to gauge the effectiveness of the suction pump, he added.<\\/p>\\r\\n<p>\\u201cBased on their response, they said it was much faster to use the suction pump as compared to other devices and that the battery lasted longer.\\u00a0<\\/p>\\r\\n<p>\\u201cThere was less bubbling. Most of the consumers did not like honey with too much bubbling, and at times, it could cause the bottles to crack.<\\/p>\\r\\n<p>\\u201cWith the \\u2018Sleek Pump\\u2019, suction can be made straight from the bee nests into bottles and it does not need between one week and a month for the bubbling to set in. The system is powered by batteries that can last up to four hours,\\u201d he said.<\\/p>\\r\\n<p>He added that the compact-designed pumps would be in the market soon and the price was set between RM500 and RM600.<\\/p>\\r\\n<p>\\u201cThe suction pump works faster and the honey produced in bubbling-free,\\u201d said Dr. Mohamad Firdaus.<\\/p>\",\"state\":1,\"catid\":\"13\",\"created\":\"2019-12-23 15:42:17\",\"created_by\":\"803\",\"created_by_alias\":\"\",\"modified\":\"2019-12-23 15:59:49\",\"modified_by\":\"803\",\"checked_out\":\"803\",\"checked_out_time\":\"2019-12-23 15:59:42\",\"publish_up\":\"2019-12-23 15:42:17\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2019\\\\\\/12\\\\\\/23\\\\\\/UMP researchers invented stingless bee honey suction pump.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":4,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"12\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0'),
('316', '36', '1', '', '2019-12-23 16:02:05', '803', '5656', 'd7657e5e8d6bb090998e9a6dc663b9c5def01a5d', '{\"id\":36,\"asset_id\":216,\"title\":\"UMP the first public university in the country to use Blockchain Technology for cert validation for its 2,773 graduates\",\"alias\":\"ump-1st-ua-blockchain-technology\",\"introtext\":\"<div class=\\\"field field--name-body field--type-text-with-summary field--label-hidden field__item\\\">\\r\\n<p class=\\\"text-align-justify\\\">Universiti Malaysia Pahang (UMP) became the first public university in the country to use Blockchain technology for UMP Valid8 - a new application to validate the authenticity of graduation certificates.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p class=\\\"text-align-justify\\\">It would benefit the 2,773 of its graduates who received their scrolls during the university\\u2019s 13th Convocation Ceremony held on November 10 and 11, 2018 at the Gambang Campus Sports Complex.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">According to UMP Vice-Chancellor, Professor Dato\\u2019 Dr. Daing Nasir Ibrahim, UMP Valid8 was an application to validate the authenticity of certificates based on the QR Code.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">\\u201cEach certificate is equipped with a unique QR Code to ascertain the authenticity of the graduate\\u2019s certificate. By scanning the QR Code, it will display the graduate\\u2019s photo, full name, academic programme and year of graduation.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">\\u201cThe QR Code itself will be a network of confidential data record, a data storage system that contains all information of the graduate, using the Blockchain Technology.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">\\u201cThe system is developed to function as a record storage on the education information of UMP graduates. This mobile application can validate the authenticity of a degree using the QR Code embedded in the certificate. All their data is stored in the blockchain form that cannot be hacked or forged,\\u201d he said.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">Likewise, UMP also introduced the convocation e-book, in a move to support the green practise and in line with the using of technology to facilitate parents, graduates, students and members of the public to get quick information on the convocation.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">The convocation e-book can be accessed via UMP Konvo application with 4.0 version for Android user and 8.0 version for iOS user.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">The e-Book uses applications with access of Android (version 4.0 and above) and iOS (version 8.0 and above).<br \\/> \\u00a0<br \\/> This pilot project was conducted by IBM Centre of Excellence that has the IT expertise, together with UMP Alumni and Faculty of Industrial Management (FIM) that has the expertise in supply chain.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">There are also plans to explore the potentials of Blockchain technology to develop the halal supply network management system as well as to design the halal industry\\u2019s technical system for commercial prospects.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">This application can be further extended into the National Institute of Higher Learning and other university and industrial partners in Malaysia and abroad.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">With this kind of expertise, UMP is in the position to offer its services in Blockchain Certificate Authentication to any institutes and agencies.<br \\/> \\u00a0<\\/p>\\r\\n<\\/div>\\r\\n<div class=\\\"field field--name-field-tags field--type-entity-reference field--label-above\\\">\\r\\n<div class=\\\"field__label\\\">TAGS \\/ KEYWORDS<\\/div>\\r\\n<div class=\\\"field__items\\\">\\r\\n<div class=\\\"field__item\\\"><a href=\\\"http:\\/\\/news.ump.edu.my\\/konvokesyenump\\\" hreflang=\\\"en\\\">KONVOKESYENUMP<\\/a><\\/div>\\r\\n<div class=\\\"field__item\\\"><a href=\\\"http:\\/\\/news.ump.edu.my\\/blockchain\\\" hreflang=\\\"en\\\">BLOCKCHAIN<\\/a><\\/div>\\r\\n<\\/div>\\r\\n<\\/div>\",\"state\":1,\"catid\":\"13\",\"created\":\"2019-12-23 16:02:05\",\"created_by\":\"803\",\"created_by_alias\":\"\",\"modified\":\"2019-12-23 16:02:05\",\"modified_by\":null,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2019-12-23 16:02:05\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":1,\"ordering\":null,\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":null,\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0'),
('317', '36', '1', '', '2019-12-23 16:04:03', '803', '5729', '35a34044a0e46ac8f9258e66a0cc35c9054a1017', '{\"id\":36,\"asset_id\":\"216\",\"title\":\"UMP the first public university in the country to use Blockchain Technology for cert validation for its 2,773 graduates\",\"alias\":\"ump-1st-ua-blockchain-technology\",\"introtext\":\"<div class=\\\"field field--name-body field--type-text-with-summary field--label-hidden field__item\\\">\\r\\n<p class=\\\"text-align-justify\\\">Universiti Malaysia Pahang (UMP) became the first public university in the country to use Blockchain technology for UMP Valid8 - a new application to validate the authenticity of graduation certificates.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p class=\\\"text-align-justify\\\">It would benefit the 2,773 of its graduates who received their scrolls during the university\\u2019s 13th Convocation Ceremony held on November 10 and 11, 2018 at the Gambang Campus Sports Complex.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">According to UMP Vice-Chancellor, Professor Dato\\u2019 Dr. Daing Nasir Ibrahim, UMP Valid8 was an application to validate the authenticity of certificates based on the QR Code.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">\\u201cEach certificate is equipped with a unique QR Code to ascertain the authenticity of the graduate\\u2019s certificate. By scanning the QR Code, it will display the graduate\\u2019s photo, full name, academic programme and year of graduation.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">\\u201cThe QR Code itself will be a network of confidential data record, a data storage system that contains all information of the graduate, using the Blockchain Technology.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">\\u201cThe system is developed to function as a record storage on the education information of UMP graduates. This mobile application can validate the authenticity of a degree using the QR Code embedded in the certificate. All their data is stored in the blockchain form that cannot be hacked or forged,\\u201d he said.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">Likewise, UMP also introduced the convocation e-book, in a move to support the green practise and in line with the using of technology to facilitate parents, graduates, students and members of the public to get quick information on the convocation.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">The convocation e-book can be accessed via UMP Konvo application with 4.0 version for Android user and 8.0 version for iOS user.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">The e-Book uses applications with access of Android (version 4.0 and above) and iOS (version 8.0 and above).<br \\/> \\u00a0<br \\/> This pilot project was conducted by IBM Centre of Excellence that has the IT expertise, together with UMP Alumni and Faculty of Industrial Management (FIM) that has the expertise in supply chain.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">There are also plans to explore the potentials of Blockchain technology to develop the halal supply network management system as well as to design the halal industry\\u2019s technical system for commercial prospects.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">This application can be further extended into the National Institute of Higher Learning and other university and industrial partners in Malaysia and abroad.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">With this kind of expertise, UMP is in the position to offer its services in Blockchain Certificate Authentication to any institutes and agencies.<br \\/> \\u00a0<\\/p>\\r\\n<\\/div>\\r\\n<div class=\\\"field field--name-field-tags field--type-entity-reference field--label-above\\\">\\r\\n<div class=\\\"field__label\\\">TAGS \\/ KEYWORDS<\\/div>\\r\\n<div class=\\\"field__items\\\">\\r\\n<div class=\\\"field__item\\\"><a href=\\\"http:\\/\\/news.ump.edu.my\\/konvokesyenump\\\" hreflang=\\\"en\\\">KONVOKESYENUMP<\\/a><\\/div>\\r\\n<div class=\\\"field__item\\\"><a href=\\\"http:\\/\\/news.ump.edu.my\\/blockchain\\\" hreflang=\\\"en\\\">BLOCKCHAIN<\\/a><\\/div>\\r\\n<\\/div>\\r\\n<\\/div>\",\"state\":1,\"catid\":\"13\",\"created\":\"2019-12-23 16:02:05\",\"created_by\":\"803\",\"created_by_alias\":\"\",\"modified\":\"2019-12-23 16:04:03\",\"modified_by\":\"803\",\"checked_out\":\"803\",\"checked_out_time\":\"2019-12-23 16:02:05\",\"publish_up\":\"2019-12-23 16:02:05\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2019\\\\\\/12\\\\\\/23\\\\\\/ump-blockchain-convo.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":2,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0'),
('318', '36', '1', '', '2019-12-23 16:15:05', '803', '5725', 'c8a11ef9beac50d49e305f548794e1b1bf7c0838', '{\"id\":36,\"asset_id\":\"216\",\"title\":\"UMP the first public university in the country to use Blockchain Technology for cert validation for its 2,773 graduates\",\"alias\":\"ump-1st-ua-blockchain-technology\",\"introtext\":\"<div class=\\\"field field--name-body field--type-text-with-summary field--label-hidden field__item\\\">\\r\\n<p class=\\\"text-align-justify\\\">Universiti Malaysia Pahang (UMP) became the first public university in the country to use Blockchain technology for UMP Valid8 - a new application to validate the authenticity of graduation certificates.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">It would benefit the 2,773 of its graduates who received their scrolls during the university\\u2019s 13th Convocation Ceremony held on November 10 and 11, 2018 at the Gambang Campus Sports Complex.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">According to UMP Vice-Chancellor, Professor Dato\\u2019 Dr. Daing Nasir Ibrahim, UMP Valid8 was an application to validate the authenticity of certificates based on the QR Code.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">\\u201cEach certificate is equipped with a unique QR Code to ascertain the authenticity of the graduate\\u2019s certificate. By scanning the QR Code, it will display the graduate\\u2019s photo, full name, academic programme and year of graduation.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">\\u201cThe QR Code itself will be a network of confidential data record, a data storage system that contains all information of the graduate, using the Blockchain Technology.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">\\u201cThe system is developed to function as a record storage on the education information of UMP graduates. This mobile application can validate the authenticity of a degree using the QR Code embedded in the certificate. All their data is stored in the blockchain form that cannot be hacked or forged,\\u201d he said.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">Likewise, UMP also introduced the convocation e-book, in a move to support the green practise and in line with the using of technology to facilitate parents, graduates, students and members of the public to get quick information on the convocation.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">The convocation e-book can be accessed via UMP Konvo application with 4.0 version for Android user and 8.0 version for iOS user.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">The e-Book uses applications with access of Android (version 4.0 and above) and iOS (version 8.0 and above).<br \\/> \\u00a0<br \\/> This pilot project was conducted by IBM Centre of Excellence that has the IT expertise, together with UMP Alumni and Faculty of Industrial Management (FIM) that has the expertise in supply chain.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">There are also plans to explore the potentials of Blockchain technology to develop the halal supply network management system as well as to design the halal industry\\u2019s technical system for commercial prospects.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">This application can be further extended into the National Institute of Higher Learning and other university and industrial partners in Malaysia and abroad.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">With this kind of expertise, UMP is in the position to offer its services in Blockchain Certificate Authentication to any institutes and agencies.<br \\/> \\u00a0<\\/p>\\r\\n<\\/div>\\r\\n<div class=\\\"field field--name-field-tags field--type-entity-reference field--label-above\\\">\\r\\n<div class=\\\"field__label\\\">TAGS \\/ KEYWORDS<\\/div>\\r\\n<div class=\\\"field__items\\\">\\r\\n<div class=\\\"field__item\\\"><a href=\\\"http:\\/\\/news.ump.edu.my\\/konvokesyenump\\\" hreflang=\\\"en\\\">KONVOKESYENUMP<\\/a><\\/div>\\r\\n<div class=\\\"field__item\\\"><a href=\\\"http:\\/\\/news.ump.edu.my\\/blockchain\\\" hreflang=\\\"en\\\">BLOCKCHAIN<\\/a><\\/div>\\r\\n<\\/div>\\r\\n<\\/div>\",\"fulltext\":\"\",\"state\":1,\"catid\":\"13\",\"created\":\"2019-12-23 16:02:05\",\"created_by\":\"803\",\"created_by_alias\":\"\",\"modified\":\"2019-12-23 16:15:05\",\"modified_by\":\"803\",\"checked_out\":\"803\",\"checked_out_time\":\"2019-12-23 16:14:16\",\"publish_up\":\"2019-12-23 16:02:05\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2019\\\\\\/12\\\\\\/23\\\\\\/ump-blockchain-convo.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":4,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0'),
('319', '35', '1', '', '2019-12-23 16:18:44', '803', '4878', '7921f7e9d37a5392e991771791062946c08f3774', '{\"id\":35,\"asset_id\":\"215\",\"title\":\"UMP researchers invented stingless bee honey suction pump for more quality produce\",\"alias\":\"ump-researchers-invented-stingless-bee-honey-suction-pump-for-more-quality-produce\",\"introtext\":\"\",\"fulltext\":\"\\r\\n<p>A group of researchers from Universiti Malaysia Pahang (UMP) has developed a product called \\u2018Sleek Pump\\u2019 to make it easier for stingless bee farmers to extract honey without compromising the quality.<\\/p>\\r\\n<p>The group was led by Dr. Mohamad Firdaus Basrawi, 34, who is also a lecturer at Faculty of Mechanical Engineering &amp; Manufacturing (FKMP) while the rest of the members were Dr. Daing Mohamad Nafiz Daing Idris, Dr. Mohd Hazwan Yusof, Dr. Mohd Yusof Taib, Abdullah Inrahim Mahmoud Al Anati, Luqman Abdul Halim and Siti Sarah Shaikh Mohd Raziff.<\\/p>\\r\\n<p>Dr. Mohamad Firdaus said the project began in 2016 and was fully completed in 2018, following a request from the Pahang Stingless Bee Honey Entrepreneurs Association (PUKP).<\\/p>\\r\\n<p>He said Malaysia had more than 4,000 stingless bee honey farmers and in Pahang alone, there were 110 farmers who were registered with PUKP.<\\/p>\\r\\n<p>Their monthly production was estimated at 1,400kg, he added.<\\/p>\\r\\n<p>\\u201cThe association had sought help for an easy and cheap method to extract the honey which gave us the idea for this suction pump.<\\/p>\\r\\n<p>\\u201cPrior to this, various methods had been used which included using of the straw, syringe and even a pump. However, these methods resulted in honey produced of less quality, bubbling while the suction flow was slow,\\u201d he added.<\\/p>\\r\\n<p>He said the \\u2018Sleek Pump\\u2019 created was a battery-powered tool and easy to carry.<\\/p>\\r\\n<p>He also said if a rubber tapper would require a good knife to get quality latex, a stingless bee honey farmer would need a good suction tool to extract quality honey.<\\/p>\\r\\n<p>At the initial stage, the tool was used and tested by 30 farmers who were members of PUKP and feedback from them were collected to gauge the effectiveness of the suction pump, he added.<\\/p>\\r\\n<p>\\u201cBased on their response, they said it was much faster to use the suction pump as compared to other devices and that the battery lasted longer.\\u00a0<\\/p>\\r\\n<p>\\u201cThere was less bubbling. Most of the consumers did not like honey with too much bubbling, and at times, it could cause the bottles to crack.<\\/p>\\r\\n<p>\\u201cWith the \\u2018Sleek Pump\\u2019, suction can be made straight from the bee nests into bottles and it does not need between one week and a month for the bubbling to set in. The system is powered by batteries that can last up to four hours,\\u201d he said.<\\/p>\\r\\n<p>He added that the compact-designed pumps would be in the market soon and the price was set between RM500 and RM600.<\\/p>\\r\\n<p>\\u201cThe suction pump works faster and the honey produced in bubbling-free,\\u201d said Dr. Mohamad Firdaus.<\\/p>\",\"state\":1,\"catid\":\"13\",\"created\":\"2019-12-23 15:42:17\",\"created_by\":\"803\",\"created_by_alias\":\"\",\"modified\":\"2019-12-23 16:18:44\",\"modified_by\":\"803\",\"checked_out\":\"803\",\"checked_out_time\":\"2019-12-23 16:18:33\",\"publish_up\":\"2019-12-23 15:42:17\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2019\\\\\\/12\\\\\\/23\\\\\\/UMP researchers invented stingless bee honey suction pump.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":6,\"ordering\":\"2\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"13\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0'),
('320', '34', '1', '', '2019-12-23 16:19:02', '803', '5602', '5ec7f741da506e84e604c3caf540293e0f6e487d', '{\"id\":34,\"asset_id\":\"208\",\"title\":\"UMP proudly produces 2,773 graduates in its 13th Convocation\",\"alias\":\"ump-proudly-produces-2-773-graduates-in-its-13th-convocation\",\"introtext\":\"\",\"fulltext\":\"\\r\\n<p class=\\\"text-align-justify\\\">Universiti Malaysia Pahang (UMP) will celebrate the graduation of 2,773 of its students in its 13th convocation ceremony to be held over two days on November 10 and 11 at UMP Gambang Campus Sports Complex.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">His Royal Highness the Regent of Pahang and UMP Chancellor Tengku Abdullah Al-Haj Ibni Sultan Haji Ahmad Shah Al-Musta\\u2019in Billah will grace the ceremony and present the scrolls and excellent achievement awards in the first session.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">There are 63 Doctor of Philosophy (PhD) graduates, 172 Masters\\u2019 degree graduates, 1,713 Bachelor\\u2019s degree graduates, 40 dual degree graduates, 270 Diploma graduates, 221 Executive Masters\\u2019 degree graduates, 52 Executive Bachelor degree graduates and 242 Executive Diploma graduates from nine faculties and two education centres.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">The graduates are from Faculty of Civil &amp; Natural Resources Engineering (264), Faculty of Electrical &amp; Electronics Engineering (203), Faculty of Chemical &amp; Natural Resources Engineering (299), Faculty of Mechanical Engineering (307), Faculty of Computer Systems &amp; Software Engineering (296), Faculty of Manufacturing Engineering (136), Faculty of Industrial Sciences &amp; Technology (144), Faculty of Industrial Management (183), Faculty of Engineering Technology (191), UMP Advanced Education (515) and Institute of Postgraduate Studies (235).<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">The 40 dual degree graduates are those to be presented with Bachelor\\u2019s (Honours) in Mechatronic Engineering and Bachelor\\u2019s (Honours) in Automotive Engineering. It is a joint programme between UMP and Karlsruhe University of Applied Sciences (HsKA), Germany.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">UMP will also see the first batch of Bachelor\\u2019s Degree in Business Engineering graduates who completed their course which is a joint programme between UMP and Reutlingen University.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">A total of 28 graduates will receive the university\\u2019s excellence awards and industry\\u2019s prizes. There will be three new awards \\u2013 BASF Petronas Excellence Award, Soho Niaga Excellence Award and Setegap Ventures Excellence Award.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">According to UMP Vice-Chancellor, Professor Dato\\u2019 Sri Dr. Daing Nasir Ibrahim, the university would confer Honorary Doctorate in Engineering (Electronic) to former General Manager of Motorola Solutions Sdn. Bhd, Dr. Hari Narayanan P Ondiveeran as a mark of appreciation and recognition to his character, credibility and leadership.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">\\u201cThe university deeply appreciates the many inputs and ideas contributed during his tenure as the Adjunct Professor at Faculty of Electrical Engineering and Electronic (FKEE) and his substantial role in the <a href=\\\"mailto:CEO@Faculty\\\">CEO@Faculty<\\/a> programme implemented by Ministry of Higher Education (KPM).<br \\/> \\u00a0<br \\/> Dr. Hari Narayanan has also made considerable contribution in the wakaf and educational endowment initiatives in UMP through the MyGift platform and showed great commitment in the teaching of Science, Technology, Engineering and Mathematics (STEM) for school students.<br \\/> \\u00a0<br \\/> Dr. Hari has also received numerous awards such as The Best CEO Award, The Most Outstanding CEO Award and The Most Active CEO Award.<\\/p>\",\"state\":1,\"catid\":\"13\",\"created\":\"2019-12-20 02:37:37\",\"created_by\":\"804\",\"created_by_alias\":\"\",\"modified\":\"2019-12-23 16:19:02\",\"modified_by\":\"803\",\"checked_out\":\"803\",\"checked_out_time\":\"2019-12-23 16:18:50\",\"publish_up\":\"2019-12-20 02:37:37\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2019\\\\\\/12\\\\\\/20\\\\\\/ump_konvo_13.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":3,\"ordering\":\"1\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"52\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0'),
('321', '36', '1', '', '2019-12-23 16:39:20', '803', '4715', '86db52d07776debf19825c65468ad5a59ab69f33', '{\"id\":36,\"asset_id\":\"216\",\"title\":\"UMP the first public university in the country to use Blockchain Technology for cert validation for its 2,773 graduates\",\"alias\":\"ump-1st-ua-blockchain-technology\",\"introtext\":\"<p>Universiti Malaysia Pahang (UMP) became the first public university in the country to use Blockchain technology for UMP Valid8<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>- a new application to validate the authenticity of graduation certificates. It would benefit the 2,773 of its graduates who received their scrolls during the university\\u2019s 13th Convocation Ceremony held on November 10 and 11, 2018 at the Gambang Campus Sports Complex. According to UMP Vice-Chancellor, Professor Dato\\u2019 Dr. Daing Nasir Ibrahim, UMP Valid8 was an application to validate the authenticity of certificates based on the QR Code. \\u201cEach certificate is equipped with a unique QR Code to ascertain the authenticity of the graduate\\u2019s certificate. By scanning the QR Code, it will display the graduate\\u2019s photo, full name, academic programme and year of graduation. \\u201cThe QR Code itself will be a network of confidential data record, a data storage system that contains all information of the graduate, using the Blockchain Technology. \\u201cThe system is developed to function as a record storage on the education information of UMP graduates. This mobile application can validate the authenticity of a degree using the QR Code embedded in the certificate. All their data is stored in the blockchain form that cannot be hacked or forged,\\u201d he said. Likewise, UMP also introduced the convocation e-book, in a move to support the green practise and in line with the using of technology to facilitate parents, graduates, students and members of the public to get quick information on the convocation. The convocation e-book can be accessed via UMP Konvo application with 4.0 version for Android user and 8.0 version for iOS user. The e-Book uses applications with access of Android (version 4.0 and above) and iOS (version 8.0 and above). This pilot project was conducted by IBM Centre of Excellence that has the IT expertise, together with UMP Alumni and Faculty of Industrial Management (FIM) that has the expertise in supply chain. There are also plans to explore the potentials of Blockchain technology to develop the halal supply network management system as well as to design the halal industry\\u2019s technical system for commercial prospects. This application can be further extended into the National Institute of Higher Learning and other university and industrial partners in Malaysia and abroad. With this kind of expertise, UMP is in the position to offer its services in Blockchain Certificate Authentication to any institutes and agencies. TAGS \\/ KEYWORDS KONVOKESYENUMP BLOCKCHAIN<\\/p>\",\"state\":1,\"catid\":\"13\",\"created\":\"2019-12-23 16:02:05\",\"created_by\":\"803\",\"created_by_alias\":\"\",\"modified\":\"2019-12-23 16:39:20\",\"modified_by\":\"803\",\"checked_out\":\"803\",\"checked_out_time\":\"2019-12-23 16:38:17\",\"publish_up\":\"2019-12-23 16:02:05\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2019\\\\\\/12\\\\\\/23\\\\\\/ump-blockchain-convo.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":6,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"1\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0'),
('322', '35', '1', '', '2019-12-23 16:39:53', '803', '4878', '55668d7ca01a6717c439930f84a8e1a5a4a2f721', '{\"id\":35,\"asset_id\":\"215\",\"title\":\"UMP researchers invented stingless bee honey suction pump for more quality produce\",\"alias\":\"ump-researchers-invented-stingless-bee-honey-suction-pump-for-more-quality-produce\",\"introtext\":\"<p>A group of researchers from Universiti Malaysia Pahang (UMP) has developed a product called \\u2018Sleek Pump\\u2019 to make it easier for stingless bee farmers to extract honey without compromising the quality.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>The group was led by Dr. Mohamad Firdaus Basrawi, 34, who is also a lecturer at Faculty of Mechanical Engineering &amp; Manufacturing (FKMP) while the rest of the members were Dr. Daing Mohamad Nafiz Daing Idris, Dr. Mohd Hazwan Yusof, Dr. Mohd Yusof Taib, Abdullah Inrahim Mahmoud Al Anati, Luqman Abdul Halim and Siti Sarah Shaikh Mohd Raziff.<\\/p>\\r\\n<p>Dr. Mohamad Firdaus said the project began in 2016 and was fully completed in 2018, following a request from the Pahang Stingless Bee Honey Entrepreneurs Association (PUKP).<\\/p>\\r\\n<p>He said Malaysia had more than 4,000 stingless bee honey farmers and in Pahang alone, there were 110 farmers who were registered with PUKP.<\\/p>\\r\\n<p>Their monthly production was estimated at 1,400kg, he added.<\\/p>\\r\\n<p>\\u201cThe association had sought help for an easy and cheap method to extract the honey which gave us the idea for this suction pump.<\\/p>\\r\\n<p>\\u201cPrior to this, various methods had been used which included using of the straw, syringe and even a pump. However, these methods resulted in honey produced of less quality, bubbling while the suction flow was slow,\\u201d he added.<\\/p>\\r\\n<p>He said the \\u2018Sleek Pump\\u2019 created was a battery-powered tool and easy to carry.<\\/p>\\r\\n<p>He also said if a rubber tapper would require a good knife to get quality latex, a stingless bee honey farmer would need a good suction tool to extract quality honey.<\\/p>\\r\\n<p>At the initial stage, the tool was used and tested by 30 farmers who were members of PUKP and feedback from them were collected to gauge the effectiveness of the suction pump, he added.<\\/p>\\r\\n<p>\\u201cBased on their response, they said it was much faster to use the suction pump as compared to other devices and that the battery lasted longer.\\u00a0<\\/p>\\r\\n<p>\\u201cThere was less bubbling. Most of the consumers did not like honey with too much bubbling, and at times, it could cause the bottles to crack.<\\/p>\\r\\n<p>\\u201cWith the \\u2018Sleek Pump\\u2019, suction can be made straight from the bee nests into bottles and it does not need between one week and a month for the bubbling to set in. The system is powered by batteries that can last up to four hours,\\u201d he said.<\\/p>\\r\\n<p>He added that the compact-designed pumps would be in the market soon and the price was set between RM500 and RM600.<\\/p>\\r\\n<p>\\u201cThe suction pump works faster and the honey produced in bubbling-free,\\u201d said Dr. Mohamad Firdaus.<\\/p>\",\"state\":1,\"catid\":\"13\",\"created\":\"2019-12-23 15:42:17\",\"created_by\":\"803\",\"created_by_alias\":\"\",\"modified\":\"2019-12-23 16:39:53\",\"modified_by\":\"803\",\"checked_out\":\"803\",\"checked_out_time\":\"2019-12-23 16:39:37\",\"publish_up\":\"2019-12-23 15:42:17\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2019\\\\\\/12\\\\\\/23\\\\\\/UMP researchers invented stingless bee honey suction pump.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":8,\"ordering\":\"2\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"13\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0'),
('323', '34', '1', '', '2019-12-23 16:40:23', '803', '5622', '56eaa40110ee0b9410b92d50d1228f4ec028207c', '{\"id\":34,\"asset_id\":\"208\",\"title\":\"UMP proudly produces 2,773 graduates in its 13th Convocation\",\"alias\":\"ump-proudly-produces-2-773-graduates-in-its-13th-convocation\",\"introtext\":\"<div>\\r\\n<p class=\\\"text-align-justify\\\">Universiti Malaysia Pahang (UMP) will celebrate the graduation of 2,773 of its students in its 13th convocation ceremony to be held over two days on November 10 and 11 at UMP Gambang Campus Sports Complex.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p class=\\\"text-align-justify\\\">His Royal Highness the Regent of Pahang and UMP Chancellor Tengku Abdullah Al-Haj Ibni Sultan Haji Ahmad Shah Al-Musta\\u2019in Billah will grace the ceremony and present the scrolls and excellent achievement awards in the first session.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">There are 63 Doctor of Philosophy (PhD) graduates, 172 Masters\\u2019 degree graduates, 1,713 Bachelor\\u2019s degree graduates, 40 dual degree graduates, 270 Diploma graduates, 221 Executive Masters\\u2019 degree graduates, 52 Executive Bachelor degree graduates and 242 Executive Diploma graduates from nine faculties and two education centres.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">The graduates are from Faculty of Civil &amp; Natural Resources Engineering (264), Faculty of Electrical &amp; Electronics Engineering (203), Faculty of Chemical &amp; Natural Resources Engineering (299), Faculty of Mechanical Engineering (307), Faculty of Computer Systems &amp; Software Engineering (296), Faculty of Manufacturing Engineering (136), Faculty of Industrial Sciences &amp; Technology (144), Faculty of Industrial Management (183), Faculty of Engineering Technology (191), UMP Advanced Education (515) and Institute of Postgraduate Studies (235).<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">The 40 dual degree graduates are those to be presented with Bachelor\\u2019s (Honours) in Mechatronic Engineering and Bachelor\\u2019s (Honours) in Automotive Engineering. It is a joint programme between UMP and Karlsruhe University of Applied Sciences (HsKA), Germany.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">UMP will also see the first batch of Bachelor\\u2019s Degree in Business Engineering graduates who completed their course which is a joint programme between UMP and Reutlingen University.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">A total of 28 graduates will receive the university\\u2019s excellence awards and industry\\u2019s prizes. There will be three new awards \\u2013 BASF Petronas Excellence Award, Soho Niaga Excellence Award and Setegap Ventures Excellence Award.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">According to UMP Vice-Chancellor, Professor Dato\\u2019 Sri Dr. Daing Nasir Ibrahim, the university would confer Honorary Doctorate in Engineering (Electronic) to former General Manager of Motorola Solutions Sdn. Bhd, Dr. Hari Narayanan P Ondiveeran as a mark of appreciation and recognition to his character, credibility and leadership.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">\\u201cThe university deeply appreciates the many inputs and ideas contributed during his tenure as the Adjunct Professor at Faculty of Electrical Engineering and Electronic (FKEE) and his substantial role in the <a href=\\\"mailto:CEO@Faculty\\\">CEO@Faculty<\\/a> programme implemented by Ministry of Higher Education (KPM).<br \\/> \\u00a0<br \\/> Dr. Hari Narayanan has also made considerable contribution in the wakaf and educational endowment initiatives in UMP through the MyGift platform and showed great commitment in the teaching of Science, Technology, Engineering and Mathematics (STEM) for school students.<br \\/> \\u00a0<br \\/> Dr. Hari has also received numerous awards such as The Best CEO Award, The Most Outstanding CEO Award and The Most Active CEO Award.<\\/p>\\r\\n<\\/div>\",\"state\":1,\"catid\":\"13\",\"created\":\"2019-12-20 02:37:37\",\"created_by\":\"804\",\"created_by_alias\":\"\",\"modified\":\"2019-12-23 16:40:23\",\"modified_by\":\"803\",\"checked_out\":\"803\",\"checked_out_time\":\"2019-12-23 16:39:56\",\"publish_up\":\"2019-12-20 02:37:37\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2019\\\\\\/12\\\\\\/20\\\\\\/ump_konvo_13.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":5,\"ordering\":\"1\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"53\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0'),
('324', '37', '1', '', '2019-12-23 16:42:16', '803', '4831', 'a0b54962ec91d764c19ef1f0ac2e814ac974d6f7', '{\"id\":37,\"asset_id\":217,\"title\":\"36 SPM leavers are excited to be at UMP\",\"alias\":\"36-spm-leavers-are-excited-to-be-at-ump\",\"introtext\":\"<p class=\\\"text-align-justify\\\">A total of 36 SPM leavers along with five teachers from Sekolah Menengah Kebangsaan (SMK) Chiku 2, Gua Musang experienced the campus life in Universiti Malaysia Pahang (UMP) on 3 December 2019.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p class=\\\"text-align-justify\\\">This two-day and one-night programme provided them with the boost to create success and path to university. According to Zainuddin Yusof, the Principal of SMK Chiku 2, the programme was aimed to expose the students in choosing the right course in the institutes of higher learning (IHL) in line with their SPM results.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">\\u201cI want them to make the best choice that must be based on the entry requirements and their interests in any field to be pursued.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">\\u201cTo make it more meaningful, the students can experience the facilities in UMP, especially the technologies available at the laboratories for teaching and learning.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">\\u201cUMP has been close to these students as several motivational programmes had been conducted especially involving UMP InSmartive Club,\\u201d he said.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">According to Rabiatul Asyikin Mohd Zaki, 17, who participated in the programme, all students had the opportunity to gain knowledge so that they could prepare for the future and make an informed decision about the course that they plan to enrol into.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">\\u201cI feel delighted because not everyone has the chance to get into university.\\u00a0<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">\\u201cThe two-day experience in UMP has been invaluable to us, and we hope the partnership between the school and UMP continues,\\u201d she said.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">She added that UMP Library is appealing. It is not only a place to borrow books and find references but also a place for student self-management and development after a long tiring day in classes. They also had the chance to visit and try the facilities available in the library such as the karaoke room, virtual reality games using PlayStation 4 and Xbox, and various high-tech games with the latest software.<br \\/> The students also participated in a motivational programme with the cooperation of UMP students from InSmartive Club.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">Two new modules were introduced \\u2014 Growth Mindset Challenge and Wheel of Fortune. The contents of the modules were designed based on the six aspirations of the Malaysia Education Blueprint 2013\\u20132025, which are knowledge, thinking skills, leadership skills, bilingual proficiency, ethics and spirituality, and national identity. The excitement of joining this short visit catalysed their spirit to earn a place in university for pursuing study.<\\/p>\",\"state\":1,\"catid\":\"13\",\"created\":\"2019-12-23 16:42:16\",\"created_by\":\"803\",\"created_by_alias\":\"\",\"modified\":\"2019-12-23 16:42:16\",\"modified_by\":null,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2019-12-23 16:42:16\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":1,\"ordering\":null,\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":null,\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0'),
('325', '37', '1', '', '2019-12-23 16:45:04', '803', '4894', 'd2502ad6c50bb7d2eb6fcb1293549f177cdd8482', '{\"id\":37,\"asset_id\":\"217\",\"title\":\"36 SPM leavers are excited to be at UMP\",\"alias\":\"36-spm-leavers-are-excited-to-be-at-ump\",\"introtext\":\"<p class=\\\"text-align-justify\\\">A total of 36 SPM leavers along with five teachers from Sekolah Menengah Kebangsaan (SMK) Chiku 2, Gua Musang experienced the campus life in Universiti Malaysia Pahang (UMP) on 3 December 2019.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p class=\\\"text-align-justify\\\">This two-day and one-night programme provided them with the boost to create success and path to university. According to Zainuddin Yusof, the Principal of SMK Chiku 2, the programme was aimed to expose the students in choosing the right course in the institutes of higher learning (IHL) in line with their SPM results.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">\\u201cI want them to make the best choice that must be based on the entry requirements and their interests in any field to be pursued.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">\\u201cTo make it more meaningful, the students can experience the facilities in UMP, especially the technologies available at the laboratories for teaching and learning.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">\\u201cUMP has been close to these students as several motivational programmes had been conducted especially involving UMP InSmartive Club,\\u201d he said.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">According to Rabiatul Asyikin Mohd Zaki, 17, who participated in the programme, all students had the opportunity to gain knowledge so that they could prepare for the future and make an informed decision about the course that they plan to enrol into.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">\\u201cI feel delighted because not everyone has the chance to get into university.\\u00a0<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">\\u201cThe two-day experience in UMP has been invaluable to us, and we hope the partnership between the school and UMP continues,\\u201d she said.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">She added that UMP Library is appealing. It is not only a place to borrow books and find references but also a place for student self-management and development after a long tiring day in classes. They also had the chance to visit and try the facilities available in the library such as the karaoke room, virtual reality games using PlayStation 4 and Xbox, and various high-tech games with the latest software.<br \\/> The students also participated in a motivational programme with the cooperation of UMP students from InSmartive Club.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">Two new modules were introduced \\u2014 Growth Mindset Challenge and Wheel of Fortune. The contents of the modules were designed based on the six aspirations of the Malaysia Education Blueprint 2013\\u20132025, which are knowledge, thinking skills, leadership skills, bilingual proficiency, ethics and spirituality, and national identity. The excitement of joining this short visit catalysed their spirit to earn a place in university for pursuing study.<\\/p>\",\"state\":1,\"catid\":\"13\",\"created\":\"2019-12-23 16:42:16\",\"created_by\":\"803\",\"created_by_alias\":\"\",\"modified\":\"2019-12-23 16:45:04\",\"modified_by\":\"803\",\"checked_out\":\"803\",\"checked_out_time\":\"2019-12-23 16:42:16\",\"publish_up\":\"2019-12-23 16:42:16\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2019\\\\\\/12\\\\\\/23\\\\\\/NFL_6170_0.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":2,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0'),
('326', '37', '1', '', '2019-12-23 16:45:54', '803', '5388', '4c02c9d7be68cc8680ddd246ea3282b6a94b132f', '{\"id\":37,\"asset_id\":\"217\",\"title\":\"MHeLFAGV Ciptaan Penyelidik UMP Bantu Angkat Bebanan lebih 50 kg\",\"alias\":\"mhelfagv-ciptaan-penyelidik-ump-bantu-angkat-bebanan-lebih-50-kg\",\"introtext\":\"<p class=\\\"text-align-justify\\\">Pekan, 4 Julai \\u2013 Prihatin terhadap permasalahan dalam industri mendorong sekumpulan penyelidik Universiti Malaysia Pahang menghasilkan <em>Mini Heavy Loaded Forklift Autonomous Guided Vehicle <\\/em>(MHeLFAGV)<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p class=\\\"text-align-justify\\\">bagi menyelesaikan masalah untuk mengangkut penggulung besi yang beratnya antara 50 kg hingga 60 kg daripada stor kilang yang agak sempit ke bilik pemeriksaan dalam masa tidak lebih dari 20 minit.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">Pada kebiasaannya industri tersebut menggunakan jentera forklift yang sesuai untuk mengangkat barang yang berat namun demikian \\u00a0saiznya yang agak besar \\u00a0tidak sesuai untuk mengangkat muatan di dalam stor yang mempunyai luas yang terhad dan sempit. \\u00a0\\u00a0\\u00a0\\u00a0\\u00a0<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">Ketua Penyelidik yang merupakan Pensyarah Fakulti Kejuruteraan Elektrik &amp; Elektronik (FKEE), Ir. Dr. Addie Irawan Hashim berkata, idea penghasilan produk bermula apabila pihak Vacuumschmelze (M) Sdn. Bhd \\u00a0(VAC) telah menjemput pihaknya \\u00a0untuk bekerjasama dalam menyelesaikan masalah mereka.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">Justeru bermula perbincangan dan pembangunan MHeLFAGV mengikut kehendak industri. Penyelidikan bermula sejak 2014 bersama \\u00a0bersama rakannya, Ir Dr. Akhtar Razul dan idea ciptaan ini mendapat cetusan daripada Pengurus Besar, Vacuumschmelze (Malaysia) Sdn Bhd, Mohd Arif \\u00a0Zakaria \\u00a0dan siap pada tahun lalu.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">Bagi Ir. Dr. Addie yang merupakan anak kelahiran Pahang ini berkata, produk ini direkabentuk dengan mekanisma <em>pick-and-swallow<\\/em> yang mana penggulung besi yang berat akan dimasukkan ke dalam mesin sebelum bergerak ke tempat yang hendak dituju untuk keseimbangan semasa bergerak.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">\\u201cIanya satu kelainan berbanding jentera forklift standard yang berada di pasaran. Selain itu, dengan penggunaan tayar omni yang dinamakan <em>mecanum wheel<\\/em>, membolehkan mesin ini bergerak pelbagai arah dan berpusing setempat tanpa mengambil jarak yang lebih terutama dalam mengambil pusingan untuk memasuki sesuatu lorong,\\u201d katanya.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">Selain itu, MHeLFAGV ini juga mudah untuk bergerak di kawasan sempit dan kurang keberangkalian untuk berlaku kemalangan seperti bergesel dengan dinding bersebelahan atau tersekat.<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">Beliau berharap pihak industri berpuas hati dengan hasil inovasi ini dan mampu memudahkan pekerja mereka bagi mengangkat penggulung besi di kawasan stor atau inventori di VAC, Pekan.\\u00a0<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">Pada masa yang sama kedua-dua pihak merancang untuk mendapatkan dana bagi menambahbaik fungsi MHeLFAGV untuk lebih automotik.\\u00a0<\\/p>\\r\\n<p class=\\\"text-align-justify\\\">Ujarnya, pelan penambahbaikan adalah pada proses pengangkutan yang lebih cepat dengan sistem automatik yang berteraskan pemprosesan imej &amp; <em>artificial intelligent<\\/em> termasuklah mekanisma mekanikal yang unik. \\u00a0Dalam pada itu, rekabentuk robot ini dapat diperluaskan, ditambah baik dan dipasarkan untuk aplikasi-aplikasi pengangkutan lain yang sesuai dalam pelbagai versi.<\\/p>\",\"state\":1,\"catid\":\"13\",\"created\":\"2019-12-23 16:42:16\",\"created_by\":\"803\",\"created_by_alias\":\"\",\"modified\":\"2019-12-23 16:45:54\",\"modified_by\":\"803\",\"checked_out\":\"803\",\"checked_out_time\":\"2019-12-23 16:45:04\",\"publish_up\":\"2019-12-23 16:42:16\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2019\\\\\\/12\\\\\\/23\\\\\\/NFL_6170_0.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":3,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0'),
('327', '15', '5', '', '2020-01-06 09:15:21', '803', '553', 'a00cd6e74a054571fcbaa504c7aae81c4a2020ec', '{\"id\":15,\"asset_id\":230,\"parent_id\":\"1\",\"lft\":\"23\",\"rgt\":24,\"level\":1,\"path\":null,\"extension\":\"com_content\",\"title\":\"Profile\",\"alias\":\"profile\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":null,\"checked_out_time\":null,\"access\":\"1\",\"params\":\"{\\\"category_layout\\\":\\\"\\\",\\\"image\\\":\\\"\\\",\\\"image_alt\\\":\\\"\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"803\",\"created_time\":\"2020-01-06 09:15:21\",\"modified_user_id\":null,\"modified_time\":\"2020-01-06 09:15:21\",\"hits\":\"0\",\"language\":\"*\",\"version\":null}', '0'),
('328', '15', '5', '', '2020-01-06 09:16:05', '803', '600', 'eb748bd5fa8019af979e968c30080d789da05024', '{\"id\":15,\"asset_id\":\"230\",\"parent_id\":\"1\",\"lft\":\"23\",\"rgt\":\"24\",\"level\":\"1\",\"path\":\"profile\",\"extension\":\"com_content\",\"title\":\"Academic Profile\",\"alias\":\"academic-profile\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":\"803\",\"checked_out_time\":\"2020-01-06 09:15:57\",\"access\":\"1\",\"params\":\"{\\\"category_layout\\\":\\\"\\\",\\\"image\\\":\\\"\\\",\\\"image_alt\\\":\\\"\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"803\",\"created_time\":\"2020-01-06 17:15:21\",\"modified_user_id\":\"803\",\"modified_time\":\"2020-01-06 09:16:05\",\"hits\":\"0\",\"language\":\"*\",\"version\":\"1\"}', '0'),
('331', '38', '1', '', '2020-01-06 09:34:23', '803', '2568', 'f12e4e2dce49daa35e91a791e86102c00f5fdb42', '{\"id\":38,\"asset_id\":\"231\",\"title\":\"Academic Sahir\",\"alias\":\"academic-sahir\",\"introtext\":\"\",\"fulltext\":\"\\r\\n<p>prof. dr. sahir ahmet ismaiel Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\",\"state\":1,\"catid\":\"15\",\"created\":\"2020-01-06 09:16:44\",\"created_by\":\"803\",\"created_by_alias\":\"\",\"modified\":\"2020-01-06 09:34:23\",\"modified_by\":\"803\",\"checked_out\":\"803\",\"checked_out_time\":\"2020-01-06 09:33:18\",\"publish_up\":\"2020-01-06 09:16:44\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"0\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":7,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"15\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0'),
('332', '38', '1', '', '2020-01-06 09:34:34', '803', '2412', 'fb001970c7b7f9869a59d1ff36f125e95dc16428', '{\"id\":38,\"asset_id\":\"231\",\"title\":\"Academic Sahir\",\"alias\":\"academic-sahir\",\"introtext\":\"\",\"fulltext\":\"\\r\\n<p>prof. dr. sahir ahmet ismaiel Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\",\"state\":1,\"catid\":\"15\",\"created\":\"2020-01-06 09:16:44\",\"created_by\":\"803\",\"created_by_alias\":\"\",\"modified\":\"2020-01-06 09:34:34\",\"modified_by\":\"803\",\"checked_out\":\"803\",\"checked_out_time\":\"2020-01-06 09:34:23\",\"publish_up\":\"2020-01-06 09:16:44\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"0\\\",\\\"show_article_options\\\":\\\"0\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":8,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"16\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0'),
('333', '38', '1', '', '2020-01-06 09:34:45', '803', '2410', '5eac319862437c93202c8599717cba319606d0e7', '{\"id\":38,\"asset_id\":\"231\",\"title\":\"Academic Sahir\",\"alias\":\"academic-sahir\",\"introtext\":\"\",\"fulltext\":\"\\r\\n<p>prof. dr. sahir ahmet ismaiel Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\",\"state\":1,\"catid\":\"15\",\"created\":\"2020-01-06 09:16:44\",\"created_by\":\"803\",\"created_by_alias\":\"\",\"modified\":\"2020-01-06 09:34:45\",\"modified_by\":\"803\",\"checked_out\":\"803\",\"checked_out_time\":\"2020-01-06 09:34:34\",\"publish_up\":\"2020-01-06 09:16:44\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":9,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"17\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0'),
('334', '38', '1', '', '2020-01-06 16:03:57', '803', '2588', '56d3b5df824137bbcf578b8f8e48d5dad2a8b03b', '{\"id\":38,\"asset_id\":\"231\",\"title\":\"Academician - Sahir Ahmet\",\"alias\":\"academician-sahir-ahmet\",\"introtext\":\"\",\"fulltext\":\"\\r\\n<p>prof. dr. sahir ahmet ismaiel Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\",\"state\":1,\"catid\":\"15\",\"created\":\"2020-01-06 09:16:44\",\"created_by\":\"803\",\"created_by_alias\":\"\",\"modified\":\"2020-01-06 16:03:57\",\"modified_by\":\"803\",\"checked_out\":\"803\",\"checked_out_time\":\"2020-01-06 16:03:14\",\"publish_up\":\"2020-01-06 09:16:44\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":16,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"25\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0');
/**ABDB**/INSERT INTO `#__ucm_history`  VALUES 
('335', '38', '1', '', '2020-01-06 16:04:25', '803', '2589', '015ef10fce8d45fbf994ddac06fb0c431eaa1c42', '{\"id\":38,\"asset_id\":\"231\",\"title\":\"Academician \\/ Sahir Ahmet\",\"alias\":\"academician-sahir-ahmet\",\"introtext\":\"\",\"fulltext\":\"\\r\\n<p>prof. dr. sahir ahmet ismaiel Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\",\"state\":1,\"catid\":\"15\",\"created\":\"2020-01-06 09:16:44\",\"created_by\":\"803\",\"created_by_alias\":\"\",\"modified\":\"2020-01-06 16:04:25\",\"modified_by\":\"803\",\"checked_out\":\"803\",\"checked_out_time\":\"2020-01-06 16:03:57\",\"publish_up\":\"2020-01-06 09:16:44\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":17,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"26\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0'),
('336', '38', '1', '', '2020-01-06 16:04:45', '803', '2591', 'b459ca64cf29066b7feadcdf5612d662e7a16391', '{\"id\":38,\"asset_id\":\"231\",\"title\":\"Academician  \\/  Sahir Ahmet\",\"alias\":\"academician-sahir-ahmet\",\"introtext\":\"\",\"fulltext\":\"\\r\\n<p>prof. dr. sahir ahmet ismaiel Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\",\"state\":1,\"catid\":\"15\",\"created\":\"2020-01-06 09:16:44\",\"created_by\":\"803\",\"created_by_alias\":\"\",\"modified\":\"2020-01-06 16:04:45\",\"modified_by\":\"803\",\"checked_out\":\"803\",\"checked_out_time\":\"2020-01-06 16:04:25\",\"publish_up\":\"2020-01-06 09:16:44\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":18,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"27\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0'),
('337', '38', '1', '', '2020-01-06 16:06:52', '803', '2576', 'e955583387567ab1778340672a201ba067f2ad77', '{\"id\":38,\"asset_id\":\"231\",\"title\":\"Academician \\/ Sahir Ahmet\",\"alias\":\"sahirahmet\",\"introtext\":\"\",\"fulltext\":\"\\r\\n<p>prof. dr. sahir ahmet ismaiel Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\",\"state\":1,\"catid\":\"15\",\"created\":\"2020-01-06 09:16:44\",\"created_by\":\"803\",\"created_by_alias\":\"\",\"modified\":\"2020-01-06 16:06:52\",\"modified_by\":\"803\",\"checked_out\":\"803\",\"checked_out_time\":\"2020-01-06 16:04:55\",\"publish_up\":\"2020-01-06 09:16:44\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":20,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"29\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0'),
('338', '38', '1', '', '2020-01-07 01:01:57', '803', '2588', '21e50e2406b71b79289c4e4723102bdb9bee928c', '{\"id\":38,\"asset_id\":\"231\",\"title\":\"Academician \\/ Dr. Sahir Ahmet Ismaiel\",\"alias\":\"sahirahmet\",\"introtext\":\"\",\"fulltext\":\"\\r\\n<p>prof. dr. sahir ahmet ismaiel Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\",\"state\":1,\"catid\":\"15\",\"created\":\"2020-01-06 09:16:44\",\"created_by\":\"803\",\"created_by_alias\":\"\",\"modified\":\"2020-01-07 01:01:57\",\"modified_by\":\"803\",\"checked_out\":\"803\",\"checked_out_time\":\"2020-01-07 01:01:39\",\"publish_up\":\"2020-01-06 09:16:44\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":21,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"32\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0'),
('339', '38', '1', '', '2020-01-07 01:02:18', '803', '2587', 'e9407cf0da9fd44678ab766e6e3d731e09b533b0', '{\"id\":38,\"asset_id\":\"231\",\"title\":\"Academician - Dr. Sahir Ahmet Ismaiel\",\"alias\":\"sahirahmet\",\"introtext\":\"\",\"fulltext\":\"\\r\\n<p>prof. dr. sahir ahmet ismaiel Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\",\"state\":1,\"catid\":\"15\",\"created\":\"2020-01-06 09:16:44\",\"created_by\":\"803\",\"created_by_alias\":\"\",\"modified\":\"2020-01-07 01:02:18\",\"modified_by\":\"803\",\"checked_out\":\"803\",\"checked_out_time\":\"2020-01-07 01:01:57\",\"publish_up\":\"2020-01-06 09:16:44\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":22,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"33\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0'),
('340', '38', '1', '', '2020-01-07 01:02:27', '803', '2579', '2ad6d4858bb49f5638fe420630538db2c978e109', '{\"id\":38,\"asset_id\":\"231\",\"title\":\"Academician - Dr. Sahir Ahmet\",\"alias\":\"sahirahmet\",\"introtext\":\"\",\"fulltext\":\"\\r\\n<p>prof. dr. sahir ahmet ismaiel Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\",\"state\":1,\"catid\":\"15\",\"created\":\"2020-01-06 09:16:44\",\"created_by\":\"803\",\"created_by_alias\":\"\",\"modified\":\"2020-01-07 01:02:27\",\"modified_by\":\"803\",\"checked_out\":\"803\",\"checked_out_time\":\"2020-01-07 01:02:18\",\"publish_up\":\"2020-01-06 09:16:44\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":23,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"34\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0'),
('341', '39', '1', '', '2020-01-07 07:15:03', '803', '4488', '67a57a5f0402fe30516984eb8ae617d32582fe7c', '{\"id\":39,\"asset_id\":254,\"title\":\"Disclaimer\",\"alias\":\"disclaimer\",\"introtext\":\"<p>The accuracy and currency of the information presented herein was correct at the date of publication. However, Universiti Malaysia Pahang reserves the right to alter procedures, fees and regulations should the need arise.<br \\/>The publication on details this system of a course in no way creates an obligation on the part of University to educate it in any given year or to educate it in any manner described herein. Thus, Universiti Malaysia Pahang reserves the right to suspend or make changes to courses at any time without notice.<br \\/>Students and prospective students should always check with the relevant faculty officers before applying for or planning courses. International students should also check relevant policies, fees and procedures with Universiti Malaysia Pahang.<\\/p>\\r\\n<p><strong>SECURITY INFORMATION<\\/strong><br \\/>University sites have security measures in place against the loss, misuse and alteration of information as defined in the University\'s IT Security Policy.<br \\/>A login name and password are necessary to visit secure areas. Before personal information (such as examination results) is published on the site, visitors are required to enter their student or staff number as well. This is to ensure that the information is only displayed to the intended person. Users should ensure that his\\/her password is kept securely and cannot be discovered by anyone else.<\\/p>\\r\\n<p><strong>USE OF PERSONAL INFORMATION<\\/strong><br \\/>Personal information you supply on-line will be used by the University staff in conducting the business of the University. Such uses include matters related to student administration, provision of services and the dissemination of information to staff, prospective and current students and remaining in contact with graduates. The University may also use your IP address to help diagnose problems with a server and to administer a web site. Your IP address is sometimes used to set up individual sessions to provide secure logins.<\\/p>\\r\\n<p><strong>DISCLOSURE OF PERSONAL INFORMATION<\\/strong><br \\/>If personal information is collected via a website and held, every effort will be made to ensure that this is done by sufficiently secure means.<br \\/>A student may elect to enroll in person rather than providing personal information to the University via a website.<br \\/>For certain applications, our site\'s enrolment and\\/ registration forms require users to give contact information (like name and e-mail address) and unique identifiers (like login identification and student number).<\\/p>\",\"fulltext\":\"\",\"state\":1,\"catid\":\"2\",\"created\":\"2020-01-07 07:15:03\",\"created_by\":\"803\",\"created_by_alias\":\"\",\"modified\":\"2020-01-07 07:15:03\",\"modified_by\":null,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2020-01-07 07:15:03\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":1,\"ordering\":null,\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":null,\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0'),
('342', '40', '1', '', '2020-01-07 07:16:33', '803', '2338', '687b2d3ef69aa6f773323393c4022fb026df5be5', '{\"id\":40,\"asset_id\":255,\"title\":\"ICT Security Policy\",\"alias\":\"ict-security-policy\",\"introtext\":\"<p><strong>Data protection<\\/strong><br \\/> Leading technologies including encryption software is used to protect data and adhering to strict security standards are maintained to prevent unauthorized access.<\\/p>\\r\\n<p><br \\/><strong> Storage Security<\\/strong><br \\/> All electronic storage and transmission of personal data are secured and stored with appropriate security technologies.<\\/p>\",\"fulltext\":\"\",\"state\":1,\"catid\":\"2\",\"created\":\"2020-01-07 07:16:33\",\"created_by\":\"803\",\"created_by_alias\":\"\",\"modified\":\"2020-01-07 07:16:33\",\"modified_by\":null,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2020-01-07 07:16:33\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":1,\"ordering\":null,\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":null,\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0'),
('343', '41', '1', '', '2020-01-07 07:17:53', '803', '3221', 'd236f54de70d54d382f77a7450041bce92ab1f48', '{\"id\":41,\"asset_id\":256,\"title\":\"Privacy Policy\",\"alias\":\"privacy-policy\",\"introtext\":\"<p><strong>Your Privacy<\\/strong><\\/p>\\r\\n<p>This page explains our privacy policy which includes the use and protection of information submitted by visitors.<\\/p>\\r\\n<p>If you make a transaction or send an e-mail containing personal information, this information may be shared with other government agencies to help provide a more efficient and effective. For example in resolving complaints that require escalation to other Government agencies.<\\/p>\\r\\n<p><strong>Information Collected<\\/strong><\\/p>\\r\\n<p>No personally identifiable information is gathered during the browsing of this web site except for information given by you via e-mail.<\\/p>\\r\\n<p>What Happens When I Link to Another Site?<\\/p>\\r\\n<p>This website contains links to other websites. This privacy policy applies only to this website. It should be noted that the website is available in the links may have different privacy policies and we highly recommend that you read and understand the privacy policies of each site.<\\/p>\\r\\n<p><strong>Changes to this Policy<\\/strong><\\/p>\\r\\n<p>If this privacy policy changes, it will be updated on this page. Regularly reviewing this page ensures you are updated on the information collected, how it is used and under what circumstances, it is shared with other parties.<\\/p>\",\"fulltext\":\"\",\"state\":1,\"catid\":\"2\",\"created\":\"2020-01-07 07:17:53\",\"created_by\":\"803\",\"created_by_alias\":\"\",\"modified\":\"2020-01-07 07:17:53\",\"modified_by\":null,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2020-01-07 07:17:53\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":1,\"ordering\":null,\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":null,\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', '0');
/**ABDB**/CREATE TABLE `#__ucm_content` (
  `core_content_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `core_type_alias` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'FK to the content types table',
  `core_title` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `core_body` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `core_state` tinyint(1) NOT NULL DEFAULT '0',
  `core_checked_out_time` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_checked_out_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `core_access` int(10) unsigned NOT NULL DEFAULT '0',
  `core_params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `core_featured` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `core_metadata` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `core_created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `core_created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_modified_user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Most recent user that modified',
  `core_modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_content_item_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ID from the individual type table',
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `core_images` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `core_urls` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `core_hits` int(10) unsigned NOT NULL DEFAULT '0',
  `core_version` int(10) unsigned NOT NULL DEFAULT '1',
  `core_ordering` int(11) NOT NULL DEFAULT '0',
  `core_metakey` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `core_metadesc` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `core_catid` int(10) unsigned NOT NULL DEFAULT '0',
  `core_xreference` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'A reference to enable linkages to external data sets.',
  `core_type_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`core_content_id`),
  KEY `tag_idx` (`core_state`,`core_access`),
  KEY `idx_access` (`core_access`),
  KEY `idx_alias` (`core_alias`(100)),
  KEY `idx_language` (`core_language`),
  KEY `idx_title` (`core_title`(100)),
  KEY `idx_modified_time` (`core_modified_time`),
  KEY `idx_created_time` (`core_created_time`),
  KEY `idx_content_type` (`core_type_alias`(100)),
  KEY `idx_core_modified_user_id` (`core_modified_user_id`),
  KEY `idx_core_checked_out_user_id` (`core_checked_out_user_id`),
  KEY `idx_core_created_user_id` (`core_created_user_id`),
  KEY `idx_core_type_id` (`core_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Contains core content data in name spaced fields';
/**ABDB**/CREATE TABLE `#__ucm_base` (
  `ucm_id` int(10) unsigned NOT NULL,
  `ucm_item_id` int(10) NOT NULL,
  `ucm_type_id` int(11) NOT NULL,
  `ucm_language_id` int(11) NOT NULL,
  PRIMARY KEY (`ucm_id`),
  KEY `idx_ucm_item_id` (`ucm_item_id`),
  KEY `idx_ucm_type_id` (`ucm_type_id`),
  KEY `idx_ucm_language_id` (`ucm_language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__template_styles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `template` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `home` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_template` (`template`),
  KEY `idx_client_id` (`client_id`),
  KEY `idx_client_id_home` (`client_id`,`home`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__template_styles`  VALUES 
('5', 'hathor', '1', '0', 'Hathor - Default', '{\"showSiteName\":\"0\",\"colourChoice\":\"\",\"boldText\":\"0\"}'),
('8', 'isis', '1', '1', 'isis - Default', '{\"templateColor\":\"\",\"logoFile\":\"\"}'),
('11', 'yamas', '0', '1', 'yamas - Default', '{\"logo_type\":\"image\",\"logo_image\":\"images\\/logo-faculty\\/logo-fsti.svg\",\"logo_height\":\"60\",\"mobile_logo\":\"\",\"logo_text\":\"\",\"logo_slogan\":\"\",\"header_height\":\"85px\",\"sticky_header\":\"1\",\"favicon\":\"images\\/logo-faculty\\/favicon.png\",\"body_bg_image\":\"\",\"body_bg_repeat\":\"inherit\",\"body_bg_size\":\"inherit\",\"body_bg_attachment\":\"inherit\",\"body_bg_position\":\"0 0\",\"enabled_copyright\":\"1\",\"copyright_position\":\"footer1\",\"copyright_load_pos\":\"default\",\"copyright\":\"Copyright\\u00a9 {year} UMP. All Rights Reserved.\",\"goto_top\":\"1\",\"show_social_icons\":\"1\",\"social_position\":\"top1\",\"social_load_pos\":\"after\",\"facebook\":\"#\",\"twitter\":\"#\",\"googleplus\":\"\",\"pinterest\":\"\",\"linkedin\":\"\",\"dribbble\":\"\",\"instagram\":\"#\",\"behance\":\"\",\"youtube\":\"#\",\"flickr\":\"\",\"skype\":\"\",\"whatsapp\":\"\",\"vk\":\"\",\"custom\":\"\",\"contact_position\":\"top2\",\"contact_phone\":\"+228 872 4444\",\"contact_mobile\":\"+775 872 4444\",\"contact_email\":\"contact@email.com\",\"contact_time\":\"\",\"comingsoon_title\":\"Coming Soon Title\",\"comingsoon_content\":\"Coming soon content\",\"comingsoon_date\":\"5-10-2020\",\"comingsoon_logo\":\"\",\"comingsoon_bg_image\":\"images\\/Demo\\/coming_soon.jpg\",\"comingsoon_social_icons\":\"1\",\"error_logo\":\"\",\"error_bg\":\"images\\/stock-photo\\/ump-konvo-stock-photo.png\",\"preset\":\"{\\\"footer_link_hover_color\\\":\\\"#e74c3c\\\",\\\"footer_link_color\\\":\\\"#FFFFFF\\\",\\\"footer_text_color\\\":\\\"#FFFFFF\\\",\\\"footer_bg_color\\\":\\\"#312929\\\",\\\"menu_dropdown_text_active_color\\\":\\\"#e74c3c\\\",\\\"menu_dropdown_text_hover_color\\\":\\\"#e74c3c\\\",\\\"menu_dropdown_text_color\\\":\\\"#404752\\\",\\\"menu_dropdown_bg_color\\\":\\\"#FFFFFF\\\",\\\"menu_text_active_color\\\":\\\"#e74c3c\\\",\\\"menu_text_hover_color\\\":\\\"#e74c3c\\\",\\\"menu_text_color\\\":\\\"#404752\\\",\\\"logo_text_color\\\":\\\"#312929\\\",\\\"topbar_text_color\\\":\\\"#404752\\\",\\\"topbar_bg_color\\\":\\\"#95a5a6\\\",\\\"header_bg_color\\\":\\\"#e8e7ec\\\",\\\"link_hover_color\\\":\\\"#e74c3c\\\",\\\"link_color\\\":\\\"#e74c3c\\\",\\\"bg_color\\\":\\\"#e8e7ec\\\",\\\"text_color\\\":\\\"#454545\\\",\\\"preset\\\":\\\"preset1\\\"}\",\"custom_style\":\"1\",\"text_color\":\"#133332\",\"bg_color\":\"#ffffff\",\"link_color\":\"#15a195\",\"link_hover_color\":\"#1ac75f\",\"header_bg_color\":\"#ffffff\",\"logo_text_color\":\"#235196\",\"topbar_bg_color\":\"#15a195\",\"topbar_text_color\":\"#f5f5f5\",\"menu_text_color\":\"#303030\",\"menu_text_hover_color\":\"#15a195\",\"menu_text_active_color\":\"#15a195\",\"menu_dropdown_bg_color\":\"#ffffff\",\"menu_dropdown_text_color\":\"#202020\",\"menu_dropdown_text_hover_color\":\"#15a195\",\"menu_dropdown_text_active_color\":\"#15a195\",\"footer_bg_color\":\"#282b2e\",\"footer_text_color\":\"#ebebeb\",\"footer_link_color\":\"#ffffff\",\"footer_link_hover_color\":\"#15a195\",\"header_style\":\"style-1\",\"layout\":\"[{\\\"type\\\":\\\"row\\\",\\\"layout\\\":12,\\\"settings\\\":{\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":1,\\\"hide_on_large_phone\\\":1,\\\"hide_on_phone\\\":1,\\\"background_position\\\":\\\"\\\",\\\"background_attachment\\\":\\\"\\\",\\\"background_size\\\":\\\"\\\",\\\"background_repeat\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"fluidrow\\\":0,\\\"name\\\":\\\"top-bar\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":12,\\\"column_type\\\":0,\\\"name\\\":\\\"top1\\\",\\\"custom_class\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"md_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":12,\\\"settings\\\":{\\\"hide_on_desktop\\\":1,\\\"hide_on_small_desktop\\\":1,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"background_position\\\":\\\"\\\",\\\"background_attachment\\\":\\\"\\\",\\\"background_size\\\":\\\"\\\",\\\"background_repeat\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"fluidrow\\\":0,\\\"name\\\":\\\"top-bar\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":12,\\\"hide_on_desktop\\\":1,\\\"hide_on_small_desktop\\\":1,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"xs_col\\\":0,\\\"sm_col\\\":0,\\\"md_col\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"name\\\":\\\"top2\\\",\\\"column_type\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"4+8\\\",\\\"settings\\\":{\\\"name\\\":\\\"Header\\\",\\\"fluidrow\\\":0,\\\"custom_class\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_repeat\\\":\\\"\\\",\\\"background_size\\\":\\\"\\\",\\\"background_attachment\\\":\\\"\\\",\\\"background_position\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":1,\\\"hide_on_desktop\\\":0},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":4,\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"column_type\\\":0,\\\"name\\\":\\\"logo\\\",\\\"custom_class\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"md_col\\\":7,\\\"sm_col\\\":7,\\\"xs_col\\\":7,\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":8,\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"column_type\\\":0,\\\"name\\\":\\\"menu\\\",\\\"custom_class\\\":\\\"\\\",\\\"xl_col\\\":0,\\\"md_col\\\":5,\\\"sm_col\\\":5,\\\"xs_col\\\":5,\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"3+9\\\",\\\"settings\\\":{\\\"name\\\":\\\"Header\\\",\\\"fluidrow\\\":0,\\\"custom_class\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_repeat\\\":\\\"\\\",\\\"background_size\\\":\\\"\\\",\\\"background_attachment\\\":\\\"\\\",\\\"background_position\\\":\\\"\\\",\\\"hide_on_phone\\\":1,\\\"hide_on_large_phone\\\":1,\\\"hide_on_tablet\\\":1,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":1},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"grid_size\\\":3,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"md_col\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"name\\\":\\\"logo\\\",\\\"column_type\\\":0}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":9,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"md_col\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"name\\\":\\\"menu\\\",\\\"column_type\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":12,\\\"settings\\\":{\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"background_image\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"fluidrow\\\":1,\\\"name\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"hide_mobile\\\":1,\\\"hide_large_mobile\\\":1,\\\"hide_tablet\\\":0,\\\"hide_small_desktop\\\":0,\\\"hide_desktop\\\":0},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"column_type\\\":0,\\\"name\\\":\\\"title\\\",\\\"custom_class\\\":\\\"title-height\\\",\\\"xl_col\\\":\\\"\\\",\\\"md_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"hide_on_phone\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_desktop\\\":0,\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"grid_size\\\":12}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"4+4+4\\\",\\\"settings\\\":{\\\"name\\\":\\\"Main Body\\\",\\\"background_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"padding\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"fluidrow\\\":0,\\\"custom_class\\\":\\\"\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"custom_class\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"name\\\":\\\"left\\\",\\\"grid_size\\\":4,\\\"column_type\\\":0}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":4,\\\"custom_class\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"sortableitem\\\":\\\"[object Object]\\\",\\\"column_type\\\":1}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"custom_class\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"name\\\":\\\"right\\\",\\\"column_type\\\":0,\\\"grid_size\\\":4}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":12,\\\"settings\\\":{\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"background_position\\\":\\\"50% 50%\\\",\\\"background_attachment\\\":\\\"fixed\\\",\\\"background_size\\\":\\\"cover\\\",\\\"background_repeat\\\":\\\"no-repeat\\\",\\\"background_image\\\":\\\"images\\/2019\\/02\\/26\\/blog-cta.jpg\\\",\\\"background_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"custom_class\\\":\\\"bg-overlay blog-cta\\\",\\\"fluidrow\\\":0,\\\"name\\\":\\\"\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"grid_size\\\":12,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"md_col\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"name\\\":\\\"blog-bottom\\\",\\\"column_type\\\":0}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"3+1+3+3+2\\\",\\\"settings\\\":{\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"background_position\\\":\\\"\\\",\\\"background_attachment\\\":\\\"\\\",\\\"background_size\\\":\\\"\\\",\\\"background_repeat\\\":\\\"\\\",\\\"background_image\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"link_hover_color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"margin\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"fluidrow\\\":0,\\\"name\\\":\\\"Bottom\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"md_col\\\":2,\\\"xl_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"name\\\":\\\"bottom1\\\",\\\"column_type\\\":0,\\\"grid_size\\\":3,\\\"sortableitem\\\":\\\"[object Object]\\\"}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":0,\\\"md_col\\\":1,\\\"xl_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"name\\\":\\\"bottom2\\\",\\\"column_type\\\":0,\\\"grid_size\\\":1,\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"sortableitem\\\":\\\"[object Object]\\\"}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"md_col\\\":3,\\\"xl_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"name\\\":\\\"bottom3\\\",\\\"column_type\\\":0,\\\"grid_size\\\":3,\\\"hidden_xs\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_md\\\":0,\\\"sortableitem\\\":\\\"[object Object]\\\"}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"md_col\\\":3,\\\"xl_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"name\\\":\\\"bottom4\\\",\\\"column_type\\\":0,\\\"grid_size\\\":3,\\\"sortableitem\\\":\\\"[object Object]\\\"}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"md_col\\\":3,\\\"xl_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"name\\\":\\\"bottom5\\\",\\\"column_type\\\":0,\\\"grid_size\\\":2,\\\"sortableitem\\\":\\\"[object Object]\\\"}}]},{\\\"type\\\":\\\"row\\\",\\\"layout\\\":\\\"6+6\\\",\\\"settings\\\":{\\\"custom_class\\\":\\\"\\\",\\\"fluidrow\\\":0,\\\"margin\\\":\\\"\\\",\\\"padding\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"link_hover_color\\\":\\\"\\\",\\\"link_color\\\":\\\"\\\",\\\"color\\\":\\\"\\\",\\\"background_color\\\":\\\"\\\",\\\"name\\\":\\\"Footer\\\"},\\\"attr\\\":[{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"custom_class\\\":\\\"\\\",\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"name\\\":\\\"footer1\\\",\\\"column_type\\\":0,\\\"grid_size\\\":6,\\\"sortableitem\\\":\\\"[object Object]\\\"}},{\\\"type\\\":\\\"sp_col\\\",\\\"settings\\\":{\\\"hidden_md\\\":0,\\\"hidden_sm\\\":0,\\\"hidden_xs\\\":0,\\\"grid_size\\\":6,\\\"hide_on_desktop\\\":0,\\\"hide_on_small_desktop\\\":0,\\\"hide_on_tablet\\\":0,\\\"hide_on_large_phone\\\":0,\\\"hide_on_phone\\\":0,\\\"xs_col\\\":\\\"\\\",\\\"sm_col\\\":\\\"\\\",\\\"md_col\\\":\\\"\\\",\\\"xl_col\\\":\\\"\\\",\\\"custom_class\\\":\\\"\\\",\\\"name\\\":\\\"footer2\\\",\\\"column_type\\\":0}}]}]\",\"menu\":\"mainmenu\",\"menu_type\":\"mega\",\"dropdown_width\":\"\",\"menu_animation\":\"menu-animation-zoom\",\"offcanvas_position\":\"right\",\"enable_body_font\":\"1\",\"body_font\":\"{\\\"fontFamily\\\":\\\"Poppins\\\",\\\"fontSize\\\":\\\"16\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"300\\\",\\\"fontStyle\\\":\\\"\\\",\\\"fontSubset\\\":\\\"devanagari\\\"}\",\"enable_h1_font\":\"1\",\"h1_font\":\"{\\\"fontFamily\\\":\\\"Open Sans\\\",\\\"fontSize\\\":\\\"48\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"500\\\",\\\"fontStyle\\\":\\\"\\\",\\\"fontSubset\\\":\\\"cyrillic\\\"}\",\"enable_h2_font\":\"1\",\"h2_font\":\"{\\\"fontFamily\\\":\\\"Poppins\\\",\\\"fontSize\\\":\\\"54\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"600\\\",\\\"fontStyle\\\":\\\"normal\\\",\\\"fontSubset\\\":\\\"devanagari\\\"}\",\"enable_h3_font\":\"1\",\"h3_font\":\"{\\\"fontFamily\\\":\\\"Poppins\\\",\\\"fontSize\\\":\\\"44\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"400\\\",\\\"fontStyle\\\":\\\"\\\",\\\"fontSubset\\\":\\\"devanagari\\\"}\",\"enable_h4_font\":\"1\",\"h4_font\":\"{\\\"fontFamily\\\":\\\"Poppins\\\",\\\"fontSize\\\":\\\"27\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"400\\\",\\\"fontStyle\\\":\\\"\\\",\\\"fontSubset\\\":\\\"devanagari\\\"}\",\"enable_h5_font\":\"1\",\"h5_font\":\"{\\\"fontFamily\\\":\\\"Poppins\\\",\\\"fontSize\\\":\\\"18\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"500\\\",\\\"fontStyle\\\":\\\"\\\",\\\"fontSubset\\\":\\\"devanagari\\\"}\",\"enable_h6_font\":\"1\",\"h6_font\":\"{\\\"fontFamily\\\":\\\"Poppins\\\",\\\"fontSize\\\":\\\"14\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"500\\\",\\\"fontStyle\\\":\\\"\\\",\\\"fontSubset\\\":\\\"devanagari\\\"}\",\"enable_navigation_font\":\"1\",\"navigation_font\":\"{\\\"fontFamily\\\":\\\"Poppins\\\",\\\"fontSize\\\":\\\"14\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"700\\\",\\\"fontStyle\\\":\\\"normal\\\",\\\"fontSubset\\\":\\\"devanagari\\\"}\",\"custom_font\":\"{\\\"fontFamily\\\":\\\"Poppins\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontStyle\\\":\\\"\\\",\\\"fontSubset\\\":\\\"devanagari\\\"}\",\"custom_font_selectors\":\".sp-page-title .sp-page-title-heading, .article-details .article-header h1,\\r\\n.article-details .article-header h2,\\r\\n.sppb-addon-text-block.first-letter-cap .sppb-addon-content:first-letter,\\r\\n.sppb-addon-blocknumber .sppb-blocknumber .sppb-blocknumber-number\",\"custom_font_two\":\"{\\\"fontFamily\\\":\\\"IBM Plex Sans\\\",\\\"fontSize\\\":\\\"\\\",\\\"fontSize_sm\\\":\\\"\\\",\\\"fontSize_xs\\\":\\\"\\\",\\\"fontWeight\\\":\\\"\\\",\\\"fontStyle\\\":\\\"\\\",\\\"fontSubset\\\":\\\"cyrillic\\\"}\",\"custom_font_two_selectors\":\".sppb-addon-blocknumber .sppb-media-body .sppb-media-heading, .sppb-addon-pricing-table.basic-card .sppb-pricing-box .sppb-pricing-header .sppb-pricing-price-container .sppb-pricing-duration, .sppb-addon-pricing-table.basic-card .sppb-pricing-box .sppb-pricing-header .sppb-pricing-price-container .sppb-pricing-price-symbol,.article-list .article .article-header h1, .sppb-addon-articles .article .article-header h1, .article-list .sppb-addon-article .article-header h1, .sppb-addon-articles .sppb-addon-article .article-header h1, .article-list .article .sppb-article-info-wrap h1, .sppb-addon-articles .article .sppb-article-info-wrap h1, .article-list .sppb-addon-article .sppb-article-info-wrap h1, .sppb-addon-articles .sppb-addon-article .sppb-article-info-wrap h1, .article-list .article .article-header h2, .sppb-addon-articles .article .article-header h2, .article-list .sppb-addon-article .article-header h2, .sppb-addon-articles .sppb-addon-article .article-header h2, .article-list .article .sppb-article-info-wrap h2, .sppb-addon-articles .article .sppb-article-info-wrap h2, .article-list .sppb-addon-article .sppb-article-info-wrap h2, .sppb-addon-articles .sppb-addon-article .sppb-article-info-wrap h2, .article-list .article .article-header h3, .sppb-addon-articles .article .article-header h3, .article-list .sppb-addon-article .article-header h3, .sppb-addon-articles .sppb-addon-article .article-header h3, .article-list .article .sppb-article-info-wrap h3, .sppb-addon-articles .article .sppb-article-info-wrap h3, .article-list .sppb-addon-article .sppb-article-info-wrap h3, .sppb-addon-articles .sppb-addon-article .sppb-article-info-wrap h3, .sppb-addon-title .tm-symbol, .card-holder .card-top .card-exten sub,\\r\\n.card-holder .card-top .card-exten sup,.sp-page-title .sp-page-title-sub-heading, .popular-classes .sppb-addon-title, .sppb-yogacalendar-time, .sppb-yogacalendar-title, .sp-megamenu-parent .sp-dropdown .sp-module .sp-module-title\",\"gfont_api\":\"\",\"image_small_size\":\"100X100\",\"image_thumbnail\":\"1\",\"image_thumbnail_size\":\"350X207\",\"image_medium\":\"1\",\"image_medium_size\":\"445X420\",\"image_large_size\":\"600X600\",\"image_crop_quality\":\"100\",\"blog_list_image\":\"thumbnail\",\"leading_blog_list_image\":\"default\",\"blog_details_image\":\"default\",\"social_share\":\"1\",\"og_fb_id\":\"\",\"og_twitter_site\":\"\",\"comment\":\"disabled\",\"comment_disqus_subdomain\":\"\",\"comment_disqus_devmode\":\"1\",\"comment_intensedebate_acc\":\"\",\"comment_facebook_app_id\":\"\",\"comment_facebook_width\":\"100\",\"comment_facebook_number\":\"10\",\"comments_count\":\"1\",\"joomshaper_email\":\"\",\"joomshaper_license_key\":\"\",\"before_head\":\"\",\"before_body\":\"\",\"custom_css\":\".article-header-wrap .article-share-on {\\r\\n    top: 160px; left: -160px; right: initial;\\r\\n}\\r\\n\\r\\n\\/* search box result *\\/\\r\\nselect.inputbox:not([multiple]), select:not([multiple]) {height: 2.75rem}\\r\\n\\r\\n.article-body-right .sp-module ul > li {\\r\\n    display: list-item;\\r\\n    list-style: disc;\\r\\n    padding-left: .5em}\\r\\n.article-body-right .sp-module {\\r\\nbackground-color: #f9f9f9;\\r\\n    margin: 20px 0}\\r\\n\\r\\n\\/* Heading + Breadcrumbs *\\/\\r\\n\\r\\n.breadcrumb-white .breadcrumb-item.active {color: inherit}\\r\\n.breadcrumb-white .breadcrumb-item +.breadcrumb-item:before {color: inherit}\\r\\n.breadcrumb-white .breadcrumb {background-color: transparent}\\r\\n.breadcrumb-white .breadcrumb {margin-bottom: 0}\\r\\n.breadcrumb-white .breadcrumb {padding: 0.5rem 0rem}\\r\\n\\r\\n.breadcrumb-black .breadcrumb-item.active {color: inherit}\\r\\n.breadcrumb-black .breadcrumb-item +.breadcrumb-item:before {color: inherit}\\r\\n.breadcrumb-black .breadcrumb {background-color: transparent}\\r\\n.breadcrumb-black .breadcrumb {margin-bottom: 0}\\r\\n.breadcrumb-black .breadcrumb {padding: 0.5rem 0rem}\\r\\n\\r\\n\\r\\n\\r\\n.transparent-header .sp-page-title .sp-page-title-heading {color: white;}\\r\\n.transparent-header .sp-page-title {padding: 135px 0 40px;}\\r\\n.transparent-header .sp-page-title .breadcrumb a:hover {color: #15a195;}\\r\\n\\r\\n.transparent-header1 #sp-header:not(.header-sticky) {background-color: white}\\r\\n.transparent-header1 .sp-page-title .sp-page-title-heading {color: #15a195;}\\r\\n.transparent-header1 .sp-page-title {padding-top: 50px; padding-bottom: 40px;}\\r\\n.transparent-header1 .sp-page-title .breadcrumb > li, .transparent-header1 .sp-page-title .breadcrumb > li + li:before, .transparent-header1 .sp-page-title .breadcrumb > li > a, .transparent-header1 .sp-page-title .breadcrumb > .active {color: white;}\\r\\n.transparent-header1 .sp-page-title .breadcrumb a:hover {color: #15a195;}\\r\\n.transparent-header1 .sp-page-title .breadcrumb {font-size: 15px; padding-left: 5px}\\r\\n\\r\\n.transparent-header1a #sp-header:not(.header-sticky) {background-color: transparent; position: absolute;}\\r\\n.transparent-header1a .sp-page-title .sp-page-title-heading {color: #15a195;}\\r\\n.transparent-header1a .sp-page-title {padding: 135px 0 40px;}\\r\\n.transparent-header1a .sp-page-title .breadcrumb > li, .transparent-header1a .sp-page-title .breadcrumb > li + li:before, .transparent-header1a .sp-page-title .breadcrumb > li > a, .transparent-header1a .sp-page-title .breadcrumb > .active {color: white;}\\r\\n.transparent-header1a .sp-page-title .breadcrumb a:hover {color: #15a195;}\\r\\n.transparent-header1a .sp-page-title .breadcrumb {font-size: 15px; padding-left: 5px}\\r\\n\\r\\n.transparent-header2 #sp-header:not(.header-sticky) {background-color: white}\\r\\n.transparent-header2 .sp-page-title .sp-page-title-heading {color: white}\\r\\n.transparent-header2 .sp-page-title {padding-top: 50px; padding-bottom: 40px;}\\r\\n.transparent-header2 .sp-page-title .breadcrumb > li, .transparent-header2 .sp-page-title .breadcrumb > li + li:before, .transparent-header2 .sp-page-title .breadcrumb > li > a, .transparent-header2 .sp-page-title .breadcrumb > .active {color: white;}\\r\\n.transparent-header2 .sp-page-title .breadcrumb a:hover {color: #15a195;}\\r\\n.transparent-header2 .sp-page-title .breadcrumb {font-size: 15px; padding-left: 5px}\\r\\n\\r\\n.transparent-header2a #sp-header:not(.header-sticky) {background-color: transparent; position: absolute;}\\r\\n.transparent-header2a .sp-page-title .sp-page-title-heading {color: white}\\r\\n.transparent-header2a .sp-page-title {padding: 135px 0 40px;}\\r\\n.transparent-header2a .sp-page-title .breadcrumb > li, .transparent-header2a .sp-page-title .breadcrumb > li + li:before, .transparent-header2a .sp-page-title .breadcrumb > li > a, .transparent-header2a .sp-page-title .breadcrumb > .active {color: white;}\\r\\n.transparent-header2a .sp-page-title .breadcrumb a:hover {color: #15a195;}\\r\\n.transparent-header2a .sp-page-title .breadcrumb {font-size: 15px; padding-left: 5px}\\r\\n\\r\\n.transparent-header3 #sp-header:not(.header-sticky) {background-color: white}\\r\\n.transparent-header3 .sp-page-title .sp-page-title-heading {color: white}\\r\\n.transparent-header3 .sp-page-title {padding-top: 50px; padding-bottom: 40px;}\\r\\n.transparent-header3 .sp-page-title .breadcrumb > li, .transparent-header3 .sp-page-title .breadcrumb > li + li:before, .transparent-header3 .sp-page-title .breadcrumb > li > a, .transparent-header3 .sp-page-title .breadcrumb > .active {color: black;}\\r\\n.transparent-header3 .sp-page-title .breadcrumb a:hover {color: #15a195;}\\r\\n.transparent-header3 .sp-page-title .breadcrumb {font-size: 15px; padding-left: 5px}\\r\\n\\r\\n.transparent-header3a #sp-header:not(.header-sticky) {background-color: transparent; position: absolute;}\\r\\n.transparent-header3a .sp-page-title .sp-page-title-heading {color: white;}\\r\\n.transparent-header3a .sp-page-title {padding: 135px 0 40px;}\\r\\n.transparent-header3a .sp-page-title .breadcrumb > li, .transparent-header3a .sp-page-title .breadcrumb > li + li:before, .transparent-header3a .sp-page-title .breadcrumb > li > a, .transparent-header3a .sp-page-title .breadcrumb > .active {color: black;}\\r\\n.transparent-header3a .sp-page-title .breadcrumb a:hover {color: #15a195;}\\r\\n.transparent-header3a .sp-page-title .breadcrumb {font-size: 15px; padding-left: 5px}\\r\\n\\r\\n.transparent-header4 #sp-header:not(.header-sticky) {background-color: white}\\r\\n.transparent-header4 .sp-page-title .sp-page-title-heading {color: #15a195;}\\r\\n.transparent-header4 .sp-page-title {padding-top: 50px; padding-bottom: 40px;}\\r\\n.transparent-header4 .sp-page-title .breadcrumb > li, .transparent-header4 .sp-page-title .breadcrumb > li + li:before, .transparent-header4 .sp-page-title .breadcrumb > li > a, .transparent-header4 .sp-page-title .breadcrumb > .active {color: black;}\\r\\n.transparent-header4 .sp-page-title .breadcrumb a:hover {color: #15a195;}\\r\\n.transparent-header4 .sp-page-title .breadcrumb {font-size: 15px; padding-left: 5px}\\r\\n\\r\\n.transparent-header4a #sp-header:not(.header-sticky) {background-color: transparent; position: absolute;}\\r\\n.transparent-header4a .sp-page-title .sp-page-title-heading {color: #15a195;}\\r\\n.transparent-header4a .sp-page-title {padding: 135px 0 40px;}\\r\\n.transparent-header4a .sp-page-title .breadcrumb > li, .transparent-header4a .sp-page-title .breadcrumb > li + li:before, .transparent-header4a .sp-page-title .breadcrumb > li > a, .transparent-header4a .sp-page-title .breadcrumb > .active {color: black;}\\r\\n.transparent-header4a .sp-page-title .breadcrumb a:hover {color: #15a195;}\\r\\n.transparent-header4a .sp-page-title .breadcrumb {font-size: 15px; padding-left: 5px}\\r\\n\\r\\n.transparent-header5 #sp-header:not(.header-sticky) {background-color: white}\\r\\n.transparent-header5 .sp-page-title .sp-page-title-heading {color: inherit;}\\r\\n.transparent-header5 .sp-page-title {padding-top: 50px; padding-bottom: 40px;}\\r\\n.transparent-header5 .sp-page-title .breadcrumb > li, .transparent-header5 .sp-page-title .breadcrumb > li + li:before, .transparent-header5 .sp-page-title .breadcrumb > li > a, .transparent-header5 .sp-page-title .breadcrumb > .active {color: black;}\\r\\n.transparent-header5 .sp-page-title .breadcrumb a:hover {color: #15a195;}\\r\\n.transparent-header5 .sp-page-title .breadcrumb {font-size: 15px; padding-left: 5px}\\r\\n\\r\\n.transparent-header5a #sp-header:not(.header-sticky) {background-color: transparent; position: absolute;}\\r\\n.transparent-header5a .sp-page-title .sp-page-title-heading {color: inherit;}\\r\\n.transparent-header5a .sp-page-title {padding: 135px 0 40px;}\\r\\n.transparent-header5a .sp-page-title .breadcrumb > li, .transparent-header5a .sp-page-title .breadcrumb > li + li:before, .transparent-header5a .sp-page-title .breadcrumb > li > a, .transparent-header5a .sp-page-title .breadcrumb > .active {color: black;}\\r\\n.transparent-header5a .sp-page-title .breadcrumb a:hover {color: #15a195;}\\r\\n.transparent-header5a .sp-page-title .breadcrumb {font-size: 15px; padding-left: 5px}\\r\\n\\r\\n\\r\\n\\r\\n\\r\\n\\/* Susun tel, email & social icons *\\/\\r\\n\\r\\n.sp-contact-info {float: right;}\\r\\n\\r\\n.sp-contact-info-2 {\\r\\n  list-style: none;\\r\\n  padding: 0;\\r\\n  margin: 0 -10px;\\r\\n}\\r\\n.sp-contact-info-2 li {\\r\\n  display: inline-block;\\r\\n  margin: 0 10px;\\r\\n  white-space: nowrap;\\r\\n}\\r\\n.sp-contact-info-2 li i {\\r\\n  margin: 0 3px;\\r\\n}\\r\\n\\r\\n.sp-contact-info-3 {\\r\\n  list-style: none;  padding: 0;\\r\\n  margin: 0 -10px; font-size: 11.6px\\r\\n}\\r\\n.sp-contact-info-3 li {\\r\\n  display: inline-block;\\r\\n  margin: 0 10px;\\r\\n  white-space: nowrap;\\r\\n}\\r\\n.sp-contact-info-3 li i {\\r\\n  margin: 0 3px;\\r\\n}\\r\\n\\r\\n\\/*  Tinggi Top Bar *\\/\\r\\n\\r\\n#sp-top-bar .sp-module {\\r\\n    margin: 0 0 -16px 1.25rem;}\\r\\n\\r\\n\\/* Font Menu Footer *\\/\\r\\n#sp-bottom .sp-module .sp-module-title {\\r\\n    font-weight: 600;\\r\\n    font-size: 14px;}\\r\\n#sp-bottom .sp-module ul > li > a {\\r\\n    font-size: 13px;}\\r\\n#sp-bottom .sp-module ul > li > a:hover { color: white;}\\r\\n\\r\\n#sp-top-bar {height: auto; font-weight: 500;}\\r\\n\\r\\n#sp-header {top: auto;}\\r\\n\\r\\n.transparent-header #sp-header:not(.header-sticky) {\\r\\n    background-color:  rgba(247, 247, 247, 0.7); position: absolute; }\\r\\n\\r\\n#sp-header.header-sticky {\\r\\ntop:-15px; height: 70px; transition: all 0.5s ease-in-out;}\\r\\n.header-sticky div div .logo {width: 70%}\\r\\n\\r\\n#sp-header .sp-megamenu-parent > li > a:before {display:none;}\\r\\n\\r\\n.sp-megamenu-parent > li > a {\\r\\n    color: #202020;\\r\\n    text-transform: uppercase;\\r\\n}\\r\\n\\r\\n@media (min-width: 992px) {\\r\\n#sp-header .sp-megamenu-parent > li > a {\\r\\n    padding: 0 0px;\\r\\n    margin: 0 13px;\\r\\n    font-weight: 500;\\r\\n    font-size: 13px;\\r\\n}}\\r\\n\\r\\n@media (min-width: 1200px) {\\r\\n#sp-header .sp-megamenu-parent > li > a {\\r\\n    padding: 0 0px;\\r\\n    margin: 0 15px;\\r\\n    font-weight: 600;\\r\\n    font-size: 15px;\\r\\n}}\\r\\n\\r\\n .menu-center-2 {\\r\\n   float: left;\\r\\n }\\r\\n\\r\\n#sp-bottom .sp-module ul > li > a {\\r\\n    font-weight: 300;\\r\\n    color: rgba(245, 245, 245, .6);\\r\\n}\\r\\n\\r\\n#sp-footer a, #sp-bottom a {\\r\\n    color: rgba(219, 219, 219, 0.5);\\r\\n}\",\"custom_js\":\"\",\"exclude_js\":\"\",\"scssoption\":\"1\"}');
/**ABDB**/CREATE TABLE `#__tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `lft` int(11) NOT NULL DEFAULT '0',
  `rgt` int(11) NOT NULL DEFAULT '0',
  `level` int(10) unsigned NOT NULL DEFAULT '0',
  `path` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadesc` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `images` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `urls` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `tag_idx` (`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__tags`  VALUES 
('1', '0', '0', '15', '0', '', 'ROOT', 'root', '', '', '1', '0', '0000-00-00 00:00:00', '1', '', '', '', '', '803', '2019-08-28 03:04:45', '', '0', '0000-00-00 00:00:00', '', '', '0', '*', '1', '0000-00-00 00:00:00', '0000-00-00 00:00:00'),
('2', '1', '1', '2', '1', 'animations', 'Animations', 'animations', '', '', '1', '0', '2018-02-26 06:42:28', '1', '{}', '', '', '{}', '803', '2019-08-28 03:04:45', '', '0', '2019-08-28 03:04:45', '{}', '{}', '0', '*', '1', '2019-08-28 03:04:45', '2019-08-28 03:04:45'),
('3', '1', '3', '4', '1', 'builder', 'Builder', 'builder', '', '', '1', '0', '2018-02-26 06:51:56', '1', '{}', '', '', '{}', '803', '2019-08-28 03:04:45', '', '0', '2019-08-28 03:04:45', '{}', '{}', '0', '*', '1', '2019-08-28 03:04:45', '2019-08-28 03:04:45'),
('4', '1', '5', '6', '1', 'dropdown', 'Dropdown', 'dropdown', '', '', '1', '0', '2018-02-26 06:51:56', '1', '{}', '', '', '{}', '803', '2019-08-28 03:04:45', '', '0', '2019-08-28 03:04:45', '{}', '{}', '0', '*', '1', '2019-08-28 03:04:45', '2019-08-28 03:04:45'),
('5', '1', '7', '8', '1', 'drag', 'Drag', 'drag', '', '', '1', '0', '2018-02-26 06:51:56', '1', '{}', '', '', '{}', '803', '2019-08-28 03:04:45', '', '0', '2019-08-28 03:04:45', '{}', '{}', '0', '*', '1', '2019-08-28 03:04:45', '2019-08-28 03:04:45'),
('6', '1', '9', '10', '1', 'drop', 'Drop', 'drop', '', '', '1', '0', '2018-02-26 06:51:56', '1', '{}', '', '', '{}', '803', '2019-08-28 03:04:45', '', '0', '2019-08-28 03:04:45', '{}', '{}', '0', '*', '1', '2019-08-28 03:04:45', '2019-08-28 03:04:45'),
('7', '1', '11', '12', '1', 'mega-menu', 'Mega Menu', 'mega-menu', '', '', '1', '0', '2018-02-26 06:51:56', '1', '{}', '', '', '{}', '803', '2019-08-28 03:04:45', '', '0', '2019-08-28 03:04:45', '{}', '{}', '0', '*', '1', '2019-08-28 03:04:45', '2019-08-28 03:04:45'),
('8', '1', '13', '14', '1', 'features', 'Features', 'features', '', '', '1', '0', '2018-02-26 06:51:56', '1', '{}', '', '', '{}', '803', '2019-08-28 03:04:45', '', '0', '2019-08-28 03:04:45', '{}', '{}', '0', '*', '1', '2019-08-28 03:04:45', '2019-08-28 03:04:45');
/**ABDB**/CREATE TABLE `#__sppagebuilder_sections` (
  `id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `section` mediumtext NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__sppagebuilder_sections`  VALUES 
('1', 'cta', '{\"id\":1549612334359,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"120px 0px 120px 0px\",\"sm\":\"   \",\"xs\":\"60px 0px 60px 0px\"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"image\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"images/2019/02/08/home-cta.jpg\",\"background_parallax\":0,\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"50% 50%\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549612334359},\"layout\":\"12\",\"columns\":[{\"id\":1549612334358,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1549612334385,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"105px 0px 105px 0px\",\"sm\":\"60px 60px 60px 60px\",\"xs\":\"30px 30px 30px 30px\"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549612334385,\"class\":\"link-color-light-bg\"},\"layout\":\"8,4\",\"visibility\":true,\"columns\":[{\"id\":1549612334386,\"class_name\":\"col-md-8\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549612334386,\"padding\":{\"md\":\"0px 0px 0px 95px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1549604284943,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"— DISCOVER THE DIFFERENCE\",\"heading_selector\":\"h5\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"Find your Inner Peace!\",\"alignment\":\"\",\"text_fontsize\":{\"md\":\"56\",\"sm\":\"\",\"xs\":\"45\"},\"text_lineheight\":{\"md\":\"66\",\"sm\":\"\",\"xs\":\"55\"},\"text_fontweight\":\"500\",\"dropcap\":0,\"class\":\"white-light-color\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549604284943,\"title_font_style\":{\"weight\":\"\",\"uppercase\":true},\"title_margin_bottom\":{\"md\":\"15\",\"sm\":\"\",\"xs\":\"10\"},\"global_text_color\":\"#ffffff\",\"text_font_family\":\"Abhaya Libre\"}}]},{\"id\":1549612334389,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1549612334380,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"2 Free Classes\",\"alignment\":\"sppb-text-center\",\"text_fontsize\":{\"md\":\"18\",\"sm\":\"\",\"xs\":\"14\"},\"text_lineheight\":{\"md\":\"29\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"500\",\"dropcap\":0,\"class\":\"white-light-color\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549612334380,\"global_text_color\":\"rgba(255, 255, 255, 0.6)\"}},{\"id\":1549604284938,\"name\":\"button\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"text\":\"Get Started\",\"alignment\":\"sppb-text-center\",\"letterspace\":\"0\",\"type\":\"default\",\"appearance\":\"outline\",\"fontsize\":{\"md\":16},\"button_status\":\"normal\",\"background_color\":\"#03E16D\",\"background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"color\":\"#FFFFFF\",\"background_color_hover\":\"#00E66E\",\"background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"color_hover\":\"#FFFFFF\",\"link_button_status\":\"normal\",\"link_button_color\":\"\",\"link_button_border_width\":\"\",\"link_border_color\":\"\",\"link_button_padding_bottom\":\"\",\"link_button_hover_color\":\"\",\"link_button_border_hover_color\":\"\",\"button_padding\":\"\",\"icon_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549604284938,\"url\":\"#\"}}]}]}]}]}', '2019-02-11 11:46:35', '348'),
('6', '1', '{\"id\":1549542681214,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"100px 0px 20px 0px\",\"sm\":\"   \",\"xs\":\"40px 0px 10px 0px\"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549542681214},\"layout\":\"12,12\",\"columns\":[{\"id\":1549542681212,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1549542914354,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"— Upcoming Events\",\"heading_selector\":\"h3\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_text_transform\":\"none\",\"title_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"title-color\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 45px 0px\",\"sm\":\"0px 0px 45px 0px\",\"xs\":\"0px 0px 30px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549542914354}}]},{\"id\":1549542681213,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1549602534101,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"65px 0px 65px 0px\",\"sm\":\"40px 40px 40px 40px\",\"xs\":\"30px 30px 30px 30px\"},\"margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549602534101,\"class\":\"event-list\",\"background_color\":\"#ffffff\"},\"layout\":\"4,5,3\",\"visibility\":true,\"columns\":[{\"id\":1549602534102,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549602534102,\"padding\":{\"md\":\"0px 0px 0px 95px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1549602534164,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Sep, 15 - Sep, 25 | 2019\",\"heading_selector\":\"h5\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"Rishikesh, Uttarakhand, India\",\"alignment\":\"\",\"text_fontsize\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"14\"},\"text_lineheight\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"title-color\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549602534164,\"title_font_style\":{\"weight\":\"\"},\"title_margin_bottom\":{\"md\":\"25\",\"sm\":\"15\",\"xs\":\"10\"}}}]},{\"id\":1549602534105,\"class_name\":\"col-md-5\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-8\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549602534105,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1549522119301,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Kundalini & The Radiant Body\",\"heading_selector\":\"h4\",\"title_fontsize\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"Access deeper levels of connection and wisdom, facilitated by specific Kundalini kriyas…\",\"alignment\":\"\",\"text_fontsize\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"14\"},\"text_lineheight\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"title-color text-color-extra-light\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"0px 30px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549522119301,\"font_family\":\"IBM Plex Sans\",\"title_margin_bottom\":{\"md\":\"20\",\"sm\":\"10\",\"xs\":\"10\"}}}]},{\"id\":1549602534106,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-4\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549602534106,\"padding\":{\"md\":\"0px 75px 0px 0px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1550811808360,\"name\":\"countdown\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"date\":\"2019/09/15\",\"time\":\"20:23\",\"finish_text\":\"Time Up\",\"counter_height\":{\"md\":\"20\"},\"counter_width\":{\"md\":\"\"},\"counter_font_size\":{\"md\":\"18\",\"xs\":\"14\"},\"counter_text_color\":\"\",\"counter_background_color\":\"\",\"counter_user_border\":0,\"counter_border_width\":{\"md\":1},\"counter_border_color\":\"#E5E5E5\",\"counter_border_style\":\"solid\",\"counter_border_radius\":{\"md\":\"\"},\"label_font_size\":{\"md\":\"18\",\"xs\":\"14\"},\"label_color\":\"\",\"class\":\" day-countdown\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1550811808360,\"label_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"counter_text_font_weight\":\"500\",\"label_font_style\":{\"weight\":500}}},{\"id\":1549604125490,\"name\":\"button\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"text\":\"Know More\",\"alignment\":\"sppb-text-center\",\"letterspace\":\"0\",\"type\":\"default\",\"appearance\":\"outline\",\"fontsize\":{\"md\":16},\"button_status\":\"normal\",\"background_color\":\"#03E16D\",\"background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"color\":\"#FFFFFF\",\"background_color_hover\":\"#00E66E\",\"background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"color_hover\":\"#FFFFFF\",\"link_button_status\":\"normal\",\"link_button_color\":\"\",\"link_button_border_width\":\"\",\"link_border_color\":\"\",\"link_button_padding_bottom\":\"\",\"link_button_hover_color\":\"\",\"link_button_border_hover_color\":\"\",\"button_padding\":\"\",\"icon_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549604125490,\"url\":\"#\"}}]}]},{\"id\":1549604284921,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"65px 0px 65px 0px\",\"sm\":\"40px 40px 40px 40px\",\"xs\":\"30px 30px 30px 30px\"},\"margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549602534101,\"class\":\"event-list\",\"background_color\":\"#ffffff\"},\"layout\":\"4,5,3\",\"visibility\":true,\"columns\":[{\"id\":1549604284922,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549602534102,\"padding\":{\"md\":\"0px 0px 0px 95px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1549604284923,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Oct 10 - Oct 14 | 2019\",\"heading_selector\":\"h5\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"Calabasas, CA, United States\",\"alignment\":\"\",\"text_fontsize\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"14\"},\"text_lineheight\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"title-color\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549604284923,\"title_font_style\":{\"weight\":\"\"},\"title_margin_bottom\":{\"md\":\"25\",\"sm\":\"15\",\"xs\":\"10\"}}}]},{\"id\":1549604284924,\"class_name\":\"col-md-5\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-8\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549604284924,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1549604284925,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Sat Nam Fest 2019\",\"heading_selector\":\"h4\",\"title_fontsize\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"Access deeper levels of connection and wisdom, facilitated by specific Kundalini kriyas…\",\"alignment\":\"\",\"text_fontsize\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"14\"},\"text_lineheight\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"title-color text-color-extra-light\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"0px 30px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549604284925,\"font_family\":\"IBM Plex Sans\",\"title_margin_bottom\":{\"md\":\"20\",\"sm\":\"10\",\"xs\":\"10\"}}}]},{\"id\":1549604284926,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-4\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549604284926,\"padding\":{\"md\":\"0px 75px 0px 0px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1550812796760,\"name\":\"countdown\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"date\":\"2019/10/10\",\"time\":\"20:23\",\"finish_text\":\"Time Up\",\"counter_height\":{\"md\":\"20\"},\"counter_width\":{\"md\":\"\"},\"counter_font_size\":{\"md\":\"18\",\"xs\":\"14\"},\"counter_text_color\":\"\",\"counter_background_color\":\"\",\"counter_user_border\":0,\"counter_border_width\":{\"md\":1},\"counter_border_color\":\"#E5E5E5\",\"counter_border_style\":\"solid\",\"counter_border_radius\":{\"md\":\"\"},\"label_font_size\":{\"md\":\"18\",\"xs\":\"14\"},\"label_color\":\"\",\"class\":\" day-countdown\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1550812796760,\"label_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"counter_text_font_weight\":\"500\",\"label_font_style\":{\"weight\":500}}},{\"id\":1549604284928,\"name\":\"button\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"text\":\"Know More\",\"alignment\":\"sppb-text-center\",\"letterspace\":\"0\",\"type\":\"default\",\"appearance\":\"outline\",\"fontsize\":{\"md\":16},\"button_status\":\"normal\",\"background_color\":\"#03E16D\",\"background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"color\":\"#FFFFFF\",\"background_color_hover\":\"#00E66E\",\"background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"color_hover\":\"#FFFFFF\",\"link_button_status\":\"normal\",\"link_button_color\":\"\",\"link_button_border_width\":\"\",\"link_border_color\":\"\",\"link_button_padding_bottom\":\"\",\"link_button_hover_color\":\"\",\"link_button_border_hover_color\":\"\",\"button_padding\":\"\",\"icon_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549604125490,\"url\":\"#\"}}]}]},{\"id\":1549604284941,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"65px 0px 65px 0px\",\"sm\":\"40px 40px 40px 40px\",\"xs\":\"30px 30px 30px 30px\"},\"margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549602534101,\"class\":\"event-list\",\"background_color\":\"#ffffff\"},\"layout\":\"4,5,3\",\"visibility\":true,\"columns\":[{\"id\":1549604284942,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549602534102,\"padding\":{\"md\":\"0px 0px 0px 95px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1549612334369,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Nov 9 - Nov 13 | 2019\",\"heading_selector\":\"h5\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"Joshua Tree, CA, United States\",\"alignment\":\"\",\"text_fontsize\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"14\"},\"text_lineheight\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"title-color\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549612334369,\"title_font_style\":{\"weight\":\"\"},\"title_margin_bottom\":{\"md\":\"25\",\"sm\":\"15\",\"xs\":\"10\"}}}]},{\"id\":1549604284944,\"class_name\":\"col-md-5\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-8\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549604284944,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1549604284945,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Shakti Fest 2019\",\"heading_selector\":\"h4\",\"title_fontsize\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"Access deeper levels of connection and wisdom, facilitated by specific Kundalini kriyas…\",\"alignment\":\"\",\"text_fontsize\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"14\"},\"text_lineheight\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"title-color text-color-extra-light\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"0px 30px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549604284945,\"font_family\":\"IBM Plex Sans\",\"title_margin_bottom\":{\"md\":\"20\",\"sm\":\"10\",\"xs\":\"10\"}}}]},{\"id\":1549604284946,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-4\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549604284946,\"padding\":{\"md\":\"0px 75px 0px 0px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1550812796781,\"name\":\"countdown\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"date\":\"2019/11/09\",\"time\":\"20:23\",\"finish_text\":\"Time Up\",\"counter_height\":{\"md\":\"20\"},\"counter_width\":{\"md\":\"\"},\"counter_font_size\":{\"md\":\"18\",\"xs\":\"14\"},\"counter_text_color\":\"\",\"counter_background_color\":\"\",\"counter_user_border\":0,\"counter_border_width\":{\"md\":1},\"counter_border_color\":\"#E5E5E5\",\"counter_border_style\":\"solid\",\"counter_border_radius\":{\"md\":\"\"},\"label_font_size\":{\"md\":\"18\",\"xs\":\"14\"},\"label_color\":\"\",\"class\":\" day-countdown\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1550812796781,\"label_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"counter_text_font_weight\":\"500\",\"label_font_style\":{\"weight\":500}}},{\"id\":1549604284948,\"name\":\"button\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"text\":\"Know More\",\"alignment\":\"sppb-text-center\",\"letterspace\":\"0\",\"type\":\"default\",\"appearance\":\"outline\",\"fontsize\":{\"md\":16},\"button_status\":\"normal\",\"background_color\":\"#03E16D\",\"background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"color\":\"#FFFFFF\",\"background_color_hover\":\"#00E66E\",\"background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"color_hover\":\"#FFFFFF\",\"link_button_status\":\"normal\",\"link_button_color\":\"\",\"link_button_border_width\":\"\",\"link_border_color\":\"\",\"link_button_padding_bottom\":\"\",\"link_button_hover_color\":\"\",\"link_button_border_hover_color\":\"\",\"button_padding\":\"\",\"icon_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549604125490,\"url\":\"#\"}}]}]},{\"id\":1549604284931,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"65px 0px 65px 0px\",\"sm\":\"40px 40px 40px 40px\",\"xs\":\"30px 30px 30px 30px\"},\"margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549602534101,\"class\":\"event-list\",\"background_color\":\"#ffffff\"},\"layout\":\"4,5,3\",\"visibility\":true,\"columns\":[{\"id\":1549604284932,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549602534102,\"padding\":{\"md\":\"0px 0px 0px 95px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1549604284933,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Dec 20 - Dec 25 | 2019\",\"heading_selector\":\"h5\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"Pacific Palisades, CA, United States\",\"alignment\":\"\",\"text_fontsize\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"14\"},\"text_lineheight\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"title-color\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549604284933,\"title_font_style\":{\"weight\":\"\"},\"title_margin_bottom\":{\"md\":\"25\",\"sm\":\"15\",\"xs\":\"10\"}}}]},{\"id\":1549604284934,\"class_name\":\"col-md-5\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-8\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549604284934,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1549604284935,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Mantra and The Yoga of Sound\",\"heading_selector\":\"h4\",\"title_fontsize\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"Access deeper levels of connection and wisdom, facilitated by specific Kundalini kriyas…\",\"alignment\":\"\",\"text_fontsize\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"14\"},\"text_lineheight\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"title-color text-color-extra-light\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"0px 30px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549604284935,\"font_family\":\"IBM Plex Sans\",\"title_margin_bottom\":{\"md\":\"20\",\"sm\":\"10\",\"xs\":\"10\"}}}]},{\"id\":1549604284936,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-4\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549604284936,\"padding\":{\"md\":\"0px 75px 0px 0px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1550812796806,\"name\":\"countdown\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"date\":\"2019/12/20\",\"time\":\"20:23\",\"finish_text\":\"Time Up\",\"counter_height\":{\"md\":\"20\"},\"counter_width\":{\"md\":\"\"},\"counter_font_size\":{\"md\":\"18\",\"xs\":\"14\"},\"counter_text_color\":\"\",\"counter_background_color\":\"\",\"counter_user_border\":0,\"counter_border_width\":{\"md\":1},\"counter_border_color\":\"#E5E5E5\",\"counter_border_style\":\"solid\",\"counter_border_radius\":{\"md\":\"\"},\"label_font_size\":{\"md\":\"18\",\"xs\":\"14\"},\"label_color\":\"\",\"class\":\" day-countdown\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1550812796806,\"label_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"counter_text_font_weight\":\"500\",\"label_font_style\":{\"weight\":500}}},{\"id\":1549612334385,\"name\":\"button\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"text\":\"Know More\",\"alignment\":\"sppb-text-center\",\"letterspace\":\"0\",\"type\":\"default\",\"appearance\":\"outline\",\"fontsize\":{\"md\":16},\"button_status\":\"normal\",\"background_color\":\"#03E16D\",\"background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"color\":\"#FFFFFF\",\"background_color_hover\":\"#00E66E\",\"background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"color_hover\":\"#FFFFFF\",\"link_button_status\":\"normal\",\"link_button_color\":\"\",\"link_button_border_width\":\"\",\"link_border_color\":\"\",\"link_button_padding_bottom\":\"\",\"link_button_hover_color\":\"\",\"link_button_border_hover_color\":\"\",\"button_padding\":\"\",\"icon_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549612334385,\"url\":\"#\"}}]}]}]}]}', '2019-02-22 05:28:13', '348');
/**ABDB**/CREATE TABLE `#__sppagebuilder_languages` (
  `id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `description` mediumtext NOT NULL,
  `lang_tag` varchar(255) NOT NULL DEFAULT '',
  `lang_key` varchar(100) DEFAULT NULL,
  `version` mediumtext NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/**ABDB**/CREATE TABLE `#__sppagebuilder_integrations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `description` mediumtext NOT NULL,
  `component` varchar(255) NOT NULL,
  `plugin` mediumtext NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__sppagebuilder_integrations`  VALUES 
('1', 'Joomla Article', 'Plugin to add SP Page Builder support in Joomla article.', 'com_content', '{\"name\":\"sppagebuilder\",\"group\":\"content\"}', '1'),
('2', 'K2', 'Plugin to add SP Page Builder support in K2 item.', 'com_k2', '{\"name\":\"sppagebuilder\",\"group\":\"k2\"}', '2');
/**ABDB**/CREATE TABLE `#__sppagebuilder_addons` (
  `id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `code` mediumtext NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__sppagebuilder_addons`  VALUES 
('20', 'Follow Us', '{\"id\":1556102562303,\"name\":\"icons_group\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"size\":{\"md\":\"12\"},\"margin\":{\"md\":\"15\",\"xs\":\"3\"},\"item_display\":\"inline-block\",\"icon_alignment\":\"sppb-text-left\",\"sp_icons_group_item\":[{\"title\":\"\",\"icon_name\":\"fa-facebook\",\"icon_link\":\"#\",\"link_open_new_window\":0,\"width\":{\"md\":\"\"},\"height\":{\"md\":\"\"},\"border_style\":\"\",\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"show_label\":0,\"label_position\":\"top\",\"label_size\":{\"md\":16},\"label_lineheight\":\"\",\"label_letterspace\":\"0px\",\"label_margin\":\"\",\"use_hover\":0,\"icon_class\":\"\"},{\"title\":\"\",\"icon_name\":\"fa-twitter\",\"icon_link\":\"#\",\"link_open_new_window\":0,\"width\":{\"md\":\"\"},\"height\":{\"md\":\"\"},\"border_style\":\"\",\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"show_label\":0,\"label_position\":\"top\",\"label_size\":{\"md\":16},\"label_lineheight\":\"\",\"label_letterspace\":\"0px\",\"label_margin\":\"\",\"use_hover\":0,\"icon_class\":\"\"},{\"title\":\"\",\"icon_name\":\"fa-instagram\",\"icon_link\":\"#\",\"link_open_new_window\":0,\"width\":{\"md\":\"\"},\"height\":{\"md\":\"\"},\"border_style\":\"\",\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"show_label\":0,\"label_position\":\"top\",\"label_size\":{\"md\":16},\"label_lineheight\":\"\",\"label_letterspace\":\"0px\",\"label_margin\":\"\",\"use_hover\":0,\"icon_class\":\"\"}],\"class\":\"yoga-social-link\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"-90px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"-60px 0px 0px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1556102562303,\"title_margin\":{\"md\":\"0px 15px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title\":\"Follow Me —\",\"global_text_color\":\"rgba(64, 71, 82, 0.5)\",\"title_position\":\"left\",\"heading_selector\":\"h5\",\"title_fontsize\":{\"md\":\"14\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":{\"md\":\"24\",\"sm\":\"\",\"xs\":\"\"},\"title_font_style\":{\"weight\":500}}}', '2019-04-29 11:11:04', '348');
/**ABDB**/CREATE TABLE `#__sppagebuilder` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `text` mediumtext NOT NULL,
  `extension` varchar(255) NOT NULL DEFAULT 'com_sppagebuilder',
  `extension_view` varchar(255) NOT NULL DEFAULT 'page',
  `view_id` bigint(20) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `published` tinyint(3) NOT NULL DEFAULT '1',
  `catid` int(10) NOT NULL DEFAULT '0',
  `access` int(10) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `created_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` bigint(20) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` bigint(20) NOT NULL DEFAULT '0',
  `checked_out` int(10) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `attribs` varchar(5120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '[]',
  `og_title` varchar(255) NOT NULL,
  `og_image` varchar(255) NOT NULL,
  `og_description` varchar(255) NOT NULL,
  `language` char(7) NOT NULL,
  `hits` bigint(20) NOT NULL DEFAULT '0',
  `css` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=92 DEFAULT CHARSET=utf8;
/**ABDB**/INSERT INTO `#__sppagebuilder`  VALUES 
('5', '94', 'HOME - Classic', '[{\"id\":1549438682218,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":1,\"no_gutter\":0,\"padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"video\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":0,\"video_loop\":1,\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549438682218},\"layout\":\"12\",\"columns\":[{\"id\":1549438682268,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1577434763461,\"name\":\"js_slideshow\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"content_container_option\":\"bootstrap\",\"content_container_width\":{\"md\":\"100\",\"sm\":75,\"xs\":75},\"content_vertical_alignment\":1,\"slideshow_items\":[{\"slider_img\":\"images/stock-photo/blur-click-company-1109543.jpg\",\"content_alignment\":\"right\",\"slideshow_inner_items\":[{\"title_content_title\":\"Info Kemasukan\",\"content_type\":\"title_content\",\"title_heading_selector\":\"h2\",\"content_color\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"top\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":100,\"animation_timing_function\":\"ease\",\"content_tabs\":\"content_type\",\"content_border\":\"   \",\"content_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},{\"content_text\":\"UMP offers a wide range of practical-based tertiary education <span data-scayt_word=\\\"programmes\\\" data-scaytid=\\\"1\\\">programmes</span> in engineering and technology. Its application-oriented curriculum integrates theory and practice in the concept of a teaching factory, emphasizing experiential and action learning, task oriented and problem solving.\",\"content_type\":\"text_content\",\"content_color\":\"\",\"content_fontsize\":{\"md\":20,\"sm\":16,\"xs\":14},\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"top\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":100,\"animation_timing_function\":\"ease\",\"content_tabs\":\"content_type\",\"content_border\":\"   \",\"content_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_padding\":{\"md\":\"0px 0px 40px 0px\",\"sm\":\"   \",\"xs\":\"   \"}},{\"btn_content\":\"Start Your Journey\",\"content_type\":\"btn_content\",\"content_color\":\"#fff\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"top\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":100,\"animation_timing_function\":\"ease\",\"content_tabs\":\"content_type\",\"button_icon_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_border\":\"   \",\"content_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_padding\":{\"md\":\"10px 30px 10px 30px\",\"sm\":\"   \",\"xs\":\"   \"},\"button_background_options\":\"color_bg\",\"content_fontsize\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_color\":\"#15a195\",\"content_border_radius\":\"30\",\"title\":\"Register Now!\",\"button_url\":\"http://admission.ump.edu.my/\"}],\"enable_youtube_vimeo\":0,\"video_volume_btn\":0,\"image_in_column\":1,\"icon_display_block\":0,\"slider_bg_options\":\"bg_image\",\"slider_overlay_options\":\"color_overlay\",\"image_column_reverse\":0,\"image_column_width\":{\"md\":\"2\",\"xs\":\"1\"},\"image_content_alignment\":\"right\",\"slider_bg_gradient_overlay\":{\"color2\":\"\",\"color\":\"\",\"pos2\":\"100\",\"pos\":\"80\",\"deg\":\"360\"}}],\"slider_settings\":\"slider_global\",\"height\":\"custom\",\"custom_height\":{\"md\":\"600\",\"sm\":600,\"xs\":350},\"slider_animation\":\"slide\",\"slide_vertically\":0,\"three_d_rotate\":15,\"autoplay\":0,\"pause_on_hover\":0,\"interval\":5,\"speed\":800,\"timer\":0,\"timer_bg_color\":\"\",\"timer_color\":\"\",\"timer_width\":{\"md\":\"\"},\"timer_top_gap\":{\"md\":\"\"},\"timer_left_gap\":{\"md\":\"\"},\"slide_counter\":0,\"slide_counter_fontsize\":{\"md\":22},\"slide_counter_padding\":\"0px 0px 0px 0px\",\"slide_counter_gap_bottom\":{\"md\":\"20\"},\"slide_counter_gap_left\":{\"md\":\"20\"},\"class\":\"\",\"controllers\":\"dot\",\"dot_controllers\":0,\"dot_controllers_style\":\"line\",\"line_indecator\":1,\"dot_controllers_position\":\"vertical_right\",\"dot_controllers_bottom_gap\":{\"md\":\"50\"},\"dot_controllers_left_gap\":{\"md\":\"50\"},\"dot_controllers_right_gap\":{\"md\":\"50\"},\"dot_controller_style_option\":\"dot_active\",\"dot_ctlr_height\":\"2\",\"dot_ctlr_width\":\"100\",\"dot_ctlr_bg\":\"\",\"dot_ctlr_border_width\":\"\",\"dot_ctlr_border_color\":\"\",\"dot_ctlr_border_radius\":\"\",\"dot_ctlr_margin\":\"   \",\"dot_ctlr_center_bg\":\"rgba(255, 255, 255, 0.6)\",\"dot_ctlr_hover_height\":\"2\",\"dot_ctlr_hover_width\":\"100\",\"dot_ctlr_hover_border_color\":\"\",\"text_thumb_cont_style\":\"thumb_number\",\"arrow_controllers\":0,\"arrow_on_hover\":0,\"arrow_controllers_style\":\"spread\",\"arrow_controllers_content\":\"icon_only\",\"arrow_controllers_position\":\"bottom_center\",\"arrow_controllers_bottom_gap\":{\"md\":\"50\"},\"arrow_controllers_left_gap\":{\"md\":\"50\"},\"arrow_controllers_right_gap\":{\"md\":\"50\"},\"arrow_spread_controllers_left_gap\":{\"md\":\"50\"},\"arrow_spread_controllers_right_gap\":{\"md\":\"50\"},\"arrow_style\":\"arrow_normal\",\"arrow_ctlr_width\":{\"md\":\"\"},\"arrow_ctlr_height\":{\"md\":\"\"},\"arrow_ctlr_color\":\"\",\"arrow_ctlr_font_size\":{\"md\":\"\"},\"arrow_ctlr_background\":\"\",\"arrow_ctlr_border_width\":\"\",\"arrow_ctlr_border_color\":\"\",\"arrow_ctlr_border_radius\":\"50\",\"arrow_ctlr_hover_background\":\"\",\"arrow_ctlr_hover_color\":\"\",\"arrow_ctlr_hover_border_color\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":\"0\",\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#ffffff\",\"inset\":false},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"instFormId\":1569854362142,\"global_width\":{\"md\":\"-60\",\"sm\":\"\",\"xs\":\"\"},\"language\":\"en-GB\"}},{\"id\":1569854362142,\"name\":\"js_slideshow\",\"visibility\":true,\"settings\":{\"admin_label\":\"Bahasa Melayu\",\"content_container_option\":\"bootstrap\",\"content_container_width\":{\"md\":\"100\",\"sm\":75,\"xs\":75},\"content_vertical_alignment\":1,\"slideshow_items\":[{\"slider_img\":\"images/stock-photo/blur-click-company-1109543.jpg\",\"content_alignment\":\"right\",\"slideshow_inner_items\":[{\"title_content_title\":\"Info Kemasukan\",\"content_type\":\"title_content\",\"title_heading_selector\":\"h2\",\"content_color\":\"\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"top\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":100,\"animation_timing_function\":\"ease\",\"content_tabs\":\"content_type\",\"content_border\":\"   \",\"content_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},{\"content_text\":\"<br />UMP menawarkan program pengajian berteraskan Teknologi &amp; Kejuruteraan. Penganjuran program-program Pendidikan Teknikal dan Latihan Vokasional (TVET) bagi melahirkan graduan berilmiah dan berkemahiran di Malaysia.\",\"content_type\":\"text_content\",\"content_color\":\"\",\"content_fontsize\":{\"md\":20,\"sm\":16,\"xs\":14},\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"top\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":100,\"animation_timing_function\":\"ease\",\"content_tabs\":\"content_type\",\"content_border\":\"   \",\"content_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_padding\":{\"md\":\"0px 0px 40px 0px\",\"sm\":\"   \",\"xs\":\"   \"}},{\"btn_content\":\"Start Your Journey\",\"content_type\":\"btn_content\",\"content_color\":\"#fff\",\"content_animation_type\":\"slide\",\"animation_slide_direction\":\"top\",\"animation_duration\":800,\"animation_delay\":1000,\"animation_slide_from\":100,\"animation_timing_function\":\"ease\",\"content_tabs\":\"content_type\",\"button_icon_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_border\":\"   \",\"content_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"content_padding\":{\"md\":\"10px 30px 10px 30px\",\"sm\":\"   \",\"xs\":\"   \"},\"button_background_options\":\"color_bg\",\"content_fontsize\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"button_background_color\":\"#15a195\",\"content_border_radius\":\"30\",\"title\":\"Daftar sekarang!\",\"button_url\":\"http://admission.ump.edu.my/\"}],\"enable_youtube_vimeo\":0,\"video_volume_btn\":0,\"image_in_column\":1,\"icon_display_block\":0,\"slider_bg_options\":\"bg_image\",\"slider_overlay_options\":\"color_overlay\",\"image_column_reverse\":0,\"image_column_width\":{\"md\":\"2\",\"xs\":\"1\"},\"image_content_alignment\":\"right\",\"slider_bg_gradient_overlay\":{\"color2\":\"\",\"color\":\"\",\"pos2\":\"100\",\"pos\":\"80\",\"deg\":\"360\"}}],\"slider_settings\":\"slider_global\",\"height\":\"custom\",\"custom_height\":{\"md\":\"600\",\"sm\":600,\"xs\":350},\"slider_animation\":\"slide\",\"slide_vertically\":0,\"three_d_rotate\":15,\"autoplay\":0,\"pause_on_hover\":0,\"interval\":5,\"speed\":800,\"timer\":0,\"timer_bg_color\":\"\",\"timer_color\":\"\",\"timer_width\":{\"md\":\"\"},\"timer_top_gap\":{\"md\":\"\"},\"timer_left_gap\":{\"md\":\"\"},\"slide_counter\":0,\"slide_counter_fontsize\":{\"md\":22},\"slide_counter_padding\":\"0px 0px 0px 0px\",\"slide_counter_gap_bottom\":{\"md\":\"20\"},\"slide_counter_gap_left\":{\"md\":\"20\"},\"class\":\"\",\"controllers\":\"dot\",\"dot_controllers\":0,\"dot_controllers_style\":\"line\",\"line_indecator\":1,\"dot_controllers_position\":\"vertical_right\",\"dot_controllers_bottom_gap\":{\"md\":\"50\"},\"dot_controllers_left_gap\":{\"md\":\"50\"},\"dot_controllers_right_gap\":{\"md\":\"50\"},\"dot_controller_style_option\":\"dot_active\",\"dot_ctlr_height\":\"2\",\"dot_ctlr_width\":\"100\",\"dot_ctlr_bg\":\"\",\"dot_ctlr_border_width\":\"\",\"dot_ctlr_border_color\":\"\",\"dot_ctlr_border_radius\":\"\",\"dot_ctlr_margin\":\"   \",\"dot_ctlr_center_bg\":\"rgba(255, 255, 255, 0.6)\",\"dot_ctlr_hover_height\":\"2\",\"dot_ctlr_hover_width\":\"100\",\"dot_ctlr_hover_border_color\":\"\",\"text_thumb_cont_style\":\"thumb_number\",\"arrow_controllers\":0,\"arrow_on_hover\":0,\"arrow_controllers_style\":\"spread\",\"arrow_controllers_content\":\"icon_only\",\"arrow_controllers_position\":\"bottom_center\",\"arrow_controllers_bottom_gap\":{\"md\":\"50\"},\"arrow_controllers_left_gap\":{\"md\":\"50\"},\"arrow_controllers_right_gap\":{\"md\":\"50\"},\"arrow_spread_controllers_left_gap\":{\"md\":\"50\"},\"arrow_spread_controllers_right_gap\":{\"md\":\"50\"},\"arrow_style\":\"arrow_normal\",\"arrow_ctlr_width\":{\"md\":\"\"},\"arrow_ctlr_height\":{\"md\":\"\"},\"arrow_ctlr_color\":\"\",\"arrow_ctlr_font_size\":{\"md\":\"\"},\"arrow_ctlr_background\":\"\",\"arrow_ctlr_border_width\":\"\",\"arrow_ctlr_border_color\":\"\",\"arrow_ctlr_border_radius\":\"50\",\"arrow_ctlr_hover_background\":\"\",\"arrow_ctlr_hover_color\":\"\",\"arrow_ctlr_hover_border_color\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":{\"ho\":\"0\",\"vo\":0,\"blur\":0,\"spread\":0,\"color\":\"#ffffff\",\"inset\":false},\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"instFormId\":1569854362142,\"global_width\":{\"md\":\"-60\",\"sm\":\"\",\"xs\":\"\"},\"language\":\"ms-MY\"}}]}]},{\"id\":1577114323588,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"50px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"20px 0px 10px 0px\"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1577114323588,\"background_color\":\"\"},\"layout\":\"3,3,3,3\",\"columns\":[{\"id\":1577114323609,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1577114323612,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Undergraduate<br>Studies\",\"heading_selector\":\"h3\",\"title_position\":\"after\",\"title_fontsize\":{\"md\":\"18\",\"xs\":\"22\"},\"title_lineheight\":{\"md\":\"\",\"xs\":\"32\"},\"title_letterspace\":\"0\",\"title_text_color\":\"#cb9c00\",\"title_url\":\"\",\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"feature_image_width\":{\"md\":50},\"icon_name\":\"fa-id-badge\",\"icon_size\":{\"md\":\"55\",\"xs\":\"40\"},\"icon_color\":\"#CB9C00\",\"icon_boxshadow\":\"0 0 0 0 #ffffff\",\"text\":\"We have more than 139 programmes to choose that suits your needs from Diploma &amp; Degree\",\"text_fontsize\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"14\"},\"text_fontweight\":\"400\",\"text_lineheight\":{\"md\":\"24\",\"sm\":\"\",\"xs\":\"24\"},\"alignment\":\"sppb-text-center\",\"addon_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_use_overlay\":0,\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0 0 75px 0\",\"sm\":\"0 0 60px 0\",\"xs\":\"0 0 30px 0\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1577114323612,\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_font_style\":{\"weight\":600},\"title_font_family\":\"\",\"text_font_family\":\"\",\"title_margin_bottom\":{\"md\":\"13\",\"sm\":\"\",\"xs\":\"\"},\"title_margin_top\":{\"md\":\"20\",\"sm\":\"\",\"xs\":\"\"},\"icon_hover_color\":\"#debf59\",\"title_hover_color\":\"#debf59\"}}]},{\"id\":1577114323611,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1541590311028,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1577114323614,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Postgraduate<br>Studies\",\"heading_selector\":\"h3\",\"title_position\":\"after\",\"title_fontsize\":{\"md\":\"18\",\"xs\":\"22\"},\"title_lineheight\":{\"md\":\"\",\"xs\":\"32\"},\"title_letterspace\":\"0\",\"title_text_color\":\"#4d8b40\",\"title_url\":\"\",\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"feature_image_width\":{\"md\":50},\"icon_name\":\"fa-graduation-cap\",\"icon_size\":{\"md\":\"55\",\"xs\":\"40\"},\"icon_color\":\"#4d8b40\",\"icon_boxshadow\":\"0 0 0 0 #ffffff\",\"text\":\"<p>Students from all disciplines are encouraged to apply to our Postgraduate programmes.</p>\",\"text_fontsize\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"14\"},\"text_fontweight\":\"400\",\"text_lineheight\":{\"md\":\"24\",\"sm\":\"\",\"xs\":\"24\"},\"alignment\":\"sppb-text-center\",\"addon_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_use_overlay\":0,\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0 0 75px 0\",\"sm\":\"0 0 60px 0\",\"xs\":\"0 0 30px 0\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1577114323614,\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_font_style\":{\"weight\":600},\"title_font_family\":\"\",\"text_font_family\":\"\",\"title_margin_bottom\":{\"md\":\"13\",\"sm\":\"\",\"xs\":\"\"},\"title_margin_top\":{\"md\":\"20\",\"sm\":\"\",\"xs\":\"\"},\"icon_hover_color\":\"#6eb55f\",\"addon_hover_color\":\"\",\"title_hover_color\":\"#6eb55f\"}}]},{\"id\":1577114323613,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1541590311029,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1577114323616,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"International<br>Students\",\"heading_selector\":\"h3\",\"title_position\":\"after\",\"title_fontsize\":{\"md\":\"18\",\"xs\":\"22\"},\"title_lineheight\":{\"md\":\"\",\"xs\":\"32\"},\"title_letterspace\":\"0\",\"title_text_color\":\"#1680bb\",\"title_url\":\"\",\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"feature_image_width\":{\"md\":50},\"icon_name\":\"fa-globe\",\"icon_size\":{\"md\":\"55\",\"xs\":\"40\"},\"icon_color\":\"#1680bb\",\"icon_boxshadow\":\"0 0 0 0 #ffffff\",\"text\":\"<p>In the tumultuous business of cutting-in and attending to a whale, there is much running backwards.</p>\",\"text_fontsize\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"14\"},\"text_fontweight\":\"400\",\"text_lineheight\":{\"md\":\"24\",\"sm\":\"\",\"xs\":\"24\"},\"alignment\":\"sppb-text-center\",\"addon_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_use_overlay\":0,\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0 0 75px 0\",\"sm\":\"0 0 60px 0\",\"xs\":\"0 0 30px 0\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1577114323616,\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_font_style\":{\"weight\":600},\"title_font_family\":\"\",\"text_font_family\":\"\",\"title_margin_bottom\":{\"md\":\"13\",\"sm\":\"\",\"xs\":\"\"},\"title_margin_top\":{\"md\":\"20\",\"sm\":\"\",\"xs\":\"\"},\"icon_hover_color\":\"#67b5e0\",\"title_hover_color\":\"#67b5e0\"}}]},{\"id\":1577114323615,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1541590311030,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1577114323618,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Continues<br>Studies\",\"heading_selector\":\"h3\",\"title_position\":\"after\",\"title_fontsize\":{\"md\":\"18\",\"xs\":\"22\"},\"title_lineheight\":{\"md\":\"\",\"xs\":\"32\"},\"title_letterspace\":\"0\",\"title_text_color\":\"#5f3c87\",\"title_url\":\"\",\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"feature_image_width\":{\"md\":50},\"icon_name\":\"fa-arrow-circle-up\",\"icon_size\":{\"md\":\"55\",\"xs\":\"40\"},\"icon_color\":\"#5f3c87\",\"icon_boxshadow\":\"0 0 0 0 #ffffff\",\"text\":\"<p>Explore more about programme offered, VISA application and Student Registration.</p>\",\"text_fontsize\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"14\"},\"text_fontweight\":\"400\",\"text_lineheight\":{\"md\":\"24\",\"sm\":\"\",\"xs\":\"24\"},\"alignment\":\"sppb-text-center\",\"addon_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_use_overlay\":0,\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0 0 75px 0\",\"sm\":\"0 0 60px 0\",\"xs\":\"0 0 30px 0\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1577114323618,\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_font_style\":{\"weight\":600},\"title_font_family\":\"\",\"text_font_family\":\"\",\"title_margin_bottom\":{\"md\":\"13\",\"sm\":\"\",\"xs\":\"\"},\"title_margin_top\":{\"md\":\"20\",\"sm\":\"\",\"xs\":\"\"},\"icon_hover_color\":\"#8b72a7\",\"title_hover_color\":\"#8b72a7\"}}]}]},{\"id\":1576292133379,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":1,\"padding\":{\"md\":\"121px 0px 100px 0px\",\"sm\":\"   \",\"xs\":\"30px 0px 40px 0px\"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"\",\"color2\":\"\",\"deg\":\"0\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":0,\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"50% 50%\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1570500475152,\"color\":\"\",\"overlay\":\"\",\"section_height_option\":\"\",\"section_height\":{\"md\":\"609\",\"sm\":\"\",\"xs\":\"\"},\"background_color\":\"#ececec\"},\"layout\":\"7,5\",\"columns\":[{\"id\":1576292133425,\"class_name\":\"col-md-7\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1576292133426,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Welcome to \",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"-1px\",\"title_text_transform\":\"none\",\"title_margin\":{\"md\":\"0px 0px 3px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1547462260281,\"title_font_style\":{\"weight\":400}}},{\"id\":1576292133427,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"<p class=\\\"opacity6\\\">Engineering Technology specializes in smart learning education. With more than 30 years of experience teaching engineering as a main programme, ET has gained a reputation for providing high-quality education in a friendly and supportive environment at an affordable price <strong><a title=\\\"read more\\\" href=\\\"../index.php/about/background\\\">read more..</a></strong></p>\",\"alignment\":\"\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":1,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"instFormId\":1570500475094,\"global_width\":{\"md\":\"94\",\"sm\":\"\",\"xs\":\"\"}}},{\"id\":1576292133428,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Engineering Technology\",\"heading_selector\":\"h3\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":{\"md\":\"30\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"-1px\",\"title_text_transform\":\"none\",\"title_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"link-color\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1547462259646,\"title_font_style\":{\"weight\":700,\"uppercase\":true}}},{\"id\":1576292133429,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1547462259758},\"layout\":\"5,7\",\"visibility\":true,\"columns\":[{\"id\":1576292133430,\"class_name\":\"col-md-5\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1576292133431,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"10.30 AM - 07:30 PM\",\"heading_selector\":\"h4\",\"title_position\":\"left\",\"title_fontsize\":{\"md\":\"14\"},\"title_lineheight\":{\"md\":\"20\"},\"title_letterspace\":\"0\",\"title_text_color\":\"\",\"title_url\":\"\",\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"feature_image_width\":{\"md\":\"\"},\"icon_name\":\"fa-hourglass-3\",\"icon_size\":{\"md\":\"20\"},\"icon_color\":\"\",\"icon_boxshadow\":\"0 0 0 0 #ffffff\",\"text\":\"Monday - Friday\",\"text_fontsize\":\"\",\"text_fontweight\":\"\",\"text_lineheight\":\"\",\"alignment\":\"sppb-text-left\",\"addon_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"class\":\"light-feature-text-color\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"   \",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1547465081859,\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"icon_border_width\":{\"md\":\"0\",\"sm\":\"\",\"xs\":\"\"},\"feature_image_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_margin_top\":{\"md\":\"-4\",\"sm\":\"\",\"xs\":\"\"},\"title_font_style\":{\"weight\":600,\"uppercase\":true},\"title_margin_bottom\":{\"md\":\"1\",\"sm\":\"\",\"xs\":\"\"}}}]},{\"id\":1576292133432,\"class_name\":\"col-md-7\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1547462259604},\"addons\":[{\"id\":1576292133433,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Building A3, UMP Gambang Campus\",\"heading_selector\":\"h4\",\"title_position\":\"left\",\"title_fontsize\":{\"md\":\"14\"},\"title_lineheight\":{\"md\":\"20\"},\"title_letterspace\":\"0\",\"title_text_color\":\"\",\"title_url\":\"\",\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"feature_image_width\":{\"md\":\"\"},\"icon_name\":\"fa-map-signs\",\"icon_size\":{\"md\":\"20\"},\"icon_color\":\"\",\"icon_boxshadow\":\"0 0 0 0 #ffffff\",\"text\":\"Office Address\",\"text_fontsize\":\"\",\"text_fontweight\":\"\",\"text_lineheight\":\"\",\"alignment\":\"sppb-text-left\",\"addon_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"class\":\"light-feature-text-color\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1547465081678,\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"icon_border_width\":{\"md\":\"0\",\"sm\":\"\",\"xs\":\"\"},\"feature_image_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_margin_top\":{\"md\":\"-4\",\"sm\":\"\",\"xs\":\"\"},\"title_font_style\":{\"weight\":600,\"uppercase\":true},\"title_margin_bottom\":{\"md\":\"1\",\"sm\":\"\",\"xs\":\"\"}}}]}]}]},{\"id\":1576292133435,\"class_name\":\"col-md-5\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1576292133436,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":1,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"10px 10px 10px 10px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1547462259758},\"layout\":\"7,12\",\"visibility\":true,\"columns\":[{\"id\":1576292133437,\"class_name\":\"col-md-7\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1576292133438,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":\"images/staff-photo/400px-c-33.jpg\",\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-left\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 10px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1576292133438}}]},{\"id\":1576292133439,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1576292133440,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Dean\'s Welcome Speech Notes\",\"heading_selector\":\"h3\",\"title_fontsize\":{\"md\":\"21\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"<p>Justo eget magna fermentum iaculis eu non diam phasellus. Nibh sit amet commodo nulla facilisi nullam. Maecenas accumsan lacus vel facilisis volutpat est velit   <strong><strong><a href=\\\"../index.php/about/welcome-speech\\\">read more..</a></strong><em><br /></em></strong></p>\",\"alignment\":\"\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"global_custom_position\":0,\"global_seclect_position\":\"relative\",\"global_addon_position_left\":{\"unit\":\"px\"},\"global_addon_position_top\":{\"unit\":\"px\"},\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"while_scroll_view\":[{\"enable_while_scroll_view\":0,\"on_scroll_actions\":[{\"id\":\"b3fdc1c1e6bfde5942ea\",\"index\":0,\"keyframe\":0,\"name\":\"move\",\"property\":{\"x\":\"0\",\"y\":\"-100\",\"z\":\"0\"},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"},{\"id\":\"936e0225e6dc8edfba7d\",\"index\":1,\"keyframe\":100,\"name\":\"move\",\"property\":{\"x\":0,\"y\":0,\"z\":0},\"range\":{\"max\":500,\"min\":-500,\"stop\":1},\"single\":true,\"title\":\"Move\"}],\"transition_origin_x\":\"center\",\"transition_origin_y\":\"center\",\"enable_tablet\":0,\"enable_mobile\":0}],\"mouse_movement\":[{\"enable_tilt_effect\":0,\"mouse_tilt_direction\":\"direct\",\"mouse_tilt_speed\":\"1\",\"mouse_tilt_max\":\"15\",\"enable_tablet\":0,\"enable_mobile\":0}],\"instFormId\":1576292133440,\"title_font_style\":{\"weight\":700}}}]}]}]}]},{\"id\":1567149790127,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"subtitle_fontsize\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":1,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"152px 0px 152px 0px\",\"sm\":\"100px  100px \",\"xs\":\"50px  50px \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_image\":\"images/2019/08/28/bg-main-2.jpg\",\"background_parallax\":0,\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"50% 50%\",\"background_video\":0,\"external_background_video\":\"0\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"overlay\":\"rgba(0, 0, 0, 0.2)\",\"instFormId\":1567149790127,\"background_type\":\"image\",\"overlay_type\":\"overlay_color\"},\"layout\":\"12\",\"columns\":[{\"id\":1567149787523,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1567149787524,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Become our student!\",\"heading_selector\":\"div\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":{\"md\":\"42\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_letterspace\":\"0\",\"title_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0,\"global_text_color\":\"#03c7b6\",\"instFormId\":1567149787524,\"title_font_style\":{\"weight\":700}}},{\"id\":1567149787525,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Call Us Now: +609-549 2000\",\"heading_selector\":\"h2\",\"use_link\":1,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":{\"md\":\"36\",\"sm\":\"\",\"xs\":\"30\"},\"title_lineheight\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_letterspace\":\"0\",\"title_margin\":{\"md\":\"20px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0,\"global_text_color\":\"#ffffff\",\"title_font_style\":{\"weight\":500},\"instFormId\":1567149787525,\"title_font_family\":\"Poppins\"}}]}]},{\"id\":1549525331516,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"50px 0px 100px 0px\",\"sm\":\"   \",\"xs\":\"20px 0px 40px 0px\"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549525331516},\"layout\":\"6,6\",\"columns\":[{\"id\":1549525331514,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549525331514,\"padding\":{\"md\":\"0px 40px 0px 0px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1549525331525,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"The Benefits as a UMP\'s Student\",\"heading_selector\":\"h3\",\"title_fontsize\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"“The purpose of yoga is to build strength, awareness and harmony in both the mind and body,” explains Natalie Nevins, DO, a board-certified osteopathic family physician and certified Kundalini Yoga instructor in Hollywood, California.\",\"alignment\":\"\",\"text_fontsize\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"14\"},\"text_lineheight\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"title-color blockquote-contant\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549525331525,\"title_margin_bottom\":{\"md\":\"20\",\"sm\":\"\",\"xs\":\"10\"},\"title_font_style\":{\"weight\":500}}},{\"id\":1549962226092,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"According to American Osteopathic Medicine Maintaining a regular yoga practice can provide physical and mental health benefits such as :\",\"heading_selector\":\"h5\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":{\"md\":\"29\",\"sm\":\"\",\"xs\":\"\"},\"title_letterspace\":\"0\",\"title_text_transform\":\"none\",\"title_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\" text-color-gray\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549962226092,\"title_font_family\":\"IBM Plex Sans\"}}]},{\"id\":1549525331515,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1549529105356,\"name\":\"tab\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"style\":\"tabs\",\"sp_tab_item\":[{\"title\":\"Physical benefits\",\"icon\":\"\",\"content\":[{\"id\":1549529026741,\"name\":\"text_block\",\"settings\":{\"text\":\"“The relaxation techniques incorporated in yoga can lessen chronic pain, such as lower back pain, arthritis, headaches and carpal tunnel syndrome,” explains Dr. Nevins. <br /><br />Other physical benefits of yoga include:<br />\\n<ul>\\n<li>increased flexibility</li>\\n<li>increased muscle strength and tone</li>\\n<li>improved respiration, energy and vitality</li>\\n<li>maintaining a balanced metabolism</li>\\n</ul>\",\"dropcap\":0,\"text_fontsize\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"14\"},\"text_lineheight\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"}}}]},{\"title\":\"Mental benefits\",\"icon\":\"\",\"content\":[{\"id\":1549529740322,\"name\":\"text_block\",\"settings\":{\"text\":\"“The relaxation techniques incorporated in yoga can lessen chronic pain, such as lower back pain, arthritis, headaches and carpal tunnel syndrome,” explains Dr. Nevins. <br /><br />Other physical benefits of yoga include:<br />\\n<ul>\\n<li>increased flexibility</li>\\n<li>increased muscle strength and tone</li>\\n<li>improved respiration, energy and vitality</li>\\n<li>maintaining a balanced metabolism</li>\\n</ul>\",\"dropcap\":0,\"text_fontsize\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"14\"},\"text_lineheight\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"}}}]}],\"nav_gutter\":{\"md\":15},\"nav_style\":\"normal\",\"nav_width\":{\"md\":30,\"sm\":30,\"xs\":30},\"nav_color\":\"#fff\",\"nav_bg_color\":\"#000\",\"nav_fontsize\":{\"md\":16},\"nav_lineheight\":{\"md\":\"\"},\"nav_border\":\"1px 1px 1px 1px\",\"nav_border_color\":\"#e5e5e5\",\"nav_border_radius\":\"\",\"nav_margin\":\"0px 0px 5px 0px\",\"nav_padding\":\"10px 10px 10px 10px\",\"nav_text_align\":\"left\",\"hover_tab_bg\":\"\",\"hover_tab_color\":\"\",\"hover_tab_border_width\":\"\",\"hover_tab_border_color\":\"\",\"active_tab_bg\":\"#e5e5e5\",\"active_tab_color\":\"#333333\",\"active_tab_border_width\":\"\",\"active_tab_border_color\":\"\",\"nav_icon_postion\":\"left\",\"icon_fontsize\":{\"md\":16},\"icon_margin\":\"\",\"content_color\":\"#000\",\"content_backround\":\"#e5e5e5\",\"content_fontsize\":{\"md\":\"\"},\"content_lineheight\":{\"md\":\"\"},\"content_border\":1,\"content_border_radius\":\"\",\"content_border_color\":\"#e5e5e5\",\"show_boxshadow\":1,\"shadow_color\":\"#000\",\"shadow_horizontal\":\"\",\"shadow_vertical\":\"\",\"shadow_blur\":\"\",\"shadow_spread\":\"\",\"content_margin\":\"\",\"content_padding\":\"10px 10px 10px 10px\",\"class\":\"about-tab\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549529105356}}]}]},{\"id\":1576292133400,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":1,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"120px 0px 100px 0px\",\"sm\":\"   \",\"xs\":\"30px 0px 40px 0px\"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"image\",\"background_gradient\":{\"color\":\"\",\"color2\":\"\",\"deg\":\"0\",\"type\":\"linear\"},\"background_image\":\"images/stock-photo/student-bookpen.jpg\",\"background_parallax\":1,\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"50% 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1576292133400,\"color\":\"#ffffff\",\"overlay\":\"rgba(0, 0, 0, 0.46)\",\"section_height_option\":\"\",\"section_height\":{\"md\":\"609\",\"sm\":\"\",\"xs\":\"\"},\"background_color\":\"\"},\"layout\":\"6,6\",\"columns\":[{\"id\":1576292133442,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1576292133443,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Facts and Figures\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_text_transform\":\"none\",\"title_margin\":{\"md\":\"0px 0px 15px 0px\",\"sm\":\"   \",\"xs\":\"0px 0px 10px 0px\"},\"title_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1548414371744,\"title_font_style\":{\"uppercase\":false,\"weight\":600}}},{\"id\":1576292133444,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":{\"md\":\"18\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_letterspace\":\"0\",\"text\":\"<p><span style=\\\"font-size: 12pt;\\\">The program concentrates on teaching and building basic English skills in order to gain confidence at work.</span></p>\",\"alignment\":\"\",\"text_fontsize\":{\"md\":\"14\",\"sm\":\"\",\"xs\":\"13\"},\"text_lineheight\":{\"md\":\"26\",\"sm\":\"\",\"xs\":\"22\"},\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId{\\n\\topacity: .7;\\n}\",\"use_global_width\":1,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"instFormId\":1570464765394,\"global_width\":{\"md\":\"88\",\"sm\":\"\",\"xs\":\"100\"}}},{\"id\":1576292133445,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1570464765395},\"layout\":\"4,4,4\",\"visibility\":true,\"columns\":[{\"id\":1576292133446,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-4\",\"xs_col\":\"col-xs-4\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1548222196767,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1576292133447,\"name\":\"animated_number\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"number\":\"459\",\"number_before_after_text\":\"\",\"number_before_after_text_position\":\"left\",\"duration\":\"1000\",\"font_size\":{\"md\":\"40\",\"xs\":\"30\"},\"line_height\":{\"md\":36},\"counter_title\":\"STUDENTS\",\"title_font_size\":{\"md\":\"14\"},\"title_line_height\":{\"md\":36},\"title_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"alignment\":\"sppb-text-left\",\"class\":\"left-border\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1570464765397,\"number_font_wight\":\"800\",\"title_color\":\"\"}}]},{\"id\":1576292133448,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-4\",\"xs_col\":\"col-xs-4\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1548222196844,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1576292133449,\"name\":\"animated_number\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"number\":\"129\",\"number_before_after_text\":\"\",\"number_before_after_text_position\":\"left\",\"duration\":\"1000\",\"font_size\":{\"md\":\"40\",\"xs\":\"30\"},\"line_height\":{\"md\":36},\"counter_title\":\"ACADEMICIANS\",\"title_font_size\":{\"md\":\"14\"},\"title_line_height\":{\"md\":36},\"title_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"alignment\":\"sppb-text-left\",\"class\":\"left-border\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1570464765399,\"number_font_wight\":\"800\",\"title_color\":\"\"}}]},{\"id\":1576292133450,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-4\",\"xs_col\":\"col-xs-4\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1548222196845,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1576292133451,\"name\":\"animated_number\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"number\":\"16\",\"number_before_after_text\":\"\",\"number_before_after_text_position\":\"left\",\"duration\":\"1000\",\"font_size\":{\"md\":\"40\",\"xs\":\"30\"},\"line_height\":{\"md\":36},\"counter_title\":\"COURSE\",\"title_font_size\":{\"md\":\"14\"},\"title_line_height\":{\"md\":36},\"title_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"alignment\":\"sppb-text-left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1570464765401,\"number_font_wight\":\"800\",\"title_color\":\"\"}}]}]}]},{\"id\":1576292133452,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1576292133453,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Why Choose Us\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_text_transform\":\"none\",\"title_margin\":{\"md\":\"0px 0px 15px 0px\",\"sm\":\"   \",\"xs\":\"0px 0px 10px 0px\"},\"title_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1547626611708,\"title_font_style\":{\"uppercase\":false,\"weight\":600}}},{\"id\":1576292133454,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"<span style=\\\"font-size: 12pt;\\\">Whether you\'re looking for a rich cultural experience or superior language education, you\'ll find both in the exciting environment of LS.</span>\",\"alignment\":\"\",\"text_fontsize\":{\"md\":\"14\",\"sm\":\"\",\"xs\":\"13\"},\"text_lineheight\":{\"md\":\"26\",\"sm\":\"\",\"xs\":\"22\"},\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId{\\n\\topacity: .7;\\n}\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1570464765404}},{\"id\":1576292133455,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"A Wealth of Experience, a Reputation for Excellence\",\"heading_selector\":\"h3\",\"title_position\":\"left\",\"title_fontsize\":{\"md\":16,\"xs\":\"14\"},\"title_lineheight\":{\"md\":22},\"title_letterspace\":\"0\",\"title_text_color\":\"\",\"title_url\":\"\",\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"feature_image_width\":{\"md\":50},\"icon_name\":\"fa-check\",\"icon_size\":{\"md\":\"18\"},\"icon_color\":\"#C0C0C0\",\"icon_boxshadow\":\"0 0 0 0 #ffffff\",\"text\":\"\",\"text_fontsize\":\"\",\"text_fontweight\":\"\",\"text_lineheight\":\"\",\"alignment\":\"sppb-text-left\",\"addon_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1548239284355,\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_font_style\":{\"weight\":400}}},{\"id\":1576292133456,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":\"1px 0px 1px 0px\",\"margin\":\"0px 0px 0px 0px\",\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":\"\",\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":\"\",\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1548239284238},\"layout\":\"6,6\",\"visibility\":true,\"columns\":[{\"id\":1576292133457,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1576292133458,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Affordable Cost\",\"heading_selector\":\"h3\",\"title_position\":\"left\",\"title_fontsize\":{\"md\":16,\"xs\":\"14\"},\"title_lineheight\":{\"md\":22},\"title_letterspace\":\"0\",\"title_text_color\":\"\",\"title_url\":\"\",\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"feature_image_width\":{\"md\":50},\"icon_name\":\"fa-check\",\"icon_size\":{\"md\":\"18\"},\"icon_color\":\"#C0C0C0\",\"icon_boxshadow\":\"0 0 0 0 #ffffff\",\"text\":\"\",\"text_fontsize\":\"\",\"text_fontweight\":\"\",\"text_lineheight\":\"\",\"alignment\":\"sppb-text-left\",\"addon_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1548239284312,\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_font_style\":{\"weight\":400}}},{\"id\":1576292133459,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Convenient Schedules\",\"heading_selector\":\"h3\",\"title_position\":\"left\",\"title_fontsize\":{\"md\":16,\"xs\":\"14\"},\"title_lineheight\":{\"md\":22},\"title_letterspace\":\"0\",\"title_text_color\":\"\",\"title_url\":\"\",\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"feature_image_width\":{\"md\":50},\"icon_name\":\"fa-check\",\"icon_size\":{\"md\":\"18\"},\"icon_color\":\"#C0C0C0\",\"icon_boxshadow\":\"0 0 0 0 #ffffff\",\"text\":\"\",\"text_fontsize\":\"\",\"text_fontweight\":\"\",\"text_lineheight\":\"\",\"alignment\":\"sppb-text-left\",\"addon_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1548239284384,\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_font_style\":{\"weight\":400}}}]},{\"id\":1576292133460,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1576292133461,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Locations Throughout\",\"heading_selector\":\"h3\",\"title_position\":\"left\",\"title_fontsize\":{\"md\":16,\"xs\":\"14\"},\"title_lineheight\":{\"md\":22},\"title_letterspace\":\"0\",\"title_text_color\":\"\",\"title_url\":\"\",\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"feature_image_width\":{\"md\":50},\"icon_name\":\"fa-check\",\"icon_size\":{\"md\":\"18\"},\"icon_color\":\"#C0C0C0\",\"icon_boxshadow\":\"0 0 0 0 #ffffff\",\"text\":\"\",\"text_fontsize\":\"\",\"text_fontweight\":\"\",\"text_lineheight\":\"\",\"alignment\":\"sppb-text-left\",\"addon_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1548239284352,\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_font_style\":{\"weight\":400}}},{\"id\":1576292133462,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Quality Control\",\"heading_selector\":\"h3\",\"title_position\":\"left\",\"title_fontsize\":{\"md\":16,\"xs\":\"14\"},\"title_lineheight\":{\"md\":22},\"title_letterspace\":\"0\",\"title_text_color\":\"\",\"title_url\":\"\",\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"feature_image_width\":{\"md\":50},\"icon_name\":\"fa-check\",\"icon_size\":{\"md\":\"18\"},\"icon_color\":\"#C0C0C0\",\"icon_boxshadow\":\"0 0 0 0 #ffffff\",\"text\":\"\",\"text_fontsize\":\"\",\"text_fontweight\":\"\",\"text_lineheight\":\"\",\"alignment\":\"sppb-text-left\",\"addon_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1548239284389,\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_font_style\":{\"weight\":400}}}]}]}]}]},{\"id\":1549612334359,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"110px 0px 110px 0px\",\"sm\":\"   \",\"xs\":\"60px 0px 60px 0px\"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"image\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"images/stock-photo/ump-konvo-stock-photo.png\",\"background_parallax\":0,\"background_repeat\":\"no-repeat\",\"background_size\":\"contain\",\"background_attachment\":\"fixed\",\"background_position\":\"50% 100%\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549612334359},\"layout\":\"12\",\"columns\":[{\"id\":1549612334358,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1549612334385,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"105px 0px 105px 0px\",\"sm\":\"60px 60px 60px 60px\",\"xs\":\"30px 30px 30px 30px\"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549612334385,\"class\":\"link-color-light-bg\"},\"layout\":\"8,4\",\"visibility\":true,\"columns\":[{\"id\":1549612334386,\"class_name\":\"col-md-8\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549612334386,\"padding\":{\"md\":\"0px 0px 0px 95px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1549604284943,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"— Universiti Malaysia Pahang Recruitment Video\",\"heading_selector\":\"h5\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"Discover UMP\",\"alignment\":\"sppb-text-center\",\"text_fontsize\":{\"md\":\"56\",\"sm\":\"\",\"xs\":\"45\"},\"text_lineheight\":{\"md\":\"66\",\"sm\":\"\",\"xs\":\"55\"},\"text_fontweight\":\"600\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549604284943,\"title_font_style\":{\"weight\":\"\",\"uppercase\":false},\"title_margin_bottom\":{\"md\":\"15\",\"sm\":\"\",\"xs\":\"10\"},\"global_text_color\":\"#ffffff\",\"text_font_family\":\"Poppins\"}}]},{\"id\":1549612334389,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1567495335270,\"name\":\"icon\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"name\":\"fa-caret-square-o-right\",\"link\":\"\",\"size\":{\"md\":\"93\"},\"width\":{\"md\":96},\"height\":{\"md\":96},\"use_hover\":0,\"hover_effect\":\"zoom-in\",\"alignment\":\"sppb-text-left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1567495335270,\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"color\":\"#ffffff\"}}]}]}]}]}]', 'com_sppagebuilder', 'page', '0', '0', '-2', '0', '1', '-2', '2019-02-05 09:44:02', '803', '2019-12-30 18:46:30', '803', '0', '0000-00-00 00:00:00', '[]', '', '', '', '*', '2070', '');
/**ABDB**/INSERT INTO `#__sppagebuilder`  VALUES 
('6', '95', 'About', '[{\"id\":1549622645758,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"340px 0px 25px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"image\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"images/2019/02/18/header-about.png\",\"background_parallax\":0,\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"inherit\",\"background_position\":\"50% 100%\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549622645758,\"background_color\":\"#ffffff\"},\"layout\":\"8,4,4,8\",\"columns\":[{\"id\":1549622645757,\"class_name\":\"col-md-8\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1556626341642,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Meet <br>Helena Lee\",\"heading_selector\":\"h2\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_text_transform\":\"none\",\"title_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"link-color\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 10px 0px\",\"sm\":\"0px 0px 10px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1556626341642}},{\"id\":1549622789941,\"name\":\"button\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"text\":\"Say Ommm\",\"alignment\":\"sppb-text-left\",\"letterspace\":\"0\",\"type\":\"link\",\"appearance\":\"\",\"fontsize\":{\"md\":16},\"button_status\":\"normal\",\"background_color\":\"#03E16D\",\"background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"color\":\"#FFFFFF\",\"background_color_hover\":\"#00E66E\",\"background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"color_hover\":\"#FFFFFF\",\"link_button_status\":\"normal\",\"link_button_color\":\"\",\"link_button_border_width\":\"\",\"link_border_color\":\"\",\"link_button_padding_bottom\":\"\",\"link_button_hover_color\":\"\",\"link_button_border_hover_color\":\"\",\"button_padding\":\"\",\"icon_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 265px 0px\",\"sm\":\"0px 0px 200px 0px\",\"xs\":\"0px 0px 100px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549622789941,\"url\":\"#\",\"font_style\":{\"weight\":400}}}]},{\"id\":1549622645759,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549622645759,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"class\":\"inner-div\"},\"addons\":[{\"id\":1556620025509,\"name\":\"icons_group\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"size\":{\"md\":\"12\"},\"margin\":{\"md\":\"3\",\"xs\":\"3\"},\"item_display\":\"inline-block\",\"icon_alignment\":\"sppb-text-left\",\"sp_icons_group_item\":[{\"title\":\"\",\"icon_name\":\"fa-facebook\",\"icon_link\":\"#\",\"link_open_new_window\":0,\"width\":{\"md\":\"\"},\"height\":{\"md\":\"\"},\"border_style\":\"\",\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"show_label\":0,\"label_position\":\"top\",\"label_size\":{\"md\":16},\"label_lineheight\":\"\",\"label_letterspace\":\"0px\",\"label_margin\":\"\",\"use_hover\":0,\"icon_class\":\"\"},{\"title\":\"\",\"icon_name\":\"fa-twitter\",\"icon_link\":\"#\",\"link_open_new_window\":0,\"width\":{\"md\":\"\"},\"height\":{\"md\":\"\"},\"border_style\":\"\",\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"show_label\":0,\"label_position\":\"top\",\"label_size\":{\"md\":16},\"label_lineheight\":\"\",\"label_letterspace\":\"0px\",\"label_margin\":\"\",\"use_hover\":0,\"icon_class\":\"\"},{\"title\":\"\",\"icon_name\":\"fa-instagram\",\"icon_link\":\"#\",\"link_open_new_window\":0,\"width\":{\"md\":\"\"},\"height\":{\"md\":\"\"},\"border_style\":\"\",\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"show_label\":0,\"label_position\":\"top\",\"label_size\":{\"md\":16},\"label_lineheight\":\"\",\"label_letterspace\":\"0px\",\"label_margin\":\"\",\"use_hover\":0,\"icon_class\":\"\"}],\"class\":\"yoga-social-link social-profile social-profile-right rotate-90\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"-60px 0px 0px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\".social-profile-right.rotate-90{\\n\\ttop: inherit;\\n  bottom: 120px;\\n  transform: rotateZ(90deg) translate(0, 0);\\n}\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1556620025509,\"title_margin\":{\"md\":\"0px 15px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title\":\"Follow Me —\",\"global_text_color\":\"rgba(64, 71, 82, 0.5)\",\"title_position\":\"left\",\"heading_selector\":\"h5\",\"title_fontsize\":{\"md\":\"14\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":{\"md\":\"24\",\"sm\":\"\",\"xs\":\"\"},\"title_font_style\":{\"weight\":500}}}]},{\"id\":1549622645760,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549622645760,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1549961995654,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"— Where else you may have seen Helena\",\"heading_selector\":\"h5\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":{\"md\":\"44\",\"sm\":\"\",\"xs\":\"32\"},\"title_letterspace\":\"0\",\"title_text_transform\":\"none\",\"title_margin\":{\"md\":\"0px 0px 0px -3px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\" text-color-gray letter-spacing5\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549961995654,\"title_font_family\":\"IBM Plex Sans\"}}]},{\"id\":1556619887386,\"class_name\":\"col-md-8\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1549625397201,\"name\":\"clients\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"count\":\"sppb-col-sm-2\",\"alignment\":\"sppb-text-center\",\"class\":\"\",\"sp_clients_item\":[{\"title\":\"Client 1\",\"image\":\"images/2019/02/20/client1.png\",\"url\":\"#\"},{\"title\":\"Client 2\",\"image\":\"images/2019/02/20/client2.png\",\"url\":\"#\"},{\"title\":\"Client 3\",\"image\":\"images/2019/02/20/client3.png\",\"url\":\"#\"},{\"title\":\"Client 4\",\"image\":\"images/2019/02/20/client4.png\",\"url\":\"#\"},{\"title\":\"Client 5\",\"image\":\"images/2019/02/20/client5.png\",\"url\":\"#\"},{\"title\":\"Client 6\",\"image\":\"images/2019/02/20/client6.png\",\"url\":\"#\"}],\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549625397201}}]}]},{\"id\":1549622645947,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"190px 0px 50px 0px\",\"sm\":\"   \",\"xs\":\"40px 0px 20px 0px\"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549622645947},\"layout\":\"12,6,6\",\"columns\":[{\"id\":1549622645945,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549622645946},\"addons\":[{\"id\":1549629849122,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"— Inspirational Massage <br> from Helena\",\"heading_selector\":\"h3\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_text_transform\":\"none\",\"title_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"title-color\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 25px 0px\",\"sm\":\"0px 0px 45px 0px\",\"xs\":\"0px 0px 30px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549629849122}}]},{\"id\":1549622645946,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549622645946,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1549622646081,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"Mama, teacher, author, speaker, and Presidential Diamond leader with doTERRA, Helena has taught yoga since 1999. Her first book, The Heart of Yoga, has been ranked number one in design on Amazon, and has now been translated into six languages. Helena\'s second book, Hatha Yoga Pradipika, now being incorporated into teaching curricula worldwide for all ages. <br /><br />Her Yoga Practice Program is beloved for adding analog creativity to online coursework, and her third book, Better Apart, is poised to bring elegance and integrity to the process of separation and divorce. Elena has contributed to Yoga Journal, Yoga International, Huffington Post, MindBodyGreen, Well and Good NYC, Positively Positive, and more.\",\"alignment\":\"\",\"text_fontsize\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"14\"},\"text_lineheight\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"title-color\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549622646081}}]},{\"id\":1549622646161,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549622646161,\"padding\":{\"md\":\"0px 95px 0px 95px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1549628824143,\"name\":\"audio\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"5-Minute Breathing Meditation\",\"heading_selector\":\"h6\",\"title_fontsize\":\"\",\"title_lineheight\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"title_letterspace\":\"0\",\"mp3_link\":\"https://prodengcom.s3.amazonaws.com/students/audio/focus/classmp3/level1/Focus_GLB_1_MP3_001.mp3\",\"ogg_link\":\"https://prodengcom.s3.amazonaws.com/students/audio/focus/classmp3/level1/Focus_GLB_1_MP3_001.mp3\",\"autoplay\":\"\",\"repeat\":\"\",\"class\":\" text-color-gray\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId .sppb-addon-title {\\n  letter-spacing: 0.3px;\\n}\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549628824143,\"title_font_style\":{\"weight\":400},\"title_margin_bottom\":{\"md\":\"15\",\"sm\":\"\",\"xs\":\"\"}}},{\"id\":1549627585663,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"A basic meditation that focuses on following the breath to cultivate mindful awareness, by Helena <br /><br />Listen to the Full Audio Courses on Sounds True, and practice with Helena on :\",\"alignment\":\"\",\"text_fontsize\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"14\"},\"text_lineheight\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"title-color\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549627585663}},{\"id\":1549629054630,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_position\":\"left\",\"title_fontsize\":{\"md\":16},\"title_lineheight\":{\"md\":22},\"title_letterspace\":\"0\",\"title_text_color\":\"#4A4A4A\",\"title_url\":\"#\",\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"feature_image_width\":{\"md\":50},\"icon_name\":\"fa-forumbee\",\"icon_size\":{\"md\":\"16\"},\"icon_color\":\"\",\"icon_boxshadow\":\"0 0 0 0 #ffffff\",\"text\":\"<a href=\\\"#\\\">spotify.com/album/Helena</a>\",\"text_fontsize\":{\"md\":\"14\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"text_lineheight\":{\"md\":\"22\",\"sm\":\"\",\"xs\":\"\"},\"alignment\":\"sppb-text-left\",\"addon_hover_boxshadow\":\"0 0 0 0 #ffffff\",\"class\":\"profile-link\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549629054630,\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}}}]}]},{\"id\":1549865885954,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"50px 0px 50px 0px\",\"sm\":\"   \",\"xs\":\"20px 0px 20px 0px\"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549865885954},\"layout\":\"12\",\"columns\":[{\"id\":1549865885953,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549865885965},\"addons\":[{\"id\":1549865885961,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":1,\"fullscreen\":0,\"no_gutter\":1,\"padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549865885961,\"class\":\"link-color-bg\"},\"layout\":\"8,4\",\"visibility\":true,\"columns\":[{\"id\":1549865885962,\"class_name\":\"col-md-8\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-8\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549865885962,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1549866126331,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":\"images/2019/02/11/about-img1.jpg\",\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549866126331}}]},{\"id\":1549865885965,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-4\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549865885965,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1549866095529,\"name\":\"animated_number\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"number\":\"300\",\"number_before_after_text\":\"+\",\"number_before_after_text_position\":\"right\",\"duration\":\"1000\",\"font_size\":{\"md\":\"56\",\"xs\":\"45\"},\"line_height\":{\"md\":\"66\",\"xs\":\"55\"},\"counter_title\":\"Article Published\",\"title_font_size\":{\"md\":18,\"xs\":\"16\"},\"title_line_height\":{\"md\":\"29\",\"xs\":\"26\"},\"title_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549866095529,\"number_font_wight\":\"500\",\"number_font_family\":\"Abhaya Libre\",\"title_fontstyle\":{\"weight\":500},\"title_color\":\"#3d3d3d\",\"color\":\"#ffffff\"}},{\"id\":1549865886325,\"name\":\"animated_number\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"number\":\"800\",\"number_before_after_text\":\"+\",\"number_before_after_text_position\":\"right\",\"duration\":\"1000\",\"font_size\":{\"md\":\"56\",\"xs\":\"45\"},\"line_height\":{\"md\":\"66\",\"xs\":\"55\"},\"counter_title\":\"Students Tought\",\"title_font_size\":{\"md\":18,\"xs\":\"16\"},\"title_line_height\":{\"md\":\"29\",\"xs\":\"26\"},\"title_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549865886325,\"number_font_wight\":\"500\",\"number_font_family\":\"Abhaya Libre\",\"title_fontstyle\":{\"weight\":500},\"title_color\":\"#3d3d3d\",\"color\":\"#ffffff\"}},{\"id\":1549865886347,\"name\":\"animated_number\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"number\":\"137\",\"number_before_after_text\":\"\",\"number_before_after_text_position\":\"right\",\"duration\":\"1000\",\"font_size\":{\"md\":\"56\",\"xs\":\"45\"},\"line_height\":{\"md\":\"66\",\"xs\":\"55\"},\"counter_title\":\"Yoga Postures\",\"title_font_size\":{\"md\":18,\"xs\":\"16\"},\"title_line_height\":{\"md\":\"29\",\"xs\":\"26\"},\"title_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549865886347,\"number_font_wight\":\"500\",\"number_font_family\":\"Abhaya Libre\",\"title_fontstyle\":{\"weight\":500},\"title_color\":\"#3d3d3d\",\"color\":\"#ffffff\"}},{\"id\":1549865886338,\"name\":\"animated_number\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"number\":\"12\",\"number_before_after_text\":\"+\",\"number_before_after_text_position\":\"right\",\"duration\":\"1000\",\"font_size\":{\"md\":\"56\",\"xs\":\"45\"},\"line_height\":{\"md\":\"66\",\"xs\":\"55\"},\"counter_title\":\"Events Yearly\",\"title_font_size\":{\"md\":18,\"xs\":\"16\"},\"title_line_height\":{\"md\":\"29\",\"xs\":\"26\"},\"title_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"alignment\":\"sppb-text-center\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 10px 0px\",\"sm\":\"0px 0px 10px 0px\",\"xs\":\"0px 0px 20px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549865886338,\"number_font_wight\":\"500\",\"number_font_family\":\"Abhaya Libre\",\"title_fontstyle\":{\"weight\":500},\"title_color\":\"#3d3d3d\",\"color\":\"#ffffff\"}}]}]}]}]},{\"id\":1549865886503,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"39px 0px 50px 0px\",\"sm\":\"   \",\"xs\":\"20px 0px 20px 0px\"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549865886503},\"layout\":\"12,4,4,4\",\"columns\":[{\"id\":1549865886499,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549865885965},\"addons\":[{\"id\":1549867858921,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"— What Do You Want to Learn?\",\"heading_selector\":\"h3\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_text_transform\":\"none\",\"title_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"title-color\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 45px 0px\",\"sm\":\"0px 0px 45px 0px\",\"xs\":\"0px 0px 30px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549867858921}}]},{\"id\":1549865886500,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549865886500,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1550053254900,\"name\":\"image_layouts\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"image_preset_thumb\":\"stack\",\"image\":\"images/2019/02/11/yoga-book1.png\",\"image_alt_text\":\"\",\"image_strech\":0,\"image_order_option\":\"desktop\",\"open_in_lightbox\":0,\"image_overlay_color\":\"rgba(240, 18, 216, 0.5)\",\"lightbox_icon_bg\":\"\",\"click_url\":\"https://example.com\",\"url_in_new_window\":0,\"caption_options\":\"caption\",\"caption\":\"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.\",\"caption_postion\":\"caption-below\",\"caption_background\":\"\",\"caption_fontsize\":\"\",\"caption_lineheight\":\"\",\"caption_letterspace\":\"0px\",\"caption_padding\":\"\",\"content_order_option\":\"desktop\",\"content_text_align\":{\"md\":\"center\"},\"content_vertical_align\":\"top\",\"content_options\":\"button\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_background\":\"#fff\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0px\",\"title_margin\":{\"md\":\"0px 0px 10px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"text_content\":\"\",\"text_content_fontsize\":\"\",\"text_content_lineheight\":\"\",\"text_content_letterspace\":\"0px\",\"text_content_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_content_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_text\":\"Get This Book\",\"btn_letterspace\":\"\",\"btn_type\":\"link\",\"btn_appearance\":\"\",\"btn_fontsize\":{\"md\":16},\"button_status\":\"normal\",\"btn_background_color\":\"#98A7B5\",\"btn_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color\":\"#FFFFFF\",\"btn_background_color_hover\":\"#00E66E\",\"btn_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color_hover\":\"#FFFFFF\",\"button_margin\":{\"md\":\"45px 0px 0px -30px\",\"sm\":\"20px 0px 0px 0px\",\"xs\":\"10px 0px 0px 0px\"},\"button_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_size\":\"\",\"btn_shape\":\"square\",\"btn_icon_position\":\"left\",\"wrapper_background\":\"rgba(255, 255, 255, 0)\",\"wrapper_margin\":\"\",\"wrapper_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"wrapper_box_shadow\":\"0 0 0 0 #ffffff\",\"class\":\"circle-bg  circle-bg1\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"15px -20px 0px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1550053254900,\"wrapper_border\":\"   \",\"btn_url\":\"#\",\"btn_font_style\":{\"underline\":false},\"wrapper_color_type\":\"color\"}}]},{\"id\":1549865886501,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549865886501,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1550053254927,\"name\":\"image_layouts\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"image_preset_thumb\":\"stack\",\"image\":\"images/2019/02/11/yoga-book2.png\",\"image_alt_text\":\"\",\"image_strech\":0,\"image_order_option\":\"desktop\",\"open_in_lightbox\":0,\"image_overlay_color\":\"rgba(240, 18, 216, 0.5)\",\"lightbox_icon_bg\":\"\",\"click_url\":\"https://example.com\",\"url_in_new_window\":0,\"caption_options\":\"caption\",\"caption\":\"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.\",\"caption_postion\":\"caption-below\",\"caption_background\":\"\",\"caption_fontsize\":\"\",\"caption_lineheight\":\"\",\"caption_letterspace\":\"0px\",\"caption_padding\":\"\",\"content_order_option\":\"desktop\",\"content_text_align\":{\"md\":\"center\"},\"content_vertical_align\":\"top\",\"content_options\":\"button\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_background\":\"#fff\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0px\",\"title_margin\":{\"md\":\"0px 0px 10px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"text_content\":\"\",\"text_content_fontsize\":\"\",\"text_content_lineheight\":\"\",\"text_content_letterspace\":\"0px\",\"text_content_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_content_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_text\":\"Get This Book\",\"btn_letterspace\":\"\",\"btn_type\":\"link\",\"btn_appearance\":\"\",\"btn_fontsize\":{\"md\":16},\"button_status\":\"normal\",\"btn_background_color\":\"#98A7B5\",\"btn_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color\":\"#FFFFFF\",\"btn_background_color_hover\":\"#00E66E\",\"btn_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color_hover\":\"#FFFFFF\",\"button_margin\":{\"md\":\"45px 0px 0px -30px\",\"sm\":\"20px 0px 0px 0px\",\"xs\":\"10px 0px 0px 0px\"},\"button_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_size\":\"\",\"btn_shape\":\"square\",\"btn_icon_position\":\"left\",\"wrapper_background\":\"rgba(255, 255, 255, 0)\",\"wrapper_margin\":\"\",\"wrapper_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"wrapper_box_shadow\":\"0 0 0 0 #ffffff\",\"class\":\"circle-bg  circle-bg2\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"15px -50px 0px 30px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1550053254927,\"wrapper_border\":\"   \",\"btn_url\":\"#\",\"btn_font_style\":{\"underline\":false},\"wrapper_color_type\":\"color\"}}]},{\"id\":1549865886502,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549865886502,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1550052438475,\"name\":\"image_layouts\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"image_preset_thumb\":\"stack\",\"image\":\"images/2019/02/11/yoga-book3.png\",\"image_alt_text\":\"\",\"image_strech\":0,\"image_order_option\":\"desktop\",\"open_in_lightbox\":0,\"image_overlay_color\":\"rgba(240, 18, 216, 0.5)\",\"lightbox_icon_bg\":\"\",\"click_url\":\"https://example.com\",\"url_in_new_window\":0,\"caption_options\":\"caption\",\"caption\":\"Far far away, behind the word mountains, far from the countries Vokalia and Consonantia, there live the blind texts.\",\"caption_postion\":\"caption-below\",\"caption_background\":\"\",\"caption_fontsize\":\"\",\"caption_lineheight\":\"\",\"caption_letterspace\":\"0px\",\"caption_padding\":\"\",\"content_order_option\":\"desktop\",\"content_text_align\":{\"md\":\"center\"},\"content_vertical_align\":\"top\",\"content_options\":\"button\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_background\":\"#fff\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0px\",\"title_margin\":{\"md\":\"0px 0px 10px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"text_content\":\"\",\"text_content_fontsize\":\"\",\"text_content_lineheight\":\"\",\"text_content_letterspace\":\"0px\",\"text_content_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"text_content_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_text\":\"Get This Book\",\"btn_letterspace\":\"\",\"btn_type\":\"link\",\"btn_appearance\":\"\",\"btn_fontsize\":{\"md\":16},\"button_status\":\"normal\",\"btn_background_color\":\"#98A7B5\",\"btn_background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color\":\"#FFFFFF\",\"btn_background_color_hover\":\"#00E66E\",\"btn_background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"btn_color_hover\":\"#FFFFFF\",\"button_margin\":{\"md\":\"45px 0px 0px -30px\",\"sm\":\"20px 0px 0px 0px\",\"xs\":\"10px 0px 0px 0px\"},\"button_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"btn_size\":\"\",\"btn_shape\":\"square\",\"btn_icon_position\":\"left\",\"wrapper_background\":\"rgba(255, 255, 255, 0)\",\"wrapper_margin\":\"\",\"wrapper_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"wrapper_box_shadow\":\"0 0 0 0 #ffffff\",\"class\":\"circle-bg  circle-bg3\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"15px -70px 0px 50px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1550052438475,\"wrapper_border\":\"   \",\"btn_url\":\"#\",\"btn_font_style\":{\"underline\":false},\"wrapper_color_type\":\"color\"}}]}]},{\"id\":1549870330708,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"50px 0px 50px 0px\",\"sm\":\"   \",\"xs\":\"20px 0px 20px 0px\"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549865886503},\"layout\":\"5,7\",\"columns\":[{\"id\":1549870330709,\"class_name\":\"col-md-5\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-5\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549870330709,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1549870543217,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":\"images/2019/02/11/about-img2.jpg\",\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549870543217}}]},{\"id\":1549870330711,\"class_name\":\"col-md-7\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":1,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-7\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549870330711,\"padding\":{\"md\":\"0px 0px 0px 30px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1549870330710,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"— Dynamic Yoga  <span class=\\\"tm-symbol\\\">TM</span>\",\"heading_selector\":\"h3\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_text_transform\":\"none\",\"title_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"title-color\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 10px 0px\",\"sm\":\"0px 0px 10px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549870330710}},{\"id\":1549870633638,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"A Special Method Of Yoga Developed By Helena\",\"heading_selector\":\"h5\",\"title_fontsize\":\"\",\"title_lineheight\":{\"md\":\"29\",\"sm\":\"\",\"xs\":\"\"},\"title_letterspace\":\"0\",\"text\":\"The Dynamic Yoga Training Method is a complete yoga training methodology, integrating body, mind and spirit. Based directly on the intelligent nature of the body, its unique simplicity and power recalibrate body and mind through repetetive systematic movements based on traditional yoga postures. These movements have been chosen for their ability to integrate all the muscles of the body. Their use as a preparation for deep stillness transforms body and mind towards harmony with spirit, by allowing the intelligence of mind to be guided by the intelligence of the body into the intelligence of consciousness. <br /><br />Dynamic Yoga is taught in yoga classes, yoga workshops, yoga immersions, yoga retreats and yoga teacher trainings throughout the world. The complete training methodology is available annually at her class.\",\"alignment\":\"\",\"text_fontsize\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"14\"},\"text_lineheight\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 12px 0px\",\"sm\":\"0px 0px 12px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549870633638,\"font_family\":\"IBM Plex Sans\",\"title_font_style\":{\"weight\":500},\"title_text_color\":\" #95a5a6\",\"title_margin_bottom\":{\"md\":\"18\",\"sm\":\"\",\"xs\":\"10\"}}},{\"id\":1549870330719,\"name\":\"button\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"text\":\"Join Now\",\"alignment\":\"sppb-text-left\",\"letterspace\":\"0\",\"type\":\"link\",\"appearance\":\"\",\"fontsize\":{\"md\":16},\"button_status\":\"normal\",\"background_color\":\"#03E16D\",\"background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"color\":\"#FFFFFF\",\"background_color_hover\":\"#00E66E\",\"background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"color_hover\":\"#FFFFFF\",\"link_button_status\":\"normal\",\"link_button_color\":\"\",\"link_button_border_width\":\"\",\"link_border_color\":\"\",\"link_button_padding_bottom\":\"\",\"link_button_hover_color\":\"\",\"link_button_border_hover_color\":\"\",\"button_padding\":\"\",\"icon_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549870330719,\"url\":\"#\"}}]}]},{\"id\":1549876862160,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"50px 0px 70px 0px\",\"sm\":\"   \",\"xs\":\"20px 0px 30px 0px\"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549876862160},\"layout\":\"4,4,4\",\"columns\":[{\"id\":1549876862157,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549876862157,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1549878266845,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"— Meet My Team\",\"heading_selector\":\"h3\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_text_transform\":\"none\",\"title_margin\":{\"md\":\"0px 0px 5px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"title-color\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"35px 0px 10px 0px\",\"sm\":\"0px 0px 10px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549878266845}},{\"id\":1549878266848,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Learn from the Best\",\"heading_selector\":\"h6\",\"title_fontsize\":\"\",\"title_lineheight\":{\"md\":\"22\",\"sm\":\"\",\"xs\":\"\"},\"title_letterspace\":\"0\",\"text\":\"As social beings, we derive wisdom and wellness from interaction. I have a network of global instructors coveted for their constant innovation and enduring expertise on a range of practices.\",\"alignment\":\"\",\"text_fontsize\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"14\"},\"text_lineheight\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"\",\"dropcap\":0,\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 65px 0px\",\"sm\":\"0px 0px 65px 0px\",\"xs\":\"0px 0px 30px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"#addonId .sppb-addon-title {\\nletter-spacing:.3px;\\n}\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549878266848,\"font_family\":\"IBM Plex Sans\",\"title_font_style\":{\"weight\":500},\"title_text_color\":\" #95a5a6\",\"title_margin_bottom\":{\"md\":\"15\",\"sm\":\"\",\"xs\":\"10\"}}},{\"id\":1549880497835,\"name\":\"person\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"image\":\"images/2019/02/11/team1.jpg\",\"image_border_radius\":0,\"person_style_preset\":\"\",\"content_overlay_type\":\"gradient\",\"content_overlay_color\":\"\",\"content_overlay_gradient\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"name_desig_bg\":\"#fff\",\"name_desig_padding\":\"15px 0px 15px 15px\",\"person_content_bg\":\"#fff\",\"person_content_padding\":\"15px 15px 15px 15px\",\"name\":\"Christopher Ryan\",\"name_fontsize\":{\"md\":\"18\",\"sm\":\"\",\"xs\":\"16\"},\"name_lineheight\":\"\",\"name_letterspace\":\"0px\",\"designation\":\"Hatha Yoga\",\"designation_fontsize\":{\"md\":\"16\",\"sm\":\"\",\"xs\":\"14\"},\"designation_lineheight\":\"\",\"designation_letterspace\":\"0px\",\"designation_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"email\":\"\",\"introtext\":\"\",\"introtext_color\":\"\",\"introtext_fontsize\":\"\",\"introtext_lineheight\":\"\",\"facebook\":\"http://www.facebook.com/joomshaper\",\"twitter\":\"\",\"google_plus\":\"\",\"social_icon_color\":\"\",\"social_icon_hover_color\":\"\",\"social_icon_fontsize\":\"\",\"social_icon_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"social_position\":\"after\",\"alignment\":\"sppb-text-left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549880497835,\"instagram\":\"#\",\"name_font_style\":{\"weight\":500},\"name_font_family\":\"IBM Plex Sans\",\"designation_font_family\":\"IBM Plex Sans\",\"designation_font_style\":{\"weight\":300},\"name_color\":\"#3d3d3d\"}}]},{\"id\":1549876862158,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549876862158,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1549878266995,\"name\":\"person\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"image\":\"images/2019/02/11/team2.jpg\",\"image_border_radius\":0,\"person_style_preset\":\"\",\"content_overlay_type\":\"gradient\",\"content_overlay_color\":\"\",\"content_overlay_gradient\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"name_desig_bg\":\"#fff\",\"name_desig_padding\":\"15px 0px 15px 15px\",\"person_content_bg\":\"#fff\",\"person_content_padding\":\"15px 15px 15px 15px\",\"name\":\"Christopher Stephens\",\"name_fontsize\":{\"md\":\"18\",\"sm\":\"\",\"xs\":\"16\"},\"name_lineheight\":\"\",\"name_letterspace\":\"0px\",\"designation\":\"Hatha Yoga\",\"designation_fontsize\":{\"md\":\"16\",\"sm\":\"\",\"xs\":\"14\"},\"designation_lineheight\":\"\",\"designation_letterspace\":\"0px\",\"designation_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"email\":\"\",\"introtext\":\"\",\"introtext_color\":\"\",\"introtext_fontsize\":\"\",\"introtext_lineheight\":\"\",\"facebook\":\"http://www.facebook.com/joomshaper\",\"twitter\":\"\",\"google_plus\":\"\",\"social_icon_color\":\"\",\"social_icon_hover_color\":\"\",\"social_icon_fontsize\":\"\",\"social_icon_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"social_position\":\"after\",\"alignment\":\"sppb-text-left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549878266995,\"instagram\":\"#\",\"name_font_style\":{\"weight\":500},\"name_font_family\":\"IBM Plex Sans\",\"designation_font_family\":\"IBM Plex Sans\",\"designation_font_style\":{\"weight\":300},\"name_color\":\"#3d3d3d\"}},{\"id\":1549880497838,\"name\":\"person\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"image\":\"images/2019/02/11/team4.jpg\",\"image_border_radius\":0,\"person_style_preset\":\"\",\"content_overlay_type\":\"gradient\",\"content_overlay_color\":\"\",\"content_overlay_gradient\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"name_desig_bg\":\"#fff\",\"name_desig_padding\":\"15px 0px 15px 15px\",\"person_content_bg\":\"#fff\",\"person_content_padding\":\"15px 15px 15px 15px\",\"name\":\"Cynthia Hernandez\",\"name_fontsize\":{\"md\":\"18\",\"sm\":\"\",\"xs\":\"16\"},\"name_lineheight\":\"\",\"name_letterspace\":\"0px\",\"designation\":\"Hatha Yoga\",\"designation_fontsize\":{\"md\":\"16\",\"sm\":\"\",\"xs\":\"14\"},\"designation_lineheight\":\"\",\"designation_letterspace\":\"0px\",\"designation_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"email\":\"\",\"introtext\":\"\",\"introtext_color\":\"\",\"introtext_fontsize\":\"\",\"introtext_lineheight\":\"\",\"facebook\":\"http://www.facebook.com/joomshaper\",\"twitter\":\"\",\"google_plus\":\"\",\"social_icon_color\":\"\",\"social_icon_hover_color\":\"\",\"social_icon_fontsize\":\"\",\"social_icon_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"social_position\":\"after\",\"alignment\":\"sppb-text-left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549880497838,\"instagram\":\"#\",\"name_font_style\":{\"weight\":500},\"name_font_family\":\"IBM Plex Sans\",\"designation_font_family\":\"IBM Plex Sans\",\"designation_font_style\":{\"weight\":300},\"name_color\":\"#3d3d3d\"}}]},{\"id\":1549876862159,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":1,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-6\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549876862159,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1549880497832,\"name\":\"person\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"image\":\"images/2019/02/11/team3.jpg\",\"image_border_radius\":0,\"person_style_preset\":\"\",\"content_overlay_type\":\"gradient\",\"content_overlay_color\":\"\",\"content_overlay_gradient\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"name_desig_bg\":\"#fff\",\"name_desig_padding\":\"15px 0px 15px 15px\",\"person_content_bg\":\"#fff\",\"person_content_padding\":\"15px 15px 15px 15px\",\"name\":\"Kimberly Gilbert\",\"name_fontsize\":{\"md\":\"18\",\"sm\":\"\",\"xs\":\"16\"},\"name_lineheight\":\"\",\"name_letterspace\":\"0px\",\"designation\":\"Hatha Yoga\",\"designation_fontsize\":{\"md\":\"16\",\"sm\":\"\",\"xs\":\"14\"},\"designation_lineheight\":\"\",\"designation_letterspace\":\"0px\",\"designation_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"email\":\"\",\"introtext\":\"\",\"introtext_color\":\"\",\"introtext_fontsize\":\"\",\"introtext_lineheight\":\"\",\"facebook\":\"http://www.facebook.com/joomshaper\",\"twitter\":\"\",\"google_plus\":\"\",\"social_icon_color\":\"\",\"social_icon_hover_color\":\"\",\"social_icon_fontsize\":\"\",\"social_icon_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"social_position\":\"after\",\"alignment\":\"sppb-text-left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549880497832,\"instagram\":\"#\",\"name_font_style\":{\"weight\":500},\"name_font_family\":\"IBM Plex Sans\",\"designation_font_family\":\"IBM Plex Sans\",\"designation_font_style\":{\"weight\":300},\"name_color\":\"#3d3d3d\"}}]}]},{\"id\":1549880498044,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":1,\"fullscreen\":1,\"no_gutter\":0,\"padding\":{\"md\":\"100px 25px 100px 25px\",\"sm\":\"   \",\"xs\":\"40px 15px 40px 15px\"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":\"0\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549880498044,\"background_color\":\"#ffffff\"},\"layout\":\"3,3,3,3\",\"columns\":[{\"id\":1549880498045,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-4\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549880498045,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1556628003956,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":\"images/2019/04/30/instagram1.jpg\",\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":1,\"overlay_color\":\"rgba(0, 0, 0, 0.5)\",\"link\":\"\",\"class\":\"white-popup-icon\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1556628003956}},{\"id\":1556627773394,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":\"\",\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1556627773394}}]},{\"id\":1549880498048,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-4\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549880498048,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1549880498046,\"name\":\"heading\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"— Follow Her On Instagram <a href=\\\"#\\\"><i class=\\\"fa fa-instagram\\\"></i></a>\",\"heading_selector\":\"h3\",\"use_link\":0,\"title_link\":\"\",\"link_new_tab\":\"\",\"title_fontsize\":{\"md\":\"\",\"sm\":\"30\",\"xs\":\"20\"},\"title_lineheight\":{\"md\":\"\",\"sm\":\"36\",\"xs\":\"25\"},\"title_letterspace\":\"0\",\"title_text_transform\":\"none\",\"title_margin\":{\"md\":\"0px 0px 5px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_padding\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"title_icon_position\":\"before\",\"alignment\":\"sppb-text-left\",\"title_text_shadow\":\"\",\"class\":\"title-color instagram-title-only\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"160px 0px 5px 0px\",\"sm\":\"0px 0px 150px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\".sppb-addon-title{\\n\\tposition: relative; \\n  top: -100px;\\n}\",\"use_global_width\":0,\"hidden_md\":0,\"hidden_sm\":0,\"hidden_xs\":0,\"acl\":\"\",\"instFormId\":1549880498046,\"title_font_style\":{\"weight\":\"\"},\"global_width\":{\"md\":\"\",\"sm\":\"\",\"xs\":\"\"}}},{\"id\":1556628997196,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":\"images/2019/04/30/instagram2.jpg\",\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":1,\"overlay_color\":\"rgba(0, 0, 0, 0.5)\",\"link\":\"\",\"class\":\"white-popup-icon\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1556628997196}},{\"id\":1556628003959,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":\"images/2019/04/30/instagram3.jpg\",\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":1,\"overlay_color\":\"rgba(0, 0, 0, 0.5)\",\"link\":\"\",\"class\":\"white-popup-icon\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1556628003959}}]},{\"id\":1549880498050,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":1,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"col-sm-4\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":0,\"hidden_sm\":0,\"hidden_md\":0,\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549880498050,\"padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1556628003973,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":\"images/2019/04/30/instagram4.jpg\",\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":1,\"overlay_color\":\"rgba(0, 0, 0, 0.5)\",\"link\":\"\",\"class\":\"white-popup-icon\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1556628003973}},{\"id\":1556628003963,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":\"images/2019/04/30/instagram5.jpg\",\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":1,\"overlay_color\":\"rgba(0, 0, 0, 0.5)\",\"link\":\"\",\"class\":\"white-popup-icon\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1556628003963}},{\"id\":1556628003970,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":\"images/2019/04/30/instagram6.jpg\",\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":1,\"overlay_color\":\"rgba(0, 0, 0, 0.5)\",\"link\":\"\",\"class\":\"white-popup-icon\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1556628003970}}]},{\"id\":1556628003959,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"tablet_order\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1556628003953,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":\"images/2019/04/30/instagram7.jpg\",\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":1,\"overlay_color\":\"rgba(0, 0, 0, 0.5)\",\"link\":\"\",\"class\":\"white-popup-icon\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1556628003953}},{\"id\":1556628003976,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_padding\":\"\",\"title_position\":\"top\",\"image\":\"images/2019/04/30/instagram8.jpg\",\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-center\",\"open_lightbox\":1,\"overlay_color\":\"rgba(0, 0, 0, 0.5)\",\"link\":\"\",\"class\":\"white-popup-icon\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":\"\",\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1556628003976}}]}]},{\"id\":1549885338097,\"visibility\":true,\"collapse\":false,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"45px 0px 45px 0px\",\"sm\":\"   \",\"xs\":\"20px 0px 20px 0px\"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"image\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"images/2019/02/11/about-cta.png\",\"background_parallax\":0,\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"\",\"background_position\":\"50% 50%\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549885338097},\"layout\":\"12\",\"columns\":[{\"id\":1549885338153,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549885338153,\"padding\":{\"md\":\"0px 95px 0px 95px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1549885338154,\"type\":\"inner_row\",\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":1,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"145px 0px 130px 0px\",\"sm\":\"60px 60px 60px 60px\",\"xs\":\"30px 30px 30px 30px\"},\"margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"background_type\":\"color\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_parallax\":0,\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"external_background_video\":\"0\",\"video_loop\":1,\"overlay_type\":\"overlay_none\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"show_top_shape\":0,\"shape_name\":\"clouds-flat\",\"shape_color\":\"#e5e5e5\",\"shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"shape_height\":\"\",\"shape_flip\":false,\"shape_invert\":false,\"shape_to_front\":false,\"show_bottom_shape\":0,\"bottom_shape_name\":\"clouds-opacity\",\"bottom_shape_color\":\"#e5e5e5\",\"bottom_shape_width\":{\"md\":100,\"sm\":100,\"xs\":100},\"bottom_shape_height\":\"\",\"bottom_shape_flip\":false,\"bottom_shape_invert\":false,\"bottom_shape_to_front\":false,\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549885338154,\"class\":\"\",\"overlay\":\"rgba(236, 240, 241, 0.43)\",\"background_color\":\"rgba(236, 240, 241, 0.3)\"},\"layout\":\"7,5\",\"visibility\":true,\"columns\":[{\"id\":1549885338155,\"class_name\":\"col-md-7\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\",\"instFormId\":1549885338155,\"padding\":{\"md\":\"0px 0px 0px 95px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"}},\"addons\":[{\"id\":1549885338156,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"— DISCOVER THE DIFFERENCE\",\"heading_selector\":\"h5\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"Find your Inner Peace today!\",\"alignment\":\"\",\"text_fontsize\":{\"md\":\"56\",\"sm\":\"\",\"xs\":\"45\"},\"text_lineheight\":{\"md\":\"66\",\"sm\":\"\",\"xs\":\"55\"},\"text_fontweight\":\"500\",\"dropcap\":0,\"class\":\"link-color\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549885338156,\"title_font_style\":{\"weight\":\"\",\"uppercase\":true},\"title_margin_bottom\":{\"md\":\"15\",\"sm\":\"\",\"xs\":\"10\"},\"global_text_color\":\"#ffffff\",\"text_font_family\":\"Abhaya Libre\",\"title_text_color\":\" #3d3d3d\"}}]},{\"id\":1549885338157,\"class_name\":\"col-md-5\",\"visibility\":true,\"settings\":{\"background_type\":\"none\",\"background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"overlay_type\":\"overlay_color\",\"gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"pattern_overlay\":\"\",\"overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"items_align_center\":0,\"use_border\":0,\"border_width\":\"\",\"border_radius\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"mobile_order\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"addons\":[{\"id\":1549885338158,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"text\":\"2 Free Classes\",\"alignment\":\"sppb-text-center\",\"text_fontsize\":{\"md\":\"18\",\"sm\":\"\",\"xs\":\"14\"},\"text_lineheight\":{\"md\":\"29\",\"sm\":\"\",\"xs\":\"\"},\"text_fontweight\":\"500\",\"dropcap\":0,\"class\":\"white-light-color\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 20px 0px\",\"sm\":\"0px 0px 20px 0px\",\"xs\":\"0px 0px 10px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549885338158,\"global_text_color\":\" #3d3d3d\"}},{\"id\":1549885338159,\"name\":\"button\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"text\":\"Get Started\",\"alignment\":\"sppb-text-center\",\"letterspace\":\"0\",\"type\":\"default\",\"appearance\":\"outline\",\"fontsize\":{\"md\":16},\"button_status\":\"normal\",\"background_color\":\"#03E16D\",\"background_gradient\":{\"color\":\"#B4EC51\",\"color2\":\"#429321\",\"deg\":\"45\",\"type\":\"linear\"},\"color\":\"#FFFFFF\",\"background_color_hover\":\"#00E66E\",\"background_gradient_hover\":{\"color\":\"#429321\",\"color2\":\"#B4EC51\",\"deg\":\"45\",\"type\":\"linear\"},\"color_hover\":\"#FFFFFF\",\"link_button_status\":\"normal\",\"link_button_color\":\"\",\"link_button_border_width\":\"\",\"link_border_color\":\"\",\"link_button_padding_bottom\":\"\",\"link_button_hover_color\":\"\",\"link_button_border_hover_color\":\"\",\"button_padding\":\"\",\"icon_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"icon_position\":\"left\",\"class\":\"\",\"global_background_type\":\"none\",\"global_background_gradient\":{\"color\":\"#00c6fb\",\"color2\":\"#005bea\",\"deg\":\"45\",\"type\":\"linear\"},\"global_background_repeat\":\"no-repeat\",\"global_background_size\":\"cover\",\"global_background_attachment\":\"inherit\",\"global_background_position\":\"50% 50%\",\"global_use_overlay\":0,\"global_overlay_type\":\"overlay_none\",\"global_gradient_overlay\":{\"color\":\"rgba(127, 0, 255, 0.8)\",\"color2\":\"rgba(225, 0, 255, 0.7)\",\"deg\":\"45\",\"type\":\"linear\"},\"global_pattern_overlay\":\"\",\"global_overlay_pattern_color\":\"\",\"blend_mode\":\"normal\",\"global_user_border\":0,\"global_border_width\":\"\",\"global_border_radius\":0,\"global_margin\":{\"md\":\"0px 0px 0px 0px\",\"sm\":\"0px 0px 0px 0px\",\"xs\":\"0px 0px 0px 0px\"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_boxshadow\":\"0 0 0 0 #ffffff\",\"global_use_animation\":0,\"global_animationduration\":\"300\",\"global_animationdelay\":\"0\",\"global_custom_css\":\"\",\"use_global_width\":\"0\",\"hidden_md\":\"0\",\"hidden_sm\":\"0\",\"hidden_xs\":\"0\",\"acl\":\"\",\"instFormId\":1549604284938,\"url\":\"#\"}}]}]}]}]}]', 'com_sppagebuilder', 'page', '0', '0', '-2', '0', '1', '1', '2019-02-05 09:44:08', '348', '2020-01-01 18:03:44', '803', '0', '0000-00-00 00:00:00', '[]', '', '', '', '*', '222', '');
