<?php
/**
 * @package    FILEman
 * @copyright   Copyright (C) 2011 Timble CVBA (http://www.timble.net)
 * @license     GNU GPLv3 <http://www.gnu.org/licenses/gpl.html>
 * @link        http://www.joomlatools.com
 */

class ComFilemanTemplateHelperBehavior extends ComKoowaTemplateHelperBehavior
{
    public function image_editor($config = array())
    {
        $identifier = $this->getTemplate()->getIdentifier();

        $config = new KObjectConfigJson($config);
        $config->append([
            'debug'   => JFactory::getApplication()->getCfg('debug'),
            'type'    => $identifier->domain,
            'options' => [
                'site'              => (string) $this->getObject('request')->getSiteUrl(),
                'hasConnectSupport' => class_exists('PlgKoowaConnect') && PlgKoowaConnect::isSupported(),
            ],
        ])->append([
            'options' => [
                'connectToken' => $config->options->hasConnectSupport ? PlgKoowaConnect::generateToken() : false,
            ]
        ]);

        $html = $this->getTemplate()->helper('translator.script', [
            'strings' => [
                'Image editor is available with Joomlatools Connect'
            ]
        ]);

        $type = json_encode($config->type);

        $html .= $this->jquery($config);
        $html .= $this->tooltip($config);
        $html .= '<ktml:script src="media://com_fileman/js/image.editor.js" />';
        $html .= "<script>
            kQuery(function(){
                Fileman.ImageEditorFactory.getEditor({$type}, ".$config->options.");
            });
            </script>";

        return $html;
    }
}