/**ABDB**/CREATE TABLE `#__action_log_config` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `type_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `id_holder` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title_holder` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `text_prefix` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__action_log_config`  VALUES 
('1', 'article', 'com_content.article', 'id', 'title', '#__content', 'PLG_ACTIONLOG_JOOMLA'),
('2', 'article', 'com_content.form', 'id', 'title', '#__content', 'PLG_ACTIONLOG_JOOMLA'),
('3', 'banner', 'com_banners.banner', 'id', 'name', '#__banners', 'PLG_ACTIONLOG_JOOMLA'),
('4', 'user_note', 'com_users.note', 'id', 'subject', '#__user_notes', 'PLG_ACTIONLOG_JOOMLA'),
('5', 'media', 'com_media.file', '', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
('6', 'category', 'com_categories.category', 'id', 'title', '#__categories', 'PLG_ACTIONLOG_JOOMLA'),
('7', 'menu', 'com_menus.menu', 'id', 'title', '#__menu_types', 'PLG_ACTIONLOG_JOOMLA'),
('8', 'menu_item', 'com_menus.item', 'id', 'title', '#__menu', 'PLG_ACTIONLOG_JOOMLA'),
('9', 'newsfeed', 'com_newsfeeds.newsfeed', 'id', 'name', '#__newsfeeds', 'PLG_ACTIONLOG_JOOMLA'),
('10', 'link', 'com_redirect.link', 'id', 'old_url', '#__redirect_links', 'PLG_ACTIONLOG_JOOMLA'),
('11', 'tag', 'com_tags.tag', 'id', 'title', '#__tags', 'PLG_ACTIONLOG_JOOMLA'),
('12', 'style', 'com_templates.style', 'id', 'title', '#__template_styles', 'PLG_ACTIONLOG_JOOMLA'),
('13', 'plugin', 'com_plugins.plugin', 'extension_id', 'name', '#__extensions', 'PLG_ACTIONLOG_JOOMLA'),
('14', 'component_config', 'com_config.component', 'extension_id', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
('15', 'contact', 'com_contact.contact', 'id', 'name', '#__contact_details', 'PLG_ACTIONLOG_JOOMLA'),
('16', 'module', 'com_modules.module', 'id', 'title', '#__modules', 'PLG_ACTIONLOG_JOOMLA'),
('17', 'access_level', 'com_users.level', 'id', 'title', '#__viewlevels', 'PLG_ACTIONLOG_JOOMLA'),
('18', 'banner_client', 'com_banners.client', 'id', 'name', '#__banner_clients', 'PLG_ACTIONLOG_JOOMLA'),
('19', 'application_config', 'com_config.application', '', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
('20', 'task', 'com_scheduler.task', 'id', 'title', '#__scheduler_tasks', 'PLG_ACTIONLOG_JOOMLA'),
('21', 'field', 'com_fields.field', 'id', 'title', '#__fields', 'PLG_ACTIONLOG_JOOMLA'),
('22', 'guidedtour', 'com_guidedtours.state', 'id', 'title', '#__guidedtours', 'PLG_ACTIONLOG_JOOMLA'),
('23', 'contact', 'com_contact.form', 'id', 'name', '#__contact_details', 'PLG_ACTIONLOG_JOOMLA');
/**ABDB**/CREATE TABLE `#__action_logs` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `message_language_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `log_date` datetime NOT NULL,
  `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_id` int NOT NULL DEFAULT '0',
  `item_id` int NOT NULL DEFAULT '0',
  `ip_address` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0.0.0.0',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_user_id_logdate` (`user_id`,`log_date`),
  KEY `idx_user_id_extension` (`user_id`,`extension`),
  KEY `idx_extension_item_id` (`extension`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__action_logs_extensions` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `extension` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__action_logs_extensions`  VALUES 
('1', 'com_banners'),
('2', 'com_cache'),
('3', 'com_categories'),
('4', 'com_config'),
('5', 'com_contact'),
('6', 'com_content'),
('7', 'com_installer'),
('8', 'com_media'),
('9', 'com_menus'),
('10', 'com_messages'),
('11', 'com_modules'),
('12', 'com_newsfeeds'),
('13', 'com_plugins'),
('14', 'com_redirect'),
('15', 'com_tags'),
('16', 'com_templates'),
('17', 'com_users'),
('18', 'com_checkin'),
('19', 'com_scheduler'),
('20', 'com_fields'),
('21', 'com_guidedtours');
/**ABDB**/CREATE TABLE `#__action_logs_users` (
  `user_id` int unsigned NOT NULL,
  `notify` tinyint unsigned NOT NULL,
  `extensions` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`user_id`),
  KEY `idx_notify` (`notify`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__akeeba_common` (
  `key` varchar(190) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`key`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__akeeba_common`  VALUES 
('stats_lastrun', '1758154917'),
('stats_siteid', 'fc64c7a381a560067ba0949f5a315e08cfccceb5'),
('stats_siteurl', '6ae01795312380de2b826e37384a9dc2');
/**ABDB**/CREATE TABLE `#__akeebabackup_backups` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `backupstart` timestamp NULL DEFAULT NULL,
  `backupend` timestamp NULL DEFAULT NULL,
  `status` enum('run','fail','complete') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'run',
  `origin` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'backend',
  `type` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'full',
  `profile_id` bigint NOT NULL DEFAULT '1',
  `archivename` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `absolute_path` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `multipart` int NOT NULL DEFAULT '0',
  `tag` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `backupid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filesexist` tinyint NOT NULL DEFAULT '1',
  `remote_filename` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_size` bigint NOT NULL DEFAULT '0',
  `frozen` tinyint(1) NOT NULL DEFAULT '0',
  `instep` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_fullstatus` (`filesexist`,`status`),
  KEY `idx_stale` (`status`,`origin`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__akeebabackup_backups`  VALUES 
('1', 'Backup taken on Thursday, 18 September 2025 00:22 UTC', '', '2025-09-18 00:22:53', '2025-09-18 00:23:04', 'complete', 'backend', 'full', '1', 'site-localhost-20250918-002253utc-4LPD-S-UgaqBLFjH.zip', '/Applications/MAMP/htdocs/getbs1/administrator/components/com_akeebabackup/backup/site-localhost-20250918-002253utc-4LPD-S-UgaqBLFjH.zip', '0', 'backend', 'id-20250918-002253-338452', '1', NULL, '0', '0', '1');
/**ABDB**/CREATE TABLE `#__akeebabackup_profiles` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `configuration` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `filters` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `quickicon` tinyint NOT NULL DEFAULT '1',
  `access` int DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__akeebabackup_profiles`  VALUES 
('1', 'Default Backup Profile', '###AES128###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', '', '1', '1');
/**ABDB**/CREATE TABLE `#__akeebabackup_storage` (
  `tag` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `lastupdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`tag`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__assets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int NOT NULL DEFAULT '0' COMMENT 'Nested set parent.',
  `lft` int NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `level` int unsigned NOT NULL COMMENT 'The cached level in the nested tree.',
  `name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The unique name for the asset.\n',
  `title` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The descriptive title for the asset.',
  `rules` varchar(5120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_asset_name` (`name`),
  KEY `idx_lft_rgt` (`lft`,`rgt`),
  KEY `idx_parent_id` (`parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=225 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__assets`  VALUES 
('1', '0', '0', '393', '0', 'root.1', 'Root Asset', '{\"core.login.site\":{\"6\":1,\"2\":1},\"core.login.admin\":{\"6\":1},\"core.login.offline\":{\"6\":1},\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
('2', '1', '1', '2', '1', 'com_admin', 'com_admin', '{}'),
('3', '1', '3', '6', '1', 'com_banners', 'com_banners', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
('4', '1', '7', '8', '1', 'com_cache', 'com_cache', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
('5', '1', '9', '10', '1', 'com_checkin', 'com_checkin', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
('6', '1', '11', '12', '1', 'com_config', 'com_config', '{}'),
('7', '1', '13', '16', '1', 'com_contact', 'com_contact', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
('8', '1', '17', '94', '1', 'com_content', 'com_content', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1}}'),
('9', '1', '97', '96', '1', 'com_cpanel', 'com_cpanel', '{}'),
('10', '1', '99', '98', '1', 'com_installer', 'com_installer', '{\"core.manage\":{\"7\":0},\"core.delete\":{\"7\":0},\"core.edit.state\":{\"7\":0}}'),
('11', '1', '101', '100', '1', 'com_languages', 'com_languages', '{\"core.admin\":{\"7\":1}}'),
('12', '1', '103', '102', '1', 'com_login', 'com_login', '{}'),
('13', '1', '105', '104', '1', 'com_mailto', 'com_mailto', '{}'),
('14', '1', '107', '106', '1', 'com_massmail', 'com_massmail', '{}'),
('15', '1', '109', '108', '1', 'com_media', 'com_media', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":{\"5\":1}}'),
('16', '1', '111', '116', '1', 'com_menus', 'com_menus', '{\"core.admin\":{\"7\":1}}'),
('17', '1', '119', '118', '1', 'com_messages', 'com_messages', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
('18', '1', '121', '180', '1', 'com_modules', 'com_modules', '{\"core.admin\":{\"7\":1}}'),
('19', '1', '183', '184', '1', 'com_newsfeeds', 'com_newsfeeds', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
('20', '1', '187', '186', '1', 'com_plugins', 'com_plugins', '{\"core.admin\":{\"7\":1}}'),
('21', '1', '189', '188', '1', 'com_redirect', 'com_redirect', '{\"core.admin\":{\"7\":1}}'),
('22', '1', '191', '190', '1', 'com_search', 'com_search', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
('23', '1', '193', '192', '1', 'com_templates', 'com_templates', '{\"core.admin\":{\"7\":1}}'),
('24', '1', '195', '196', '1', 'com_users', 'com_users', '{\"core.admin\":{\"7\":1}}'),
('26', '1', '199', '198', '1', 'com_wrapper', 'com_wrapper', '{}'),
('27', '8', '18', '19', '2', 'com_content.category.2', 'Uncategorised', '{}'),
('28', '3', '4', '5', '2', 'com_banners.category.3', 'Uncategorised', '{}'),
('29', '7', '14', '15', '2', 'com_contact.category.4', 'Uncategorised', '{}'),
('30', '19', '184', '183', '2', 'com_newsfeeds.category.5', 'Uncategorised', '{}'),
('32', '24', '196', '195', '2', 'com_users.category.7', 'Uncategorised', '{}'),
('33', '1', '201', '200', '1', 'com_finder', 'com_finder', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
('34', '1', '203', '202', '1', 'com_joomlaupdate', 'com_joomlaupdate', '{}'),
('35', '1', '205', '204', '1', 'com_tags', 'com_tags', '{}'),
('36', '1', '207', '206', '1', 'com_contenthistory', 'com_contenthistory', '{}'),
('37', '1', '209', '208', '1', 'com_ajax', 'com_ajax', '{}'),
('38', '1', '211', '210', '1', 'com_postinstall', 'com_postinstall', '{}'),
('40', '18', '122', '121', '2', 'com_modules.module.2', 'Login', '{}'),
('41', '18', '124', '123', '2', 'com_modules.module.3', 'Popular Articles', '{}'),
('42', '18', '126', '125', '2', 'com_modules.module.4', 'Recently Added Articles', '{}'),
('43', '18', '128', '127', '2', 'com_modules.module.8', 'Toolbar', '{}'),
('44', '18', '130', '129', '2', 'com_modules.module.9', 'Quick Icons', '{}'),
('45', '18', '132', '131', '2', 'com_modules.module.10', 'Logged-in Users', '{}'),
('46', '18', '134', '133', '2', 'com_modules.module.12', 'Admin Menu', '{}'),
('47', '18', '136', '135', '2', 'com_modules.module.13', 'Admin Submenu', '{}'),
('48', '18', '138', '137', '2', 'com_modules.module.14', 'User Status', '{}'),
('49', '18', '140', '139', '2', 'com_modules.module.15', 'Title', '{}'),
('51', '18', '142', '141', '2', 'com_modules.module.17', 'Breadcrumbs', '{}'),
('52', '18', '144', '143', '2', 'com_modules.module.79', 'Multilanguage status', '{}'),
('53', '18', '146', '145', '2', 'com_modules.module.86', 'Joomla Version', '{}'),
('54', '16', '112', '111', '2', 'com_menus.menu.1', 'Main Menu', '{}'),
('55', '18', '148', '147', '2', 'com_modules.module.87', 'Sample Data', '{}'),
('56', '1', '213', '362', '1', 'com_sppagebuilder', 'SP Page Builder', '{}'),
('60', '56', '214', '213', '2', 'com_sppagebuilder.page.1', 'Home - Legacy', '{}'),
('62', '1', '365', '364', '1', 'com_speasyimagegallery', 'COM_SPEASYIMAGEGALLERY', '{}'),
('63', '18', '150', '149', '2', 'com_modules.module.91', 'Photos', '{}'),
('65', '1', '367', '366', '1', '#__speasyimagegallery_albums.1', '#__speasyimagegallery_albums.1', '{}'),
('66', '56', '216', '215', '2', 'com_sppagebuilder.page.2', 'About', '{}'),
('67', '56', '218', '217', '2', 'com_sppagebuilder.page.3', 'Contact', '{}'),
('68', '56', '220', '219', '2', 'com_sppagebuilder.page.4', 'Services', '{}'),
('69', '8', '20', '93', '2', 'com_content.category.8', 'Blog', '{}'),
('70', '69', '21', '22', '3', 'com_content.article.1', 'How Marching for Science Risks Politicizing It', '{}'),
('71', '69', '23', '24', '3', 'com_content.article.2', 'After Setbacks and Suits, Miami to Open Science Museum', '{}'),
('72', '69', '25', '26', '3', 'com_content.article.3', 'The New Threat to Wolves in and Around Yellowstone', '{}'),
('73', '18', '152', '151', '2', 'com_modules.module.93', 'Information', '{}'),
('74', '18', '154', '153', '2', 'com_modules.module.94', 'Blog', '{}'),
('75', '16', '114', '113', '2', 'com_menus.menu.2', 'Company', '{}'),
('76', '16', '116', '115', '2', 'com_menus.menu.3', 'Quick Links', '{}'),
('77', '18', '156', '155', '2', 'com_modules.module.95', 'Company', '{}'),
('78', '69', '27', '28', '3', 'com_content.article.4', 'Broke a Glass? Someday You Might 3-D-Print a New One', '{}'),
('79', '69', '29', '30', '3', 'com_content.article.5', 'Jimmy Kimmel Sheds Light on Health Coverage', '{}'),
('80', '69', '31', '32', '3', 'com_content.article.6', 'As Arctic Ice Vanishes, New Shipping Routes Open', '{}'),
('81', '69', '33', '34', '3', 'com_content.article.7', 'Want to Make More Baskets? Science Has the Answer', '{}'),
('82', '69', '35', '36', '3', 'com_content.article.8', 'Debate Over Paris Climate Deal Could Turn on a Single Phrase', '{}'),
('83', '69', '37', '38', '3', 'com_content.article.9', 'The Making of a Legacy: First Steps in the Trump Era', '{}'),
('84', '18', '158', '157', '2', 'com_modules.module.96', 'Joomla Module', '{}'),
('88', '18', '160', '159', '2', 'com_modules.module.98', 'Latest Articles', '{}'),
('90', '1', '369', '368', '1', 'com_fields', 'com_fields', '{}'),
('91', '1', '371', '370', '1', 'com_associations', 'com_associations', '{}'),
('92', '1', '373', '372', '1', 'com_privacy', 'com_privacy', '{}'),
('93', '1', '375', '374', '1', 'com_actionlogs', 'com_actionlogs', '{}'),
('94', '56', '222', '221', '2', 'com_sppagebuilder.page.5', 'Home - Corporate', '{}'),
('95', '56', '224', '223', '2', 'com_sppagebuilder.page.6', 'Home - Fashion', '{}'),
('96', '56', '226', '225', '2', 'com_sppagebuilder.page.7', 'Home - Life Style', '{}'),
('97', '56', '228', '227', '2', 'com_sppagebuilder.page.8', 'Home - Sea Food', '{}'),
('98', '56', '230', '229', '2', 'com_sppagebuilder.page.9', 'Home - Default', '{}'),
('108', '1', '377', '376', '1', 'com_qsbuilder', 'com_qsbuilder', '{}'),
('109', '1', '379', '378', '1', 'com_guidedtours', 'com_guidedtours', '{}'),
('110', '1', '381', '380', '1', 'com_mails', 'com_mails', '{}'),
('111', '1', '383', '388', '1', 'com_scheduler', 'com_scheduler', '{}'),
('112', '1', '391', '390', '1', 'com_workflow', 'com_workflow', '{}'),
('113', '56', '232', '231', '2', 'com_sppagebuilder.page.10', 'Elements', '{}'),
('114', '111', '384', '383', '2', 'com_scheduler.task.1', 'Rotate Logs', '{}'),
('115', '111', '386', '385', '2', 'com_scheduler.task.2', 'Session GC', '{}'),
('116', '111', '388', '387', '2', 'com_scheduler.task.3', 'Update Notification', '{}'),
('117', '18', '162', '161', '2', 'com_modules.module.121', 'Footer', '{}'),
('118', '56', '234', '233', '2', 'com_sppagebuilder.page.11', 'Footer', '{}'),
('119', '56', '236', '235', '2', 'com_sppagebuilder.page.12', 'Industries', '{}'),
('120', '56', '238', '237', '2', 'com_sppagebuilder.page.13', 'Industries Details', '{}'),
('121', '56', '240', '239', '2', 'com_sppagebuilder.collection.1', 'com_sppagebuilder.collection.1', '{}'),
('122', '56', '242', '241', '2', 'com_sppagebuilder.collection_item.1', 'com_sppagebuilder.collection_item.1', '{}'),
('123', '56', '244', '243', '2', 'com_sppagebuilder.page.14', 'Industries', '{}'),
('124', '56', '246', '245', '2', 'com_sppagebuilder.page.15', 'Industries Details', '{}'),
('125', '56', '248', '247', '2', 'com_sppagebuilder.collection_item.2', 'com_sppagebuilder.collection_item.2', '{}'),
('126', '56', '250', '249', '2', 'com_sppagebuilder.collection_item.3', 'com_sppagebuilder.collection_item.3', '{}'),
('127', '56', '252', '251', '2', 'com_sppagebuilder.collection_item.4', 'com_sppagebuilder.collection_item.4', '{}'),
('128', '56', '254', '253', '2', 'com_sppagebuilder.collection_item.5', 'com_sppagebuilder.collection_item.5', '{}'),
('129', '56', '256', '255', '2', 'com_sppagebuilder.collection_item.6', 'com_sppagebuilder.collection_item.6', '{}'),
('130', '56', '258', '257', '2', 'com_sppagebuilder.collection_item.7', 'com_sppagebuilder.collection_item.7', '{}'),
('131', '69', '39', '42', '3', 'com_content.category.9', 'Business', '{}'),
('132', '69', '43', '46', '3', 'com_content.category.10', 'Corporate', '{}'),
('133', '69', '47', '50', '3', 'com_content.category.11', 'Marketing', '{}'),
('134', '69', '59', '58', '3', 'com_content.category.12', 'Technology', '{}'),
('135', '69', '63', '62', '3', 'com_content.category.13', 'Agency', '{}'),
('136', '69', '67', '66', '3', 'com_content.category.14', 'Medical', '{}'),
('137', '69', '73', '72', '3', 'com_content.category.15', 'Manufacture', '{}'),
('138', '18', '164', '163', '2', 'com_modules.module.122', 'Copyright', '{}'),
('139', '18', '166', '165', '2', 'com_modules.module.123', 'Header Button', '{}'),
('140', '56', '260', '259', '2', 'com_sppagebuilder.page.16', 'Header Button', '{}'),
('141', '134', '-46', '-47', '4', 'com_content.article.19', 'Elements Development Group is Pioneering', '{}'),
('142', '56', '262', '261', '2', 'com_sppagebuilder.page.17', 'Elements Development Group is Pioneering', '{}'),
('144', '56', '264', '263', '2', 'com_sppagebuilder.page.19', 'Service Details', '{}'),
('145', '56', '266', '265', '2', 'com_sppagebuilder.page.20', 'Testimonials', '{}'),
('146', '56', '268', '267', '2', 'com_sppagebuilder.page.21', 'Team', '{}'),
('147', '18', '168', '167', '2', 'com_modules.module.124', 'Login Top', '{}'),
('148', '56', '270', '269', '2', 'com_sppagebuilder.page.22', 'Login Top', '{}'),
('149', '18', '170', '169', '2', 'com_modules.module.125', 'Registration Top', '{}'),
('150', '56', '272', '271', '2', 'com_sppagebuilder.page.23', 'Registration Top', '{}'),
('151', '56', '274', '273', '2', 'com_sppagebuilder.page.18', 'Business Policy for Next Generation', '{}'),
('152', '18', '172', '171', '2', 'com_modules.module.126', 'Category', '{}'),
('153', '18', '174', '173', '2', 'com_modules.module.127', 'Category', '{}'),
('154', '56', '276', '275', '2', 'com_sppagebuilder.page.24', 'Terms', '{}'),
('155', '56', '278', '277', '2', 'com_sppagebuilder.page.25', 'FAQ', '{}'),
('156', '56', '280', '279', '2', 'com_sppagebuilder.collection.2', 'com_sppagebuilder.collection.2', '{}'),
('157', '56', '282', '281', '2', 'com_sppagebuilder.collection_item.8', 'com_sppagebuilder.collection_item.8', '{}'),
('158', '56', '284', '283', '2', 'com_sppagebuilder.page.26', 'Testimonials', '{}'),
('159', '56', '286', '285', '2', 'com_sppagebuilder.collection_item.9', 'com_sppagebuilder.collection_item.9', '{}'),
('160', '56', '288', '287', '2', 'com_sppagebuilder.collection_item.10', 'com_sppagebuilder.collection_item.10', '{}'),
('161', '56', '290', '289', '2', 'com_sppagebuilder.collection_item.11', 'com_sppagebuilder.collection_item.11', '{}'),
('162', '56', '292', '291', '2', 'com_sppagebuilder.collection_item.12', 'com_sppagebuilder.collection_item.12', '{}'),
('163', '56', '294', '293', '2', 'com_sppagebuilder.collection_item.13', 'com_sppagebuilder.collection_item.13', '{}'),
('164', '56', '296', '295', '2', 'com_sppagebuilder.collection_item.14', 'com_sppagebuilder.collection_item.14', '{}'),
('165', '56', '298', '297', '2', 'com_sppagebuilder.collection_item.15', 'com_sppagebuilder.collection_item.15', '{}'),
('166', '56', '300', '299', '2', 'com_sppagebuilder.collection_item.16', 'com_sppagebuilder.collection_item.16', '{}'),
('167', '56', '302', '301', '2', 'com_sppagebuilder.collection_item.17', 'com_sppagebuilder.collection_item.17', '{}'),
('168', '56', '304', '303', '2', 'com_sppagebuilder.collection_item.18', 'com_sppagebuilder.collection_item.18', '{}'),
('169', '56', '306', '305', '2', 'com_sppagebuilder.collection_item.19', 'com_sppagebuilder.collection_item.19', '{}'),
('170', '56', '308', '307', '2', 'com_sppagebuilder.collection_item.20', 'com_sppagebuilder.collection_item.20', '{}'),
('171', '56', '310', '309', '2', 'com_sppagebuilder.collection_item.21', 'com_sppagebuilder.collection_item.21', '{}'),
('174', '69', '73', '74', '3', 'com_content.article.24', 'Innovative Strategies for Growing Your Business', '{}'),
('175', '56', '310', '311', '2', 'com_sppagebuilder.page.29', 'Innovative Strategies for Growing Your Business', '{}'),
('177', '69', '77', '78', '3', 'com_content.article.26', 'Strategies to Enhance Your Business Policies', '{}'),
('178', '56', '312', '313', '2', 'com_sppagebuilder.page.31', 'Strategies to Enhance Your Business Policies', '{}'),
('179', '69', '79', '80', '3', 'com_content.article.27', 'Journey to Success: Innovative Strategies for Growing', '{}'),
('180', '56', '314', '315', '2', 'com_sppagebuilder.page.32', 'Journey to Success: Innovative Strategies for Growing', '{}'),
('181', '69', '81', '82', '3', 'com_content.article.28', 'Pathway to Prosperity: Creative Approaches for Expanding', '{}'),
('182', '56', '316', '317', '2', 'com_sppagebuilder.page.33', 'Pathway to Prosperity: Creative Approaches for Expanding', '{}'),
('183', '69', '83', '84', '3', 'com_content.article.29', 'How to Boost Your Business Policy for the Next Generation', '{}'),
('184', '56', '318', '319', '2', 'com_sppagebuilder.page.34', 'How to Boost Your Business Policy for the Next Generation', '{}'),
('185', '69', '85', '86', '3', 'com_content.article.30', 'Cool Tips for Growing Your Business', '{}'),
('186', '56', '320', '321', '2', 'com_sppagebuilder.page.35', 'Cool Tips for Growing Your Business', '{}'),
('187', '69', '87', '88', '3', 'com_content.article.31', 'Igniting Progress: Cutting-Edge Methods for Business Development', '{}'),
('188', '56', '322', '323', '2', 'com_sppagebuilder.page.36', 'Unlocking Success: Innovative Strategies for Business Growth', '{}'),
('189', '69', '89', '90', '3', 'com_content.article.32', 'How to Increase Your Business Policy for Next Generation', '{}'),
('190', '56', '324', '325', '2', 'com_sppagebuilder.page.37', 'How to Increase Your Business Policy for Next Generation', '{}'),
('191', '69', '91', '92', '3', 'com_content.article.33', 'Pathways to Prosperity: Modern Tactics for Scaling Your Business', '{}'),
('193', '56', '326', '327', '2', 'com_sppagebuilder.page.39', 'Success: Innovative Strategies for Business Growth', '{}'),
('194', '56', '328', '329', '2', 'com_sppagebuilder.page.38', 'Unlocking Success: Innovative Strategies for Business', '{}'),
('195', '134', '52', '53', '4', 'com_content.article.35', 'Elements Development Group is Pioneering', '{}'),
('196', '132', '44', '45', '4', 'com_content.article.36', 'Innovative Strategies for Growing Your Business', '{}'),
('197', '134', '54', '55', '4', 'com_content.article.37', 'Strategies to Enhance Your Business Policies', '{}'),
('198', '137', '68', '69', '4', 'com_content.article.38', 'Journey to Success: Innovative Strategies for Growing', '{}'),
('199', '135', '60', '61', '4', 'com_content.article.39', 'Pathway to Prosperity: Creative Approaches for Expanding', '{}'),
('200', '134', '56', '57', '4', 'com_content.article.40', 'How to Boost Your Business Policy for the Next Generation', '{}'),
('201', '136', '64', '65', '4', 'com_content.article.41', 'Cool Tips for Growing Your Business', '{}'),
('202', '131', '40', '41', '4', 'com_content.article.42', 'How to Increase Your Business Policy for Next Generation', '{}'),
('203', '137', '70', '71', '4', 'com_content.article.43', 'Accelerate Your Growth: Proven Strategies for Business Success', '{}'),
('204', '133', '48', '49', '4', 'com_content.article.44', 'Breaking Barriers: Creative Approaches to Business Expansion', '{}'),
('205', '56', '330', '331', '2', 'com_sppagebuilder.page.40', 'Elements Development Group is Pioneering', '{}'),
('206', '56', '332', '333', '2', 'com_sppagebuilder.page.42', 'Strategies to Enhance Your Business Policies', '{}'),
('207', '56', '334', '335', '2', 'com_sppagebuilder.page.45', 'How to Boost Your Business Policy for the Next Generation', '{}'),
('208', '56', '336', '337', '2', 'com_sppagebuilder.page.46', 'Cool Tips for Growing Your Business', '{}'),
('209', '56', '338', '339', '2', 'com_sppagebuilder.page.49', 'Unlocking Success: Innovative Strategies for Business Growth', '{}'),
('210', '56', '340', '341', '2', 'com_sppagebuilder.page.43', 'Journey to Success: Innovative Strategies for Growing', '{}'),
('211', '56', '342', '343', '2', 'com_sppagebuilder.page.48', 'Unlocking Success: Innovative Strategies for Business', '{}'),
('212', '56', '344', '345', '2', 'com_sppagebuilder.page.41', 'Innovative Strategies for Growing Your Business', '{}'),
('213', '56', '346', '347', '2', 'com_sppagebuilder.page.47', 'How to Increase Your Business Policy for Next Generation', '{}'),
('214', '56', '348', '349', '2', 'com_sppagebuilder.page.44', 'Pathway to Prosperity: Creative Approaches for Expanding', '{}'),
('215', '18', '174', '175', '2', 'com_modules.module.128', 'Coming Soon', '{}'),
('216', '56', '350', '351', '2', 'com_sppagebuilder.page.50', 'Coming Soon', '{}'),
('217', '56', '352', '353', '2', 'com_sppagebuilder.page.51', 'test', '{}'),
('218', '18', '176', '177', '2', 'com_modules.module.113', 'Site', '{}'),
('219', '56', '354', '355', '2', 'com_sppagebuilder.page.53', 'Staff Details', '{}'),
('220', '18', '178', '179', '2', 'com_modules.module.129', 'My Search', '{}'),
('221', '56', '356', '357', '2', 'com_sppagebuilder.page.54', 'Strategic Partnership', '{}'),
('222', '56', '358', '359', '2', 'com_sppagebuilder.page.55', 'Alumni', '{}'),
('223', '56', '360', '361', '2', 'com_sppagebuilder.page.56', '3 Item - Living Lab', '{}'),
('224', '1', '391', '392', '1', 'com_akeebabackup', 'com_akeebabackup', '{}');
/**ABDB**/CREATE TABLE `#__associations` (
  `id` int NOT NULL COMMENT 'A reference to the associated item.',
  `context` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The context of the associated item.',
  `key` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.',
  PRIMARY KEY (`context`,`id`),
  KEY `idx_key` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__banner_clients` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `contact` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extrainfo` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `metakey` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `own_prefix` tinyint NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint NOT NULL DEFAULT '-1',
  `track_clicks` tinyint NOT NULL DEFAULT '-1',
  `track_impressions` tinyint NOT NULL DEFAULT '-1',
  PRIMARY KEY (`id`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__banner_tracks` (
  `track_date` datetime NOT NULL,
  `track_type` int unsigned NOT NULL,
  `banner_id` int unsigned NOT NULL,
  `count` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`track_date`,`track_type`,`banner_id`),
  KEY `idx_track_date` (`track_date`),
  KEY `idx_track_type` (`track_type`),
  KEY `idx_banner_id` (`banner_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__banners` (
  `id` int NOT NULL AUTO_INCREMENT,
  `cid` int NOT NULL DEFAULT '0',
  `type` int NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `imptotal` int NOT NULL DEFAULT '0',
  `impmade` int NOT NULL DEFAULT '0',
  `clicks` int NOT NULL DEFAULT '0',
  `clickurl` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `state` tinyint NOT NULL DEFAULT '0',
  `catid` int unsigned NOT NULL DEFAULT '0',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `custombannercode` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `sticky` tinyint unsigned NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  `metakey` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `own_prefix` tinyint(1) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint NOT NULL DEFAULT '-1',
  `track_clicks` tinyint NOT NULL DEFAULT '-1',
  `track_impressions` tinyint NOT NULL DEFAULT '-1',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `reset` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `version` int unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_state` (`state`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`(100)),
  KEY `idx_banner_catid` (`catid`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__categories` (
  `id` int NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `parent_id` int unsigned NOT NULL DEFAULT '0',
  `lft` int NOT NULL DEFAULT '0',
  `rgt` int NOT NULL DEFAULT '0',
  `level` int unsigned NOT NULL DEFAULT '0',
  `path` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extension` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `access` int unsigned NOT NULL DEFAULT '0',
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `metadesc` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL,
  `modified_user_id` int unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL,
  `hits` int unsigned NOT NULL DEFAULT '0',
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `version` int unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `cat_idx` (`extension`,`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__categories`  VALUES 
('1', '0', '0', '0', '27', '0', '', 'system', 'ROOT', 'root', '', '', '1', NULL, NULL, '1', '{}', '', '', '{}', '300', '2021-08-19 09:54:33', '300', '2021-08-19 09:54:33', '0', '*', '1'),
('2', '27', '1', '1', '2', '1', 'uncategorised', 'com_content', 'Uncategorised', 'uncategorised', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '300', '2021-08-19 09:54:33', '300', '2021-08-19 09:54:33', '0', '*', '1'),
('3', '28', '1', '3', '4', '1', 'uncategorised', 'com_banners', 'Uncategorised', 'uncategorised', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '300', '2021-08-19 09:54:33', '300', '2021-08-19 09:54:33', '0', '*', '1'),
('4', '29', '1', '5', '6', '1', 'uncategorised', 'com_contact', 'Uncategorised', 'uncategorised', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '300', '2021-08-19 09:54:33', '300', '2021-08-19 09:54:33', '0', '*', '1'),
('5', '30', '1', '7', '8', '1', 'uncategorised', 'com_newsfeeds', 'Uncategorised', 'uncategorised', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '300', '2021-08-19 09:54:33', '300', '2021-08-19 09:54:33', '0', '*', '1'),
('7', '32', '1', '9', '10', '1', 'uncategorised', 'com_users', 'Uncategorised', 'uncategorised', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '300', '2021-08-19 09:54:33', '300', '2021-08-19 09:54:33', '0', '*', '1'),
('8', '69', '1', '11', '26', '1', 'blog', 'com_content', 'Blog', 'blog', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '300', '2021-08-19 09:54:33', '0', '2021-08-19 09:54:33', '0', '*', '1'),
('9', '131', '8', '12', '13', '2', 'blog/business', 'com_content', 'Business', 'business', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '300', '2025-04-09 10:53:57', '300', '2025-04-09 11:04:50', '0', '*', '1'),
('10', '132', '8', '14', '15', '2', 'blog/corporate', 'com_content', 'Corporate', 'corporate', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '300', '2025-04-09 11:03:27', '300', '2025-04-09 11:05:01', '0', '*', '1'),
('11', '133', '8', '16', '17', '2', 'blog/marketing', 'com_content', 'Marketing', 'marketing', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '300', '2025-04-09 11:03:35', '300', '2025-04-09 11:05:10', '0', '*', '1'),
('12', '134', '8', '18', '19', '2', 'blog/technology', 'com_content', 'Technology', 'technology', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '300', '2025-04-09 11:03:43', '300', '2025-04-09 11:05:19', '0', '*', '1'),
('13', '135', '8', '20', '21', '2', 'blog/agency', 'com_content', 'Agency', 'agency', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '300', '2025-04-09 11:04:02', '300', '2025-04-09 11:05:26', '0', '*', '1'),
('14', '136', '8', '22', '23', '2', 'blog/medical', 'com_content', 'Medical', 'medical', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '300', '2025-04-09 11:04:14', '300', '2025-04-09 11:05:38', '0', '*', '1'),
('15', '137', '8', '24', '25', '2', 'blog/manufacture', 'com_content', 'Manufacture', 'manufacture', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '300', '2025-04-09 11:04:34', '300', '2025-04-09 11:05:51', '0', '*', '1');
/**ABDB**/CREATE TABLE `#__contact_details` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `con_position` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `suburb` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postcode` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telephone` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fax` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `misc` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_to` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_con` tinyint unsigned NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int NOT NULL DEFAULT '0',
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int NOT NULL DEFAULT '0',
  `catid` int NOT NULL DEFAULT '0',
  `access` int unsigned NOT NULL DEFAULT '0',
  `mobile` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `webpage` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname1` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname3` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language` varchar(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `metakey` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `metadesc` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint unsigned NOT NULL DEFAULT '0' COMMENT 'Set if contact is featured.',
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `version` int unsigned NOT NULL DEFAULT '1',
  `hits` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__contact_details`  VALUES 
('1', 'Contact', 'contact', '', '', '', '', '', '', '', '', '', '', '', '0', '1', NULL, NULL, '1', '{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"\",\"show_tags\":\"\",\"show_info\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"add_mailto_link\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_image\":\"\",\"show_misc\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"articles_display_num\":\"\",\"show_profile\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linka\":false,\"linkb_name\":\"\",\"linkb\":false,\"linkc_name\":\"\",\"linkc\":false,\"linkd_name\":\"\",\"linkd\":false,\"linke_name\":\"\",\"linke\":false,\"contact_layout\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\"}', '228', '4', '1', '', '', '', '', '', '*', '2021-08-19 09:54:33', '874', '', '2021-08-20 09:31:56', '874', '', '', '{\"robots\":\"\",\"rights\":\"\"}', '0', NULL, NULL, '11', '90');
/**ABDB**/CREATE TABLE `#__content` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `introtext` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `fulltext` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint NOT NULL DEFAULT '0',
  `catid` int unsigned NOT NULL DEFAULT '0',
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `images` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `urls` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribs` varchar(5120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int unsigned NOT NULL DEFAULT '1',
  `ordering` int NOT NULL DEFAULT '0',
  `metakey` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `metadesc` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `access` int unsigned NOT NULL DEFAULT '0',
  `hits` int unsigned NOT NULL DEFAULT '0',
  `metadata` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The language code for the article.',
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_alias` (`alias`(191))
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__content`  VALUES 
('19', '141', 'Elements Development Group is Pioneering', 'elements-development-group-is-pioneering', '', '\r\n<p>Through World-first Climate-responsive Technology Eco-friendly construction materials are essential in building a sustainable future. These materials, such as reclaimed wood, recycled metal, and bamboo, significantly reduce the environmental impact of construction projects. They are often sourced from renewable resources and require less energy to produce compared to traditional materials. By incorporating sustainable materials, buildings can achieve better energy efficiency and lower carbon footprints. Additionally, eco-friendly materials can improve indoor air quality and enhance the overall health and well-being of occupants. The use of green construction materials also supports the growth of a circular economy, promoting the reuse and recycling of resources. Ultimately, adopting sustainable materials in construction is a crucial step towards a more resilient and environmentally responsible built environment. How to Build a Winning Business Strategy in 2025 Define Your Vision and Objectives Start by clearly articulating where you want your business to be in the next 3–5 years. Align your goals with measurable KPIs and a timeline. Analyze the Market Landscape Conduct a SWOT analysis, evaluate competitors, and identify market opportunities. Use data-driven insights to guide decision-making. Innovate and Differentiate Highlight your unique value proposition. Stay agile by embracing innovation and leveraging emerging technologies. Align Teams and Resources Ensure all departments are aligned with the strategy. Communicate goals clearly and foster a culture of collaboration and accountability. Monitor, Adapt, and Optimize Regularly review performance, gather feedback, and refine your strategy as needed. Strategic agility is crucial to staying ahead. The outcome By reducing time spent on financial admin, Mimo gave Mikala and her team more space to focus on what matters - building partnerships, forecasting with confidence, and driving sustainable scale. With operations running more smoothly, Marleybones has entered an exciting new chapter: launching a new category of vet-developed supplement chews, expanding into new retail stockists, and reaching more pet parents than ever before. And the ambition doesn’t stop there. The goal is to make Marleybones the go-to brand for modern pet parents seeking premium, easy-to-serve nutrition. Want to increase your team\'s operational efficiency and save time on payments, just like Mikala? Get in touch to find out how Mimo can help.</p>', '1', '8', '2025-04-09 12:28:05', '752', '', '2025-04-15 06:57:36', '752', NULL, NULL, '2025-04-09 12:28:05', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Continue Reading\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/04\\/15\\/blog-1.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '1', '10', '', '', '1', '65', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('23', '0', 'Business Policy for Next Generation (2)', 'business-policy-for-next-generation-2', '', 'Through World-first Climate-responsive Technology        Eco-friendly construction materials are essential in building a sustainable future. These materials, such as reclaimed wood, recycled metal, and bamboo, significantly reduce the environmental impact of construction projects. They are often sourced from renewable resources and require less energy to produce compared to traditional materials. By incorporating sustainable materials, buildings can achieve better energy efficiency and lower carbon footprints.        Additionally, eco-friendly materials can improve indoor air quality and enhance the overall health and well-being of occupants. The use of green construction materials also supports the growth of a circular economy, promoting the reuse and recycling of resources. Ultimately, adopting sustainable materials in construction is a crucial step towards a more resilient and environmentally responsible built environment.                  How to Build a Winning Business Strategy in 2025          Define Your Vision and Objectives Start by clearly articulating where you want your business to be in the next 3–5 years. Align your goals with measurable KPIs and a timeline.  Analyze the Market Landscape Conduct a SWOT analysis, evaluate competitors, and identify market opportunities. Use data-driven insights to guide decision-making.  Innovate and Differentiate Highlight your unique value proposition. Stay agile by embracing innovation and leveraging emerging technologies.  Align Teams and Resources Ensure all departments are aligned with the strategy. Communicate goals clearly and foster a culture of collaboration and accountability.  Monitor, Adapt, and Optimize Regularly review performance, gather feedback, and refine your strategy as needed. Strategic agility is crucial to staying ahead.         The outcome        By reducing time spent on financial admin, Mimo gave Mikala and her team more space to focus on what matters - building partnerships, forecasting with confidence, and driving sustainable scale.        With operations running more smoothly, Marleybones has entered an exciting new chapter: launching a new category of vet-developed supplement chews, expanding into new retail stockists, and reaching more pet parents than ever before.       \nAnd the ambition doesn’t stop there. The goal is to make Marleybones the go-to brand for modern pet parents seeking premium, easy-to-serve nutrition.\n       \nWant to increase your team\'s operational efficiency and save time on payments, just like Mikala? Get in touch to find out how Mimo can help.', '0', '11', '2025-04-09 12:28:05', '752', '', '2025-04-11 11:41:25', '752', NULL, NULL, '2025-04-09 12:28:05', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Continue Reading\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/04\\/11\\/blog-10.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '6', '0', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('24', '174', 'Innovative Strategies for Growing Your Business', 'innovative-strategies-for-growing-your-business', '', 'Through World-first Climate-responsive Technology        Eco-friendly construction materials are essential in building a sustainable future. These materials, such as reclaimed wood, recycled metal, and bamboo, significantly reduce the environmental impact of construction projects. They are often sourced from renewable resources and require less energy to produce compared to traditional materials. By incorporating sustainable materials, buildings can achieve better energy efficiency and lower carbon footprints.        Additionally, eco-friendly materials can improve indoor air quality and enhance the overall health and well-being of occupants. The use of green construction materials also supports the growth of a circular economy, promoting the reuse and recycling of resources. Ultimately, adopting sustainable materials in construction is a crucial step towards a more resilient and environmentally responsible built environment.                  How to Build a Winning Business Strategy in 2025          Define Your Vision and Objectives Start by clearly articulating where you want your business to be in the next 3–5 years. Align your goals with measurable KPIs and a timeline.  Analyze the Market Landscape Conduct a SWOT analysis, evaluate competitors, and identify market opportunities. Use data-driven insights to guide decision-making.  Innovate and Differentiate Highlight your unique value proposition. Stay agile by embracing innovation and leveraging emerging technologies.  Align Teams and Resources Ensure all departments are aligned with the strategy. Communicate goals clearly and foster a culture of collaboration and accountability.  Monitor, Adapt, and Optimize Regularly review performance, gather feedback, and refine your strategy as needed. Strategic agility is crucial to staying ahead.         The outcome        By reducing time spent on financial admin, Mimo gave Mikala and her team more space to focus on what matters - building partnerships, forecasting with confidence, and driving sustainable scale.        With operations running more smoothly, Marleybones has entered an exciting new chapter: launching a new category of vet-developed supplement chews, expanding into new retail stockists, and reaching more pet parents than ever before.       \nAnd the ambition doesn’t stop there. The goal is to make Marleybones the go-to brand for modern pet parents seeking premium, easy-to-serve nutrition.\n       \nWant to increase your team\'s operational efficiency and save time on payments, just like Mikala? Get in touch to find out how Mimo can help.', '1', '8', '2025-04-15 06:41:30', '752', '', '2025-04-15 07:21:17', '752', NULL, NULL, '2025-04-15 06:41:30', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Continue Reading\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/04\\/15\\/blog-2.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '6', '9', '', '', '1', '2', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('26', '177', 'Strategies to Enhance Your Business Policies', 'strategies-to-enhance-your-business-policies', '', 'Through World-first Climate-responsive Technology        Eco-friendly construction materials are essential in building a sustainable future. These materials, such as reclaimed wood, recycled metal, and bamboo, significantly reduce the environmental impact of construction projects. They are often sourced from renewable resources and require less energy to produce compared to traditional materials. By incorporating sustainable materials, buildings can achieve better energy efficiency and lower carbon footprints.        Additionally, eco-friendly materials can improve indoor air quality and enhance the overall health and well-being of occupants. The use of green construction materials also supports the growth of a circular economy, promoting the reuse and recycling of resources. Ultimately, adopting sustainable materials in construction is a crucial step towards a more resilient and environmentally responsible built environment.                  How to Build a Winning Business Strategy in 2025          Define Your Vision and Objectives Start by clearly articulating where you want your business to be in the next 3–5 years. Align your goals with measurable KPIs and a timeline.  Analyze the Market Landscape Conduct a SWOT analysis, evaluate competitors, and identify market opportunities. Use data-driven insights to guide decision-making.  Innovate and Differentiate Highlight your unique value proposition. Stay agile by embracing innovation and leveraging emerging technologies.  Align Teams and Resources Ensure all departments are aligned with the strategy. Communicate goals clearly and foster a culture of collaboration and accountability.  Monitor, Adapt, and Optimize Regularly review performance, gather feedback, and refine your strategy as needed. Strategic agility is crucial to staying ahead.         The outcome        By reducing time spent on financial admin, Mimo gave Mikala and her team more space to focus on what matters - building partnerships, forecasting with confidence, and driving sustainable scale.        With operations running more smoothly, Marleybones has entered an exciting new chapter: launching a new category of vet-developed supplement chews, expanding into new retail stockists, and reaching more pet parents than ever before.       \nAnd the ambition doesn’t stop there. The goal is to make Marleybones the go-to brand for modern pet parents seeking premium, easy-to-serve nutrition.\n       \nWant to increase your team\'s operational efficiency and save time on payments, just like Mikala? Get in touch to find out how Mimo can help.', '1', '8', '2025-04-15 07:26:50', '752', '', '2025-04-15 07:34:33', '752', NULL, NULL, '2025-04-15 07:26:50', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Continue Reading\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/04\\/15\\/blog-3.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '4', '8', '', '', '1', '14', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('27', '179', 'Journey to Success: Innovative Strategies for Growing', 'journey-to-success-innovative-strategies-for-growing', '', 'Through World-first Climate-responsive Technology        Eco-friendly construction materials are essential in building a sustainable future. These materials, such as reclaimed wood, recycled metal, and bamboo, significantly reduce the environmental impact of construction projects. They are often sourced from renewable resources and require less energy to produce compared to traditional materials. By incorporating sustainable materials, buildings can achieve better energy efficiency and lower carbon footprints.        Additionally, eco-friendly materials can improve indoor air quality and enhance the overall health and well-being of occupants. The use of green construction materials also supports the growth of a circular economy, promoting the reuse and recycling of resources. Ultimately, adopting sustainable materials in construction is a crucial step towards a more resilient and environmentally responsible built environment.                  How to Build a Winning Business Strategy in 2025          Define Your Vision and Objectives Start by clearly articulating where you want your business to be in the next 3–5 years. Align your goals with measurable KPIs and a timeline.  Analyze the Market Landscape Conduct a SWOT analysis, evaluate competitors, and identify market opportunities. Use data-driven insights to guide decision-making.  Innovate and Differentiate Highlight your unique value proposition. Stay agile by embracing innovation and leveraging emerging technologies.  Align Teams and Resources Ensure all departments are aligned with the strategy. Communicate goals clearly and foster a culture of collaboration and accountability.  Monitor, Adapt, and Optimize Regularly review performance, gather feedback, and refine your strategy as needed. Strategic agility is crucial to staying ahead.         The outcome        By reducing time spent on financial admin, Mimo gave Mikala and her team more space to focus on what matters - building partnerships, forecasting with confidence, and driving sustainable scale.        With operations running more smoothly, Marleybones has entered an exciting new chapter: launching a new category of vet-developed supplement chews, expanding into new retail stockists, and reaching more pet parents than ever before.       \nAnd the ambition doesn’t stop there. The goal is to make Marleybones the go-to brand for modern pet parents seeking premium, easy-to-serve nutrition.\n       \nWant to increase your team\'s operational efficiency and save time on payments, just like Mikala? Get in touch to find out how Mimo can help.', '1', '8', '2025-04-15 07:32:44', '752', '', '2025-04-15 07:34:07', '752', NULL, NULL, '2025-04-15 07:32:44', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Continue Reading\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/04\\/15\\/blog-4.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '3', '7', '', '', '1', '6', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('28', '181', 'Pathway to Prosperity: Creative Approaches for Expanding', 'pathway-to-prosperity-creative-approaches-for-expanding', '', 'Through World-first Climate-responsive Technology        Eco-friendly construction materials are essential in building a sustainable future. These materials, such as reclaimed wood, recycled metal, and bamboo, significantly reduce the environmental impact of construction projects. They are often sourced from renewable resources and require less energy to produce compared to traditional materials. By incorporating sustainable materials, buildings can achieve better energy efficiency and lower carbon footprints.        Additionally, eco-friendly materials can improve indoor air quality and enhance the overall health and well-being of occupants. The use of green construction materials also supports the growth of a circular economy, promoting the reuse and recycling of resources. Ultimately, adopting sustainable materials in construction is a crucial step towards a more resilient and environmentally responsible built environment.                  How to Build a Winning Business Strategy in 2025          Define Your Vision and Objectives Start by clearly articulating where you want your business to be in the next 3–5 years. Align your goals with measurable KPIs and a timeline.  Analyze the Market Landscape Conduct a SWOT analysis, evaluate competitors, and identify market opportunities. Use data-driven insights to guide decision-making.  Innovate and Differentiate Highlight your unique value proposition. Stay agile by embracing innovation and leveraging emerging technologies.  Align Teams and Resources Ensure all departments are aligned with the strategy. Communicate goals clearly and foster a culture of collaboration and accountability.  Monitor, Adapt, and Optimize Regularly review performance, gather feedback, and refine your strategy as needed. Strategic agility is crucial to staying ahead.         The outcome        By reducing time spent on financial admin, Mimo gave Mikala and her team more space to focus on what matters - building partnerships, forecasting with confidence, and driving sustainable scale.        With operations running more smoothly, Marleybones has entered an exciting new chapter: launching a new category of vet-developed supplement chews, expanding into new retail stockists, and reaching more pet parents than ever before.       \nAnd the ambition doesn’t stop there. The goal is to make Marleybones the go-to brand for modern pet parents seeking premium, easy-to-serve nutrition.\n       \nWant to increase your team\'s operational efficiency and save time on payments, just like Mikala? Get in touch to find out how Mimo can help.', '1', '8', '2025-04-15 07:35:04', '752', '', '2025-04-15 07:36:12', '752', NULL, NULL, '2025-04-15 07:35:04', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Continue Reading\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/04\\/15\\/blog-5.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '3', '6', '', '', '1', '2', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('29', '183', 'How to Boost Your Business Policy for the Next Generation', 'how-to-boost-your-business-policy-for-the-next-generation', '', 'Through World-first Climate-responsive Technology        Eco-friendly construction materials are essential in building a sustainable future. These materials, such as reclaimed wood, recycled metal, and bamboo, significantly reduce the environmental impact of construction projects. They are often sourced from renewable resources and require less energy to produce compared to traditional materials. By incorporating sustainable materials, buildings can achieve better energy efficiency and lower carbon footprints.        Additionally, eco-friendly materials can improve indoor air quality and enhance the overall health and well-being of occupants. The use of green construction materials also supports the growth of a circular economy, promoting the reuse and recycling of resources. Ultimately, adopting sustainable materials in construction is a crucial step towards a more resilient and environmentally responsible built environment.                  How to Build a Winning Business Strategy in 2025          Define Your Vision and Objectives Start by clearly articulating where you want your business to be in the next 3–5 years. Align your goals with measurable KPIs and a timeline.  Analyze the Market Landscape Conduct a SWOT analysis, evaluate competitors, and identify market opportunities. Use data-driven insights to guide decision-making.  Innovate and Differentiate Highlight your unique value proposition. Stay agile by embracing innovation and leveraging emerging technologies.  Align Teams and Resources Ensure all departments are aligned with the strategy. Communicate goals clearly and foster a culture of collaboration and accountability.  Monitor, Adapt, and Optimize Regularly review performance, gather feedback, and refine your strategy as needed. Strategic agility is crucial to staying ahead.         The outcome        By reducing time spent on financial admin, Mimo gave Mikala and her team more space to focus on what matters - building partnerships, forecasting with confidence, and driving sustainable scale.        With operations running more smoothly, Marleybones has entered an exciting new chapter: launching a new category of vet-developed supplement chews, expanding into new retail stockists, and reaching more pet parents than ever before.       \nAnd the ambition doesn’t stop there. The goal is to make Marleybones the go-to brand for modern pet parents seeking premium, easy-to-serve nutrition.\n       \nWant to increase your team\'s operational efficiency and save time on payments, just like Mikala? Get in touch to find out how Mimo can help.', '1', '8', '2025-04-15 07:39:25', '752', '', '2025-04-15 07:42:14', '752', NULL, NULL, '2025-04-15 07:39:25', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Continue Reading\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/04\\/15\\/blog-6.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '3', '5', '', '', '1', '6', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('30', '185', 'Cool Tips for Growing Your Business', 'cool-tips-for-growing-your-business', '', 'Through World-first Climate-responsive Technology        Eco-friendly construction materials are essential in building a sustainable future. These materials, such as reclaimed wood, recycled metal, and bamboo, significantly reduce the environmental impact of construction projects. They are often sourced from renewable resources and require less energy to produce compared to traditional materials. By incorporating sustainable materials, buildings can achieve better energy efficiency and lower carbon footprints.        Additionally, eco-friendly materials can improve indoor air quality and enhance the overall health and well-being of occupants. The use of green construction materials also supports the growth of a circular economy, promoting the reuse and recycling of resources. Ultimately, adopting sustainable materials in construction is a crucial step towards a more resilient and environmentally responsible built environment.                  How to Build a Winning Business Strategy in 2025          Define Your Vision and Objectives Start by clearly articulating where you want your business to be in the next 3–5 years. Align your goals with measurable KPIs and a timeline.  Analyze the Market Landscape Conduct a SWOT analysis, evaluate competitors, and identify market opportunities. Use data-driven insights to guide decision-making.  Innovate and Differentiate Highlight your unique value proposition. Stay agile by embracing innovation and leveraging emerging technologies.  Align Teams and Resources Ensure all departments are aligned with the strategy. Communicate goals clearly and foster a culture of collaboration and accountability.  Monitor, Adapt, and Optimize Regularly review performance, gather feedback, and refine your strategy as needed. Strategic agility is crucial to staying ahead.         The outcome        By reducing time spent on financial admin, Mimo gave Mikala and her team more space to focus on what matters - building partnerships, forecasting with confidence, and driving sustainable scale.        With operations running more smoothly, Marleybones has entered an exciting new chapter: launching a new category of vet-developed supplement chews, expanding into new retail stockists, and reaching more pet parents than ever before.       \nAnd the ambition doesn’t stop there. The goal is to make Marleybones the go-to brand for modern pet parents seeking premium, easy-to-serve nutrition.\n       \nWant to increase your team\'s operational efficiency and save time on payments, just like Mikala? Get in touch to find out how Mimo can help.', '1', '8', '2025-04-15 07:45:37', '752', '', '2025-04-15 07:48:27', '752', NULL, NULL, '2025-04-15 07:45:37', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Continue Reading\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/04\\/15\\/blog-7.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '3', '4', '', '', '1', '2', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('31', '187', 'Igniting Progress: Cutting-Edge Methods for Business Development', 'igniting-progress-cutting-edge-methods-for-business-development', '', 'Through World-first Climate-responsive Technology        Eco-friendly construction materials are essential in building a sustainable future. These materials, such as reclaimed wood, recycled metal, and bamboo, significantly reduce the environmental impact of construction projects. They are often sourced from renewable resources and require less energy to produce compared to traditional materials. By incorporating sustainable materials, buildings can achieve better energy efficiency and lower carbon footprints.        Additionally, eco-friendly materials can improve indoor air quality and enhance the overall health and well-being of occupants. The use of green construction materials also supports the growth of a circular economy, promoting the reuse and recycling of resources. Ultimately, adopting sustainable materials in construction is a crucial step towards a more resilient and environmentally responsible built environment.                  How to Build a Winning Business Strategy in 2025          Define Your Vision and Objectives Start by clearly articulating where you want your business to be in the next 3–5 years. Align your goals with measurable KPIs and a timeline.  Analyze the Market Landscape Conduct a SWOT analysis, evaluate competitors, and identify market opportunities. Use data-driven insights to guide decision-making.  Innovate and Differentiate Highlight your unique value proposition. Stay agile by embracing innovation and leveraging emerging technologies.  Align Teams and Resources Ensure all departments are aligned with the strategy. Communicate goals clearly and foster a culture of collaboration and accountability.  Monitor, Adapt, and Optimize Regularly review performance, gather feedback, and refine your strategy as needed. Strategic agility is crucial to staying ahead.         The outcome        By reducing time spent on financial admin, Mimo gave Mikala and her team more space to focus on what matters - building partnerships, forecasting with confidence, and driving sustainable scale.        With operations running more smoothly, Marleybones has entered an exciting new chapter: launching a new category of vet-developed supplement chews, expanding into new retail stockists, and reaching more pet parents than ever before.       \nAnd the ambition doesn’t stop there. The goal is to make Marleybones the go-to brand for modern pet parents seeking premium, easy-to-serve nutrition.\n       \nWant to increase your team\'s operational efficiency and save time on payments, just like Mikala? Get in touch to find out how Mimo can help.', '1', '8', '2025-04-15 07:49:43', '961', '', '2025-04-16 09:27:05', '961', NULL, NULL, '2025-04-15 07:49:43', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Continue Reading\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/04\\/15\\/blog-8.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '3', '3', '', '', '1', '3', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('32', '189', 'How to Increase Your Business Policy for Next Generation', 'how-to-increase-your-business-policy-for-next-generation', '', 'Through World-first Climate-responsive Technology        Eco-friendly construction materials are essential in building a sustainable future. These materials, such as reclaimed wood, recycled metal, and bamboo, significantly reduce the environmental impact of construction projects. They are often sourced from renewable resources and require less energy to produce compared to traditional materials. By incorporating sustainable materials, buildings can achieve better energy efficiency and lower carbon footprints.        Additionally, eco-friendly materials can improve indoor air quality and enhance the overall health and well-being of occupants. The use of green construction materials also supports the growth of a circular economy, promoting the reuse and recycling of resources. Ultimately, adopting sustainable materials in construction is a crucial step towards a more resilient and environmentally responsible built environment.                  How to Build a Winning Business Strategy in 2025          Define Your Vision and Objectives Start by clearly articulating where you want your business to be in the next 3–5 years. Align your goals with measurable KPIs and a timeline.  Analyze the Market Landscape Conduct a SWOT analysis, evaluate competitors, and identify market opportunities. Use data-driven insights to guide decision-making.  Innovate and Differentiate Highlight your unique value proposition. Stay agile by embracing innovation and leveraging emerging technologies.  Align Teams and Resources Ensure all departments are aligned with the strategy. Communicate goals clearly and foster a culture of collaboration and accountability.  Monitor, Adapt, and Optimize Regularly review performance, gather feedback, and refine your strategy as needed. Strategic agility is crucial to staying ahead.         The outcome        By reducing time spent on financial admin, Mimo gave Mikala and her team more space to focus on what matters - building partnerships, forecasting with confidence, and driving sustainable scale.        With operations running more smoothly, Marleybones has entered an exciting new chapter: launching a new category of vet-developed supplement chews, expanding into new retail stockists, and reaching more pet parents than ever before.       \nAnd the ambition doesn’t stop there. The goal is to make Marleybones the go-to brand for modern pet parents seeking premium, easy-to-serve nutrition.\n       \nWant to increase your team\'s operational efficiency and save time on payments, just like Mikala? Get in touch to find out how Mimo can help.', '1', '8', '2025-04-15 07:54:05', '752', '', '2025-04-15 08:01:36', '752', NULL, NULL, '2025-04-15 07:54:05', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Continue Reading\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/04\\/15\\/blog-9.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '2', '2', '', '', '1', '16', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('33', '191', 'Pathways to Prosperity: Modern Tactics for Scaling Your Business', 'pathways-to-prosperity-modern-tactics-for-scaling-your-business', '', 'Through World-first Climate-responsive Technology        Eco-friendly construction materials are essential in building a sustainable future. These materials, such as reclaimed wood, recycled metal, and bamboo, significantly reduce the environmental impact of construction projects. They are often sourced from renewable resources and require less energy to produce compared to traditional materials. By incorporating sustainable materials, buildings can achieve better energy efficiency and lower carbon footprints.        Additionally, eco-friendly materials can improve indoor air quality and enhance the overall health and well-being of occupants. The use of green construction materials also supports the growth of a circular economy, promoting the reuse and recycling of resources. Ultimately, adopting sustainable materials in construction is a crucial step towards a more resilient and environmentally responsible built environment.                  How to Build a Winning Business Strategy in 2025          Define Your Vision and Objectives Start by clearly articulating where you want your business to be in the next 3–5 years. Align your goals with measurable KPIs and a timeline.  Analyze the Market Landscape Conduct a SWOT analysis, evaluate competitors, and identify market opportunities. Use data-driven insights to guide decision-making.  Innovate and Differentiate Highlight your unique value proposition. Stay agile by embracing innovation and leveraging emerging technologies.  Align Teams and Resources Ensure all departments are aligned with the strategy. Communicate goals clearly and foster a culture of collaboration and accountability.  Monitor, Adapt, and Optimize Regularly review performance, gather feedback, and refine your strategy as needed. Strategic agility is crucial to staying ahead.         The outcome        By reducing time spent on financial admin, Mimo gave Mikala and her team more space to focus on what matters - building partnerships, forecasting with confidence, and driving sustainable scale.        With operations running more smoothly, Marleybones has entered an exciting new chapter: launching a new category of vet-developed supplement chews, expanding into new retail stockists, and reaching more pet parents than ever before.       \nAnd the ambition doesn’t stop there. The goal is to make Marleybones the go-to brand for modern pet parents seeking premium, easy-to-serve nutrition.\n       \nWant to increase your team\'s operational efficiency and save time on payments, just like Mikala? Get in touch to find out how Mimo can help.', '1', '8', '2025-04-15 08:03:27', '961', '', '2025-04-16 09:26:49', '961', NULL, NULL, '2025-04-15 08:03:27', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Continue Reading\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/04\\/15\\/blog-10.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '4', '1', '', '', '1', '97', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('35', '195', 'Elements Development Group is Pioneering', 'elements-development-group-is-pioneering', '', '', '1', '12', '2025-04-09 12:28:05', '752', '', '2025-04-15 08:21:40', '752', NULL, NULL, '2025-04-09 12:28:05', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Continue Reading\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/04\\/15\\/blog-1.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '2', '10', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('36', '196', 'Innovative Strategies for Growing Your Business', 'innovative-strategies-for-growing-your-business', '', '', '1', '10', '2025-04-15 06:41:30', '752', '', '2025-04-15 08:22:03', '752', NULL, NULL, '2025-04-15 06:41:30', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Continue Reading\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/04\\/15\\/blog-2.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '7', '9', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('37', '197', 'Strategies to Enhance Your Business Policies', 'strategies-to-enhance-your-business-policies', '', '', '1', '12', '2025-04-15 07:26:50', '752', '', '2025-04-15 08:21:43', '752', NULL, NULL, '2025-04-15 07:26:50', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Continue Reading\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/04\\/15\\/blog-3.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '5', '8', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('38', '198', 'Journey to Success: Innovative Strategies for Growing', 'journey-to-success-innovative-strategies-for-growing', '', '', '1', '15', '2025-04-15 07:32:44', '752', '', '2025-04-15 08:21:57', '752', NULL, NULL, '2025-04-15 07:32:44', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Continue Reading\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/04\\/15\\/blog-4.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '4', '7', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('39', '199', 'Pathway to Prosperity: Creative Approaches for Expanding', 'pathway-to-prosperity-creative-approaches-for-expanding', '', '', '1', '13', '2025-04-15 07:35:04', '752', '', '2025-04-15 08:22:11', '752', NULL, NULL, '2025-04-15 07:35:04', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Continue Reading\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/04\\/15\\/blog-5.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '4', '6', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('40', '200', 'How to Boost Your Business Policy for the Next Generation', 'how-to-boost-your-business-policy-for-the-next-generation', '', '', '1', '12', '2025-04-15 07:39:25', '752', '', '2025-04-15 08:21:47', '752', NULL, NULL, '2025-04-15 07:39:25', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Continue Reading\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/04\\/15\\/blog-6.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '4', '5', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('41', '201', 'Cool Tips for Growing Your Business', 'cool-tips-for-growing-your-business', '', '', '1', '14', '2025-04-15 07:45:37', '752', '', '2025-04-15 08:21:51', '752', NULL, NULL, '2025-04-15 07:45:37', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Continue Reading\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/04\\/15\\/blog-7.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '4', '4', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('42', '202', 'How to Increase Your Business Policy for Next Generation', 'how-to-increase-your-business-policy-for-next-generation', '', '', '1', '9', '2025-04-15 07:54:05', '752', '', '2025-04-15 08:22:08', '752', NULL, NULL, '2025-04-15 07:54:05', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Continue Reading\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/04\\/15\\/blog-9.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '3', '2', '', '', '1', '2', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('43', '203', 'Accelerate Your Growth: Proven Strategies for Business Success', 'accelerate-your-growth-proven-strategies-for-business-success', '', 'Through World-first Climate-responsive Technology        Eco-friendly construction materials are essential in building a sustainable future. These materials, such as reclaimed wood, recycled metal, and bamboo, significantly reduce the environmental impact of construction projects. They are often sourced from renewable resources and require less energy to produce compared to traditional materials. By incorporating sustainable materials, buildings can achieve better energy efficiency and lower carbon footprints.        Additionally, eco-friendly materials can improve indoor air quality and enhance the overall health and well-being of occupants. The use of green construction materials also supports the growth of a circular economy, promoting the reuse and recycling of resources. Ultimately, adopting sustainable materials in construction is a crucial step towards a more resilient and environmentally responsible built environment.                  How to Build a Winning Business Strategy in 2025          Define Your Vision and Objectives Start by clearly articulating where you want your business to be in the next 3–5 years. Align your goals with measurable KPIs and a timeline.  Analyze the Market Landscape Conduct a SWOT analysis, evaluate competitors, and identify market opportunities. Use data-driven insights to guide decision-making.  Innovate and Differentiate Highlight your unique value proposition. Stay agile by embracing innovation and leveraging emerging technologies.  Align Teams and Resources Ensure all departments are aligned with the strategy. Communicate goals clearly and foster a culture of collaboration and accountability.  Monitor, Adapt, and Optimize Regularly review performance, gather feedback, and refine your strategy as needed. Strategic agility is crucial to staying ahead.         The outcome        By reducing time spent on financial admin, Mimo gave Mikala and her team more space to focus on what matters - building partnerships, forecasting with confidence, and driving sustainable scale.        With operations running more smoothly, Marleybones has entered an exciting new chapter: launching a new category of vet-developed supplement chews, expanding into new retail stockists, and reaching more pet parents than ever before.       \nAnd the ambition doesn’t stop there. The goal is to make Marleybones the go-to brand for modern pet parents seeking premium, easy-to-serve nutrition.\n       \nWant to increase your team\'s operational efficiency and save time on payments, just like Mikala? Get in touch to find out how Mimo can help.', '1', '15', '2025-04-15 08:03:27', '961', '', '2025-04-16 09:26:11', '961', NULL, NULL, '2025-04-15 08:03:27', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Continue Reading\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/04\\/15\\/blog-10.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '5', '1', '', '', '1', '2', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('44', '204', 'Breaking Barriers: Creative Approaches to Business Expansion', 'breaking-barriers-creative-approaches-to-business-expansion', '', 'Through World-first Climate-responsive Technology        Eco-friendly construction materials are essential in building a sustainable future. These materials, such as reclaimed wood, recycled metal, and bamboo, significantly reduce the environmental impact of construction projects. They are often sourced from renewable resources and require less energy to produce compared to traditional materials. By incorporating sustainable materials, buildings can achieve better energy efficiency and lower carbon footprints.        Additionally, eco-friendly materials can improve indoor air quality and enhance the overall health and well-being of occupants. The use of green construction materials also supports the growth of a circular economy, promoting the reuse and recycling of resources. Ultimately, adopting sustainable materials in construction is a crucial step towards a more resilient and environmentally responsible built environment.                  How to Build a Winning Business Strategy in 2025          Define Your Vision and Objectives Start by clearly articulating where you want your business to be in the next 3–5 years. Align your goals with measurable KPIs and a timeline.  Analyze the Market Landscape Conduct a SWOT analysis, evaluate competitors, and identify market opportunities. Use data-driven insights to guide decision-making.  Innovate and Differentiate Highlight your unique value proposition. Stay agile by embracing innovation and leveraging emerging technologies.  Align Teams and Resources Ensure all departments are aligned with the strategy. Communicate goals clearly and foster a culture of collaboration and accountability.  Monitor, Adapt, and Optimize Regularly review performance, gather feedback, and refine your strategy as needed. Strategic agility is crucial to staying ahead.         The outcome        By reducing time spent on financial admin, Mimo gave Mikala and her team more space to focus on what matters - building partnerships, forecasting with confidence, and driving sustainable scale.        With operations running more smoothly, Marleybones has entered an exciting new chapter: launching a new category of vet-developed supplement chews, expanding into new retail stockists, and reaching more pet parents than ever before.       \nAnd the ambition doesn’t stop there. The goal is to make Marleybones the go-to brand for modern pet parents seeking premium, easy-to-serve nutrition.\n       \nWant to increase your team\'s operational efficiency and save time on payments, just like Mikala? Get in touch to find out how Mimo can help.', '1', '11', '2025-04-15 07:49:43', '961', '', '2025-04-16 09:26:33', '961', NULL, NULL, '2025-04-15 07:49:43', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"Continue Reading\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2025\\/04\\/15\\/blog-8.jpg\",\"helix_ultimate_image_alt_txt\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', '4', '3', '', '', '1', '0', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', '');
/**ABDB**/CREATE TABLE `#__content_frontpage` (
  `content_id` int NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  `featured_up` datetime DEFAULT NULL,
  `featured_down` datetime DEFAULT NULL,
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__content_rating` (
  `content_id` int NOT NULL DEFAULT '0',
  `rating_sum` int unsigned NOT NULL DEFAULT '0',
  `rating_count` int unsigned NOT NULL DEFAULT '0',
  `lastip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__content_rating`  VALUES 
('1', '5', '1', '::1'),
('3', '5', '1', '::1'),
('9', '5', '1', '10.0.1.2');
/**ABDB**/CREATE TABLE `#__content_types` (
  `type_id` int unsigned NOT NULL AUTO_INCREMENT,
  `type_title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type_alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `table` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `rules` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_mappings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `router` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content_history_options` varchar(5120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'JSON string for com_contenthistory options',
  PRIMARY KEY (`type_id`),
  KEY `idx_alias` (`type_alias`(100))
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__content_types`  VALUES 
('1', 'Article', 'com_content.article', '{\"special\":{\"dbtable\":\"#__content\",\"key\":\"id\",\"type\":\"ArticleTable\",\"prefix\":\"Joomla\\\\Component\\\\Content\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"state\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"introtext\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"attribs\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"asset_id\", \"note\":\"note\"}, \"special\":{\"fulltext\":\"fulltext\"}}', 'ContentHelperRoute::getArticleRoute', '{\"formFile\":\"administrator\\/components\\/com_content\\/models\\/forms\\/article.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
('2', 'Contact', 'com_contact.contact', '{\"special\":{\"dbtable\":\"#__contact_details\",\"key\":\"id\",\"type\":\"ContactTable\",\"prefix\":\"Joomla\\\\Component\\\\Contact\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"address\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"image\", \"core_urls\":\"webpage\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\":{\"con_position\":\"con_position\",\"suburb\":\"suburb\",\"state\":\"state\",\"country\":\"country\",\"postcode\":\"postcode\",\"telephone\":\"telephone\",\"fax\":\"fax\",\"misc\":\"misc\",\"email_to\":\"email_to\",\"default_con\":\"default_con\",\"user_id\":\"user_id\",\"mobile\":\"mobile\",\"sortname1\":\"sortname1\",\"sortname2\":\"sortname2\",\"sortname3\":\"sortname3\"}}', 'ContactHelperRoute::getContactRoute', '{\"formFile\":\"administrator\\/components\\/com_contact\\/models\\/forms\\/contact.xml\",\"hideFields\":[\"default_con\",\"checked_out\",\"checked_out_time\",\"version\",\"xreference\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"], \"displayLookup\":[ {\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ] }'),
('3', 'Newsfeed', 'com_newsfeeds.newsfeed', '{\"special\":{\"dbtable\":\"#__newsfeeds\",\"key\":\"id\",\"type\":\"NewsfeedTable\",\"prefix\":\"Joomla\\\\Component\\\\Newsfeeds\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\":{\"numarticles\":\"numarticles\",\"cache_time\":\"cache_time\",\"rtl\":\"rtl\"}}', 'NewsfeedsHelperRoute::getNewsfeedRoute', '{\"formFile\":\"administrator\\/components\\/com_newsfeeds\\/models\\/forms\\/newsfeed.xml\",\"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
('4', 'User', 'com_users.user', '{\"special\":{\"dbtable\":\"#__users\",\"key\":\"id\",\"type\":\"UserTable\",\"prefix\":\"Joomla\\\\Component\\\\Users\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"null\",\"core_alias\":\"username\",\"core_created_time\":\"registerDate\",\"core_modified_time\":\"null\",\"core_body\":\"null\", \"core_hits\":\"null\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"access\":\"null\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"null\", \"core_language\":\"null\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"null\", \"core_ordering\":\"null\", \"core_metakey\":\"null\", \"core_metadesc\":\"null\", \"core_catid\":\"null\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{}}', '', ''),
('5', 'Article Category', 'com_content.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContentHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
('6', 'Contact Category', 'com_contact.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContactHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
('7', 'Newsfeeds Category', 'com_newsfeeds.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'NewsfeedsHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
('8', 'Tag', 'com_tags.tag', '{\"special\":{\"dbtable\":\"#__tags\",\"key\":\"tag_id\",\"type\":\"TagTable\",\"prefix\":\"Joomla\\\\Component\\\\Tags\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"null\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\"}}', 'TagsHelperRoute::getTagRoute', '{\"formFile\":\"administrator\\/components\\/com_tags\\/models\\/forms\\/tag.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"lft\", \"rgt\", \"level\", \"path\", \"urls\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'),
('9', 'Banner', 'com_banners.banner', '{\"special\":{\"dbtable\":\"#__banners\",\"key\":\"id\",\"type\":\"BannerTable\",\"prefix\":\"Joomla\\\\Component\\\\Banners\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"null\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{\"imptotal\":\"imptotal\", \"impmade\":\"impmade\", \"clicks\":\"clicks\", \"clickurl\":\"clickurl\", \"custombannercode\":\"custombannercode\", \"cid\":\"cid\", \"purchase_type\":\"purchase_type\", \"track_impressions\":\"track_impressions\", \"track_clicks\":\"track_clicks\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_banners\\/models\\/forms\\/banner.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"reset\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"imptotal\", \"impmade\", \"reset\"], \"convertToInt\":[\"publish_up\", \"publish_down\", \"ordering\"], \"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"cid\",\"targetTable\":\"#__banner_clients\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
('10', 'Banners Category', 'com_banners.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\": {\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"], \"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
('11', 'Banner Client', 'com_banners.client', '{\"special\":{\"dbtable\":\"#__banner_clients\",\"key\":\"id\",\"type\":\"ClientTable\",\"prefix\":\"Joomla\\\\Component\\\\Banners\\\\Administrator\\\\Table\\\\\"}}', '', '', '', '{\"formFile\":\"administrator\\/components\\/com_banners\\/models\\/forms\\/client.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\"], \"ignoreChanges\":[\"checked_out\", \"checked_out_time\"], \"convertToInt\":[], \"displayLookup\":[]}'),
('12', 'User Notes', 'com_users.note', '{\"special\":{\"dbtable\":\"#__user_notes\",\"key\":\"id\",\"type\":\"NoteTable\",\"prefix\":\"Joomla\\\\Component\\\\Users\\\\Administrator\\\\Table\\\\\"}}', '', '', '', '{\"formFile\":\"administrator\\/components\\/com_users\\/models\\/forms\\/note.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\"], \"convertToInt\":[\"publish_up\", \"publish_down\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'),
('13', 'User Notes Category', 'com_users.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"], \"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
('14', 'SP Easy Image Gallery Category', 'com_speasyimagegallery.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"JTable\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"JTable\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContactHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator/components/com_categories/models/forms/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}');/**ABDB**/
/**ABDB**/CREATE TABLE `#__contentitem_tag_map` (
  `type_alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_content_id` int unsigned NOT NULL COMMENT 'PK from the core content table',
  `content_item_id` int NOT NULL COMMENT 'PK from the content type table',
  `tag_id` int unsigned NOT NULL COMMENT 'PK from the tag table',
  `tag_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Date of most recent save for this tag-item',
  `type_id` mediumint NOT NULL COMMENT 'PK from the content_type table',
  UNIQUE KEY `uc_ItemnameTagid` (`type_id`,`content_item_id`,`tag_id`),
  KEY `idx_tag_type` (`tag_id`,`type_id`),
  KEY `idx_date_id` (`tag_date`,`tag_id`),
  KEY `idx_core_content_id` (`core_content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Maps items from content tables to tags';
/**ABDB**/CREATE TABLE `#__extensions` (
  `extension_id` int NOT NULL AUTO_INCREMENT,
  `package_id` int NOT NULL DEFAULT '0' COMMENT 'Parent package ID for extensions installed as a package.',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `element` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `changelogurl` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `folder` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` tinyint NOT NULL,
  `enabled` tinyint NOT NULL DEFAULT '0',
  `access` int unsigned NOT NULL DEFAULT '1',
  `protected` tinyint NOT NULL DEFAULT '0' COMMENT 'Flag to indicate if the extension is protected. Protected extensions cannot be disabled.',
  `manifest_cache` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int DEFAULT '0',
  `state` int DEFAULT '0',
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `locked` tinyint NOT NULL DEFAULT '0' COMMENT 'Flag to indicate if the extension is locked. Locked extensions cannot be uninstalled.',
  PRIMARY KEY (`extension_id`),
  KEY `element_clientid` (`element`,`client_id`),
  KEY `element_folder_clientid` (`element`,`folder`,`client_id`),
  KEY `extension` (`type`,`element`,`folder`,`client_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10155 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__extensions`  VALUES 
('2', '0', 'com_wrapper', 'component', 'com_wrapper', '', '', '1', '1', '1', '0', '{\"name\":\"com_wrapper\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Wrapper\",\"filename\":\"wrapper\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('3', '0', 'com_admin', 'component', 'com_admin', '', '', '1', '1', '1', '1', '{\"name\":\"com_admin\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_ADMIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Admin\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('4', '0', 'com_banners', 'component', 'com_banners', '', '', '1', '1', '1', '0', '{\"name\":\"com_banners\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Banners\",\"filename\":\"banners\"}', '{\"purchase_type\":\"3\",\"track_impressions\":\"0\",\"track_clicks\":\"0\",\"metakey_prefix\":\"\",\"save_history\":\"1\",\"history_limit\":10}', '', NULL, NULL, '0', '0', NULL, '1'),
('5', '0', 'com_cache', 'component', 'com_cache', '', '', '1', '1', '1', '1', '{\"name\":\"com_cache\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CACHE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Cache\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('6', '0', 'com_categories', 'component', 'com_categories', '', '', '1', '1', '1', '1', '{\"name\":\"com_categories\",\"type\":\"component\",\"creationDate\":\"2007-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Categories\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('7', '0', 'com_checkin', 'component', 'com_checkin', '', '', '1', '1', '1', '1', '{\"name\":\"com_checkin\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CHECKIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Checkin\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('8', '0', 'com_contact', 'component', 'com_contact', '', '', '1', '1', '1', '0', '{\"name\":\"com_contact\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Contact\",\"filename\":\"contact\"}', '{\"contact_layout\":\"_:default\",\"show_contact_category\":\"hide\",\"save_history\":\"1\",\"history_limit\":10,\"show_contact_list\":\"0\",\"presentation_style\":\"plain\",\"show_tags\":\"1\",\"show_info\":\"1\",\"show_name\":\"0\",\"show_position\":\"1\",\"show_email\":\"0\",\"add_mailto_link\":\"1\",\"show_street_address\":\"1\",\"show_suburb\":\"1\",\"show_state\":\"1\",\"show_postcode\":\"1\",\"show_country\":\"1\",\"show_telephone\":\"1\",\"show_mobile\":\"1\",\"show_fax\":\"1\",\"show_webpage\":\"1\",\"show_image\":\"1\",\"image\":\"\",\"show_misc\":\"1\",\"allow_vcard\":\"0\",\"show_articles\":\"0\",\"articles_display_num\":\"10\",\"show_profile\":\"0\",\"show_user_custom_fields\":[\"-1\"],\"show_links\":\"0\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"contact_icons\":\"0\",\"icon_address\":\"\",\"icon_email\":\"\",\"icon_telephone\":\"\",\"icon_mobile\":\"\",\"icon_fax\":\"\",\"icon_misc\":\"\",\"category_layout\":\"_:default\",\"show_category_title\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"0\",\"maxLevel\":\"-1\",\"show_subcat_desc\":\"1\",\"show_empty_categories\":\"0\",\"show_cat_items\":\"1\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_subcat_desc_cat\":\"1\",\"show_empty_categories_cat\":\"0\",\"show_cat_items_cat\":\"1\",\"filter_field\":\"0\",\"show_pagination_limit\":\"0\",\"show_headings\":\"1\",\"show_image_heading\":\"0\",\"show_position_headings\":\"1\",\"show_email_headings\":\"0\",\"show_telephone_headings\":\"1\",\"show_mobile_headings\":\"0\",\"show_fax_headings\":\"0\",\"show_suburb_headings\":\"1\",\"show_state_headings\":\"1\",\"show_country_headings\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"initial_sort\":\"ordering\",\"captcha\":\"\",\"show_email_form\":\"1\",\"show_email_copy\":\"0\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"1\",\"custom_reply\":\"0\",\"redirect\":\"\",\"show_feed_link\":\"1\",\"sef_advanced\":0,\"sef_ids\":0,\"custom_fields_enable\":\"1\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('9', '0', 'com_cpanel', 'component', 'com_cpanel', '', '', '1', '1', '1', '1', '{\"name\":\"com_cpanel\",\"type\":\"component\",\"creationDate\":\"2007-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CPANEL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Cpanel\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('10', '0', 'com_installer', 'component', 'com_installer', '', '', '1', '1', '1', '1', '{\"name\":\"com_installer\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_INSTALLER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Installer\"}', '{\"show_jed_info\":\"1\",\"cachetimeout\":\"6\",\"minimum_stability\":\"4\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('11', '0', 'com_languages', 'component', 'com_languages', '', '', '1', '1', '1', '1', '{\"name\":\"com_languages\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Languages\"}', '{\"administrator\":\"en-GB\",\"site\":\"en-GB\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('12', '0', 'com_login', 'component', 'com_login', '', '', '1', '1', '1', '1', '{\"name\":\"com_login\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Login\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('13', '0', 'com_media', 'component', 'com_media', '', '', '1', '1', '0', '1', '{\"name\":\"com_media\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Media\",\"filename\":\"media\"}', '{\"upload_maxsize\":\"30\",\"file_path\":\"images\",\"image_path\":\"images\",\"restrict_uploads\":\"1\",\"restrict_uploads_extensions\":\"bmp,gif,jpg,jpeg,png,webp,ico,mp3,mp4,odg,odp,ods,odt,pdf,png,ppt,txt,xcf,xls,csv\",\"check_mime\":\"1\",\"image_extensions\":\"bmp,gif,jpg,png\",\"audio_extensions\":\"mp3,m4a,mp4a,ogg\",\"video_extensions\":\"mp4,mp4v,mpeg,mov,webm\",\"doc_extensions\":\"doc,odg,odp,ods,odt,pdf,ppt,txt,xcf,xls,csv\",\"ignore_extensions\":\"\",\"upload_mime\":\"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp,application\\/msword,application\\/excel,application\\/pdf,application\\/powerpoint,text\\/plain,application\\/x-zip\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('14', '0', 'com_menus', 'component', 'com_menus', '', '', '1', '1', '1', '1', '{\"name\":\"com_menus\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MENUS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Menus\",\"filename\":\"menus\"}', '{\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('15', '0', 'com_messages', 'component', 'com_messages', '', '', '1', '1', '1', '1', '{\"name\":\"com_messages\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Messages\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('16', '0', 'com_modules', 'component', 'com_modules', '', '', '1', '1', '1', '1', '{\"name\":\"com_modules\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MODULES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Modules\",\"filename\":\"modules\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('17', '0', 'com_newsfeeds', 'component', 'com_newsfeeds', '', '', '1', '1', '1', '0', '{\"name\":\"com_newsfeeds\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Newsfeeds\",\"filename\":\"newsfeeds\"}', '{\"newsfeed_layout\":\"_:default\",\"save_history\":\"1\",\"history_limit\":5,\"show_feed_image\":\"1\",\"show_feed_description\":\"1\",\"show_item_description\":\"1\",\"feed_character_count\":\"0\",\"feed_display_order\":\"des\",\"float_first\":\"right\",\"float_second\":\"right\",\"show_tags\":\"1\",\"category_layout\":\"_:default\",\"show_category_title\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"1\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"0\",\"show_subcat_desc\":\"1\",\"show_cat_items\":\"1\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_items_cat\":\"1\",\"filter_field\":\"1\",\"show_pagination_limit\":\"1\",\"show_headings\":\"1\",\"show_articles\":\"0\",\"show_link\":\"1\",\"show_pagination\":\"1\",\"show_pagination_results\":\"1\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('18', '0', 'com_plugins', 'component', 'com_plugins', '', '', '1', '1', '1', '1', '{\"name\":\"com_plugins\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_PLUGINS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Plugins\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('19', '10067', 'com_search', 'component', 'com_search', '', '', '1', '0', '1', '0', '{\"name\":\"com_search\",\"type\":\"component\",\"creationDate\":\"17.06.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0-dev\",\"description\":\"\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"search\"}', '{\"enabled\":\"0\",\"search_phrases\":\"1\",\"search_areas\":\"1\",\"show_date\":\"1\",\"opensearch_name\":\"\",\"opensearch_description\":\"\"}', '', NULL, NULL, '0', '0', NULL, '0'),
('20', '0', 'com_templates', 'component', 'com_templates', '', '', '1', '1', '1', '1', '{\"name\":\"com_templates\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Templates\"}', '{\"template_positions_display\":\"0\",\"upload_limit\":\"10\",\"image_formats\":\"gif,bmp,jpg,jpeg,png\",\"source_formats\":\"txt,less,ini,xml,js,php,css,scss,sass\",\"font_formats\":\"woff,ttf,otf\",\"compressed_formats\":\"zip\",\"difference\":\"SideBySide\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('22', '0', 'com_content', 'component', 'com_content', '', '', '1', '1', '0', '1', '{\"name\":\"com_content\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Content\",\"filename\":\"content\"}', '{\"article_layout\":\"_:default\",\"show_title\":\"1\",\"link_titles\":\"1\",\"show_intro\":\"1\",\"info_block_position\":\"0\",\"info_block_show_title\":\"1\",\"show_category\":\"1\",\"link_category\":\"1\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_associations\":\"0\",\"flags\":\"1\",\"show_author\":\"1\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"1\",\"show_item_navigation\":\"1\",\"show_vote\":\"0\",\"show_readmore\":\"1\",\"show_readmore_title\":\"0\",\"readmore_limit\":100,\"show_tags\":\"1\",\"record_hits\":\"1\",\"show_hits\":\"0\",\"show_noauth\":\"0\",\"urls_position\":0,\"captcha\":\"\",\"show_publishing_options\":\"1\",\"show_article_options\":\"1\",\"show_configure_edit_options\":\"1\",\"show_permissions\":\"1\",\"show_associations_edit\":\"1\",\"save_history\":\"1\",\"history_limit\":10,\"show_urls_images_frontend\":\"0\",\"show_urls_images_backend\":\"1\",\"targeta\":0,\"targetb\":0,\"targetc\":0,\"float_intro\":\"left\",\"float_fulltext\":\"left\",\"category_layout\":\"_:blog\",\"show_category_title\":\"0\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"1\",\"show_empty_categories\":\"0\",\"show_no_articles\":\"1\",\"show_category_heading_title_text\":\"1\",\"show_subcat_desc\":\"1\",\"show_cat_num_articles\":\"0\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_num_articles_cat\":\"1\",\"num_leading_articles\":1,\"blog_class_leading\":\"\",\"num_intro_articles\":4,\"blog_class\":\"\",\"num_columns\":2,\"multi_column_order\":\"0\",\"num_links\":4,\"show_subcategory_content\":\"0\",\"link_intro_image\":\"0\",\"show_pagination_limit\":\"1\",\"filter_field\":\"hide\",\"show_headings\":\"1\",\"list_show_date\":\"0\",\"date_format\":\"\",\"list_show_hits\":\"1\",\"list_show_author\":\"1\",\"display_num\":\"10\",\"list_show_votes\":\"0\",\"list_show_ratings\":\"0\",\"orderby_pri\":\"order\",\"orderby_sec\":\"rdate\",\"order_date\":\"published\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"show_featured\":\"show\",\"show_feed_link\":\"1\",\"feed_summary\":\"0\",\"feed_show_readmore\":\"0\",\"sef_ids\":1,\"custom_fields_enable\":\"1\",\"workflow_enabled\":\"0\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('23', '0', 'com_config', 'component', 'com_config', '', '', '1', '1', '0', '1', '{\"name\":\"com_config\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONFIG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Config\",\"filename\":\"config\"}', '{\"filters\":{\"1\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"9\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"6\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"7\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"2\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"3\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"4\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"5\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"8\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"}}}', '', NULL, NULL, '0', '0', NULL, '1'),
('24', '0', 'com_redirect', 'component', 'com_redirect', '', '', '1', '1', '0', '0', '{\"name\":\"com_redirect\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Redirect\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('25', '0', 'com_users', 'component', 'com_users', '', '', '1', '1', '0', '1', '{\"name\":\"com_users\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_USERS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Users\",\"filename\":\"users\"}', '{\"allowUserRegistration\":\"1\",\"new_usertype\":\"2\",\"guest_usergroup\":\"9\",\"sendpassword\":\"1\",\"useractivation\":\"2\",\"mail_to_admin\":\"1\",\"captcha\":\"\",\"frontend_userparams\":\"1\",\"site_language\":\"0\",\"change_login_name\":\"0\",\"enforce_2fa_options\":0,\"domains\":[],\"reset_count\":10,\"reset_time\":1,\"minimum_length\":12,\"minimum_integers\":0,\"minimum_symbols\":0,\"minimum_uppercase\":0,\"minimum_lowercase\":0,\"save_history\":\"1\",\"history_limit\":5,\"mailSubjectPrefix\":\"\",\"mailBodySuffix\":\"\",\"custom_fields_enable\":\"1\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('27', '0', 'com_finder', 'component', 'com_finder', '', '', '1', '1', '0', '0', '{\"name\":\"com_finder\",\"type\":\"component\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Finder\",\"filename\":\"finder\"}', '{\"word_match\":\"fuzzy\",\"show_taxonomy\":\"1\",\"show_description\":\"1\",\"description_length\":255,\"show_image\":\"1\",\"image_class\":\"\",\"link_image\":\"1\",\"show_date\":\"1\",\"show_url\":\"1\",\"gather_search_statistics\":\"0\",\"allow_empty_query\":\"0\",\"show_autosuggest\":\"1\",\"show_suggested_query\":\"1\",\"show_explained_query\":\"1\",\"show_advanced\":\"1\",\"show_advanced_tips\":\"1\",\"expand_advanced\":\"0\",\"show_date_filters\":\"0\",\"sort_order\":\"relevance\",\"sort_direction\":\"desc\",\"highlight_terms\":\"1\",\"opensearch\":\"1\",\"opensearch_name\":\"\",\"opensearch_description\":\"\",\"tuplecount\":\"1\",\"batch_size\":\"50\",\"title_multiplier\":\"1.7\",\"text_multiplier\":\"0.7\",\"meta_multiplier\":\"1.2\",\"path_multiplier\":\"2\",\"misc_multiplier\":\"0.3\",\"enable_logging\":\"0\",\"language_default\":\"\",\"filter_commonwords\":\"0\",\"filter_numerics\":\"0\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('28', '0', 'com_joomlaupdate', 'component', 'com_joomlaupdate', '', '', '1', '1', '0', '1', '{\"name\":\"com_joomlaupdate\",\"type\":\"component\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2012 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.3\",\"description\":\"COM_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Joomlaupdate\"}', '{\"updatesource\":\"default\",\"minimum_stability\":\"4\",\"customurl\":\"\",\"versioncheck\":\"1\",\"backupcheck\":\"1\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('29', '0', 'com_tags', 'component', 'com_tags', '', '', '1', '1', '1', '0', '{\"name\":\"com_tags\",\"type\":\"component\",\"creationDate\":\"2013-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Tags\",\"filename\":\"tags\"}', '{\"tag_layout\":\"_:default\",\"save_history\":\"1\",\"history_limit\":5,\"show_tag_title\":\"0\",\"tag_list_show_tag_image\":\"0\",\"tag_list_show_tag_description\":\"0\",\"tag_list_image\":\"\",\"tag_list_orderby\":\"title\",\"tag_list_orderby_direction\":\"ASC\",\"show_headings\":\"0\",\"tag_list_show_date\":\"0\",\"tag_list_show_item_image\":\"0\",\"tag_list_show_item_description\":\"0\",\"tag_list_item_maximum_characters\":0,\"return_any_or_all\":\"1\",\"include_children\":\"0\",\"maximum\":200,\"tag_list_language_filter\":\"all\",\"tags_layout\":\"_:default\",\"all_tags_orderby\":\"title\",\"all_tags_orderby_direction\":\"ASC\",\"all_tags_show_tag_image\":\"0\",\"all_tags_show_tag_descripion\":\"0\",\"all_tags_tag_maximum_characters\":20,\"all_tags_show_tag_hits\":\"0\",\"filter_field\":\"1\",\"show_pagination_limit\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"tag_field_ajax_mode\":\"1\",\"show_feed_link\":\"1\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('30', '0', 'com_contenthistory', 'component', 'com_contenthistory', '', '', '1', '1', '1', '0', '{\"name\":\"com_contenthistory\",\"type\":\"component\",\"creationDate\":\"2013-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONTENTHISTORY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Contenthistory\",\"filename\":\"contenthistory\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('31', '0', 'com_ajax', 'component', 'com_ajax', '', '', '1', '1', '1', '1', '{\"name\":\"com_ajax\",\"type\":\"component\",\"creationDate\":\"2013-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_AJAX_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"ajax\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('32', '0', 'com_postinstall', 'component', 'com_postinstall', '', '', '1', '1', '1', '1', '{\"name\":\"com_postinstall\",\"type\":\"component\",\"creationDate\":\"2013-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_POSTINSTALL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Postinstall\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('33', '0', 'com_fields', 'component', 'com_fields', '', '', '1', '1', '1', '0', '{\"name\":\"com_fields\",\"type\":\"component\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Fields\",\"filename\":\"fields\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('34', '0', 'com_associations', 'component', 'com_associations', '', '', '1', '1', '1', '0', '{\"name\":\"com_associations\",\"type\":\"component\",\"creationDate\":\"2017-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_ASSOCIATIONS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Associations\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('35', '0', 'com_privacy', 'component', 'com_privacy', '', '', '1', '1', '1', '0', '{\"name\":\"com_privacy\",\"type\":\"component\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"COM_PRIVACY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Privacy\",\"filename\":\"privacy\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('36', '0', 'com_actionlogs', 'component', 'com_actionlogs', '', '', '1', '1', '1', '0', '{\"name\":\"com_actionlogs\",\"type\":\"component\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"COM_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Actionlogs\"}', '{\"ip_logging\":0,\"csv_delimiter\":\",\",\"loggable_extensions\":[\"com_banners\",\"com_cache\",\"com_categories\",\"com_checkin\",\"com_config\",\"com_contact\",\"com_content\",\"com_installer\",\"com_media\",\"com_menus\",\"com_messages\",\"com_modules\",\"com_newsfeeds\",\"com_plugins\",\"com_redirect\",\"com_tags\",\"com_templates\",\"com_users\"]}', '', NULL, NULL, '0', '0', NULL, '1'),
('103', '0', 'lib_joomla', 'library', 'joomla', '', '', '0', '1', '1', '1', '{\"name\":\"lib_joomla\",\"type\":\"library\",\"creationDate\":\"2008-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2008 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"https:\\/\\/www.joomla.org\",\"version\":\"13.1\",\"description\":\"LIB_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"joomla\"}', '{\"mediaversion\":\"5b48938d5512868fb4ba7a6f12811b7a\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('106', '0', 'lib_phpass', 'library', 'phpass', '', '', '0', '1', '1', '1', '{\"name\":\"lib_phpass\",\"type\":\"library\",\"creationDate\":\"2004-01\",\"author\":\"Solar Designer\",\"copyright\":\"\",\"authorEmail\":\"solar@openwall.com\",\"authorUrl\":\"https:\\/\\/www.openwall.com\\/phpass\\/\",\"version\":\"0.3\",\"description\":\"LIB_PHPASS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"phpass\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('200', '0', 'mod_articles_archive', 'module', 'mod_articles_archive', '', '', '0', '1', '1', '0', '{\"name\":\"mod_articles_archive\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesArchive\",\"filename\":\"mod_articles_archive\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('201', '0', 'mod_articles_latest', 'module', 'mod_articles_latest', '', '', '0', '1', '1', '0', '{\"name\":\"mod_articles_latest\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesLatest\",\"filename\":\"mod_articles_latest\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('202', '0', 'mod_articles_popular', 'module', 'mod_articles_popular', '', '', '0', '1', '1', '0', '{\"name\":\"mod_articles_popular\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesPopular\",\"filename\":\"mod_articles_popular\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('203', '0', 'mod_banners', 'module', 'mod_banners', '', '', '0', '1', '1', '0', '{\"name\":\"mod_banners\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Banners\",\"filename\":\"mod_banners\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('204', '0', 'mod_breadcrumbs', 'module', 'mod_breadcrumbs', '', '', '0', '1', '1', '0', '{\"name\":\"mod_breadcrumbs\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BREADCRUMBS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Breadcrumbs\",\"filename\":\"mod_breadcrumbs\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('205', '0', 'mod_custom', 'module', 'mod_custom', '', '', '0', '1', '1', '0', '{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Custom\",\"filename\":\"mod_custom\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('206', '0', 'mod_feed', 'module', 'mod_feed', '', '', '0', '1', '1', '0', '{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"2005-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Feed\",\"filename\":\"mod_feed\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('207', '0', 'mod_footer', 'module', 'mod_footer', '', '', '0', '1', '1', '0', '{\"name\":\"mod_footer\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FOOTER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Footer\",\"filename\":\"mod_footer\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('208', '0', 'mod_login', 'module', 'mod_login', '', '', '0', '1', '1', '0', '{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Login\",\"filename\":\"mod_login\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('209', '0', 'mod_menu', 'module', 'mod_menu', '', '', '0', '1', '1', '0', '{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Menu\",\"filename\":\"mod_menu\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('210', '0', 'mod_articles_news', 'module', 'mod_articles_news', '', '', '0', '1', '1', '0', '{\"name\":\"mod_articles_news\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesNews\",\"filename\":\"mod_articles_news\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('211', '0', 'mod_random_image', 'module', 'mod_random_image', '', '', '0', '1', '1', '0', '{\"name\":\"mod_random_image\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RANDOM_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\RandomImage\",\"filename\":\"mod_random_image\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('212', '0', 'mod_related_items', 'module', 'mod_related_items', '', '', '0', '1', '1', '0', '{\"name\":\"mod_related_items\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RELATED_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\RelatedItems\",\"filename\":\"mod_related_items\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('213', '10067', 'mod_search', 'module', 'mod_search', '', '', '0', '0', '1', '0', '{\"name\":\"mod_search\",\"type\":\"module\",\"creationDate\":\"17.08.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0-dev\",\"description\":\"\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"mod_search\"}', '', '', NULL, NULL, '0', '0', NULL, '0'),
('214', '0', 'mod_stats', 'module', 'mod_stats', '', '', '0', '1', '1', '0', '{\"name\":\"mod_stats\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Stats\",\"filename\":\"mod_stats\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('215', '0', 'mod_syndicate', 'module', 'mod_syndicate', '', '', '0', '1', '1', '0', '{\"name\":\"mod_syndicate\",\"type\":\"module\",\"creationDate\":\"2006-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SYNDICATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Syndicate\",\"filename\":\"mod_syndicate\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('216', '0', 'mod_users_latest', 'module', 'mod_users_latest', '', '', '0', '1', '1', '0', '{\"name\":\"mod_users_latest\",\"type\":\"module\",\"creationDate\":\"2009-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_USERS_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\UsersLatest\",\"filename\":\"mod_users_latest\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('218', '0', 'mod_whosonline', 'module', 'mod_whosonline', '', '', '0', '1', '1', '0', '{\"name\":\"mod_whosonline\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WHOSONLINE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Whosonline\",\"filename\":\"mod_whosonline\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('219', '0', 'mod_wrapper', 'module', 'mod_wrapper', '', '', '0', '1', '1', '0', '{\"name\":\"mod_wrapper\",\"type\":\"module\",\"creationDate\":\"2004-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Wrapper\",\"filename\":\"mod_wrapper\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('220', '0', 'mod_articles_category', 'module', 'mod_articles_category', '', '', '0', '1', '1', '0', '{\"name\":\"mod_articles_category\",\"type\":\"module\",\"creationDate\":\"2010-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesCategory\",\"filename\":\"mod_articles_category\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('221', '0', 'mod_articles_categories', 'module', 'mod_articles_categories', '', '', '0', '1', '1', '0', '{\"name\":\"mod_articles_categories\",\"type\":\"module\",\"creationDate\":\"2010-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesCategories\",\"filename\":\"mod_articles_categories\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('222', '0', 'mod_languages', 'module', 'mod_languages', '', '', '0', '1', '1', '0', '{\"name\":\"mod_languages\",\"type\":\"module\",\"creationDate\":\"2010-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"MOD_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Languages\",\"filename\":\"mod_languages\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('223', '0', 'mod_finder', 'module', 'mod_finder', '', '', '0', '1', '0', '0', '{\"name\":\"mod_finder\",\"type\":\"module\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Finder\",\"filename\":\"mod_finder\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('227', '0', 'files_joomla', 'file', 'joomla', '', '', '0', '1', '1', '1', '{\"name\":\"files_joomla\",\"type\":\"file\",\"creationDate\":\"2025-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.3.0\",\"description\":\"FILES_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('300', '0', 'mod_custom', 'module', 'mod_custom', '', '', '1', '1', '1', '0', '{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Custom\",\"filename\":\"mod_custom\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('301', '0', 'mod_feed', 'module', 'mod_feed', '', '', '1', '1', '1', '0', '{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"2005-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Feed\",\"filename\":\"mod_feed\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('302', '0', 'mod_latest', 'module', 'mod_latest', '', '', '1', '1', '1', '0', '{\"name\":\"mod_latest\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Latest\",\"filename\":\"mod_latest\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('303', '0', 'mod_logged', 'module', 'mod_logged', '', '', '1', '1', '1', '0', '{\"name\":\"mod_logged\",\"type\":\"module\",\"creationDate\":\"2005-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGGED_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Logged\",\"filename\":\"mod_logged\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('304', '0', 'mod_login', 'module', 'mod_login', '', '', '1', '1', '1', '0', '{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"2005-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Login\",\"filename\":\"mod_login\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('305', '0', 'mod_menu', 'module', 'mod_menu', '', '', '1', '1', '1', '0', '{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"2006-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Menu\",\"filename\":\"mod_menu\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('307', '0', 'mod_popular', 'module', 'mod_popular', '', '', '1', '1', '1', '0', '{\"name\":\"mod_popular\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Popular\",\"filename\":\"mod_popular\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('308', '0', 'mod_quickicon', 'module', 'mod_quickicon', '', '', '1', '1', '1', '0', '{\"name\":\"mod_quickicon\",\"type\":\"module\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_QUICKICON_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Quickicon\",\"filename\":\"mod_quickicon\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('311', '0', 'mod_title', 'module', 'mod_title', '', '', '1', '1', '1', '0', '{\"name\":\"mod_title\",\"type\":\"module\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TITLE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Title\",\"filename\":\"mod_title\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('312', '0', 'mod_toolbar', 'module', 'mod_toolbar', '', '', '1', '1', '1', '0', '{\"name\":\"mod_toolbar\",\"type\":\"module\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TOOLBAR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Toolbar\",\"filename\":\"mod_toolbar\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('313', '0', 'mod_multilangstatus', 'module', 'mod_multilangstatus', '', '', '1', '1', '1', '0', '{\"name\":\"mod_multilangstatus\",\"type\":\"module\",\"creationDate\":\"2011-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MULTILANGSTATUS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\MultilangStatus\",\"filename\":\"mod_multilangstatus\"}', '{\"cache\":\"0\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('314', '0', 'mod_version', 'module', 'mod_version', '', '', '1', '1', '1', '0', '{\"name\":\"mod_version\",\"type\":\"module\",\"creationDate\":\"2012-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2012 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_VERSION_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Version\",\"filename\":\"mod_version\"}', '{\"format\":\"short\",\"product\":\"1\",\"cache\":\"0\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('315', '0', 'mod_stats_admin', 'module', 'mod_stats_admin', '', '', '1', '1', '1', '0', '{\"name\":\"mod_stats_admin\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\StatsAdmin\",\"filename\":\"mod_stats_admin\"}', '{\"serverinfo\":\"0\",\"siteinfo\":\"0\",\"counter\":\"0\",\"increase\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('316', '0', 'mod_tags_popular', 'module', 'mod_tags_popular', '', '', '0', '1', '1', '0', '{\"name\":\"mod_tags_popular\",\"type\":\"module\",\"creationDate\":\"2013-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\TagsPopular\",\"filename\":\"mod_tags_popular\"}', '{\"maximum\":\"5\",\"timeframe\":\"alltime\",\"owncache\":\"1\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('317', '0', 'mod_tags_similar', 'module', 'mod_tags_similar', '', '', '0', '1', '1', '0', '{\"name\":\"mod_tags_similar\",\"type\":\"module\",\"creationDate\":\"2013-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_SIMILAR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\TagsSimilar\",\"filename\":\"mod_tags_similar\"}', '{\"maximum\":\"5\",\"matchtype\":\"any\",\"owncache\":\"1\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('318', '0', 'mod_sampledata', 'module', 'mod_sampledata', '', '', '1', '1', '1', '0', '{\"name\":\"mod_sampledata\",\"type\":\"module\",\"creationDate\":\"2017-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"MOD_SAMPLEDATA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Sampledata\",\"filename\":\"mod_sampledata\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('319', '0', 'mod_latestactions', 'module', 'mod_latestactions', '', '', '1', '1', '1', '0', '{\"name\":\"mod_latestactions\",\"type\":\"module\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"MOD_LATESTACTIONS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\LatestActions\",\"filename\":\"mod_latestactions\"}', '{}', '', NULL, '1970-01-01 00:00:00', '0', '0', NULL, '1'),
('320', '0', 'mod_privacy_dashboard', 'module', 'mod_privacy_dashboard', '', '', '1', '1', '1', '0', '{\"name\":\"mod_privacy_dashboard\",\"type\":\"module\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"MOD_PRIVACY_DASHBOARD_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\PrivacyDashboard\",\"filename\":\"mod_privacy_dashboard\"}', '{}', '', NULL, '1970-01-01 00:00:00', '0', '0', NULL, '1'),
('401', '0', 'plg_authentication_joomla', 'plugin', 'joomla', '', 'authentication', '0', '1', '1', '1', '{\"name\":\"plg_authentication_joomla\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTHENTICATION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Authentication\\\\Joomla\",\"filename\":\"joomla\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('402', '0', 'plg_authentication_ldap', 'plugin', 'ldap', '', 'authentication', '0', '0', '1', '0', '{\"name\":\"plg_authentication_ldap\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LDAP_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Authentication\\\\Ldap\",\"filename\":\"ldap\"}', '{\"host\":\"\",\"port\":\"389\",\"use_ldapV3\":\"0\",\"negotiate_tls\":\"0\",\"no_referrals\":\"0\",\"auth_method\":\"bind\",\"base_dn\":\"\",\"search_string\":\"\",\"users_dn\":\"\",\"username\":\"admin\",\"password\":\"bobby7\",\"ldap_fullname\":\"fullName\",\"ldap_email\":\"mail\",\"ldap_uid\":\"uid\"}', '', NULL, NULL, '3', '0', NULL, '1'),
('403', '0', 'plg_content_contact', 'plugin', 'contact', '', 'content', '0', '1', '1', '0', '{\"name\":\"plg_content_contact\",\"type\":\"plugin\",\"creationDate\":\"2014-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2014 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.2\",\"description\":\"PLG_CONTENT_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Contact\",\"filename\":\"contact\"}', '', '', NULL, NULL, '1', '0', NULL, '1'),
('404', '0', 'plg_content_emailcloak', 'plugin', 'emailcloak', '', 'content', '0', '1', '1', '0', '{\"name\":\"plg_content_emailcloak\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_EMAILCLOAK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\EmailCloak\",\"filename\":\"emailcloak\"}', '{\"mode\":\"1\"}', '', NULL, NULL, '1', '0', NULL, '1'),
('406', '0', 'plg_content_loadmodule', 'plugin', 'loadmodule', '', 'content', '0', '1', '1', '0', '{\"name\":\"plg_content_loadmodule\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOADMODULE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\LoadModule\",\"filename\":\"loadmodule\"}', '{\"style\":\"xhtml\"}', '', NULL, '2011-09-18 15:22:50', '0', '0', NULL, '1'),
('407', '0', 'plg_content_pagebreak', 'plugin', 'pagebreak', '', 'content', '0', '1', '1', '0', '{\"name\":\"plg_content_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\PageBreak\",\"filename\":\"pagebreak\"}', '{\"title\":\"1\",\"multipage_toc\":\"1\",\"showall\":\"1\"}', '', NULL, NULL, '4', '0', NULL, '1'),
('408', '0', 'plg_content_pagenavigation', 'plugin', 'pagenavigation', '', 'content', '0', '1', '1', '0', '{\"name\":\"plg_content_pagenavigation\",\"type\":\"plugin\",\"creationDate\":\"2006-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_PAGENAVIGATION_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\PageNavigation\",\"filename\":\"pagenavigation\"}', '{\"position\":\"1\"}', '', NULL, NULL, '5', '0', NULL, '1'),
('409', '0', 'plg_content_vote', 'plugin', 'vote', '', 'content', '0', '1', '1', '0', '{\"name\":\"plg_content_vote\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_VOTE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Vote\",\"filename\":\"vote\"}', '', '', NULL, NULL, '6', '0', NULL, '1'),
('410', '0', 'plg_editors_codemirror', 'plugin', 'codemirror', '', 'editors', '0', '1', '1', '0', '{\"name\":\"plg_editors_codemirror\",\"type\":\"plugin\",\"creationDate\":\"28 March 2011\",\"author\":\"Marijn Haverbeke\",\"copyright\":\"Copyright (C) 2014 - 2021 by Marijn Haverbeke <marijnh@gmail.com> and others\",\"authorEmail\":\"marijnh@gmail.com\",\"authorUrl\":\"https:\\/\\/codemirror.net\\/\",\"version\":\"6.0.0\",\"description\":\"PLG_CODEMIRROR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Editors\\\\CodeMirror\",\"filename\":\"codemirror\"}', '{\"lineNumbers\":\"1\",\"lineWrapping\":\"1\",\"matchTags\":\"1\",\"matchBrackets\":\"1\",\"marker-gutter\":\"1\",\"autoCloseTags\":\"1\",\"autoCloseBrackets\":\"1\",\"autoFocus\":\"1\",\"theme\":\"default\",\"tabmode\":\"indent\"}', '', NULL, NULL, '1', '0', NULL, '1'),
('411', '0', 'plg_editors_none', 'plugin', 'none', '', 'editors', '0', '1', '1', '1', '{\"name\":\"plg_editors_none\",\"type\":\"plugin\",\"creationDate\":\"2005-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_NONE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Editors\\\\None\",\"filename\":\"none\"}', '', '', NULL, NULL, '2', '0', NULL, '1'),
('412', '0', 'plg_editors_tinymce', 'plugin', 'tinymce', '', 'editors', '0', '1', '1', '0', '{\"name\":\"plg_editors_tinymce\",\"type\":\"plugin\",\"creationDate\":\"2005-08\",\"author\":\"Tiny Technologies, Inc\",\"copyright\":\"Tiny Technologies, Inc\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"https:\\/\\/www.tiny.cloud\",\"version\":\"6.8.5\",\"description\":\"PLG_TINY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Editors\\\\TinyMCE\",\"filename\":\"tinymce\"}', '{\"configuration\":{\"toolbars\":{\"2\":{\"toolbar1\":[\"bold\",\"underline\",\"strikethrough\",\"|\",\"undo\",\"redo\",\"|\",\"bullist\",\"numlist\",\"|\",\"pastetext\"]},\"1\":{\"menu\":[\"edit\",\"insert\",\"view\",\"format\",\"table\",\"tools\"],\"toolbar1\":[\"bold\",\"italic\",\"underline\",\"strikethrough\",\"|\",\"alignleft\",\"aligncenter\",\"alignright\",\"alignjustify\",\"|\",\"blocks\",\"|\",\"bullist\",\"numlist\",\"|\",\"outdent\",\"indent\",\"|\",\"undo\",\"redo\",\"|\",\"link\",\"unlink\",\"anchor\",\"code\",\"|\",\"hr\",\"table\",\"|\",\"subscript\",\"superscript\",\"|\",\"charmap\",\"pastetext\",\"preview\"]},\"0\":{\"menu\":[\"edit\",\"insert\",\"view\",\"format\",\"table\",\"tools\"],\"toolbar1\":[\"bold\",\"italic\",\"underline\",\"strikethrough\",\"|\",\"alignleft\",\"aligncenter\",\"alignright\",\"alignjustify\",\"|\",\"styles\",\"|\",\"blocks\",\"fontfamily\",\"fontsize\",\"|\",\"searchreplace\",\"|\",\"bullist\",\"numlist\",\"|\",\"outdent\",\"indent\",\"|\",\"undo\",\"redo\",\"|\",\"link\",\"unlink\",\"anchor\",\"image\",\"|\",\"code\",\"|\",\"forecolor\",\"backcolor\",\"|\",\"fullscreen\",\"|\",\"table\",\"|\",\"subscript\",\"superscript\",\"|\",\"charmap\",\"emoticons\",\"media\",\"hr\",\"ltr\",\"rtl\",\"|\",\"cut\",\"copy\",\"paste\",\"pastetext\",\"|\",\"visualchars\",\"visualblocks\",\"nonbreaking\",\"blockquote\",\"jtemplate\",\"|\",\"print\",\"preview\",\"codesample\",\"insertdatetime\",\"removeformat\"]}},\"setoptions\":{\"2\":{\"access\":[\"1\"],\"skin\":\"0\",\"skin_admin\":\"0\",\"mobile\":\"0\",\"drag_drop\":\"1\",\"path\":\"\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"use_config_textfilters\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"valid_elements\":\"\",\"extended_elements\":\"\",\"resizing\":\"1\",\"resize_horizontal\":\"1\",\"element_path\":\"1\",\"wordcount\":\"1\",\"image_advtab\":\"0\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"},\"1\":{\"access\":[\"6\",\"2\"],\"skin\":\"0\",\"skin_admin\":\"0\",\"mobile\":\"0\",\"drag_drop\":\"1\",\"path\":\"\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"use_config_textfilters\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"valid_elements\":\"\",\"extended_elements\":\"\",\"resizing\":\"1\",\"resize_horizontal\":\"1\",\"element_path\":\"1\",\"wordcount\":\"1\",\"image_advtab\":\"0\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"},\"0\":{\"access\":[\"7\",\"4\",\"8\"],\"skin\":\"0\",\"skin_admin\":\"0\",\"mobile\":\"0\",\"drag_drop\":\"1\",\"path\":\"\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"use_config_textfilters\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"valid_elements\":\"\",\"extended_elements\":\"\",\"resizing\":\"1\",\"resize_horizontal\":\"1\",\"element_path\":\"1\",\"wordcount\":\"1\",\"image_advtab\":\"1\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"}}},\"sets_amount\":3,\"html_height\":\"550\",\"html_width\":\"750\"}', '', NULL, NULL, '3', '0', NULL, '1'),
('413', '0', 'plg_editors-xtd_article', 'plugin', 'article', '', 'editors-xtd', '0', '1', '1', '0', '{\"name\":\"plg_editors-xtd_article\",\"type\":\"plugin\",\"creationDate\":\"2009-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_ARTICLE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Article\",\"filename\":\"article\"}', '', '', NULL, NULL, '1', '0', NULL, '1'),
('414', '0', 'plg_editors-xtd_image', 'plugin', 'image', '', 'editors-xtd', '0', '1', '1', '0', '{\"name\":\"plg_editors-xtd_image\",\"type\":\"plugin\",\"creationDate\":\"2004-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Image\",\"filename\":\"image\"}', '', '', NULL, NULL, '2', '0', NULL, '1'),
('415', '0', 'plg_editors-xtd_pagebreak', 'plugin', 'pagebreak', '', 'editors-xtd', '0', '1', '1', '0', '{\"name\":\"plg_editors-xtd_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"2004-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EDITORSXTD_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\PageBreak\",\"filename\":\"pagebreak\"}', '', '', NULL, NULL, '3', '0', NULL, '1'),
('416', '0', 'plg_editors-xtd_readmore', 'plugin', 'readmore', '', 'editors-xtd', '0', '1', '1', '0', '{\"name\":\"plg_editors-xtd_readmore\",\"type\":\"plugin\",\"creationDate\":\"2006-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_READMORE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\ReadMore\",\"filename\":\"readmore\"}', '', '', NULL, NULL, '4', '0', NULL, '1'),
('417', '10067', 'plg_search_categories', 'plugin', 'categories', '', 'search', '0', '0', '1', '0', '{\"name\":\"plg_search_categories\",\"type\":\"plugin\",\"creationDate\":\"17.08.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0-dev\",\"description\":\"PLG_SEARCH_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"categories\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', NULL, NULL, '0', '0', NULL, '0'),
('418', '10067', 'plg_search_contacts', 'plugin', 'contacts', '', 'search', '0', '0', '1', '0', '{\"name\":\"plg_search_contacts\",\"type\":\"plugin\",\"creationDate\":\"17.08.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0-dev\",\"description\":\"\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"contacts\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', NULL, NULL, '0', '0', NULL, '0'),
('419', '10067', 'plg_search_content', 'plugin', 'content', '', 'search', '0', '0', '1', '0', '{\"name\":\"plg_search_content\",\"type\":\"plugin\",\"creationDate\":\"17.08.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0-dev\",\"description\":\"PLG_SEARCH_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"content\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', NULL, NULL, '0', '0', NULL, '0'),
('420', '10067', 'plg_search_newsfeeds', 'plugin', 'newsfeeds', '', 'search', '0', '0', '1', '0', '{\"name\":\"plg_search_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"17.08.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0-dev\",\"description\":\"\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"newsfeeds\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', NULL, NULL, '0', '0', NULL, '0'),
('422', '0', 'plg_system_languagefilter', 'plugin', 'languagefilter', '', 'system', '0', '0', '1', '0', '{\"name\":\"plg_system_languagefilter\",\"type\":\"plugin\",\"creationDate\":\"2010-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGEFILTER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\LanguageFilter\",\"filename\":\"languagefilter\"}', '', '', NULL, NULL, '1', '0', NULL, '1'),
('424', '0', 'plg_system_cache', 'plugin', 'cache', '', 'system', '0', '0', '1', '0', '{\"name\":\"plg_system_cache\",\"type\":\"plugin\",\"creationDate\":\"2007-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CACHE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Cache\",\"filename\":\"cache\"}', '{\"browsercache\":\"0\",\"cachetime\":\"15\"}', '', NULL, NULL, '9', '0', NULL, '1'),
('425', '0', 'plg_system_debug', 'plugin', 'debug', '', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_debug\",\"type\":\"plugin\",\"creationDate\":\"2006-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_DEBUG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Debug\",\"filename\":\"debug\"}', '{\"profile\":\"1\",\"queries\":\"1\",\"memory\":\"1\",\"language_files\":\"1\",\"language_strings\":\"1\",\"strip-first\":\"1\",\"strip-prefix\":\"\",\"strip-suffix\":\"\"}', '', NULL, NULL, '4', '0', NULL, '1'),
('426', '0', 'plg_system_log', 'plugin', 'log', '', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_log\",\"type\":\"plugin\",\"creationDate\":\"2007-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Log\",\"filename\":\"log\"}', '', '', NULL, NULL, '5', '0', NULL, '1'),
('427', '0', 'plg_system_redirect', 'plugin', 'redirect', '', 'system', '0', '0', '1', '0', '{\"name\":\"plg_system_redirect\",\"type\":\"plugin\",\"creationDate\":\"2009-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Redirect\",\"filename\":\"redirect\"}', '', '', NULL, NULL, '6', '0', NULL, '1'),
('428', '0', 'plg_system_remember', 'plugin', 'remember', '', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_remember\",\"type\":\"plugin\",\"creationDate\":\"2007-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_REMEMBER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Remember\",\"filename\":\"remember\"}', '', '', NULL, NULL, '7', '0', NULL, '1'),
('429', '0', 'plg_system_sef', 'plugin', 'sef', '', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_sef\",\"type\":\"plugin\",\"creationDate\":\"2007-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEF_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Sef\",\"filename\":\"sef\"}', '', '', NULL, NULL, '8', '0', NULL, '1'),
('430', '0', 'plg_system_logout', 'plugin', 'logout', '', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_logout\",\"type\":\"plugin\",\"creationDate\":\"2009-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LOGOUT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Logout\",\"filename\":\"logout\"}', '', '', NULL, NULL, '3', '0', NULL, '1'),
('431', '0', 'plg_user_contactcreator', 'plugin', 'contactcreator', '', 'user', '0', '0', '1', '0', '{\"name\":\"plg_user_contactcreator\",\"type\":\"plugin\",\"creationDate\":\"2009-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTACTCREATOR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\ContactCreator\",\"filename\":\"contactcreator\"}', '{\"autowebpage\":\"\",\"category\":\"34\",\"autopublish\":\"0\"}', '', NULL, NULL, '1', '0', NULL, '1'),
('432', '0', 'plg_user_joomla', 'plugin', 'joomla', '', 'user', '0', '1', '1', '0', '{\"name\":\"plg_user_joomla\",\"type\":\"plugin\",\"creationDate\":\"2006-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\Joomla\",\"filename\":\"joomla\"}', '{\"autoregister\":\"1\",\"mail_to_user\":\"1\",\"forceLogout\":\"1\"}', '', NULL, NULL, '2', '0', NULL, '1'),
('433', '0', 'plg_user_profile', 'plugin', 'profile', '', 'user', '0', '0', '1', '0', '{\"name\":\"plg_user_profile\",\"type\":\"plugin\",\"creationDate\":\"2008-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2008 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_PROFILE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\Profile\",\"filename\":\"profile\"}', '{\"register-require_address1\":\"1\",\"register-require_address2\":\"1\",\"register-require_city\":\"1\",\"register-require_region\":\"1\",\"register-require_country\":\"1\",\"register-require_postal_code\":\"1\",\"register-require_phone\":\"1\",\"register-require_website\":\"1\",\"register-require_favoritebook\":\"1\",\"register-require_aboutme\":\"1\",\"register-require_tos\":\"1\",\"register-require_dob\":\"1\",\"profile-require_address1\":\"1\",\"profile-require_address2\":\"1\",\"profile-require_city\":\"1\",\"profile-require_region\":\"1\",\"profile-require_country\":\"1\",\"profile-require_postal_code\":\"1\",\"profile-require_phone\":\"1\",\"profile-require_website\":\"1\",\"profile-require_favoritebook\":\"1\",\"profile-require_aboutme\":\"1\",\"profile-require_tos\":\"1\",\"profile-require_dob\":\"1\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('434', '0', 'plg_extension_joomla', 'plugin', 'joomla', '', 'extension', '0', '1', '1', '0', '{\"name\":\"plg_extension_joomla\",\"type\":\"plugin\",\"creationDate\":\"2010-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EXTENSION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Extension\\\\Joomla\",\"filename\":\"joomla\"}', '', '', NULL, NULL, '1', '0', NULL, '1'),
('435', '0', 'plg_content_joomla', 'plugin', 'joomla', '', 'content', '0', '1', '1', '0', '{\"name\":\"plg_content_joomla\",\"type\":\"plugin\",\"creationDate\":\"2010-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Joomla\",\"filename\":\"joomla\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('436', '0', 'plg_system_languagecode', 'plugin', 'languagecode', '', 'system', '0', '0', '1', '0', '{\"name\":\"plg_system_languagecode\",\"type\":\"plugin\",\"creationDate\":\"2011-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGECODE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\LanguageCode\",\"filename\":\"languagecode\"}', '', '', NULL, NULL, '10', '0', NULL, '1'),
('437', '0', 'plg_quickicon_joomlaupdate', 'plugin', 'joomlaupdate', '', 'quickicon', '0', '1', '1', '0', '{\"name\":\"plg_quickicon_joomlaupdate\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\Joomlaupdate\",\"filename\":\"joomlaupdate\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('438', '0', 'plg_quickicon_extensionupdate', 'plugin', 'extensionupdate', '', 'quickicon', '0', '1', '1', '0', '{\"name\":\"plg_quickicon_extensionupdate\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_EXTENSIONUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\Extensionupdate\",\"filename\":\"extensionupdate\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('440', '0', 'plg_system_highlight', 'plugin', 'highlight', '', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_highlight\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_HIGHLIGHT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Highlight\",\"filename\":\"highlight\"}', '', '', NULL, NULL, '7', '0', NULL, '1'),
('441', '0', 'plg_content_finder', 'plugin', 'finder', '', 'content', '0', '1', '1', '0', '{\"name\":\"plg_content_finder\",\"type\":\"plugin\",\"creationDate\":\"2011-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Finder\",\"filename\":\"finder\"}', '', '', NULL, NULL, '0', '0', '', '1'),
('442', '0', 'plg_finder_categories', 'plugin', 'categories', '', 'finder', '0', '0', '1', '0', '{\"name\":\"plg_finder_categories\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Categories\",\"filename\":\"categories\"}', '', '', NULL, NULL, '1', '0', NULL, '1'),
('443', '0', 'plg_finder_contacts', 'plugin', 'contacts', '', 'finder', '0', '0', '1', '0', '{\"name\":\"plg_finder_contacts\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTACTS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Contacts\",\"filename\":\"contacts\"}', '', '', NULL, NULL, '2', '0', NULL, '1'),
('444', '0', 'plg_finder_content', 'plugin', 'content', '', 'finder', '0', '0', '1', '0', '{\"name\":\"plg_finder_content\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Content\",\"filename\":\"content\"}', '', '', NULL, NULL, '3', '0', NULL, '1'),
('445', '0', 'plg_finder_newsfeeds', 'plugin', 'newsfeeds', '', 'finder', '0', '0', '1', '0', '{\"name\":\"plg_finder_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Newsfeeds\",\"filename\":\"newsfeeds\"}', '', '', NULL, NULL, '4', '0', NULL, '1'),
('447', '0', 'plg_finder_tags', 'plugin', 'tags', '', 'finder', '0', '0', '1', '0', '{\"name\":\"plg_finder_tags\",\"type\":\"plugin\",\"creationDate\":\"2013-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Tags\",\"filename\":\"tags\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('449', '0', 'plg_authentication_cookie', 'plugin', 'cookie', '', 'authentication', '0', '1', '1', '0', '{\"name\":\"plg_authentication_cookie\",\"type\":\"plugin\",\"creationDate\":\"2013-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTHENTICATION_COOKIE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Authentication\\\\Cookie\",\"filename\":\"cookie\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('451', '10067', 'plg_search_tags', 'plugin', 'tags', '', 'search', '0', '0', '1', '0', '{\"name\":\"plg_search_tags\",\"type\":\"plugin\",\"creationDate\":\"17.08.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2014 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0-dev\",\"description\":\"\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"tags\"}', '{\"search_limit\":\"50\",\"show_tagged_items\":\"1\"}', '', NULL, NULL, '0', '0', NULL, '0'),
('453', '0', 'plg_editors-xtd_module', 'plugin', 'module', '', 'editors-xtd', '0', '1', '1', '0', '{\"name\":\"plg_editors-xtd_module\",\"type\":\"plugin\",\"creationDate\":\"2015-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2015 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_MODULE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Module\",\"filename\":\"module\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('454', '0', 'plg_system_stats', 'plugin', 'stats', '', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_stats\",\"type\":\"plugin\",\"creationDate\":\"2013-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_SYSTEM_STATS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Stats\",\"filename\":\"stats\"}', '{\"mode\":3,\"lastrun\":\"\",\"unique_id\":\"6d30f13db174eb0c94efb885594275cd80da3e3a\",\"interval\":12}', '', NULL, NULL, '0', '0', NULL, '1'),
('455', '0', 'plg_installer_packageinstaller', 'plugin', 'packageinstaller', '', 'installer', '0', '1', '1', '0', '{\"name\":\"plg_installer_packageinstaller\",\"type\":\"plugin\",\"creationDate\":\"2016-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_PACKAGEINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Package\",\"filename\":\"packageinstaller\"}', '', '', NULL, NULL, '1', '0', NULL, '1'),
('456', '0', 'plg_installer_folderinstaller', 'plugin', 'folderinstaller', '', 'installer', '0', '1', '1', '0', '{\"name\":\"plg_installer_folderinstaller\",\"type\":\"plugin\",\"creationDate\":\"2016-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_FOLDERINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Folder\",\"filename\":\"folderinstaller\"}', '', '', NULL, NULL, '2', '0', NULL, '1'),
('457', '0', 'plg_installer_urlinstaller', 'plugin', 'urlinstaller', '', 'installer', '0', '1', '1', '0', '{\"name\":\"plg_installer_urlinstaller\",\"type\":\"plugin\",\"creationDate\":\"2016-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_URLINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Url\",\"filename\":\"urlinstaller\"}', '', '', NULL, NULL, '3', '0', NULL, '1'),
('458', '0', 'plg_quickicon_phpversioncheck', 'plugin', 'phpversioncheck', '', 'quickicon', '0', '1', '1', '0', '{\"name\":\"plg_quickicon_phpversioncheck\",\"type\":\"plugin\",\"creationDate\":\"2016-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_QUICKICON_PHPVERSIONCHECK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\PhpVersionCheck\",\"filename\":\"phpversioncheck\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('459', '0', 'plg_editors-xtd_menu', 'plugin', 'menu', '', 'editors-xtd', '0', '1', '1', '0', '{\"name\":\"plg_editors-xtd_menu\",\"type\":\"plugin\",\"creationDate\":\"2016-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Menu\",\"filename\":\"menu\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('460', '0', 'plg_editors-xtd_contact', 'plugin', 'contact', '', 'editors-xtd', '0', '1', '1', '0', '{\"name\":\"plg_editors-xtd_contact\",\"type\":\"plugin\",\"creationDate\":\"2016-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Contact\",\"filename\":\"contact\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('461', '0', 'plg_system_fields', 'plugin', 'fields', '', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_fields\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_SYSTEM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Fields\",\"filename\":\"fields\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('462', '0', 'plg_fields_calendar', 'plugin', 'calendar', '', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_calendar\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CALENDAR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Calendar\",\"filename\":\"calendar\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('463', '0', 'plg_fields_checkboxes', 'plugin', 'checkboxes', '', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_checkboxes\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CHECKBOXES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Checkboxes\",\"filename\":\"checkboxes\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('464', '0', 'plg_fields_color', 'plugin', 'color', '', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_color\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_COLOR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Color\",\"filename\":\"color\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('465', '0', 'plg_fields_editor', 'plugin', 'editor', '', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_editor\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_EDITOR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Editor\",\"filename\":\"editor\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('466', '0', 'plg_fields_imagelist', 'plugin', 'imagelist', '', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_imagelist\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_IMAGELIST_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Imagelist\",\"filename\":\"imagelist\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('467', '0', 'plg_fields_integer', 'plugin', 'integer', '', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_integer\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_INTEGER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Integer\",\"filename\":\"integer\"}', '{\"multiple\":\"0\",\"first\":\"1\",\"last\":\"100\",\"step\":\"1\"}', '', NULL, NULL, '0', '0', NULL, '1'),
('468', '0', 'plg_fields_list', 'plugin', 'list', '', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_list\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_LIST_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\ListField\",\"filename\":\"list\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('469', '0', 'plg_fields_media', 'plugin', 'media', '', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_media\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Media\",\"filename\":\"media\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('470', '0', 'plg_fields_radio', 'plugin', 'radio', '', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_radio\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_RADIO_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Radio\",\"filename\":\"radio\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('471', '0', 'plg_fields_sql', 'plugin', 'sql', '', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_sql\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_SQL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\SQL\",\"filename\":\"sql\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('472', '0', 'plg_fields_text', 'plugin', 'text', '', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_text\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Text\",\"filename\":\"text\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('473', '0', 'plg_fields_textarea', 'plugin', 'textarea', '', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_textarea\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXTAREA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Textarea\",\"filename\":\"textarea\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('474', '0', 'plg_fields_url', 'plugin', 'url', '', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_url\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_URL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Url\",\"filename\":\"url\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('475', '0', 'plg_fields_user', 'plugin', 'user', '', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_user\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\User\",\"filename\":\"user\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('476', '0', 'plg_fields_usergrouplist', 'plugin', 'usergrouplist', '', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_usergrouplist\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USERGROUPLIST_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\UsergroupList\",\"filename\":\"usergrouplist\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('477', '0', 'plg_content_fields', 'plugin', 'fields', '', 'content', '0', '1', '1', '0', '{\"name\":\"plg_content_fields\",\"type\":\"plugin\",\"creationDate\":\"2017-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_CONTENT_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Fields\",\"filename\":\"fields\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('478', '0', 'plg_editors-xtd_fields', 'plugin', 'fields', '', 'editors-xtd', '0', '1', '1', '0', '{\"name\":\"plg_editors-xtd_fields\",\"type\":\"plugin\",\"creationDate\":\"2017-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Fields\",\"filename\":\"fields\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('479', '0', 'plg_sampledata_blog', 'plugin', 'blog', '', 'sampledata', '0', '1', '1', '0', '{\"name\":\"plg_sampledata_blog\",\"type\":\"plugin\",\"creationDate\":\"2017-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"PLG_SAMPLEDATA_BLOG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\SampleData\\\\Blog\",\"filename\":\"blog\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('482', '0', 'plg_content_confirmconsent', 'plugin', 'confirmconsent', '', 'content', '0', '0', '1', '0', '{\"name\":\"plg_content_confirmconsent\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_CONTENT_CONFIRMCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\ConfirmConsent\",\"filename\":\"confirmconsent\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('483', '0', 'plg_system_actionlogs', 'plugin', 'actionlogs', '', 'system', '0', '0', '1', '0', '{\"name\":\"plg_system_actionlogs\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\ActionLogs\",\"filename\":\"actionlogs\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('484', '0', 'plg_actionlog_joomla', 'plugin', 'joomla', '', 'actionlog', '0', '1', '1', '0', '{\"name\":\"plg_actionlog_joomla\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_ACTIONLOG_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Actionlog\\\\Joomla\",\"filename\":\"joomla\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('485', '0', 'plg_system_privacyconsent', 'plugin', 'privacyconsent', '', 'system', '0', '0', '1', '0', '{\"name\":\"plg_system_privacyconsent\",\"type\":\"plugin\",\"creationDate\":\"2018-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_PRIVACYCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\PrivacyConsent\",\"filename\":\"privacyconsent\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('487', '0', 'plg_privacy_user', 'plugin', 'user', '', 'privacy', '0', '1', '1', '0', '{\"name\":\"plg_privacy_user\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_USER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\User\",\"filename\":\"user\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('488', '0', 'plg_quickicon_privacycheck', 'plugin', 'privacycheck', '', 'quickicon', '0', '1', '1', '0', '{\"name\":\"plg_quickicon_privacycheck\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_QUICKICON_PRIVACYCHECK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\PrivacyCheck\",\"filename\":\"privacycheck\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('489', '0', 'plg_user_terms', 'plugin', 'terms', '', 'user', '0', '0', '1', '0', '{\"name\":\"plg_user_terms\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_USER_TERMS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\Terms\",\"filename\":\"terms\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('490', '0', 'plg_privacy_contact', 'plugin', 'contact', '', 'privacy', '0', '1', '1', '0', '{\"name\":\"plg_privacy_contact\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\Contact\",\"filename\":\"contact\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('491', '0', 'plg_privacy_content', 'plugin', 'content', '', 'privacy', '0', '1', '1', '0', '{\"name\":\"plg_privacy_content\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\Content\",\"filename\":\"content\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('492', '0', 'plg_privacy_message', 'plugin', 'message', '', 'privacy', '0', '1', '1', '0', '{\"name\":\"plg_privacy_message\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_MESSAGE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\Message\",\"filename\":\"message\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('493', '0', 'plg_privacy_actionlogs', 'plugin', 'actionlogs', '', 'privacy', '0', '1', '1', '0', '{\"name\":\"plg_privacy_actionlogs\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\Actionlogs\",\"filename\":\"actionlogs\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('494', '0', 'plg_captcha_recaptcha_invisible', 'plugin', 'recaptcha_invisible', '', 'captcha', '0', '0', '1', '0', '{\"name\":\"plg_captcha_recaptcha_invisible\",\"type\":\"plugin\",\"creationDate\":\"2017-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8\",\"description\":\"PLG_CAPTCHA_RECAPTCHA_INVISIBLE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Captcha\\\\InvisibleReCaptcha\",\"filename\":\"recaptcha_invisible\"}', '{\"public_key\":\"\",\"private_key\":\"\",\"theme\":\"clean\"}', '', NULL, NULL, '0', '0', NULL, '0'),
('495', '0', 'plg_privacy_consents', 'plugin', 'consents', '', 'privacy', '0', '1', '1', '0', '{\"name\":\"plg_privacy_consents\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONSENTS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\Consents\",\"filename\":\"consents\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('600', '802', 'English (en-GB)', 'language', 'en-GB', '', '', '0', '1', '1', '1', '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"2025-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.3.0\",\"description\":\"en-GB site language\",\"group\":\"\",\"changelogurl\":\"\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('601', '802', 'English (en-GB)', 'language', 'en-GB', '', '', '1', '1', '1', '1', '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"2025-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.3.0\",\"description\":\"en-GB administrator language\",\"group\":\"\",\"changelogurl\":\"\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('802', '0', 'English (en-GB) Language Pack', 'package', 'pkg_en-GB', '', '', '0', '1', '1', '1', '{\"name\":\"English (en-GB) Language Pack\",\"type\":\"package\",\"creationDate\":\"2025-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.3.0.1\",\"description\":\"en-GB language pack\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"pkg_en-GB\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('10000', '0', 'SP Page Builder', 'component', 'com_sppagebuilder', '', '', '1', '1', '0', '0', '{\"name\":\"SP Page Builder\",\"type\":\"component\",\"creationDate\":\"Sep 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright @ 2010 - 2025 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"https:\\/\\/www.joomshaper.com\",\"version\":\"5.5.5\",\"description\":\"\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"sppagebuilder\"}', '{\"production_mode\":\"0\",\"gmap_api\":\"\",\"ig_token\":\"{\\\"appId\\\":\\\"\\\",\\\"appSecret\\\":\\\"\\\",\\\"accessToken\\\":\\\"\\\",\\\"igId\\\":\\\"\\\"}\",\"fontawesome\":\"1\",\"disable_google_fonts\":\"0\",\"lazyloadimg\":\"0\",\"lazyplaceholder\":\"\\/components\\/com_sppagebuilder\\/assets\\/images\\/lazyloading-placeholder.svg\",\"disableanimatecss\":\"0\",\"disablecss\":\"0\",\"disable_og\":\"0\",\"fb_app_id\":\"adminump\",\"disable_tc\":\"0\",\"joomshaper_email\":\"2017.ump.ptmk@gmail.com\",\"joomshaper_license_key\":\"0b76699ec85b69cf4995cd7b1db01f49\"}', '', NULL, NULL, '0', '0', NULL, '0'),
('10001', '0', 'SP Page Builder', 'module', 'mod_sppagebuilder', '', '', '0', '1', '0', '0', '{\"name\":\"SP Page Builder\",\"type\":\"module\",\"creationDate\":\"Oct 2016\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2024 JoomShaper.com. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"5.5.5\",\"description\":\"Module to display content from SP Page Builder\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"mod_sppagebuilder\"}', '{\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', NULL, NULL, '0', '0', NULL, '0'),
('10004', '0', 'System - Helix Ultimate Framework', 'plugin', 'helixultimate', '', 'system', '0', '1', '1', '0', '{\"name\":\"System - Helix Ultimate Framework\",\"type\":\"plugin\",\"creationDate\":\"Feb 2018\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2025 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"2.1.2\",\"description\":\"Helix Ultimate Framework - Joomla Template Framework by JoomShaper\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"helixultimate\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10006', '0', 'Helix Ultimate based template installer', 'plugin', 'TmplHelixUltimate', '', 'system', '0', '0', '1', '0', '{\"name\":\"Helix Ultimate based template installer\",\"type\":\"plugin\",\"creationDate\":\"JLIB_UNKNOWN\",\"author\":\"JLIB_UNKNOWN\",\"copyright\":\"\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"\",\"description\":\"Shaper Helix Ultimate - Blank template of Helix Ultimate framework\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"TmplHelixUltimate\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10008', '0', 'COM_SPEASYIMAGEGALLERY', 'component', 'com_speasyimagegallery', '', '', '1', '0', '0', '0', '{\"name\":\"COM_SPEASYIMAGEGALLERY\",\"type\":\"component\",\"creationDate\":\"Mar 2017\",\"author\":\"JoomShaper\",\"copyright\":\"@JoomShaper 2010 - 2023. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"http:\\/\\/www.joomshaper.com\",\"version\":\"2.0.4\",\"description\":\"A simple image gallery component for Joomla.\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"speasyimagegallery\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10009', '0', 'SP Easy Image Gallery Module', 'module', 'mod_speasyimagegallery', '', '', '0', '0', '0', '0', '{\"name\":\"SP Easy Image Gallery Module\",\"type\":\"module\",\"creationDate\":\"Mar 2016\",\"author\":\"JoomShaper\",\"copyright\":\"@JoomShaper 2010 - 2021. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"http:\\/\\/www.joomshaper.com\",\"version\":\"2.0.4\",\"description\":\"Module to display albums or album images from SP Easy Image Gallery component.\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"mod_speasyimagegallery\"}', '{\"layout\":\"album\",\"albums_column\":\"3\",\"albums_column_sm\":\"4\",\"albums_column_xs\":\"6\",\"albums_gutter\":\"20\",\"albums_gutter_sm\":\"15\",\"albums_gutter_xs\":\"10\",\"album_limit\":\"8\",\"album_layout\":\"default\",\"album_column\":\"3\",\"album_column_sm\":\"4\",\"album_column_xs\":\"6\",\"album_gutter\":\"20\",\"album_gutter_sm\":\"15\",\"album_gutter_xs\":\"10\",\"show_title\":\"1\",\"show_desc\":\"1\",\"show_count\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', NULL, NULL, '0', '0', NULL, '0'),
('10015', '0', 'plg_behaviour_taggable', 'plugin', 'taggable', '', 'behaviour', '0', '1', '1', '0', '{\"name\":\"plg_behaviour_taggable\",\"type\":\"plugin\",\"creationDate\":\"2015-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_BEHAVIOUR_TAGGABLE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Behaviour\\\\Taggable\",\"filename\":\"taggable\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10016', '0', 'plg_behaviour_versionable', 'plugin', 'versionable', '', 'behaviour', '0', '1', '1', '0', '{\"name\":\"plg_behaviour_versionable\",\"type\":\"plugin\",\"creationDate\":\"2015-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_BEHAVIOUR_VERSIONABLE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Behaviour\\\\Versionable\",\"filename\":\"versionable\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10017', '0', 'atum', 'template', 'atum', '', '', '1', '1', '1', '0', '{\"name\":\"atum\",\"type\":\"template\",\"creationDate\":\"2016-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_ATUM_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"inheritable\":true,\"filename\":\"templateDetails\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10018', '0', 'cassiopeia', 'template', 'cassiopeia', '', '', '0', '1', '1', '0', '{\"name\":\"cassiopeia\",\"type\":\"template\",\"creationDate\":\"2017-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_CASSIOPEIA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"inheritable\":true,\"filename\":\"templateDetails\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10019', '0', 'plg_filesystem_local', 'plugin', 'local', '', 'filesystem', '0', '1', '1', '0', '{\"name\":\"plg_filesystem_local\",\"type\":\"plugin\",\"creationDate\":\"2017-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_FILESYSTEM_LOCAL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Filesystem\\\\Local\",\"filename\":\"local\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10020', '0', 'plg_media-action_crop', 'plugin', 'crop', '', 'media-action', '0', '1', '1', '0', '{\"name\":\"plg_media-action_crop\",\"type\":\"plugin\",\"creationDate\":\"2017-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_MEDIA-ACTION_CROP_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\MediaAction\\\\Crop\",\"filename\":\"crop\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10021', '0', 'plg_media-action_resize', 'plugin', 'resize', '', 'media-action', '0', '1', '1', '0', '{\"name\":\"plg_media-action_resize\",\"type\":\"plugin\",\"creationDate\":\"2017-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_MEDIA-ACTION_RESIZE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\MediaAction\\\\Resize\",\"filename\":\"resize\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10022', '0', 'plg_media-action_rotate', 'plugin', 'rotate', '', 'media-action', '0', '1', '1', '0', '{\"name\":\"plg_media-action_rotate\",\"type\":\"plugin\",\"creationDate\":\"2017-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_MEDIA-ACTION_ROTATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\MediaAction\\\\Rotate\",\"filename\":\"rotate\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10023', '0', 'plg_system_httpheaders', 'plugin', 'httpheaders', '', 'system', '0', '0', '1', '0', '{\"name\":\"plg_system_httpheaders\",\"type\":\"plugin\",\"creationDate\":\"2017-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_HTTPHEADERS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Httpheaders\",\"filename\":\"httpheaders\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10024', '0', 'com_workflow', 'component', 'com_workflow', '', '', '1', '1', '0', '1', '{\"name\":\"com_workflow\",\"type\":\"component\",\"creationDate\":\"2017-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_WORKFLOW_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Workflow\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10025', '0', 'plg_workflow_publishing', 'plugin', 'publishing', '', 'workflow', '0', '1', '1', '0', '{\"name\":\"plg_workflow_publishing\",\"type\":\"plugin\",\"creationDate\":\"2020-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WORKFLOW_PUBLISHING_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Workflow\\\\Publishing\",\"filename\":\"publishing\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10026', '0', 'plg_workflow_featuring', 'plugin', 'featuring', '', 'workflow', '0', '1', '1', '0', '{\"name\":\"plg_workflow_featuring\",\"type\":\"plugin\",\"creationDate\":\"2020-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WORKFLOW_FEATURING_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Workflow\\\\Featuring\",\"filename\":\"featuring\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10027', '0', 'plg_workflow_notification', 'plugin', 'notification', '', 'workflow', '0', '1', '1', '0', '{\"name\":\"plg_workflow_notification\",\"type\":\"plugin\",\"creationDate\":\"2020-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WORKFLOW_NOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Workflow\\\\Notification\",\"filename\":\"notification\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10028', '0', 'plg_extension_namespacemap', 'plugin', 'namespacemap', '', 'extension', '0', '1', '1', '1', '{\"name\":\"plg_extension_namespacemap\",\"type\":\"plugin\",\"creationDate\":\"2017-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_EXTENSION_NAMESPACEMAP_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Extension\\\\NamespaceMap\",\"filename\":\"namespacemap\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('10029', '0', 'plg_installer_override', 'plugin', 'override', '', 'installer', '0', '1', '1', '0', '{\"name\":\"plg_installer_override\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_INSTALLER_OVERRIDE_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Override\",\"filename\":\"override\"}', '', '', NULL, NULL, '4', '0', NULL, '1'),
('10030', '0', 'plg_quickicon_overridecheck', 'plugin', 'overridecheck', '', 'quickicon', '0', '1', '1', '0', '{\"name\":\"plg_quickicon_overridecheck\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_QUICKICON_OVERRIDECHECK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\OverrideCheck\",\"filename\":\"overridecheck\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('10031', '0', 'plg_extension_finder', 'plugin', 'finder', '', 'extension', '0', '1', '1', '0', '{\"name\":\"plg_extension_finder\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_EXTENSION_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Extension\\\\Finder\",\"filename\":\"finder\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('10032', '0', 'plg_api-authentication_basic', 'plugin', 'basic', '', 'api-authentication', '0', '0', '1', '0', '{\"name\":\"plg_api-authentication_basic\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_API-AUTHENTICATION_BASIC_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\ApiAuthentication\\\\Basic\",\"filename\":\"basic\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10033', '0', 'plg_webservices_content', 'plugin', 'content', '', 'webservices', '0', '1', '1', '0', '{\"name\":\"plg_webservices_content\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Content\",\"filename\":\"content\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10034', '0', 'com_mails', 'component', 'com_mails', '', '', '1', '1', '1', '1', '{\"name\":\"com_mails\",\"type\":\"component\",\"creationDate\":\"2019-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MAILS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Mails\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10035', '0', 'plg_system_skipto', 'plugin', 'skipto', '', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_skipto\",\"type\":\"plugin\",\"creationDate\":\"2020-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_SKIPTO_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Skipto\",\"filename\":\"skipto\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10036', '0', 'plg_sampledata_multilang', 'plugin', 'multilang', '', 'sampledata', '0', '1', '1', '0', '{\"name\":\"plg_sampledata_multilang\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SAMPLEDATA_MULTILANG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\SampleData\\\\MultiLanguage\",\"filename\":\"multilang\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10037', '0', 'plg_installer_webinstaller', 'plugin', 'webinstaller', '', 'installer', '0', '1', '1', '0', '{\"name\":\"plg_installer_webinstaller\",\"type\":\"plugin\",\"creationDate\":\"2017-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_INSTALLER_WEBINSTALLER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Web\",\"filename\":\"webinstaller\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10038', '0', 'plg_fields_subform', 'plugin', 'subform', '', 'fields', '0', '1', '1', '0', '{\"name\":\"plg_fields_subform\",\"type\":\"plugin\",\"creationDate\":\"2017-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_FIELDS_SUBFORM_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Subform\",\"filename\":\"subform\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('10039', '0', 'plg_system_webauthn', 'plugin', 'webauthn', '', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_webauthn\",\"type\":\"plugin\",\"creationDate\":\"2019-07-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_WEBAUTHN_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Webauthn\",\"filename\":\"webauthn\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10040', '0', 'mod_loginsupport', 'module', 'mod_loginsupport', '', '', '1', '1', '1', '0', '{\"name\":\"mod_loginsupport\",\"type\":\"module\",\"creationDate\":\"2019-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_LOGINSUPPORT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Loginsupport\",\"filename\":\"mod_loginsupport\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('10041', '0', 'mod_frontend', 'module', 'mod_frontend', '', '', '1', '1', '1', '0', '{\"name\":\"mod_frontend\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_FRONTEND_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Frontend\",\"filename\":\"mod_frontend\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('10042', '0', 'mod_messages', 'module', 'mod_messages', '', '', '1', '1', '1', '0', '{\"name\":\"mod_messages\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Messages\",\"filename\":\"mod_messages\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('10043', '0', 'mod_post_installation_messages', 'module', 'mod_post_installation_messages', '', '', '1', '1', '1', '0', '{\"name\":\"mod_post_installation_messages\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_POST_INSTALLATION_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\PostInstallationMessages\",\"filename\":\"mod_post_installation_messages\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('10044', '0', 'mod_user', 'module', 'mod_user', '', '', '1', '1', '1', '0', '{\"name\":\"mod_user\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_USER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\User\",\"filename\":\"mod_user\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('10045', '0', 'mod_submenu', 'module', 'mod_submenu', '', '', '1', '1', '1', '0', '{\"name\":\"mod_submenu\",\"type\":\"module\",\"creationDate\":\"2006-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SUBMENU_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Submenu\",\"filename\":\"mod_submenu\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10046', '0', 'mod_privacy_status', 'module', 'mod_privacy_status', '', '', '1', '1', '1', '0', '{\"name\":\"mod_privacy_status\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_PRIVACY_STATUS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\PrivacyStatus\",\"filename\":\"mod_privacy_status\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1');/**ABDB**/
/**ABDB**/INSERT INTO `#__extensions`  VALUES 
('10047', '0', 'plg_webservices_banners', 'plugin', 'banners', '', 'webservices', '0', '1', '1', '0', '{\"name\":\"plg_webservices_banners\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Banners\",\"filename\":\"banners\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10048', '0', 'plg_webservices_config', 'plugin', 'config', '', 'webservices', '0', '1', '1', '0', '{\"name\":\"plg_webservices_config\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_CONFIG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Config\",\"filename\":\"config\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10049', '0', 'plg_webservices_contact', 'plugin', 'contact', '', 'webservices', '0', '1', '1', '0', '{\"name\":\"plg_webservices_contact\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Contact\",\"filename\":\"contact\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10050', '0', 'plg_webservices_languages', 'plugin', 'languages', '', 'webservices', '0', '1', '1', '0', '{\"name\":\"plg_webservices_languages\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Languages\",\"filename\":\"languages\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10051', '0', 'plg_webservices_menus', 'plugin', 'menus', '', 'webservices', '0', '1', '1', '0', '{\"name\":\"plg_webservices_menus\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_MENUS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Menus\",\"filename\":\"menus\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10052', '0', 'plg_webservices_messages', 'plugin', 'messages', '', 'webservices', '0', '1', '1', '0', '{\"name\":\"plg_webservices_messages\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Messages\",\"filename\":\"messages\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10053', '0', 'plg_webservices_modules', 'plugin', 'modules', '', 'webservices', '0', '1', '1', '0', '{\"name\":\"plg_webservices_modules\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_MODULES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Modules\",\"filename\":\"modules\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10054', '0', 'plg_webservices_newsfeeds', 'plugin', 'newsfeeds', '', 'webservices', '0', '1', '1', '0', '{\"name\":\"plg_webservices_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Newsfeeds\",\"filename\":\"newsfeeds\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10055', '0', 'plg_webservices_plugins', 'plugin', 'plugins', '', 'webservices', '0', '1', '1', '0', '{\"name\":\"plg_webservices_plugins\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_PLUGINS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Plugins\",\"filename\":\"plugins\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10056', '0', 'plg_webservices_privacy', 'plugin', 'privacy', '', 'webservices', '0', '1', '1', '0', '{\"name\":\"plg_webservices_privacy\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_PRIVACY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Privacy\",\"filename\":\"privacy\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10057', '0', 'plg_webservices_redirect', 'plugin', 'redirect', '', 'webservices', '0', '1', '1', '0', '{\"name\":\"plg_webservices_redirect\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Redirect\",\"filename\":\"redirect\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10058', '0', 'plg_webservices_tags', 'plugin', 'tags', '', 'webservices', '0', '1', '1', '0', '{\"name\":\"plg_webservices_tags\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Tags\",\"filename\":\"tags\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10059', '0', 'plg_webservices_templates', 'plugin', 'templates', '', 'webservices', '0', '1', '1', '0', '{\"name\":\"plg_webservices_templates\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Templates\",\"filename\":\"templates\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10060', '0', 'plg_webservices_users', 'plugin', 'users', '', 'webservices', '0', '1', '1', '0', '{\"name\":\"plg_webservices_users\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_USERS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Users\",\"filename\":\"users\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10061', '0', 'plg_webservices_installer', 'plugin', 'installer', '', 'webservices', '0', '1', '1', '0', '{\"name\":\"plg_webservices_installer\",\"type\":\"plugin\",\"creationDate\":\"2020-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_INSTALLER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Installer\",\"filename\":\"installer\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10062', '0', 'plg_user_token', 'plugin', 'token', '', 'user', '0', '1', '1', '0', '{\"name\":\"plg_user_token\",\"type\":\"plugin\",\"creationDate\":\"2019-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_USER_TOKEN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\Token\",\"filename\":\"token\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10063', '0', 'plg_api-authentication_token', 'plugin', 'token', '', 'api-authentication', '0', '1', '1', '0', '{\"name\":\"plg_api-authentication_token\",\"type\":\"plugin\",\"creationDate\":\"2019-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_API-AUTHENTICATION_TOKEN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\ApiAuthentication\\\\Token\",\"filename\":\"token\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10064', '0', 'plg_system_accessibility', 'plugin', 'accessibility', '', 'system', '0', '0', '1', '0', '{\"name\":\"plg_system_accessibility\",\"type\":\"plugin\",\"creationDate\":\"2020-02-15\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_ACCESSIBILITY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Accessibility\",\"filename\":\"accessibility\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10065', '802', 'English (en-GB)', 'language', 'en-GB', '', '', '3', '1', '1', '1', '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"2025-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.3.0\",\"description\":\"en-GB api language\",\"group\":\"\",\"changelogurl\":\"\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('10066', '0', 'plg_quickicon_downloadkey', 'plugin', 'downloadkey', '', 'quickicon', '0', '1', '1', '0', '{\"name\":\"plg_quickicon_downloadkey\",\"type\":\"plugin\",\"creationDate\":\"2019-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_QUICKICON_DOWNLOADKEY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\Downloadkey\",\"filename\":\"downloadkey\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('10067', '0', 'pkg_search', 'package', 'pkg_search', '', '', '0', '1', '1', '0', '{\"name\":\"pkg_search\",\"type\":\"package\",\"creationDate\":\"2021-08-17\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"pkg_search\"}', '', '', NULL, NULL, '0', '0', NULL, '0'),
('10079', '0', 'com_scheduler', 'component', 'com_scheduler', '', '', '1', '1', '1', '0', '{\"name\":\"com_scheduler\",\"type\":\"component\",\"creationDate\":\"2021-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1.0\",\"description\":\"COM_SCHEDULER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Scheduler\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10080', '0', 'plg_system_schedulerunner', 'plugin', 'schedulerunner', '', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_schedulerunner\",\"type\":\"plugin\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_SYSTEM_SCHEDULERUNNER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\ScheduleRunner\",\"filename\":\"schedulerunner\"}', '{}', '', NULL, NULL, '15', '0', NULL, '1'),
('10081', '0', 'plg_system_task_notification', 'plugin', 'tasknotification', '', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_task_notification\",\"type\":\"plugin\",\"creationDate\":\"2021-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_SYSTEM_TASK_NOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\TaskNotification\",\"filename\":\"tasknotification\"}', '', '', NULL, NULL, '22', '0', NULL, '1'),
('10082', '0', 'plg_task_check_files', 'plugin', 'checkfiles', '', 'task', '0', '1', '1', '0', '{\"name\":\"plg_task_check_files\",\"type\":\"plugin\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_TASK_CHECK_FILES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\Checkfiles\",\"filename\":\"checkfiles\"}', '{}', '', NULL, NULL, '15', '0', NULL, '1'),
('10084', '0', 'plg_task_requests', 'plugin', 'requests', '', 'task', '0', '1', '1', '0', '{\"name\":\"plg_task_requests\",\"type\":\"plugin\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_TASK_REQUESTS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\Requests\",\"filename\":\"requests\"}', '{}', '', NULL, NULL, '15', '0', NULL, '1'),
('10085', '0', 'plg_task_site_status', 'plugin', 'sitestatus', '', 'task', '0', '1', '1', '0', '{\"name\":\"plg_task_site_status\",\"type\":\"plugin\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_TASK_SITE_STATUS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\SiteStatus\",\"filename\":\"sitestatus\"}', '{}', '', NULL, NULL, '15', '0', NULL, '1'),
('10086', '0', 'plg_system_jooa11y', 'plugin', 'jooa11y', '', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_jooa11y\",\"type\":\"plugin\",\"creationDate\":\"2022-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_SYSTEM_JOOA11Y_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Jooa11y\",\"filename\":\"jooa11y\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('10087', '0', 'plg_webservices_media', 'plugin', 'media', '', 'webservices', '0', '1', '1', '0', '{\"name\":\"plg_webservices_media\",\"type\":\"plugin\",\"creationDate\":\"2021-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1.0\",\"description\":\"PLG_WEBSERVICES_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Media\",\"filename\":\"media\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10092', '0', 'plg_multifactorauth_totp', 'plugin', 'totp', '', 'multifactorauth', '0', '0', '1', '0', '{\"name\":\"plg_multifactorauth_totp\",\"type\":\"plugin\",\"creationDate\":\"2013-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_TOTP_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Multifactorauth\\\\Totp\",\"filename\":\"totp\"}', '', '', NULL, NULL, '1', '0', NULL, '1'),
('10093', '0', 'plg_multifactorauth_yubikey', 'plugin', 'yubikey', '', 'multifactorauth', '0', '0', '1', '0', '{\"name\":\"plg_multifactorauth_yubikey\",\"type\":\"plugin\",\"creationDate\":\"2013-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_YUBIKEY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Multifactorauth\\\\Yubikey\",\"filename\":\"yubikey\"}', '', '', NULL, NULL, '2', '0', NULL, '1'),
('10094', '0', 'plg_multifactorauth_webauthn', 'plugin', 'webauthn', '', 'multifactorauth', '0', '0', '1', '0', '{\"name\":\"plg_multifactorauth_webauthn\",\"type\":\"plugin\",\"creationDate\":\"2022-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2022 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_WEBAUTHN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Multifactorauth\\\\Webauthn\",\"filename\":\"webauthn\"}', '', '', NULL, NULL, '3', '0', NULL, '1'),
('10095', '0', 'plg_multifactorauth_email', 'plugin', 'email', '', 'multifactorauth', '0', '0', '1', '0', '{\"name\":\"plg_multifactorauth_email\",\"type\":\"plugin\",\"creationDate\":\"2022-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2022 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_EMAIL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Multifactorauth\\\\Email\",\"filename\":\"email\"}', '', '', NULL, NULL, '4', '0', NULL, '1'),
('10096', '0', 'plg_multifactorauth_fixed', 'plugin', 'fixed', '', 'multifactorauth', '0', '0', '1', '0', '{\"name\":\"plg_multifactorauth_fixed\",\"type\":\"plugin\",\"creationDate\":\"2022-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2022 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_FIXED_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Multifactorauth\\\\Fixed\",\"filename\":\"fixed\"}', '', '', NULL, NULL, '5', '0', NULL, '1'),
('10097', '0', 'plg_system_shortcut', 'plugin', 'shortcut', '', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_shortcut\",\"type\":\"plugin\",\"creationDate\":\"2022-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2022 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_SYSTEM_SHORTCUT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Shortcut\",\"filename\":\"shortcut\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('10099', '0', 'System - SP Page Builder Lite Updater', 'plugin', 'sppagebuilderliteupdater', '', 'system', '0', '1', '1', '0', '{\"name\":\"System - SP Page Builder Lite Updater\",\"type\":\"plugin\",\"creationDate\":\"Jul 2022\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (c) 2010 - 2022 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"3.8.10\",\"description\":\"SP Page Builder Lite Updater Plugin\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"sppagebuilderliteupdater\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10101', '0', 'com_guidedtours', 'component', 'com_guidedtours', '', '', '1', '1', '0', '0', '{\"name\":\"com_guidedtours\",\"type\":\"component\",\"creationDate\":\"2023-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.3.0\",\"description\":\"COM_GUIDEDTOURS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Guidedtours\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10102', '0', 'mod_guidedtours', 'module', 'mod_guidedtours', '', '', '1', '1', '1', '0', '{\"name\":\"mod_guidedtours\",\"type\":\"module\",\"creationDate\":\"2023-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.3.0\",\"description\":\"MOD_GUIDEDTOURS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\GuidedTours\",\"filename\":\"mod_guidedtours\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10103', '0', 'plg_system_guidedtours', 'plugin', 'guidedtours', '', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_guidedtours\",\"type\":\"plugin\",\"creationDate\":\"2023-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.3.0\",\"description\":\"PLG_SYSTEM_GUIDEDTOURS_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\GuidedTours\",\"filename\":\"guidedtours\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10106', '0', 'plg_quickicon_eos', 'plugin', 'eos', '', 'quickicon', '0', '1', '1', '0', '{\"name\":\"plg_quickicon_eos\",\"type\":\"plugin\",\"creationDate\":\"2023-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.4.0\",\"description\":\"PLG_QUICKICON_EOS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\Eos\",\"filename\":\"eos\"}', '{\"last_snoozed_id\":3}', '', NULL, NULL, '7', '0', NULL, '1'),
('10107', '0', 'plg_behaviour_compat', 'plugin', 'compat', '', 'behaviour', '0', '1', '1', '0', '{\"name\":\"plg_behaviour_compat\",\"type\":\"plugin\",\"creationDate\":\"2023-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_COMPAT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Behaviour\\\\Compat\",\"filename\":\"compat\"}', '{}', '', NULL, NULL, '-1', '0', NULL, '1'),
('10120', '0', 'System - SP PageBuilder', 'plugin', 'sppagebuilder', '', 'system', '0', '1', '1', '0', '{\"name\":\"System - SP PageBuilder\",\"type\":\"plugin\",\"creationDate\":\"Sep 2016\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2025 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"5.5.5\",\"description\":\"SP Page Builder System plugin to add support for 3rd party components\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10121', '0', 'System - SP Page Builder Pro Updater', 'plugin', 'sppagebuilderproupdater', '', 'system', '0', '1', '1', '0', '{\"name\":\"System - SP Page Builder Pro Updater\",\"type\":\"plugin\",\"creationDate\":\"Jul 2015\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (c) 2010 - 2025 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"5.5.5\",\"description\":\"SP Page Builder Pro Updater Plugin\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"sppagebuilderproupdater\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10122', '0', 'plg_search_sppagebuilder', 'plugin', 'sppagebuilder', '', 'search', '0', '0', '1', '0', '{\"name\":\"plg_search_sppagebuilder\",\"type\":\"plugin\",\"creationDate\":\"July 2015\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2015 Open Source Matters. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"5.5.5\",\"description\":\"PLG_SEARCH_SPPAGEBUILDER_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10123', '0', 'plg_finder_sppagebuilder', 'plugin', 'sppagebuilder', '', 'finder', '0', '1', '1', '0', '{\"name\":\"plg_finder_sppagebuilder\",\"type\":\"plugin\",\"creationDate\":\"March 2018\",\"author\":\"JoomShaper\",\"copyright\":\"(C) 2010 - 2025 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"5.5.5\",\"description\":\"PLG_FINDER_SP_PAGEBUILDER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10124', '0', 'Content - SP Page Builder', 'plugin', 'sppagebuilder', '', 'content', '0', '1', '1', '0', '{\"name\":\"Content - SP Page Builder\",\"type\":\"plugin\",\"creationDate\":\"Sep 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"Copyright (C) 2010 - 2025 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"5.5.5\",\"description\":\"SP Page Builder System plugin to add support for 3rd party components\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10127', '0', 'plg_sppagebuilder_loadmodule', 'plugin', 'sppagebuilderloadmodule', '', 'content', '0', '1', '1', '0', '{\"name\":\"plg_sppagebuilder_loadmodule\",\"type\":\"plugin\",\"creationDate\":\"2024-10\",\"author\":\"JoomShaper\",\"copyright\":\"(C) 2024 joomshaper.com.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"joomshaper.com\",\"version\":\"5.5.5\",\"description\":\"PLG_SPPAGEBUILDER_LOADMODULE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"JoomShaper\\\\Plugin\\\\Content\\\\Sppagebuilderloadmodule\",\"filename\":\"sppagebuilderloadmodule\"}', '{\"style\":\"none\"}', '', NULL, NULL, '0', '0', NULL, '0'),
('10129', '0', 'stratos', 'template', 'stratos', '', '', '0', '1', '1', '0', '{\"name\":\"stratos\",\"type\":\"template\",\"creationDate\":\"April 2025\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2025 JoomShaper.com. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"http:\\/\\/www.joomshaper.com\",\"version\":\"1.0.2\",\"description\":\"Stratos - Joomla Template for Business Consultancy Firms\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"templateDetails\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10130', '0', 'plg_schemaorg_blogposting', 'plugin', 'blogposting', '', 'schemaorg', '0', '1', '1', '0', '{\"name\":\"plg_schemaorg_blogposting\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_BLOGPOSTING_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\BlogPosting\",\"filename\":\"blogposting\"}', '{}', '', NULL, NULL, '1', '0', NULL, '0'),
('10131', '0', 'plg_schemaorg_book', 'plugin', 'book', '', 'schemaorg', '0', '1', '1', '0', '{\"name\":\"plg_schemaorg_book\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_BOOK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Book\",\"filename\":\"book\"}', '{}', '', NULL, NULL, '2', '0', NULL, '0'),
('10132', '0', 'plg_schemaorg_event', 'plugin', 'event', '', 'schemaorg', '0', '1', '1', '0', '{\"name\":\"plg_schemaorg_event\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_EVENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Event\",\"filename\":\"event\"}', '{}', '', NULL, NULL, '3', '0', NULL, '0'),
('10133', '0', 'plg_schemaorg_organization', 'plugin', 'organization', '', 'schemaorg', '0', '1', '1', '0', '{\"name\":\"plg_schemaorg_organization\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_ORGANIZATION_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Organization\",\"filename\":\"organization\"}', '{}', '', NULL, NULL, '4', '0', NULL, '0'),
('10134', '0', 'plg_schemaorg_person', 'plugin', 'person', '', 'schemaorg', '0', '1', '1', '0', '{\"name\":\"plg_schemaorg_person\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_PERSON_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Person\",\"filename\":\"person\"}', '{}', '', NULL, NULL, '5', '0', NULL, '0'),
('10135', '0', 'plg_schemaorg_recipe', 'plugin', 'recipe', '', 'schemaorg', '0', '1', '1', '0', '{\"name\":\"plg_schemaorg_recipe\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_RECIPE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Recipe\",\"filename\":\"recipe\"}', '{}', '', NULL, NULL, '6', '0', NULL, '0'),
('10136', '0', 'plg_schemaorg_jobposting', 'plugin', 'jobposting', '', 'schemaorg', '0', '1', '1', '0', '{\"name\":\"plg_schemaorg_jobposting\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_JOBPOSTING_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\JobPosting\",\"filename\":\"jobposting\"}', '{}', '', NULL, NULL, '7', '0', NULL, '0'),
('10137', '0', 'plg_system_schemaorg', 'plugin', 'schemaorg', '', 'system', '0', '1', '1', '0', '{\"name\":\"plg_system_schemaorg\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SYSTEM_SCHEMAORG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Schemaorg\",\"filename\":\"schemaorg\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10138', '0', 'plg_task_globalcheckin', 'plugin', 'globalcheckin', '', 'task', '0', '1', '1', '0', '{\"name\":\"plg_task_globalcheckin\",\"type\":\"plugin\",\"creationDate\":\"2023-06-22\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_TASK_GLOBALCHECKIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\Globalcheckin\",\"filename\":\"globalcheckin\"}', '{}', '', NULL, NULL, '5', '0', NULL, '0'),
('10139', '0', 'plg_task_deleteactionlogs', 'plugin', 'deleteactionlogs', '', 'task', '0', '1', '1', '0', '{\"name\":\"plg_task_deleteactionlogs\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_TASK_DELETEACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\DeleteActionLogs\",\"filename\":\"deleteactionlogs\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10140', '0', 'plg_task_privacyconsent', 'plugin', 'privacyconsent', '', 'task', '0', '1', '1', '0', '{\"name\":\"plg_task_privacyconsent\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_TASK_PRIVACYCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\PrivacyConsent\",\"filename\":\"privacyconsent\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10141', '0', 'plg_task_rotatelogs', 'plugin', 'rotatelogs', '', 'task', '0', '1', '1', '0', '{\"name\":\"plg_task_rotatelogs\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_TASK_ROTATELOGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\RotateLogs\",\"filename\":\"rotatelogs\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10142', '0', 'plg_task_sessiongc', 'plugin', 'sessiongc', '', 'task', '0', '1', '1', '0', '{\"name\":\"plg_task_sessiongc\",\"type\":\"plugin\",\"creationDate\":\"2023-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_TASK_SESSIONGC_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\SessionGC\",\"filename\":\"sessiongc\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10143', '0', 'plg_task_updatenotification', 'plugin', 'updatenotification', '', 'task', '0', '1', '1', '0', '{\"name\":\"plg_task_updatenotification\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_TASK_UPDATENOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\UpdateNotification\",\"filename\":\"updatenotification\"}', '{}', '', NULL, NULL, '0', '0', NULL, '1'),
('10144', '0', 'plg_schemaorg_article', 'plugin', 'article', '', 'schemaorg', '0', '1', '1', '0', '{\"name\":\"plg_schemaorg_article\",\"type\":\"plugin\",\"creationDate\":\"2024-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2024 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.1.0\",\"description\":\"PLG_SCHEMAORG_ARTICLE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Article\",\"filename\":\"article\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10145', '0', 'plg_schemaorg_custom', 'plugin', 'custom', '', 'schemaorg', '0', '1', '1', '0', '{\"name\":\"plg_schemaorg_custom\",\"type\":\"plugin\",\"creationDate\":\"2024-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2024 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.1.0\",\"description\":\"PLG_SCHEMAORG_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Custom\",\"filename\":\"custom\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10146', '0', 'MOD_ARTICLES', 'module', 'mod_articles', '', '', '0', '1', '0', '0', '{\"name\":\"MOD_ARTICLES\",\"type\":\"module\",\"creationDate\":\"2024-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2024 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.2.0\",\"description\":\"MOD_ARTICLES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Articles\",\"filename\":\"mod_articles\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('10147', '0', 'SP Simple Portfolio - SP Page Builder', 'plugin', 'sppagebuilder', '', 'spsimpleportfolio', '0', '0', '1', '0', '{\"name\":\"SP Simple Portfolio - SP Page Builder\",\"type\":\"plugin\",\"creationDate\":\"Mar 2019\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2025 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"5.5.5\",\"description\":\"SP Page Builder System plugin to add support for 3rd party components\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0'),
('10149', '0', 'plg_extension_joomlaupdate', 'plugin', 'joomlaupdate', '', 'extension', '0', '1', '1', '0', '{\"name\":\"plg_extension_joomlaupdate\",\"type\":\"plugin\",\"creationDate\":\"2025-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2025 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"1.0.0\",\"description\":\"PLG_EXTENSION_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Extension\\\\Joomlaupdate\",\"filename\":\"joomlaupdate\"}', '', '', NULL, NULL, '0', '0', NULL, '1'),
('10152', '10154', 'com_akeebabackup', 'component', 'com_akeebabackup', '', '', '1', '1', '0', '0', '{\"name\":\"com_akeebabackup\",\"type\":\"component\",\"creationDate\":\"2025-07-21\",\"author\":\"Akeeba Ltd\",\"copyright\":\"Copyright (c)2006-2025 Akeeba Ltd \\/ Nicholas K. Dionysopoulos\",\"authorEmail\":\"no-reply@akeeba.com\",\"authorUrl\":\"www.akeeba.com\",\"version\":\"10.0.5\",\"description\":\"COM_AKEEBABACKUP_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Akeeba\\\\Component\\\\AkeebaBackup\",\"filename\":\"akeebabackup\"}', '{\"frontend_secret_word\":\"###AES128###vrS9NEkO4snJFPzY99JukUpQU1QAhXoqs7DpPvxz9IJl+iVOig2WZMja4YTsx2aar6ec2spGnYL3ys3XWgAudvtZKKI7gUZquW65dXU4ZoN+EPPRSlBJVsNHEi+hwTkhWTxnGv8vwGoAAAAA\",\"confwiz_upgrade\":1,\"siteurl\":\"http:\\/\\/localhost:8888\\/getbs1\\/\",\"jlibrariesdir\":\"\\/Applications\\/MAMP\\/htdocs\\/getbs1\\/libraries\"}', '', NULL, NULL, '0', '0', NULL, '0'),
('10153', '10154', 'PLG_QUICKICON_AKEEBABACKUP', 'plugin', 'akeebabackup', '', 'quickicon', '0', '1', '1', '0', '{\"name\":\"PLG_QUICKICON_AKEEBABACKUP\",\"type\":\"plugin\",\"creationDate\":\"2025-07-21\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"Copyright (c)2006-2025 Akeeba Ltd \\/ Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@dionysopoulos.me\",\"authorUrl\":\"https:\\/\\/www.akeeba.com\",\"version\":\"10.0.5\",\"description\":\"PLG_QUICKICON_AKEEBABACKUP_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Akeeba\\\\Plugin\\\\QuickIcon\\\\AkeebaBackup\",\"filename\":\"akeebabackup\"}', '{\"enablewarning\":\"1\",\"warnfailed\":\"1\",\"maxbackupperiod\":\"24\",\"profileid\":\"1\"}', '', NULL, NULL, '0', '0', NULL, '0'),
('10154', '0', 'pkg_akeebabackup', 'package', 'pkg_akeebabackup', '', '', '0', '1', '1', '0', '{\"name\":\"pkg_akeebabackup\",\"type\":\"package\",\"creationDate\":\"2025-07-21\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"Copyright (c)2006-2025 Nicholas K. Dionysopoulos \\/ Akeeba Ltd\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"10.0.5\",\"description\":\"PKG_AKEEBABACKUP_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"pkg_akeebabackup\"}', '{}', '', NULL, NULL, '0', '0', NULL, '0');
/**ABDB**/CREATE TABLE `#__fields` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0',
  `context` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `group_id` int unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `label` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `default_value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'text',
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int NOT NULL DEFAULT '0',
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldparams` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_time` datetime NOT NULL,
  `created_user_id` int unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `access` int NOT NULL DEFAULT '1',
  `only_use_in_subform` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_created_user_id` (`created_user_id`),
  KEY `idx_access` (`access`),
  KEY `idx_context` (`context`(191)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__fields_categories` (
  `field_id` int NOT NULL DEFAULT '0',
  `category_id` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`field_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__fields_groups` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0',
  `context` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int NOT NULL DEFAULT '0',
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `access` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_created_by` (`created_by`),
  KEY `idx_access` (`access`),
  KEY `idx_context` (`context`(191)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__fields_values` (
  `field_id` int unsigned NOT NULL,
  `item_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Allow references to items which have strings as ids, eg. none db systems.',
  `value` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  KEY `idx_field_id` (`field_id`),
  KEY `idx_item_id` (`item_id`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__finder_filters` (
  `filter_id` int unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint NOT NULL DEFAULT '1',
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `map_count` int unsigned NOT NULL DEFAULT '0',
  `data` text COLLATE utf8mb4_unicode_ci,
  `params` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`filter_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__finder_links` (
  `link_id` int unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `route` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `indexdate` datetime NOT NULL,
  `md5sum` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `published` tinyint NOT NULL DEFAULT '1',
  `state` int NOT NULL DEFAULT '1',
  `access` int NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `publish_start_date` datetime DEFAULT NULL,
  `publish_end_date` datetime DEFAULT NULL,
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `list_price` double unsigned NOT NULL DEFAULT '0',
  `sale_price` double unsigned NOT NULL DEFAULT '0',
  `type_id` int NOT NULL,
  `object` mediumblob,
  PRIMARY KEY (`link_id`),
  KEY `idx_type` (`type_id`),
  KEY `idx_title` (`title`(100)),
  KEY `idx_md5` (`md5sum`),
  KEY `idx_url` (`url`(75)),
  KEY `idx_language` (`language`),
  KEY `idx_published_list` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`list_price`),
  KEY `idx_published_sale` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`sale_price`)
) ENGINE=InnoDB AUTO_INCREMENT=107 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__finder_links`  VALUES 
('94', 'index.php?option=com_sppagebuilder&view=page&id=2', 'index.php?option=com_sppagebuilder&view=page&id=2&Itemid=108', 'Academic Associates', 'ABOUT - WHO WE ARE About Us Who We Are A Graduate Engineering & Technological Business School (GET-BS) that is a newly established academic entity under the Faculty of Industrial Management (FIM), Universiti Malaysia Pahang Al-Sultan Abdullah (UMPSA), accredited by MQA and ABEST21. Our Mission, Vision & Objectives Our Mission To be a leading technical graduate business school that brings positive managerial and social impact to the world. Our Vision To provide thought leadership in cutting-edge advanced courses required by the industry, and to attract good students and major industries to collaborate in developing industry solutions. Objectives To produce graduates who excel in business and technology. To strengthen collaboration with industries and the community through relevant research and consultation To advance the latest thinking from academia and professional practices for business sustainability. Why do we focus on sustainability and advanced TVET? Sustainability-Driven TVET Leadership To empower students to pioneer sustainable innovation, merging advanced TVET with eco-conscious leadership, directly advancing UMPSA’s vision as Malaysia’s first eco-university. Future-Ready Technical & Entrepreneurial Skills Equip students with cutting-edge technical expertise and industry-ready business acumen, blending engineering proficiency with entrepreneurial leadership for tomorrow’s tech-driven economy. Connect with us - Apply Now getbs_admission@umpsa.edu.my rps_fim@ump.my https://www.facebook.com/GETBS', '2025-09-17 19:06:39', '24faac55672158af7c5e8f5b066e5b88', '1', '1', '1', '*', NULL, NULL, '2018-02-22 09:31:20', NULL, '0', '0', '6', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:1533:\"ABOUT - WHO WE ARE About Us Who We Are A Graduate Engineering & Technological Business School (GET-BS) that is a newly established academic entity under the Faculty of Industrial Management (FIM), Universiti Malaysia Pahang Al-Sultan Abdullah (UMPSA), accredited by MQA and ABEST21. Our Mission, Vision & Objectives Our Mission To be a leading technical graduate business school that brings positive managerial and social impact to the world. Our Vision To provide thought leadership in cutting-edge advanced courses required by the industry, and to attract good students and major industries to collaborate in developing industry solutions. Objectives To produce graduates who excel in business and technology. To strengthen collaboration with industries and the community through relevant research and consultation To advance the latest thinking from academia and professional practices for business sustainability. Why do we focus on sustainability and advanced TVET? Sustainability-Driven TVET Leadership To empower students to pioneer sustainable innovation, merging advanced TVET with eco-conscious leadership, directly advancing UMPSA’s vision as Malaysia’s first eco-university. Future-Ready Technical & Entrepreneurial Skills Equip students with cutting-edge technical expertise and industry-ready business acumen, blending engineering proficiency with entrepreneurial leadership for tomorrow’s tech-driven economy. Connect with us - Apply Now getbs_admission@umpsa.edu.my rps_fim@ump.my https://www.facebook.com/GETBS\";i:3;a:17:{s:2:\"id\";i:2;s:7:\"view_id\";i:0;s:4:\"body\";s:1743:\"ABOUT - WHO WE ARE       About Us  Who We Are          A Graduate Engineering &amp; Technological Business School (GET-BS) that is a newly established academic entity under the Faculty of Industrial Management (FIM), Universiti Malaysia Pahang Al-Sultan Abdullah (UMPSA), accredited by MQA and ABEST21.&nbsp;                                      Our Mission, Vision & Objectives                 Our Mission  To be a leading technical graduate business school that brings positive managerial and social impact to the world.          Our Vision  To provide thought leadership in cutting-edge advanced courses required by the industry, and to attract good students and major industries to collaborate in developing industry solutions.              Objectives   To produce graduates who excel in business and technology.   To strengthen collaboration with industries and the community through relevant research and consultation   To advance the latest thinking from academia and professional practices for business sustainability.                                            Why do we focus on sustainability and advanced TVET?\n       Sustainability-Driven TVET Leadership  To empower students to pioneer sustainable innovation, merging advanced TVET with eco-conscious leadership, directly advancing UMPSA’s vision as Malaysia’s first eco-university.                Future-Ready Technical & Entrepreneurial Skills  Equip students with cutting-edge technical expertise and industry-ready business acumen, blending engineering proficiency with entrepreneurial leadership for tomorrow’s tech-driven economy.                            Connect with us - Apply Now    getbs_admission@umpsa.edu.my   rps_fim@ump.my   https://www.facebook.com/GETBS\";s:4:\"text\";s:15693:\"[{\"id\":1519292114797,\"visibility\":true,\"collapse\":false,\"settings\":{\"default\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":\"50px 0px 50px 0px\",\"margin\":\"0px 0px 0px 0px\",\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"instFormId\":1519292114797,\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"70px 0px 70px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_video\":0},\"layout\":\"12\",\"columns\":[{\"id\":1519292114796,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"default\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"}},\"addons\":[{\"id\":1519292140689,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"About Us\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eium od tempor incididunt ut labore et dolore magna aliqua. Ut enim adm inim veniam, quis nostrud exercitation. Ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.\",\"alignment\":\"sppb-text-center\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"dropcap\":0,\"class\":\"\",\"instFormId\":1519292140689,\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0}}]}]},{\"id\":1519292114817,\"visibility\":true,\"collapse\":false,\"settings\":{\"default\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":\"50px 0px 50px 0px\",\"margin\":\"0px 0px 0px 0px\",\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"instFormId\":1519292114817,\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"0px 0px 40px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_video\":0},\"layout\":\"6,6\",\"columns\":[{\"id\":1519292114815,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"default\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"}},\"addons\":[{\"id\":1519292279684,\"name\":\"tab\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"style\":\"tabs\",\"active_tab_bg\":\"#e5e5e5\",\"active_tab_color\":\"#333333\",\"class\":\"\",\"sp_tab_item\":[{\"title\":\"Mission\",\"icon\":\"\",\"content\":[{\"id\":1519292114872,\"name\":\"text_block\",\"settings\":{\"text\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod.<br /><br />Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et. Wolf moon officia aute, non cupidatat skateboard dolor brunch.\",\"dropcap\":0}}]},{\"title\":\"Vision\",\"icon\":\"\",\"content\":[{\"id\":1519292350787,\"name\":\"text_block\",\"settings\":{\"text\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod.<br /><br />Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\",\"dropcap\":0}}]}],\"instFormId\":1519292279684,\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0}}]},{\"id\":1519292114816,\"class_name\":\"col-md-6\",\"visibility\":true,\"settings\":{\"default\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"}},\"addons\":[{\"id\":1519292503968,\"name\":\"accordion\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"style\":\"panel-default\",\"openitem\":\"\",\"class\":\"\",\"sp_accordion_item\":[{\"title\":\"Accordion Title\",\"icon\":\"\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\"},{\"title\":\"Accordion Title\",\"icon\":\"\",\"content\":\"Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.\"}],\"instFormId\":1519292503968,\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0}}]}]},{\"id\":1519320065460,\"visibility\":true,\"collapse\":false,\"settings\":{\"default\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":\"50px 0px 50px 0px\",\"margin\":\"0px 0px 0px 0px\",\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"instFormId\":1519320065460,\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"70px 0px 70px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_video\":0,\"background_color\":\"#f9f9f9\"},\"layout\":\"12\",\"columns\":[{\"id\":1519320065461,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"default\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"}},\"addons\":[{\"id\":1519320065462,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Meet The Team\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"text\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eium od tempor incididunt ut labore et dolore magna aliqua.<br />Ut enim adm inim veniam, quis nostrud exercitation.\",\"alignment\":\"sppb-text-center\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"dropcap\":0,\"class\":\"\",\"instFormId\":1519320065462,\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0}}]}]},{\"id\":1519320065459,\"visibility\":true,\"collapse\":false,\"settings\":{\"default\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":\"50px 0px 50px 0px\",\"margin\":\"0px 0px 0px 0px\",\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"instFormId\":1519320065459,\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"0px 0px 40px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_video\":0,\"background_color\":\"#f9f9f9\"},\"layout\":\"4,4,4\",\"columns\":[{\"id\":1519320065455,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"default\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"}},\"addons\":[{\"id\":1519320760276,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Lucas Schultz\",\"heading_selector\":\"h3\",\"title_fontsize\":{\"md\":\"16\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_position\":\"bottom\",\"image\":\"images/2018/02/22/person1.jpg\",\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-left\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"\",\"class\":\"\",\"instFormId\":1519320760276,\"title_margin_top\":{\"md\":\"10\",\"sm\":\"\",\"xs\":\"\"},\"title_margin_bottom\":{\"md\":\"0\",\"sm\":\"\",\"xs\":\"\"},\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0}}]},{\"id\":1519320065456,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"default\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"}},\"addons\":[{\"id\":1519320838960,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Ara Dare\",\"heading_selector\":\"h3\",\"title_fontsize\":{\"md\":\"16\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_position\":\"bottom\",\"image\":\"images/2018/02/22/person2.jpg\",\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-left\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"\",\"class\":\"\",\"instFormId\":1519320838960,\"title_margin_top\":{\"md\":\"10\",\"sm\":\"\",\"xs\":\"\"},\"title_margin_bottom\":{\"md\":\"0\",\"sm\":\"\",\"xs\":\"\"},\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0}}]},{\"id\":1519320065457,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"default\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"}},\"addons\":[{\"id\":1519320838963,\"name\":\"image\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Dimitri Abernathy\",\"heading_selector\":\"h3\",\"title_fontsize\":{\"md\":\"16\",\"sm\":\"\",\"xs\":\"\"},\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_position\":\"bottom\",\"image\":\"images/2018/02/22/person3.jpg\",\"border_radius\":0,\"alt_text\":\"Image\",\"position\":\"sppb-text-left\",\"open_lightbox\":0,\"overlay_color\":\"rgba(119, 219, 31, .5)\",\"link\":\"\",\"class\":\"\",\"instFormId\":1519320838963,\"title_margin_top\":{\"md\":\"10\",\"sm\":\"\",\"xs\":\"\"},\"title_margin_bottom\":{\"md\":\"0\",\"sm\":\"\",\"xs\":\"\"},\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0}}]}]},{\"id\":1519320065316,\"visibility\":true,\"collapse\":false,\"settings\":{\"default\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":\"50px 0px 50px 0px\",\"margin\":\"0px 0px 0px 0px\",\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"instFormId\":1519320065316,\"columns_align_center\":1,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"70px 0px 40px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_video\":0,\"background_color\":\"\"},\"layout\":\"3,9\",\"columns\":[{\"id\":1519320065315,\"class_name\":\"col-md-9\",\"visibility\":true,\"settings\":{\"default\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"}},\"addons\":[{\"id\":1519320512191,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Discover all Helix Ultimate Features\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"text\":\"Lorem Ipsum is simply dummy text of the printing and typesetting industry.<br />Lorem Ipsum has been the industry&rsquo;s.\",\"alignment\":\"\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"dropcap\":0,\"class\":\"\",\"instFormId\":1519320512191,\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0}}]},{\"id\":1519320065314,\"class_name\":\"col-md-3\",\"visibility\":true,\"settings\":{\"default\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"}},\"addons\":[{\"id\":1519320578289,\"name\":\"button\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"text\":\"Learn More\",\"alignment\":\"sppb-text-right\",\"letterspace\":\"0\",\"type\":\"primary\",\"appearance\":\"flat\",\"background_color\":\"#03E16D\",\"color\":\"#FFFFFF\",\"background_color_hover\":\"#00E66E\",\"color_hover\":\"#FFFFFF\",\"button_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"icon_position\":\"left\",\"class\":\"\",\"instFormId\":1519320578289,\"url\":\"#\",\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"0px 0px 30px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0,\"size\":\"lg\"}}]}]}]\";s:10:\"created_by\";i:871;s:8:\"modified\";s:19:\"2025-09-17 18:50:25\";s:11:\"modified_by\";i:300;s:5:\"catid\";i:0;s:9:\"extension\";s:17:\"com_sppagebuilder\";s:14:\"extension_view\";s:4:\"page\";s:8:\"ordering\";i:0;s:4:\"name\";N;s:4:\"mime\";N;s:6:\"layout\";s:4:\"page\";s:7:\"context\";s:22:\"com_sppagebuilder.page\";s:7:\"summary\";s:1743:\"ABOUT - WHO WE ARE       About Us  Who We Are          A Graduate Engineering &amp; Technological Business School (GET-BS) that is a newly established academic entity under the Faculty of Industrial Management (FIM), Universiti Malaysia Pahang Al-Sultan Abdullah (UMPSA), accredited by MQA and ABEST21.&nbsp;                                      Our Mission, Vision & Objectives                 Our Mission  To be a leading technical graduate business school that brings positive managerial and social impact to the world.          Our Vision  To provide thought leadership in cutting-edge advanced courses required by the industry, and to attract good students and major industries to collaborate in developing industry solutions.              Objectives   To produce graduates who excel in business and technology.   To strengthen collaboration with industries and the community through relevant research and consultation   To advance the latest thinking from academia and professional practices for business sustainability.                                            Why do we focus on sustainability and advanced TVET?\n       Sustainability-Driven TVET Leadership  To empower students to pioneer sustainable innovation, merging advanced TVET with eco-conscious leadership, directly advancing UMPSA’s vision as Malaysia’s first eco-university.                Future-Ready Technical & Entrepreneurial Skills  Equip students with cutting-edge technical expertise and industry-ready business acumen, blending engineering proficiency with entrepreneurial leadership for tomorrow’s tech-driven economy.                            Connect with us - Apply Now    getbs_admission@umpsa.edu.my   rps_fim@ump.my   https://www.facebook.com/GETBS\";s:4:\"path\";s:5:\"index\";}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:4:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:4:\"user\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;N;i:10;N;i:11;s:60:\"index.php?option=com_sppagebuilder&view=page&id=2&Itemid=108\";i:12;N;i:13;s:19:\"2018-02-22 09:31:20\";i:14;i:1;i:15;a:2:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:4:\"Page\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:0;s:2:\"id\";i:35;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:0;s:2:\"id\";i:7;}}}i:16;s:19:\"Academic Associates\";i:17;i:6;i:18;s:49:\"index.php?option=com_sppagebuilder&view=page&id=2\";}'),
('95', 'index.php?option=com_sppagebuilder&view=page&id=3', 'index.php?option=com_sppagebuilder&view=page&id=3', 'Contact', 'CONTACT US Get in Touch with Stratos What can we help you with? choose items Strategic Planning Financial Consulting Operational Optimization HR Development Marketing Strategy Technology Integration First Name Email Phone Message * Please fill the required field. PHA+PHN0cm9uZz5Gcm9tOjwvc3Ryb25nPnt7Zmlyc3QtbmFtZX19IHt7bGFzdC1uYW1lfX08L3A+CjxwPjxzdHJvbmc+RW1haWw6PC9zdHJvbmc+e3tlbWFpbH19PC9wPgo8cD48c3Ryb25nPlN1YmplY3Q6PC9zdHJvbmc+e3tzdWJqZWN0fX08L3A+CjxwPjxzdHJvbmc+TWVzc2FnZTo8L3N0cm9uZz57e21lc3NhZ2V9fTwvcD4= Make an Appointment New York, USA 2005 Stokes Isle Apt. 896, New York 10010 (920) 948-1722 Los Angeles, USA 2614 Sweetwood Drive, Arvada, CO 80002 (907) 248-8330 Boston, USA 1406 Mattson Street, Boston, OR 97103 (636) 296-7838', '2025-09-17 19:06:39', 'f9643acc87fd5c12527821881bb85690', '1', '1', '1', '*', NULL, NULL, '2018-02-22 09:31:28', NULL, '0', '0', '6', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:739:\"CONTACT US Get in Touch with Stratos What can we help you with? choose items Strategic Planning Financial Consulting Operational Optimization HR Development Marketing Strategy Technology Integration First Name Email Phone Message * Please fill the required field. PHA+PHN0cm9uZz5Gcm9tOjwvc3Ryb25nPnt7Zmlyc3QtbmFtZX19IHt7bGFzdC1uYW1lfX08L3A+CjxwPjxzdHJvbmc+RW1haWw6PC9zdHJvbmc+e3tlbWFpbH19PC9wPgo8cD48c3Ryb25nPlN1YmplY3Q6PC9zdHJvbmc+e3tzdWJqZWN0fX08L3A+CjxwPjxzdHJvbmc+TWVzc2FnZTo8L3N0cm9uZz57e21lc3NhZ2V9fTwvcD4= Make an Appointment New York, USA 2005 Stokes Isle Apt. 896, New York 10010 (920) 948-1722 Los Angeles, USA 2614 Sweetwood Drive, Arvada, CO 80002 (907) 248-8330 Boston, USA 1406 Mattson Street, Boston, OR 97103 (636) 296-7838\";i:3;a:17:{s:2:\"id\";i:3;s:7:\"view_id\";i:0;s:4:\"body\";s:915:\"CONTACT US       Get in Touch with Stratos                              What can we help you with?           choose items     Strategic Planning    Financial Consulting    Operational Optimization    HR Development    Marketing Strategy    Technology Integration     First Name    Email    Phone    Message *    Please fill the required field.     PHA+PHN0cm9uZz5Gcm9tOjwvc3Ryb25nPnt7Zmlyc3QtbmFtZX19IHt7bGFzdC1uYW1lfX08L3A+CjxwPjxzdHJvbmc+RW1haWw6PC9zdHJvbmc+e3tlbWFpbH19PC9wPgo8cD48c3Ryb25nPlN1YmplY3Q6PC9zdHJvbmc+e3tzdWJqZWN0fX08L3A+CjxwPjxzdHJvbmc+TWVzc2FnZTo8L3N0cm9uZz57e21lc3NhZ2V9fTwvcD4=     Make an Appointment                             New York, USA         2005 Stokes Isle Apt. 896, New York 10010 (920) 948-1722                   Los Angeles, USA         2614 Sweetwood Drive, Arvada, CO 80002 (907) 248-8330                   Boston, USA         1406 Mattson Street, Boston, OR 97103 (636) 296-7838\";s:4:\"text\";s:2:\"[]\";s:10:\"created_by\";i:871;s:8:\"modified\";s:19:\"2025-04-16 09:13:13\";s:11:\"modified_by\";i:961;s:5:\"catid\";i:0;s:9:\"extension\";s:17:\"com_sppagebuilder\";s:14:\"extension_view\";s:4:\"page\";s:8:\"ordering\";i:0;s:4:\"name\";N;s:4:\"mime\";N;s:6:\"layout\";s:4:\"page\";s:7:\"context\";s:22:\"com_sppagebuilder.page\";s:7:\"summary\";s:915:\"CONTACT US       Get in Touch with Stratos                              What can we help you with?           choose items     Strategic Planning    Financial Consulting    Operational Optimization    HR Development    Marketing Strategy    Technology Integration     First Name    Email    Phone    Message *    Please fill the required field.     PHA+PHN0cm9uZz5Gcm9tOjwvc3Ryb25nPnt7Zmlyc3QtbmFtZX19IHt7bGFzdC1uYW1lfX08L3A+CjxwPjxzdHJvbmc+RW1haWw6PC9zdHJvbmc+e3tlbWFpbH19PC9wPgo8cD48c3Ryb25nPlN1YmplY3Q6PC9zdHJvbmc+e3tzdWJqZWN0fX08L3A+CjxwPjxzdHJvbmc+TWVzc2FnZTo8L3N0cm9uZz57e21lc3NhZ2V9fTwvcD4=     Make an Appointment                             New York, USA         2005 Stokes Isle Apt. 896, New York 10010 (920) 948-1722                   Los Angeles, USA         2614 Sweetwood Drive, Arvada, CO 80002 (907) 248-8330                   Boston, USA         1406 Mattson Street, Boston, OR 97103 (636) 296-7838\";s:4:\"path\";s:5:\"index\";}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:4:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:4:\"user\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;N;i:10;N;i:11;s:49:\"index.php?option=com_sppagebuilder&view=page&id=3\";i:12;N;i:13;s:19:\"2018-02-22 09:31:28\";i:14;i:1;i:15;a:2:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:4:\"Page\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:0;s:2:\"id\";i:35;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:0;s:2:\"id\";i:7;}}}i:16;s:7:\"Contact\";i:17;i:6;i:18;s:49:\"index.php?option=com_sppagebuilder&view=page&id=3\";}'),
('96', 'index.php?option=com_sppagebuilder&view=page&id=4', 'index.php?option=com_sppagebuilder&view=page&id=4', 'Services', 'SERVICES Innovative Approaches for Lasting Growth #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-before { display: block; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-after { display: none; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-left { display: none; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-right { display: none; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}}@media (max-width: 1200px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-before { display: block; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-after { display: none; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-left { display: none; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-right { display: none; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} } @media (max-width: 992px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-before { display: block; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-after { display: none; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-left { display: none; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-right { display: none; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} } @media (max-width: 768px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-before { display: block; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-after { display: none; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-left { display: none; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-right { display: none; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} } @media (max-width: 575px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-before { display: block; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-after { display: none; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-left { display: none; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-right { display: none; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} } Biz Strategy & Growth We assist businesses in defining their vision and creating growth strategies for long-term success. Learn More #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-before { display: block; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-after { display: none; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-left { display: none; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-right { display: none; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}}@media (max-width: 1200px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-before { display: block; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-after { display: none; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-left { display: none; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-right { display: none; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} } @media (max-width: 992px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-before { display: block; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-after { display: none; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-left { display: none; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-right { display: none; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} } @media (max-width: 768px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-before { display: block; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-after { display: none; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-left { display: none; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-right { display: none; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} } @media (max-width: 575px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-before { display: block; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-after { display: none; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-left { display: none; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-right { display: none; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} } Financial Consulting We assist businesses in defining their vision and creating growth strategies for long-term success. Learn More #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-before { display: block; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-after { display: none; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-left { display: none; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-right { display: none; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}}@media (max-width: 1200px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-before { display: block; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-after { display: none; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-left { display: none; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-right { display: none; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} } @media (max-width: 992px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-before { display: block; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-after { display: none; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-left { display: none; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-right { display: none; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} } @media (max-width: 768px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-before { display: block; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-after { display: none; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-left { display: none; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-right { display: none; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} } @media (max-width: 575px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-before { display: block; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-after { display: none; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-left { display: none; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-right { display: none; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} } Operations & Efficiency We assist businesses in defining their vision and creating growth strategies for long-term success. Learn More #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-before { display: block; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-after { display: none; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-left { display: none; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-right { display: none; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}}@media (max-width: 1200px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-before { display: block; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-after { display: none; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-left { display: none; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-right { display: none; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} } @media (max-width: 992px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-before { display: block; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-after { display: none; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-left { display: none; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-right { display: none; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} } @media (max-width: 768px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-before { display: block; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-after { display: none; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-left { display: none; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-right { display: none; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} } @media (max-width: 575px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-before { display: block; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-after { display: none; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-left { display: none; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-right { display: none; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} } Leadership Training We assist businesses in defining their vision and creating growth strategies for long-term success. Learn More Our Company Working Process 01 Discussions About Project Let\'s dive into the exciting conversations surrounding our latest project! We can explore ideas, and brainstorm solutions together. What are your thoughts? 02 Start Work With Them Start collaborating with them on our latest project! We can discuss ideas, provide updates, and brainstorm solutions together. What do you think? 03 Handover & Save World Let\'s discuss the Handover process and how we can collectively save the world! We can share insights impactful solutions. What do you think? TESTIMONIALS What Our Clients Say \"Using this software has transformed the way our team collaborates. The intuitive interface and powerful features have significantly boosted our productivity. Alex Buckmaster CEO, Skyline Innovations \"Our team\'s collaboration has taken a giant leap forward thanks to this software. Its intuitive interface and powerful features have significantly boosted our productivity.\" Stephanie Nicol CEO, Skyline Innovations \"This software has revolutionized our team\'s collaboration. Its user-friendly design and robust functionalities have greatly enhanced our efficiency.\" Chris Glasser CEO, Skyline Innovations \"Thanks to this amazing software, our team is working together like never before! The user-friendly design and robust functionalities have really ramped up our efficiency.\" Judith Rodriguez CEO, Skyline Innovations', '2025-09-17 19:06:39', '072c1522984c8d270f162dd1903108b0', '1', '1', '1', '*', NULL, NULL, '2018-02-22 09:31:20', NULL, '0', '0', '6', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:17707:\"SERVICES Innovative Approaches for Lasting Growth #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-before { display: block; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-after { display: none; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-left { display: none; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-right { display: none; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}}@media (max-width: 1200px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-before { display: block; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-after { display: none; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-left { display: none; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-right { display: none; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} } @media (max-width: 992px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-before { display: block; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-after { display: none; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-left { display: none; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-right { display: none; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} } @media (max-width: 768px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-before { display: block; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-after { display: none; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-left { display: none; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-right { display: none; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} } @media (max-width: 575px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-before { display: block; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-after { display: none; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-left { display: none; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-right { display: none; } #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} } Biz Strategy & Growth We assist businesses in defining their vision and creating growth strategies for long-term success. Learn More #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-before { display: block; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-after { display: none; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-left { display: none; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-right { display: none; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}}@media (max-width: 1200px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-before { display: block; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-after { display: none; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-left { display: none; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-right { display: none; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} } @media (max-width: 992px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-before { display: block; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-after { display: none; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-left { display: none; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-right { display: none; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} } @media (max-width: 768px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-before { display: block; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-after { display: none; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-left { display: none; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-right { display: none; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} } @media (max-width: 575px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-before { display: block; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-after { display: none; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-left { display: none; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-right { display: none; } #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} } Financial Consulting We assist businesses in defining their vision and creating growth strategies for long-term success. Learn More #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-before { display: block; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-after { display: none; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-left { display: none; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-right { display: none; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}}@media (max-width: 1200px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-before { display: block; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-after { display: none; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-left { display: none; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-right { display: none; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} } @media (max-width: 992px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-before { display: block; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-after { display: none; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-left { display: none; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-right { display: none; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} } @media (max-width: 768px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-before { display: block; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-after { display: none; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-left { display: none; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-right { display: none; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} } @media (max-width: 575px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-before { display: block; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-after { display: none; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-left { display: none; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-right { display: none; } #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} } Operations & Efficiency We assist businesses in defining their vision and creating growth strategies for long-term success. Learn More #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-before { display: block; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-after { display: none; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-left { display: none; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-right { display: none; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}}@media (max-width: 1200px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-before { display: block; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-after { display: none; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-left { display: none; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-right { display: none; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} } @media (max-width: 992px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-before { display: block; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-after { display: none; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-left { display: none; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-right { display: none; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} } @media (max-width: 768px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-before { display: block; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-after { display: none; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-left { display: none; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-right { display: none; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} } @media (max-width: 575px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-before { display: block; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-after { display: none; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-left { display: none; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-right { display: none; } #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{ display: block; } @media (max-width: 1199.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} @media (max-width: 991.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} @media (max-width: 767.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} @media (max-width: 575.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} } Leadership Training We assist businesses in defining their vision and creating growth strategies for long-term success. Learn More Our Company Working Process 01 Discussions About Project Let\'s dive into the exciting conversations surrounding our latest project! We can explore ideas, and brainstorm solutions together. What are your thoughts? 02 Start Work With Them Start collaborating with them on our latest project! We can discuss ideas, provide updates, and brainstorm solutions together. What do you think? 03 Handover & Save World Let\'s discuss the Handover process and how we can collectively save the world! We can share insights impactful solutions. What do you think? TESTIMONIALS What Our Clients Say \"Using this software has transformed the way our team collaborates. The intuitive interface and powerful features have significantly boosted our productivity. Alex Buckmaster CEO, Skyline Innovations \"Our team\'s collaboration has taken a giant leap forward thanks to this software. Its intuitive interface and powerful features have significantly boosted our productivity.\" Stephanie Nicol CEO, Skyline Innovations \"This software has revolutionized our team\'s collaboration. Its user-friendly design and robust functionalities have greatly enhanced our efficiency.\" Chris Glasser CEO, Skyline Innovations \"Thanks to this amazing software, our team is working together like never before! The user-friendly design and robust functionalities have really ramped up our efficiency.\" Judith Rodriguez CEO, Skyline Innovations\";i:3;a:17:{s:2:\"id\";i:4;s:7:\"view_id\";i:0;s:4:\"body\";s:18858:\"SERVICES       Innovative Approaches for Lasting Growth                              #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}}@media (max-width: 1200px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} } @media (max-width: 992px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} } @media (max-width: 768px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} } @media (max-width: 575px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} }        Biz Strategy & Growth We assist businesses in defining their vision and creating growth strategies for long-term success. Learn More                 #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}}@media (max-width: 1200px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} } @media (max-width: 992px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} } @media (max-width: 768px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} } @media (max-width: 575px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} }        Financial Consulting We assist businesses in defining their vision and creating growth strategies for long-term success. Learn More                 #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}}@media (max-width: 1200px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} } @media (max-width: 992px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} } @media (max-width: 768px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} } @media (max-width: 575px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} }        Operations & Efficiency We assist businesses in defining their vision and creating growth strategies for long-term success. Learn More                 #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}}@media (max-width: 1200px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} } @media (max-width: 992px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} } @media (max-width: 768px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} } @media (max-width: 575px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} }        Leadership Training We assist businesses in defining their vision and creating growth strategies for long-term success. Learn More                                                                 Our Company Working Process            01   Discussions About Project Let\'s dive into the exciting conversations surrounding our latest project! We can explore ideas, and brainstorm solutions together. What are your thoughts?                 02   Start Work With Them Start collaborating with them on our latest project! We can discuss ideas, provide updates, and brainstorm solutions together. What do you think?                 03   Handover & Save World Let\'s discuss the Handover process and how we can collectively save the world! We can share insights impactful solutions. What do you think?                        TESTIMONIALS       What Our Clients Say                \"Using this software has transformed the way our team collaborates. The intuitive interface and powerful features have significantly boosted our productivity.   Alex Buckmaster&nbsp;CEO, Skyline Innovations      \"Our team\'s collaboration has taken a giant leap forward thanks to this software. Its intuitive interface and powerful features have significantly boosted our productivity.\"   Stephanie Nicol&nbsp;CEO, Skyline Innovations      \"This software has revolutionized our team\'s collaboration. Its user-friendly design and robust functionalities have greatly enhanced our efficiency.\"   Chris Glasser&nbsp;CEO, Skyline Innovations      \"Thanks to this amazing software, our team is working together like never before! The user-friendly design and robust functionalities have really ramped up our efficiency.\"   Judith Rodriguez&nbsp;CEO, Skyline Innovations\";s:4:\"text\";s:11442:\"[{\"id\":1519278764266,\"visibility\":true,\"collapse\":false,\"settings\":{\"default\":{\"admin_label\":\"\",\"title\":\"\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_fontweight\":\"\",\"title_position\":\"sppb-text-center\",\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":\"50px 0px 50px 0px\",\"margin\":\"0px 0px 0px 0px\",\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"fixed\",\"background_position\":\"0 0\",\"background_video\":\"0\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"},\"instFormId\":1519278764266,\"columns_align_center\":0,\"fullscreen\":0,\"no_gutter\":0,\"padding\":{\"md\":\"70px 0px 20px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"margin\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"background_video\":0,\"background_color\":\"#F9F9F9\"},\"layout\":\"12,4,4,4\",\"columns\":[{\"id\":1519278764262,\"class_name\":\"col-md-12\",\"visibility\":true,\"settings\":{\"default\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"}},\"addons\":[{\"id\":1519279062623,\"name\":\"text_block\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Our Services\",\"heading_selector\":\"h3\",\"title_fontsize\":\"\",\"title_lineheight\":\"\",\"title_letterspace\":\"0\",\"title_fontweight\":\"\",\"text\":\"Why Two Volcanoes in Hawaii Are So Close, but So Different<br />Empirical Evidence: Cats Love People\",\"alignment\":\"sppb-text-center\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"dropcap\":0,\"class\":\"\",\"instFormId\":1519279062623,\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"0px 0px 50px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0}}]},{\"id\":1519278764263,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"default\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"}},\"addons\":[{\"id\":1519279129419,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Visualize impactful mindshare\",\"heading_selector\":\"h3\",\"title_position\":\"after\",\"title_fontsize\":{\"md\":16},\"title_lineheight\":{\"md\":22},\"title_letterspace\":\"0\",\"title_text_color\":\"#4A4A4A\",\"title_url\":\"\",\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_name\":\"fa-street-view\",\"icon_size\":{\"md\":36},\"icon_color\":\"\",\"text\":\"Are you ready to buy a home theater audio system here are several\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"alignment\":\"sppb-text-left\",\"class\":\"\",\"instFormId\":1519279129419,\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_font_style\":{\"weight\":700},\"title_margin_top\":{\"md\":\"20\",\"sm\":\"\",\"xs\":\"\"},\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"0px 0px 50px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0}},{\"id\":1519279374075,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Enable efficient interfaces\",\"heading_selector\":\"h3\",\"title_position\":\"after\",\"title_fontsize\":{\"md\":16},\"title_lineheight\":{\"md\":22},\"title_letterspace\":\"0\",\"title_text_color\":\"#4A4A4A\",\"title_url\":\"\",\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_name\":\"fa-bullhorn\",\"icon_size\":{\"md\":36},\"icon_color\":\"\",\"text\":\"Are you ready to buy a home theater audio system here are several\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"alignment\":\"sppb-text-left\",\"class\":\"\",\"instFormId\":1519279374075,\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_font_style\":{\"weight\":700},\"title_margin_top\":{\"md\":\"20\",\"sm\":\"\",\"xs\":\"\"},\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"0px 0px 50px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0}},{\"id\":1519327302555,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Best Business Planning\",\"heading_selector\":\"h3\",\"title_position\":\"after\",\"title_fontsize\":{\"md\":16},\"title_lineheight\":{\"md\":22},\"title_letterspace\":\"0\",\"title_text_color\":\"#4A4A4A\",\"title_url\":\"\",\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_name\":\"fa-bookmark-o\",\"icon_size\":{\"md\":36},\"icon_color\":\"\",\"text\":\"Are you ready to buy a home theater audio system here are several\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"alignment\":\"sppb-text-left\",\"class\":\"\",\"instFormId\":1519327302555,\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_font_style\":{\"weight\":700},\"title_margin_top\":{\"md\":\"20\",\"sm\":\"\",\"xs\":\"\"},\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"0px 0px 50px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0}}]},{\"id\":1519278764264,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"default\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"}},\"addons\":[{\"id\":1519279374057,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Enable value-added convergence\",\"heading_selector\":\"h3\",\"title_position\":\"after\",\"title_fontsize\":{\"md\":16},\"title_lineheight\":{\"md\":22},\"title_letterspace\":\"0\",\"title_text_color\":\"#4A4A4A\",\"title_url\":\"\",\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_name\":\"fa-angellist\",\"icon_size\":{\"md\":36},\"icon_color\":\"\",\"text\":\"Are you ready to buy a home theater audio system here are several\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"alignment\":\"sppb-text-left\",\"class\":\"\",\"instFormId\":1519279374057,\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_font_style\":{\"weight\":700},\"title_margin_top\":{\"md\":\"20\",\"sm\":\"\",\"xs\":\"\"},\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"0px 0px 50px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0}},{\"id\":1519279374078,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Matrix holistic deliverables\",\"heading_selector\":\"h3\",\"title_position\":\"after\",\"title_fontsize\":{\"md\":16},\"title_lineheight\":{\"md\":22},\"title_letterspace\":\"0\",\"title_text_color\":\"#4A4A4A\",\"title_url\":\"\",\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_name\":\"fa-code\",\"icon_size\":{\"md\":36},\"icon_color\":\"\",\"text\":\"Are you ready to buy a home theater audio system here are several\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"alignment\":\"sppb-text-left\",\"class\":\"\",\"instFormId\":1519279374078,\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_font_style\":{\"weight\":700},\"title_margin_top\":{\"md\":\"20\",\"sm\":\"\",\"xs\":\"\"},\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"0px 0px 50px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0}},{\"id\":1519327302558,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Great Business Solution\",\"heading_selector\":\"h3\",\"title_position\":\"after\",\"title_fontsize\":{\"md\":16},\"title_lineheight\":{\"md\":22},\"title_letterspace\":\"0\",\"title_text_color\":\"#4A4A4A\",\"title_url\":\"\",\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_name\":\"fa-circle-o-notch\",\"icon_size\":{\"md\":36},\"icon_color\":\"\",\"text\":\"Are you ready to buy a home theater audio system here are several\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"alignment\":\"sppb-text-left\",\"class\":\"\",\"instFormId\":1519327302558,\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_font_style\":{\"weight\":700},\"title_margin_top\":{\"md\":\"20\",\"sm\":\"\",\"xs\":\"\"},\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"0px 0px 50px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0}}]},{\"id\":1519278764265,\"class_name\":\"col-md-4\",\"visibility\":true,\"settings\":{\"default\":{\"background_image\":\"\",\"background_repeat\":\"no-repeat\",\"background_size\":\"cover\",\"background_attachment\":\"scroll\",\"background_position\":\"0 0\",\"items_align_center\":0,\"boxshadow\":\"0 0 0 0 #fff\",\"sm_col\":\"\",\"xs_col\":\"\",\"hidden_xs\":\"\",\"hidden_sm\":\"\",\"hidden_md\":\"\",\"animationduration\":\"300\",\"animationdelay\":\"0\"}},\"addons\":[{\"id\":1519279374066,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Streamline customized models\",\"heading_selector\":\"h3\",\"title_position\":\"after\",\"title_fontsize\":{\"md\":16},\"title_lineheight\":{\"md\":22},\"title_letterspace\":\"0\",\"title_text_color\":\"#4A4A4A\",\"title_url\":\"\",\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_name\":\"fa-bell-o\",\"icon_size\":{\"md\":36},\"icon_color\":\"\",\"text\":\"Are you ready to buy a home theater audio system here are several\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"alignment\":\"sppb-text-left\",\"class\":\"\",\"instFormId\":1519279374066,\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_font_style\":{\"weight\":700},\"title_margin_top\":{\"md\":\"20\",\"sm\":\"\",\"xs\":\"\"},\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"0px 0px 50px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0}},{\"id\":1519279374081,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Repurpose viral metrics\",\"heading_selector\":\"h3\",\"title_position\":\"after\",\"title_fontsize\":{\"md\":16},\"title_lineheight\":{\"md\":22},\"title_letterspace\":\"0\",\"title_text_color\":\"#4A4A4A\",\"title_url\":\"\",\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_name\":\"fa-crosshairs\",\"icon_size\":{\"md\":36},\"icon_color\":\"\",\"text\":\"Are you ready to buy a home theater audio system here are several\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"alignment\":\"sppb-text-left\",\"class\":\"\",\"instFormId\":1519279374081,\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_font_style\":{\"weight\":700},\"title_margin_top\":{\"md\":\"20\",\"sm\":\"\",\"xs\":\"\"},\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"0px 0px 50px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0}},{\"id\":1519327302561,\"name\":\"feature\",\"visibility\":true,\"settings\":{\"admin_label\":\"\",\"title\":\"Expart Consultance\",\"heading_selector\":\"h3\",\"title_position\":\"after\",\"title_fontsize\":{\"md\":16},\"title_lineheight\":{\"md\":22},\"title_letterspace\":\"0\",\"title_text_color\":\"#4A4A4A\",\"title_url\":\"\",\"url_appear\":\"title\",\"feature_type\":\"icon\",\"feature_image\":\"\",\"icon_name\":\"fa-comment-o\",\"icon_size\":{\"md\":36},\"icon_color\":\"\",\"text\":\"Are you ready to buy a home theater audio system here are several\",\"text_fontsize\":\"\",\"text_lineheight\":\"\",\"alignment\":\"sppb-text-left\",\"class\":\"\",\"instFormId\":1519327302561,\"icon_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"title_font_style\":{\"weight\":700},\"title_margin_top\":{\"md\":\"20\",\"sm\":\"\",\"xs\":\"\"},\"global_use_background\":0,\"global_user_border\":0,\"global_margin\":{\"md\":\"0px 0px 50px 0px\",\"sm\":\"   \",\"xs\":\"   \"},\"global_padding\":{\"md\":\"   \",\"sm\":\"   \",\"xs\":\"   \"},\"global_use_animation\":0}}]}]}]\";s:10:\"created_by\";i:871;s:8:\"modified\";s:19:\"2025-04-16 06:43:29\";s:11:\"modified_by\";i:961;s:5:\"catid\";i:0;s:9:\"extension\";s:17:\"com_sppagebuilder\";s:14:\"extension_view\";s:4:\"page\";s:8:\"ordering\";i:0;s:4:\"name\";N;s:4:\"mime\";N;s:6:\"layout\";s:4:\"page\";s:7:\"context\";s:22:\"com_sppagebuilder.page\";s:7:\"summary\";s:18858:\"SERVICES       Innovative Approaches for Lasting Growth                              #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}}@media (max-width: 1200px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} } @media (max-width: 992px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} } @media (max-width: 768px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} } @media (max-width: 575px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-ugeMfU2y6jWDmLuyiwoBX .sppb-img-container{}} }        Biz Strategy & Growth We assist businesses in defining their vision and creating growth strategies for long-term success. Learn More                 #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}}@media (max-width: 1200px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} } @media (max-width: 992px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} } @media (max-width: 768px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} } @media (max-width: 575px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-SUzDXBDU1MxuAUFxP8aU1 .sppb-img-container{}} }        Financial Consulting We assist businesses in defining their vision and creating growth strategies for long-term success. Learn More                 #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}}@media (max-width: 1200px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} } @media (max-width: 992px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} } @media (max-width: 768px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} } @media (max-width: 575px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-D_22sSZizpiJ0grkPs8Pu .sppb-img-container{}} }        Operations & Efficiency We assist businesses in defining their vision and creating growth strategies for long-term success. Learn More                 #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}}@media (max-width: 1200px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} } @media (max-width: 992px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} } @media (max-width: 768px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} } @media (max-width: 575px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-before {\n					display: block;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-after {\n					display: none;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-left {\n					display: none;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-addon-content-align-right {\n					display: none;\n				} #sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{\r\ndisplay: block;\r\n}\r\n@media (max-width: 1199.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}}\r\n@media (max-width: 991.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}}\r\n@media (max-width: 767.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}}\r\n@media (max-width: 575.98px) {#sppb-addon-RCPJG2gLFLyAHDwY6YuhP .sppb-img-container{}} }        Leadership Training We assist businesses in defining their vision and creating growth strategies for long-term success. Learn More                                                                 Our Company Working Process            01   Discussions About Project Let\'s dive into the exciting conversations surrounding our latest project! We can explore ideas, and brainstorm solutions together. What are your thoughts?                 02   Start Work With Them Start collaborating with them on our latest project! We can discuss ideas, provide updates, and brainstorm solutions together. What do you think?                 03   Handover & Save World Let\'s discuss the Handover process and how we can collectively save the world! We can share insights impactful solutions. What do you think?                        TESTIMONIALS       What Our Clients Say                \"Using this software has transformed the way our team collaborates. The intuitive interface and powerful features have significantly boosted our productivity.   Alex Buckmaster&nbsp;CEO, Skyline Innovations      \"Our team\'s collaboration has taken a giant leap forward thanks to this software. Its intuitive interface and powerful features have significantly boosted our productivity.\"   Stephanie Nicol&nbsp;CEO, Skyline Innovations      \"This software has revolutionized our team\'s collaboration. Its user-friendly design and robust functionalities have greatly enhanced our efficiency.\"   Chris Glasser&nbsp;CEO, Skyline Innovations      \"Thanks to this amazing software, our team is working together like never before! The user-friendly design and robust functionalities have really ramped up our efficiency.\"   Judith Rodriguez&nbsp;CEO, Skyline Innovations\";s:4:\"path\";s:5:\"index\";}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:4:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:4:\"user\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;N;i:10;N;i:11;s:49:\"index.php?option=com_sppagebuilder&view=page&id=4\";i:12;N;i:13;s:19:\"2018-02-22 09:31:20\";i:14;i:1;i:15;a:2:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:4:\"Page\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:0;s:2:\"id\";i:35;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:0;s:2:\"id\";i:7;}}}i:16;s:8:\"Services\";i:17;i:6;i:18;s:49:\"index.php?option=com_sppagebuilder&view=page&id=4\";}');/**ABDB**/
